<?php

/**
 * Template Name: Case Studies Archive
 */
$themeData = get_fields( 'option' );
$currentPage = get_queried_object();
get_header();
?>

<!--start hero banner -->
<?php
if (isset($themeData['hero_banner']) && is_array($themeData['hero_banner'])) :
?>
    <section class="<?php echo !empty( $themeData['hero_banner']['section_class'] ) ? $themeData['hero_banner']['section_class'] : '' ?> hero-banner" <?php if (!empty($themeData['hero_banner']['background_image']['url'])) { ?> style="background-image: url(<?php echo $themeData['hero_banner']['background_image']['url'] ?>); "<?php } ?>>
    <div class="container h-100">
        <div class="row align-items-center h-100">
            <div class="col-lg-6">
                <div class="banner-inner-content">
                    <?php
                    if ( isset($themeData['hero_banner']['heading_black']) && !empty( $themeData['hero_banner']['heading_black'] ) ):
                    ?>
                    <h1> <?php echo $themeData['hero_banner']['heading_black']; ?> 
                        <?php
                        if ( isset($themeData['hero_banner']['heading_blue']) && !empty( $themeData['hero_banner']['heading_blue'] ) ):
                        ?>
                        <span><?php echo $themeData['hero_banner']['heading_blue']; ?></span>
                        <?php
                        endif;
                        ?>
                    </h1>
                    <?php
                    endif;
                    ?>
                    <?php
                    if ( isset($themeData['hero_banner']['description']) && !empty( $themeData['hero_banner']['description'] ) ):
                    ?>
                        <?php echo $themeData['hero_banner']['description']; ?>
                    <?php
                    endif;
                    ?>
                    <?php
                    if ( isset($themeData['hero_banner']['button_label']) && !empty( $themeData['hero_banner']['button_label']) || isset($themeData['hero_banner']['second_button_label']) && !empty( $themeData['hero_banner']['second_button_label']) ):
                    ?>
                    <div class="hero-banner-button">
                        <?php
                        if ( isset($themeData['hero_banner']['button_label']) && !empty( $themeData['hero_banner']['button_label'] ) ):
                        ?>
                         <a <?php if (!empty($themeData['hero_banner']['first_button_modal_id'])) { ?> data-bs-toggle="modal" data-bs-target="#<?php echo  $themeData['hero_banner']['first_button_modal_id']; ?>" <?php } ?> href="<?php echo !empty( $themeData['hero_banner']['button_link']['url'] ) ? $themeData['hero_banner']['button_link']['url'] : '' ?>" target="<?php echo !empty( $themeData['hero_banner']['button_link']['target'] ) ? $themeData['hero_banner']['button_link']['target'] : '_self' ?>" class="btn-lg-gradient">
                        <?php
                        if ( isset($themeData['hero_banner']['button_icon']['url']) && !empty( $themeData['hero_banner']['button_icon']['url'] ) ):
                        ?>
                            <img src="<?php echo $themeData['hero_banner']['button_icon']['url']; ?>" alt="<?php echo $themeData['hero_banner']['button_icon']['alt']; ?>">
                        <?php
                        endif;
                        ?>
                         <?php echo $themeData['hero_banner']['button_label'] ?></a>
                        <?php
                        endif;
                        ?>
                        <?php
                        if ( isset($themeData['hero_banner']['second_button_label']) && !empty( $themeData['hero_banner']['second_button_label'] ) ):
                        ?>
                         <a href="javascript:void(0)" data-youtube-id="<?php echo !empty( $themeData['hero_banner']['second_button_video_id'] ) ? $themeData['hero_banner']['second_button_video_id'] : '' ?>" class="btn-lg-outline-blue video-thumb js-trigger-video-modal">
                        <?php
                        if ( !empty( $themeData['hero_banner']['second_button_icon']['url'] ) ):
                        ?>
                            <img class="play-icon" src="<?php echo $themeData['hero_banner']['second_button_icon']['url']; ?>" alt="<?php echo $themeData['hero_banner']['second_button_icon']['alt']; ?>">
                        <?php
                        endif;
                        ?>
                        <?php
                        if ( !empty( $themeData['hero_banner']['second_button_icon_hover']['url'] ) ):
                        ?>
                            <img class="play-icon-hover" src="<?php echo $themeData['hero_banner']['second_button_icon_hover']['url']; ?>" alt="<?php echo $themeData['hero_banner']['second_button_icon_hover']['alt']; ?>">
                        <?php
                        endif;
                        ?>
                         <?php echo $themeData['hero_banner']['second_button_label'] ?>
                         </a>
                        <?php
                        endif;
                        ?>
                    </div>
                    <?php
                    endif;
                    ?>
                </div>
            </div>
            <div class="col-lg-6">
            <?php
            if ( isset($themeData['hero_banner']['video_link']) && !empty( $themeData['hero_banner']['video_link'] ) ):
            ?>
                <video width="100%" autoplay muted loop id="bannerVideo">
                    <source src="<?php echo $themeData['hero_banner']['video_link'] ?>" type="video/mp4">
                </video>
            <?php
            else:
                if ( isset($themeData['hero_banner']['hero_image_link']) && !empty( $themeData['hero_banner']['hero_image_link'] ) ):
                ?>
                <div class="hero-banner-image">
                    <img src="<?php echo $themeData['hero_banner']['hero_image_link']['url']; ?>" alt="<?php echo $themeData['hero_banner']['hero_image_link']['alt']; ?>" class="banner-image img-fluid">
                </div>
                <?php
                endif;
            endif;
            ?>
            </div>
        </div>
    </div>
    <?php 
    if ( isset($themeData['hero_banner']['outer_wrapper_image']) && !empty( $themeData['hero_banner']['outer_wrapper_image'] ) ):
    ?>
    <div class="hero-banner-image hero-banner-outer-wrapper">
        <img src="<?php echo $themeData['hero_banner']['outer_wrapper_image']['url']; ?>" alt="<?php echo $themeData['hero_banner']['outer_wrapper_image']['alt']; ?>" class="banner-image img-fluid">
    </div>
    <?php 
    endif;
    ?>
</section>
<?php
    if ( isset($themeData['hero_banner']['second_button_video_link']) && !empty( $themeData['hero_banner']['second_button_video_link'] )):
    ?>
    <!-- video modal -->
    <div class="video-modal">
        <div id="video-modal-content" class="video-modal-content">
            <!-- iframe -->
            <iframe class="youtube" width="100%" height="100%" frameborder="0" allow="autoplay" allowfullscreen src=></iframe>
            <a href="<?php echo $themeData['hero_banner']['second_button_video_link']; ?>" class="close-video-modal">
                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve" width="24" height="24">
                    <g id="icon-x-close">
                        <path fill="#ffffff" d="M30.3448276,31.4576271 C29.9059965,31.4572473 29.4852797,31.2855701 29.1751724,30.980339 L0.485517241,2.77694915 C-0.122171278,2.13584324 -0.104240278,1.13679247 0.52607603,0.517159487 C1.15639234,-0.102473494 2.17266813,-0.120100579 2.82482759,0.477288136 L31.5144828,28.680678 C31.9872448,29.1460053 32.1285698,29.8453523 31.8726333,30.4529866 C31.6166968,31.0606209 31.0138299,31.4570487 30.3448276,31.4576271 Z" id="Shape"></path>
                        <path fill="#ffffff" d="M1.65517241,31.4576271 C0.986170142,31.4570487 0.383303157,31.0606209 0.127366673,30.4529866 C-0.12856981,29.8453523 0.0127551942,29.1460053 0.485517241,28.680678 L29.1751724,0.477288136 C29.8273319,-0.120100579 30.8436077,-0.102473494 31.473924,0.517159487 C32.1042403,1.13679247 32.1221713,2.13584324 31.5144828,2.77694915 L2.82482759,30.980339 C2.51472031,31.2855701 2.09400353,31.4572473 1.65517241,31.4576271 Z" id="Shape"></path>
                    </g>
                </svg>
            </a>
        </div><!-- end modal content wrapper -->
        <div class="overlay"></div>
    </div>
    <?php 
    endif;
    ?>
<?php if (isset($themeData['first_modal_data']) && is_array($themeData['first_modal_data'])) : 
?>
    <?php 
    foreach ($themeData['first_modal_data'] as $modalData) :
    ?>
    <div class="modal fade pricing-popup" id="<?php echo !empty( $modalData['modal_id'] ) ? $modalData['modal_id'] : '' ?>" tabindex="-1" aria-labelledby="pricing-modalLabel" aria-hidden="true">
        <?php include( get_template_directory() . '/includes/button-modal.php' ); ?>
    </div>
    <?php
    endforeach;
    ?>
<?php
endif;
?>
<?php
endif;
?>
<!--end hero banner -->
<section class="resource-menu-section">
    <div class="faq-tab-nav">
        <div class="container">
        <?php
        if ( isset($themeData['resources_listings']['section_heading']) && !empty( $themeData['resources_listings']['section_heading'] ) ):
        ?>
            <h2><?php echo $themeData['resources_listings']['section_heading'] ?></h2>
        <?php
        endif;
        ?>
        <?php
        if (isset($themeData['resources_listings']['blog_categories']) && is_array($themeData['resources_listings']['blog_categories'])) :
        ?>
            <ul class="list-inline faq-menu">
            <?php
            foreach ($themeData['resources_listings']['blog_categories'] as $CategoryRepeater) : ?>
            <?php if (!empty($CategoryRepeater['category_title'])) :
            ?>
                <li class="list-inline-item">
                    <a href="<?php echo !empty($CategoryRepeater['category_link']['url']) ? $CategoryRepeater['category_link']['url'] : 'javascript:void(0)' ?>" target="<?php echo !empty($CategoryRepeater['category_link']['target']) ? $CategoryRepeater['category_link']['target'] : '_self' ?>"><?php echo $CategoryRepeater['category_title']; ?></a>
                </li>
            <?php endif; ?>
            <?php 
            endforeach;
            ?>
            </ul>
        <?php
        endif;
        ?>
        </div>
    </div>
</section>
<section class="section-spacing resource-list">
    <div class="container">
        <div class="blog-list-row">
            <div class="blog-list-col">
                <form role="search" class="resource-search" method="get" id="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <input class="resource-search-input" type="text" placeholder="I'm looking for..."  value="" name="s" id="s">
                    <button class="resource-search-icon" type="submit" id="searchsubmit" value="Search">
                        <i class="fa-solid fa-magnifying-glass"></i>
                    </button>
                </form>
                <?php
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $the_query = array(
					'post_type' => get_post_type(),
					'posts_per_page' => 4,
					'paged' => $paged
				);
                ?>
                <?php
                $wpb_all_query = new WP_Query($the_query);
                ?>
                <div class="row resource-blog-list-row">
                <?php if ($wpb_all_query->have_posts()) : ?>
                <!-- loop -->
                <?php while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post(); ?>
                    <?php
                    $current_id = get_the_ID();
                    $excerpt = get_the_excerpt($current_id);
                    $excerpt = substr($excerpt, 0, 130);
                    ?>
                    <div class="col-lg-6 resource-blog-list-col">
                        <div class="card blog-card">
                            <div class="card-header">
                                <a href="<?php the_permalink(); ?>" class="d-block">
                                <?php if (function_exists('add_theme_support')) {
                                    the_post_thumbnail();
                                } ?> 
                                </a>
                            </div>
                            <div class="card-body">
                                <h3 class="blog-title">
                                    <a href="<?php the_permalink(); ?>" class="d-block">
                                        <?php echo get_the_title() ?>
                                    </a>
                                </h3>
                                <p class="blog-text">
                                    <?php echo $excerpt . '...'; ?>
                                </p>
                                <div class="d-flex blog-meta-tag justify-content-between">
                                    <div class="">
                                        <a href="<?php the_permalink(); ?>" class="readMore-link"><?php echo !empty($themeData['resources_listings']['ebook_download_text']) ? $themeData['resources_listings']['ebook_download_text']: 'Download' ?> <i class="fa-solid fa-chevron-right"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> 
                    <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
                <?php else : ?>
                    <p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
                <?php endif; ?>
                <div class="pagination-resource">
                    <?php
                    /** Pagination query */                    
                    $total_pages = $wpb_all_query->max_num_pages;
                    if ($total_pages > 1){
                        $current_page = max(1, get_query_var('paged'));
                        echo paginate_links(array(
                            'base' => get_pagenum_link(1) . '%_%',
                            'format' => '/page/%#%',
                            'current' => $current_page,
                            'total' => $total_pages,
                            'prev_text'    => __('Prev'),
                            'next_text'    => __('Next'),
                        ));
                    } ?>
                </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
get_footer();
?>