<?php

/**
 * Blog Listing file.
 *
 */
$themeData = get_fields( 'option' );
$customizationClass = new NtCustomization();
$current_tag = get_queried_object();
get_header();
?>

    <section class="our-resources">
        <div class="container">
            <div class="our-resources-heading text-center">
                <h3>Our Resources</h3>
            </div>
            <div class="resources-category">
				<?php
				$terms = get_categories(
					array(
						'taxonomy'   => 'resource_type',
						'hide_empty' => false,
					)
				);
				if ( ! empty( $terms ) ):
					foreach ( $terms as $value ):
						?>
                        <a class="btn resources-category-btn <?php echo $value->name == $current_tag->name ? 'active' : '' ?>"
                           role="button"
                           href="<?php echo get_category_link( $value ) ?>">
							<?php echo $value->name ?>
                        </a>
					<?php
					endforeach;
				endif;
				?>
                <a class="btn resources-category-btn custom"
                           role="button"
                           href="<?php echo get_site_url();?>/ebooks/">
						    E-Book
                        </a>
                            <a class="btn resources-category-btn custom"
                           role="button"
                           href="<?php echo get_site_url();?>/case-studies/">
						    Case Studies
                        </a>
            </div>
            <div class="resources-search mb-5">
				<?php get_search_form(); ?>
            </div>
        </div>
    </section>
    <section class="our-resources-blog">
        <div class="container">
            <div class="row">
				<?php
				$paged     = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
				$args      = array(
					'post_type'      => get_post_type(),
					'posts_per_page' => 6,
					'paged'          => $paged,
					'tax_query'      => array(
						array(
							'taxonomy' => 'resource_type',
							'field'    => 'name',
							'terms'    => $current_tag->name,
						)
					)
				);
				$the_query = new WP_Query( $args );
				?>
				<?php if ( $the_query->have_posts() ) : ?>

					<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>


                        <div class="col-md-6 col-sm-12 col-xs-12 listing-card-padding">
                            <div class="blog-box text-center">
                                <a href="<?php the_permalink(); ?>">
                                    <figure class="our-resources-blog-img "> <?php if ( function_exists( 'add_theme_support' ) ) {

											the_post_thumbnail();
										} ?></figure>
                                </a>
                                <div class="content-blog">
                                    <h5>
                                        <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                                    </h5>
									<?php the_excerpt(); ?>
                                </div>
                                <div class="bottom-details">
                                    <p><?php the_time( 'F d , Y' ); ?></p>
                                    <div class="read-more">
                                        <a href="<?php the_permalink(); ?>">+ Read More</a>
                                    </div>
                                </div>
                            </div>
                        </div>

					<?php endwhile; /* rewind or continue if all posts have been fetched */ ?>
                    <!--pagination-->
                    <div class="col-md-12">
                        <div class="pagination text-right">
                            <div class="pagination-wrapper">
								<?php
								$big = 999999999;
								echo paginate_links( array(
									'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
									'format'    => '?paged=%#%',
									'current'   => max( 1, get_query_var( 'paged' ) ),
									'total'     => $the_query->max_num_pages,
									'prev_text' => '<span>Prev</span>',
									'next_text' => '<span>Next</span>'
								) );
								wp_reset_postdata();
								?>
                            </div>
                        </div>
                    </div>
                    <!--pagination ends-->

				<?php else :
					?>
                    <div class="alert alert-info w-100 text-center">
                        <p>No Data Found</p>
                    </div>
				<?php endif; ?>

            </div>
        </div>
    </section>

<?php get_footer(); ?>