jQuery(document).ready(function () {
  //start slider tab
  var bigimage = jQuery("#tabContent");
  var thumbs = jQuery("#tabHeading");
  //var totalslides = 10;
  var syncedSecondary = true;

  bigimage
    .owlCarousel({
      items: 1,
      slideSpeed: 2000,
      nav: false,
      autoplay: true,
      dots: false,
      loop: true,
      responsiveRefreshRate: 200,
      navText: [
        '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
        '<i class="fa fa-arrow-right" aria-hidden="true"></i>',
      ],
    })
    .on("changed.owl.carousel", syncPosition);

  thumbs
    .on("initialized.owl.carousel", function () {
      thumbs.find(".owl-item").eq(0).addClass("current");
    })
    .owlCarousel({
      dots: false,
      nav: false,
      navText: [
        '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
        '<i class="fa fa-arrow-right" aria-hidden="true"></i>',
      ],
      smartSpeed: 3000,
      slideSpeed: 5000,
      slideBy: 4,

      responsive: {
        0: {
          items: 1,
        },
        600: {
          items: 3,
          margin: 16,
        },
        1000: {
          items: 4,
          margin: 16,
        },
      },
    })
    .on("changed.owl.carousel", syncPosition2);

  function syncPosition(el) {
    //if loop is set to false, then you have to uncomment the next line
    //var current = el.item.index;

    //to disable loop, comment this block
    var count = el.item.count - 1;
    var current = Math.round(el.item.index - el.item.count / 2 - 0.5);

    if (current < 0) {
      current = count;
    }
    if (current > count) {
      current = 0;
    }
    //to this
    thumbs
      .find(".owl-item")
      .removeClass("current")
      .eq(current)
      .addClass("current");
    var onscreen = thumbs.find(".owl-item.active").length - 1;
    var start = thumbs.find(".owl-item.active").first().index();
    var end = thumbs.find(".owl-item.active").last().index();

    if (current > end) {
      thumbs.data("owl.carousel").to(current, 100, true);
    }
    if (current < start) {
      thumbs.data("owl.carousel").to(current - onscreen, 100, true);
    }
  }

  function syncPosition2(el) {
    if (syncedSecondary) {
      var number = el.item.index;
      bigimage.data("owl.carousel").to(number, 100, true);
    }
  }

  thumbs.on("click", ".owl-item", function (e) {
    e.preventDefault();
    var number = jQuery(this).index();
    bigimage.data("owl.carousel").to(number, 300, true);
  });

  //end slider tab

  //start awards js

  jQuery(".awards-carousel").owlCarousel({
    loop: false,
    margin: 56,
    dots: jQuery(".owl-carousel .item").length > 4 ? true : false,
    nav: false,
    responsiveClass: true,
    touchDrag: false,
    mouseDrag: false,
    autoplay: jQuery(".owl-carousel .item").length > 4 ? true : false,
    autoplayTimeout: 3000,
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items: 3,
      },
      1000: {
        items: 4,
      },
    },
  });
  //end awards js

  //start product feature slider //

  jQuery(".feature-product-slider").owlCarousel({
    loop: true,
    margin: 28,
    nav: false,
    dots: false,
    autoplay: true,
    autoplayTimeout: 5000,
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items: 2,
      },
      1000: {
        items: 3,
      },
    },
  });
  //end product feature slider //

  //start video popup
  function toggle_video_modal() {
    jQuery(".js-trigger-video-modal").on("click", function (e) {
      e.preventDefault();
      var id = jQuery(this).attr("data-youtube-id");
      var autoplay = "?autoplay=1";
      var related_no = "&rel=0";
      var src = "//www.youtube.com/embed/" + id + autoplay + related_no;
      jQuery(".youtube").attr("src", src);
      jQuery("body").addClass("show-video-modal noscroll");
    });
    function close_video_modal() {
      event.preventDefault();
      jQuery("body").removeClass("show-video-modal noscroll");
      jQuery(".youtube").attr("src", "");
    }

    jQuery("body").on(
      "click",
      ".close-video-modal, .video-modal .overlay",
      function (event) {
        close_video_modal();
      }
    );
    jQuery("body").keyup(function (e) {
      if (e.keyCode == 27) {
        close_video_modal();
      }
    });
  }
  toggle_video_modal();

  //end video popup

  // start partner map popup
  jQuery(".popUpBtn").on("click", function () {
    jQuery("#" + jQuery(this).data("modal")).css({
      display: "block",
      transform: "translateY(0%)",
      animation: "slide-in 0.2s forwards",
      "-webkit-animation": " slide-in 0.2s forwards",
    });
  });
  jQuery("span.close").on("click", function () {
    jQuery(".modal").css({
      display: "none",
      transform: "translateY(-100%)",
      animation: "slide-out 0.2s forwards",
      "-webkit-animation": " slide-out 0.2s forwards",
    });
  });

  jQuery(".modal.map-detail-popup span.close").click(function () {
    jQuery(".partner-image-map figure").css("display", "block");
    jQuery(".map-detail-popup").css({
      display: "none",
      transform: "translateY(-100%)",
      animation: "slide-out 0.2s forwards",
      "-webkit-animation": " slide-out 0.2s forwards",
    });
  });

  jQuery(".popUpBtn").click(function () {
    jQuery(".partner-image-map figure").css("display", "none");
  });
  //end partner map popup

  //start brand logo slider
  jQuery(".brand-loge-carousel").owlCarousel({
    loop: true,
    margin: 20,
    responsiveClass: true,
    autoplay: true,
    dots: false,
    nav: false,
    autoplayTimeout: 1000,
    autoplayHoverPause: true,
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items: 3,
      },
      1000: {
        items: 5,
      },
      1600: {
        items: 9,
        loop: false,
        autoplay: false,
      },
    },
  });
  //end brand logo slider

  //Start get personalized solution slider
  jQuery(".personalized-solution-carousel").owlCarousel({
    loop: true,
    margin: 20,
    nav: false,
    dots: false,
    responsiveClass: true,
    autoplay: true,
    autoplayTimeout: 1000,
    autoplayHoverPause: true,
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items:2,
      },
      1200: {
        items: 3,
        margin: 47,
      },
    },
  });
  //End get personalized solution
  //Start get personalized solution slider
  jQuery(".testmonial-carousel").owlCarousel({
    loop: true,
    margin: 20,
    nav: false,
    dots: true,
    autoplay: false,
    autoplayTimeout: 1000,
    autoplayHoverPause: true,
    items: 1,
  });
  //End get personalized solution
  /** Add active class on resources blogs tabs */
    jQuery(".faq-menu .list-inline-item [href]").each(function() {
        if(this.href == window.location.href) {
            jQuery(this).closest('.list-inline-item').addClass("active");
        }
    });
});
