<?php
/**
 *Template Name: Front Page
 */
$themeData = get_fields();
$currentPage = get_queried_object();
get_header();
?>
<!--start hero banner -->
<?php include( get_template_directory() . '/includes/hero-banner.php' ); ?>
<!--end hero banner -->
<?php
if (isset($themeData['tabs_slider']) && is_array($themeData['tabs_slider'])) :
?>
    <?php include( get_template_directory() . '/includes/tab-slider.php' ); ?>
<?php 
endif;
?>
<!--start CTA banner -->
<?php if (isset($themeData['cta_data']) && is_array($themeData['cta_data'])) : ?>
    <?php include( get_template_directory() . '/includes/cta-banner.php' ); ?>
<?php endif; ?> 
<!--end CTA banner -->
<!--start Networkon Tech Suite-->
<?php
if (isset($themeData['gradient_image_with_text']) && is_array($themeData['gradient_image_with_text'])) :
?>
 <?php include( get_template_directory() . '/includes/gradient-image-with-text.php' ); ?>
<?php 
endif;
?>
<!--End Networkon Tech Suite-->
<?php
if (isset($themeData['modal_video_with_text']) && is_array($themeData['modal_video_with_text'])) :
?>
<?php
foreach ($themeData['modal_video_with_text'] as $modalTextData) :
?>
<!--start Offer Your Clients Our End-To-End Saas Suite-->
<section class="section-spacing bg-img offer-clients-section" <?php if (!empty($modalTextData['background_image']['url'])) { ?> style="background-image: url(<?php echo $modalTextData['background_image']['url'] ?>); "<?php } ?>>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5">
                <div class="video-image">
                    <div class="video-overlay"></div>
                    <a href="javascript:void(0)" data-youtube-id="<?php echo !empty( $modalTextData['video_id'] ) ? $modalTextData['video_id'] : '' ?>"  class="video-thumb js-trigger-video-modal">
                        <?php
                            if ( isset($modalTextData['video_poster_image']['url']) && !empty( $modalTextData['video_poster_image']['url'] ) ):
                        ?>
                            <img class="video-banner-img" src="<?php echo $modalTextData['video_poster_image']['url'] ?>" alt="<?php echo $modalTextData['video_poster_image']['alt'] ?>" />
                        <?php 
                            endif;
                        ?>
                        <div class="">
                            <span class="play-btn"><i class="fa-solid fa-play"></i></span>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-7">
                <div class="card">
                <?php
                if ( isset($modalTextData['heading']) && !empty( $modalTextData['heading'] ) ):
                ?>
                    <h2><?php echo $modalTextData['heading'] ?></h2>
                <?php 
                endif;
                ?>
                <?php
                if ( isset($modalTextData['description']) && !empty( $modalTextData['description'] ) ):
                ?>   
                    <?php echo $modalTextData['description'] ?>
                <?php 
                endif;
                ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if ( isset($modalTextData['video_link']) && !empty( $modalTextData['video_link'] ) ):
    ?>
    <!-- video modal -->
    <div class="video-modal">
        <div id="video-modal-content" class="video-modal-content">
            <!-- iframe -->
            <iframe id="youtube" width="100%" height="100%" frameborder="0" allow="autoplay" allowfullscreen src=></iframe>
            <a href="<?php echo $modalTextData['video_link'] ?>" class="close-video-modal">
                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve" width="24" height="24">
                    <g id="icon-x-close">
                        <path fill="#ffffff" d="M30.3448276,31.4576271 C29.9059965,31.4572473 29.4852797,31.2855701 29.1751724,30.980339 L0.485517241,2.77694915 C-0.122171278,2.13584324 -0.104240278,1.13679247 0.52607603,0.517159487 C1.15639234,-0.102473494 2.17266813,-0.120100579 2.82482759,0.477288136 L31.5144828,28.680678 C31.9872448,29.1460053 32.1285698,29.8453523 31.8726333,30.4529866 C31.6166968,31.0606209 31.0138299,31.4570487 30.3448276,31.4576271 Z" id="Shape"></path>
                        <path fill="#ffffff" d="M1.65517241,31.4576271 C0.986170142,31.4570487 0.383303157,31.0606209 0.127366673,30.4529866 C-0.12856981,29.8453523 0.0127551942,29.1460053 0.485517241,28.680678 L29.1751724,0.477288136 C29.8273319,-0.120100579 30.8436077,-0.102473494 31.473924,0.517159487 C32.1042403,1.13679247 32.1221713,2.13584324 31.5144828,2.77694915 L2.82482759,30.980339 C2.51472031,31.2855701 2.09400353,31.4572473 1.65517241,31.4576271 Z" id="Shape"></path>
                    </g>
                </svg>
            </a>
        </div><!-- end modal content wrapper -->
        <div class="overlay"></div>
    </div>
    <?php 
    endif;
    ?>
</section>
<?php 
endforeach;
?>
<?php 
endif;
?>
<!--end Offer Your Clients Our End-To-End Saas Suite-->
<?php
if (isset($themeData['small_cards_grid']) && is_array($themeData['small_cards_grid'])) :
?>
<?php
foreach ($themeData['small_cards_grid'] as $grid_data) :
?>
<!-- start Business Solutions-->
<section class="section-spacing solution-section ">
    <div class="container">
        <div class="section-header">
        <?php
        if ( ! empty( $grid_data['heading'] ) ):
        ?>
            <h2><?php echo $grid_data['heading'] ?></h2>
        <?php 
        endif;
        ?>
        <?php
        if ( ! empty( $grid_data['description'] ) ):
        ?>   
            <?php echo $grid_data['description'] ?>
        <?php 
        endif;
        ?>
        </div>
        <?php
        if (isset($grid_data['cards_content']) && is_array($grid_data['cards_content'])) :
        ?>
        <div class="d-flex flex-wrap card-row">
        <?php 
        foreach ($grid_data['cards_content'] as $carditem) :
        ?>
            <div class="card">
            <?php if (!empty($carditem['card_image']['url'])) : ?>
               <div class="card-icon">
               <img src="<?php echo $carditem['card_image']['url']; ?>" alt="<?php echo $carditem['card_image']['alt']; ?>" class="solution-icon img-fluid">
               </div>
            <?php endif; ?>
            <?php if (!empty($carditem['card_title'])) : ?>
                <h5><?php echo $carditem['card_title'] ?></h5>
            <?php endif; ?>
            </div>    
        <?php 
        endforeach;
        ?>
        </div>
        <?php 
        endif;
        ?>
    </div>
</section>
<?php 
endforeach;
?>
<?php 
endif;
?>
<!--end Business Solutions-->
<?php
if (isset($themeData['video_section']) && !empty($themeData['video_section'])) :
?>
<!-- start Video-->
<section class="Video-section">
    <video width="100%" playsinline autoplay muted loop id="bannerVideo">
        <source src="<?php echo $themeData['video_section']['url']; ?>" type="video/mp4">
    </video>
</section>
<!--end Video-->
<?php 
endif;
?>
<!-- start blog-->
    <?php include( get_template_directory() . '/includes/blogs-card.php' ); ?>
<!--end blog-->
<!--start awards-->
<?php
$field = get_fields('options');
if (isset($field['awards_slider']) && !empty($field['awards_slider'])) :
?>
    <?php include( get_template_directory() . '/includes/awards-slider.php' ); ?>
<?php 
endif;
?>
<!--end awards-->
<?php
get_footer();
?>