<?php
//directory
$understrap_inc_dir = '/components';
// Array of files to include.
$understrap_includes = array(
'/contactForm-partner.php', // Partner form integration with hubspot
'/contactform-contactus.php', // contactus form integration with hubspot
);
foreach ($understrap_includes as $file) {
   //require_once get_theme_file_path($understrap_inc_dir . $file);
   include get_template_directory() . $understrap_inc_dir . $file; // if it's inside components directory

}

function enqueue_parent_styles()
{
	wp_register_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css');
	wp_enqueue_style('bootstrap');
	wp_register_style('fontawesome', get_template_directory_uri() . '/assets/fonts/fontawesome/fontawesome.min.css');
	wp_enqueue_style('fontawesome');
	wp_register_style('owl-carousel', get_template_directory_uri() . '/assets/plugin/owl-carousel/owl.carousel.min.css');
	wp_enqueue_style('owl-carousel');	
	wp_register_style('fonts', get_template_directory_uri() . '/assets/fonts/fonts.css');
	wp_enqueue_style('fonts');
	wp_register_style('style', get_template_directory_uri() . '/assets/scss/style.css');
	wp_enqueue_style('style');	
	
}

add_action('wp_enqueue_scripts', 'enqueue_parent_styles');

function load_js()
{
	wp_register_script('jquery', get_template_directory_uri() . '/assets/js/jquery-3.6.3.min.js', array(), 1, 1, 1);
	wp_enqueue_script('jquery');

	wp_register_script('popper', get_template_directory_uri() . '/assets/js/popper.min.js', array(), 1, 1, 1);
	wp_enqueue_script('popper');

	wp_register_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array(), 1, 1, 1);
	wp_enqueue_script('bootstrap');

	wp_register_script('lottie-player', get_template_directory_uri() . '/assets/js/lottie-player.js', array(), 1, 1, 1);
	wp_enqueue_script('lottie-player');

	wp_register_script('owl-carousel', get_template_directory_uri() . '/assets/plugin/owl-carousel/owl.carousel.min.js', array(), 1, 1, 1);
	wp_enqueue_script('owl-carousel');	

	wp_register_script('custom', get_template_directory_uri() . '/assets/js/custom.js', array(), 1, 1, 1);
	wp_enqueue_script('custom');	
	
}

add_action('wp_enqueue_scripts', 'load_js');


/* Enqueue Styles */
if ( ! function_exists('thr_enqueue_styles') ) {
    function thr_enqueue_styles() {
        wp_enqueue_style( 'twenty-twenty-three-style', get_template_directory_uri() .'/style.css' );
    }
    add_action('wp_enqueue_scripts', 'thr_enqueue_styles');
}
//for options page
add_action('acf/init', 'my_acf_op_init');
function my_acf_op_init()
{
	// Check function exists.
	if (function_exists('acf_add_options_sub_page')) {
		// Add parent.
		$parent = acf_add_options_page(array(
			'page_title' => __('Theme General Settings'),
			'menu_title' => __('Theme Settings'),
			'menu_slug'  => __('theme-settings'),
			'redirect'   => false,
		));
		acf_add_options_sub_page(array(
			'title'  => __('Awards slider'),
			'parent' => __('theme-settings')
		));
		acf_add_options_sub_page(array(
			'title'  => __('Testimonials'),
			'parent' => __('theme-settings')
		));
		acf_add_options_sub_page(array(
			'title'  => __('Delivery Clients'),
			'parent' => __('theme-settings')
		));
		acf_add_options_sub_page(array(
			'title'  => __('Resources Data'),
			'parent' => __('theme-settings')
		));
	}
}
define('ALLOW_UNFILTERED_UPLOADS', true);
//for custom menues
function wpb_custom_new_menu()
{
	register_nav_menus(
		array(
			'header-navigation' => __('Header Navigation'),
			'products-menu' => __('Products Menu'),
		)
	);
}
add_action('init', 'wpb_custom_new_menu'); 
//upload json file
function add_upload_mimes( $types ) {
	$types['json'] = 'text/plain';
	
	return $types;
  }
add_filter( 'upload_mimes', 'add_upload_mimes' );

function webp_upload_mimes( $existing_mimes ) {
    // add webp to the list of mime types
    $existing_mimes['webp'] = 'image/webp';
    // return the array back to the function with our added mime type
    return $existing_mimes;
}
add_filter( 'mime_types', 'webp_upload_mimes' );
// Allow SVG media upload
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
	$filetype = wp_check_filetype( $filename, $mimes );
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
//** * Enable preview / thumbnail for webp image files.*/
function webp_is_displayable($result, $path) {
    if ($result === false) {
        $displayable_image_types = array( IMAGETYPE_WEBP );
        $info = @getimagesize( $path );
        if (empty($info)) {
            $result = false;
        } elseif (!in_array($info[2], $displayable_image_types)) {
            $result = false;
        } else {
            $result = true;
        }
    }
    return $result;
}
add_filter('file_is_displayable_image', 'webp_is_displayable', 10, 2);

// Register products custom post type

add_action('init', 'product_custom_postType');
function product_custom_postType()
{
	$labels   = array(
		'name'               => _x('Products', 'Post type general name', 'textdomain'),
		'singular_name'      => _x('Product', 'Post type singular name', 'textdomain'),
		'menu_name'          => _x('Products', 'Admin Menu text', 'textdomain'),
		'name_admin_bar'     => _x('Product', 'Add New on Toolbar', 'textdomain'),
		'add_new'            => __('Add New', 'textdomain'),
		'add_new_item'       => __('Add New Product', 'textdomain'),
		'new_item'           => __('New Product', 'textdomain'),
		'edit_item'          => __('Edit Product', 'textdomain'),
		'view_item'          => __('View Product', 'textdomain'),
		'all_items'          => __('All Products', 'textdomain'),
		'search_items'       => __('Search Products', 'textdomain'),
		'parent_item_colon'  => __('Parent Products:', 'textdomain'),
		'not_found'          => __('No Products found.', 'textdomain'),
		'not_found_in_trash' => __('No Product found in Trash.', 'textdomain'),
	);
	$supports = array(
		'title', // post title
		'editor', // post content
		'author', // post author
		'thumbnail', // featured images
		'excerpt', // post excerpt
		'custom-fields', // custom fields
		'revisions', // post revisions
		'post-formats', // post formats
	);
	$args     = array(
		'labels'              => $labels,
		'supports'            => $supports,
		// give personal category and post_tag inside it instead of common to all posts
		'taxonomies'          => array('category', 'post_tag'),
		'public'              => true,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_rest'        => true,
		'query_var'           => true,
		'capability_type'     => 'post',
		'has_archive'         => true,
		'hierarchical'        => false, //false = post, true = page
		'menu_position'       => null,
		'exclude_from_search' => 'false',
		'description'         => 'products',
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'can_export'          => true,
		'rewrite' => array(
			'with_front' => false,
			'slug'       => 'product'
		)

	);
	register_post_type('products', $args);
}

// add custom taxonomy for Category
function add_resourcesType_taxonomy() {
	$args = array(
		'labels'       => array(
			'name'          => 'Resource Types',
			'singular_name' => 'Resource Type',
		),
		'public'       => true,
		'show_in_rest' => true,
		'hierarchical' => true, //false = tag, true = category
	);
	register_taxonomy( 'resource_type', array( 'post' ), $args );

}
add_action( 'init', 'add_resourcesType_taxonomy' );
	/*Case studies Custom Post type start*/
	function cw_post_type_case_study() {
		$supports = array(
		'title', // post title
		'editor', // post content
		'author', // post author
		'thumbnail', // featured images
		'excerpt', // post excerpt
		'custom-fields', // custom fields
		'comments', // post comments
		'revisions', // post revisions
		'post-formats', // post formats
		);
		$labels = array(
		'name' => _x('Case Studies', 'plural'),
		'singular_name' => _x('Case Study', 'singular'),
		'menu_name' => _x('Case-Study', 'admin menu'),
		'name_admin_bar' => _x('Case-Study', 'admin bar'),
		'add_new' => _x('Add New', 'add new'),
		'add_new_item' => __('Add New Case-Study'),
		'new_item' => __('New Case-Study'),
		'edit_item' => __('Edit Case-Study'),
		'view_item' => __('View Case-Study'),
		'all_items' => __('All Case-Study'),
		'search_items' => __('Search Case-Study'),
		'not_found' => __('No Case-Study found.'),
		);
		$args = array(
		'supports' => $supports,
		'labels' => $labels,
		'public' => true,
		'query_var' => true,
		'rewrite' => array('slug' => 'case-studies','with_front' => false),
		'has_archive' => 'case-studies',
		'hierarchical' => false,
		);
		register_post_type('case-studies', $args);
		}
	add_action('init', 'cw_post_type_case_study');
	/*E-books Custom Post type start*/
	function cw_post_type_ebook() {
		$supports = array(
		'title', // post title
		'editor', // post content
		'author', // post author
		'thumbnail', // featured images
		'excerpt', // post excerpt
		'custom-fields', // custom fields
		'comments', // post comments
		'revisions', // post revisions
		'post-formats', // post formats
		);
		$labels = array(
		'name' => _x('E-Book', 'plural'),
		'singular_name' => _x('E-Book', 'singular'),
		'menu_name' => _x('E-Book', 'admin menu'),
		'name_admin_bar' => _x('E-Book', 'admin bar'),
		'add_new' => _x('Add New', 'add new'),
		'add_new_item' => __('Add New EBook'),
		'new_item' => __('New EBook'),
		'edit_item' => __('Edit EBook'),
		'view_item' => __('View EBook'),
		'all_items' => __('All EBook'),
		'search_items' => __('Search EBook'),
		'not_found' => __('No EBook found.'),
		);
		$args = array(
		'supports' => $supports,
		'labels' => $labels,
		'public' => true,
		'query_var' => true,
		'rewrite' => array('slug' => 'ebooks','with_front' => false),
		'has_archive' => true,
		'hierarchical' => false,
		);
		register_post_type('ebooks', $args);
		}
	add_action('init', 'cw_post_type_ebook');
//Fx to remove URL field in comment form//
add_filter('comment_form_default_fields', 'unset_url_field');
function unset_url_field($fields){
	if(isset($fields['url']))
	unset($fields['url']);
	return $fields;
}
/** Fx for Ebook detail page to download the pdf on successful CF7 submission */
function ebook_pdf_download() {
	global $post;
		if ( is_singular( 'ebooks' )) {
			$get_page_ID = get_the_ID();
			$cformId = get_field( "ebook_banner_form_id", $get_page_ID );
			$ebook = get_field('ebook_pdf', $get_page_ID);
			if ( !empty($cformId) && !empty($ebook)) {
			$pdfurl = $ebook['url'];
			?>
			<script type="text/javascript">
				document.addEventListener('wpcf7mailsent', function (event) {
					var cformid = '<?php echo $cformId;?>'
					var pdfurl = '<?php echo $pdfurl;?>'
					if (cformid == event.detail.contactFormId) {
						window.open(pdfurl, '_blank');
					}
				}, false);
			</script>
			<?php
			}
		}
	}
	add_action( 'wp_footer', 'ebook_pdf_download' );
  ?>


