<!DOCTYPE html>
<?php
$current_page = get_queried_object();
$field = get_fields( 'options' );
?>
<html>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Networkon</title>
    <?php wp_head(); ?>

</head>
<!-- Google Tag Manager (noscript) -->
<noscript>
    <!-- <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-NZGGQ4H" height="0" width="0" style="display:none;visibility:hidden"></iframe> -->
</noscript>
<!-- End Google Tag Manager (noscript) -->

<!-- header starts -->
    <?php
    function yourprefix_get_menu_items($menu_name)
    {
        if (($locations = get_nav_menu_locations()) && isset($locations[$menu_name])) {
            $menu = wp_get_nav_menu_object($locations[$menu_name]);
            return wp_get_nav_menu_items($menu->term_id);
        }
    }
    
    if ( is_page_template('templates/single-ordering-platform.php') || is_page_template('templates/pricing.php') || is_page_template('templates/single-delivery-management.php')) : ?>
            <?php $menu_array = yourprefix_get_menu_items('products-menu');?>
    <?php else : ?>
            <?php $menu_array = yourprefix_get_menu_items('header-navigation'); ?>
    <?php endif;
    ?>
    
<nav class="navbar navbar-expand-xl nw-navbar bg-dark mobile-offcanvas" data-bs-theme="dark">
    <div class="container">
            <a href="<?php echo site_url(); ?>" class="custom-logo-link" rel="home" aria-current="page">
            <?php if (!empty($field['header_logo']['url'])) : ?>
                <img  src="<?php echo $field['header_logo']['url']; ?>" alt="<?php echo $field['header_logo']['alt']; ?>" class="custom-logo" decoding="async">
            <?php
            else :
				bloginfo( 'name' );
            endif;
                ?>
            </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasDarkNavbar" aria-controls="offcanvasDarkNavbar">
            <span></span>
            <span></span>
            <span></span>
        </button>
        <div class="offcanvas offcanvas-end text-bg-dark" tabindex="-1" id="offcanvasDarkNavbar" aria-labelledby="offcanvasDarkNavbarLabel">
        <button type="button" class="btn-close " data-bs-dismiss="offcanvas" aria-label="Close">
        <span></span>
            <span></span>
            <span></span>
        </button>
            <ul class="navbar-nav">
            <?php
            foreach ( $menu_array as $menu_item ) :
                $custom_menu = get_fields( $menu_item->ID );
                
                $page = basename($menu_item->url);
                
            ?>

              <li class="nav-item dropdown<?php echo $menu_item->menu_item_parent != 0 ? 'sub-menu-item' : ''; ?>" <?php if ( !empty( $custom_menu['slug_to_display']) && (($custom_menu['slug_to_display'] == $current_page->post_name) || ($page == $current_page->post_name )) ) : ?> style="display:block;" <?php elseif (!empty( $custom_menu['slug_to_display']) && (($custom_menu['slug_to_display'] != $current_page->post_name))):?> style="display:none;" <?php else : ?>  style="display:block;" <?php endif; ?>>
                
                <a class="nav-link <?php echo empty( $custom_menu['dropdown_mega_menu'] ) ? '' : 'dropdown-toggle' ?>" target="<?php echo ! empty( $menu_item->target ) ? $menu_item->target : '_self' ?>" href="<?php echo $menu_item->url ?>" <?php echo empty( $custom_menu['dropdown_mega_menu'] ) ? '' : 'data-bs-toggle="dropdown"' ?> aria-expanded="false">
                        <?php echo $menu_item->title ?></a>
                </a>
                <?php
                if ( ! empty( $custom_menu['dropdown_mega_menu'] ) ) : ?>
                <div class="dropdown-menu <?php echo ! empty( $menu_item->classes[0] ) ? $menu_item->classes[0] : '' ?>">   
                <?php
                if ( have_rows( 'dropdown_mega_menu', $menu_item->ID ) ) :
                    while ( have_rows( 'dropdown_mega_menu', $menu_item->ID ) ) :
                    the_row(); ?>
                    <?php
                    if ( get_row_layout() == 'dropdown_items_1' ) :
                        ?>
                        <?php
                        if ( get_sub_field( 'heading' ) != null ) :
                        ?>
                        <h6><?php echo get_sub_field( 'heading' ); ?></h6>   
                        <?php
                        endif;
                        ?>                  
                        <div class="sub-menu-list">                            
                        <?php
                                $item_repeater  = get_sub_field( 'item_repeater' );
                                foreach ( $item_repeater as $item ) :
                                    ?>
                                    <a href="<?php echo $item['item_link'] ?>" class="menu-link" target="<?php echo $item['target_link'] ?>">
                                        <span class="menu-title"><?php echo $item['item_heading'] ?></span>
                                        <span class="menu-subTitle"><?php echo $item['item_description'] ?></span>
                                    </a>
                                <?php endforeach; ?>
                        </div>
                    <?php
                    endif; ?>
                <?php
                    endwhile;
                endif; ?>
                </div>
                <?php
                endif; ?>
              </li>
            <?php
            endforeach;
            ?>
            </ul>
        <?php
        if ( ! empty( $field['header_buttons'] ) ):
        ?>
            <div class="login-button">
            <?php
            foreach ( $field['header_buttons'] as $key => $value ) :
            ?>
                <?php
                if ( ! empty( $value['button_label'] ) ):
                ?>
                    <a href="<?php echo ! empty( $value['button_url']['url'] ) ? $value['button_url']['url'] : 'javascript:void(0)' ?>" class="<?php echo ! empty( $value['button_class'] ) ? $value['button_class'] : '' ?>" target="<?php echo ! empty( $value['button_url']['target'] ) ? $value['button_url']['target'] : '_self' ?>">
                        <?php echo $value['button_label'] ?>
                    </a>
                <?php
                endif;
                ?>
            <?php endforeach; ?>
            </div>
        <?php
        endif;
        ?>
        </div>
    </div>
</nav>

<body <?php body_class(); ?>>
    <!-- header ends -->