<section class="section-spacing blog-section">
    <div class="container">
        <div class="section-header">
            <h2>Blogs</h2>
        </div>
        <?php
        // the query
        $wpb_all_query = new WP_Query(array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => 3,
        )); ?>
        <div class="row justify-content-center">
        <?php if ($wpb_all_query->have_posts()) : ?>
                                <!-- loop -->
        <?php while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post(); ?>
            <?php
            $current_id = get_the_ID();
            $category = get_the_category();
            $cat_name = $category[0]->name;
            $excerpt = get_the_excerpt($current_id);
            $excerpt = substr($excerpt, 0, 130);
            ?>
            <div class="col-lg-4 col-md-6 col-12">
                <div class="card blog-card">
                    <div class="card-header">
                        <a href="<?php the_permalink(); ?>" class="d-block">
                        <?php if (function_exists('add_theme_support')) {
                            the_post_thumbnail();
                        } ?>
                        </a>
                        <span class="tag-categories <?php if ($cat_name == 'Delivery' ) : ?>delivery-cat <?php elseif($cat_name == 'Ordering' ): ?>ordering-cat<?php endif; ?>"><?php echo $cat_name; ?></span>
                    </div>
                    <div class="card-body">
                        <h3 class="blog-title">
                            <a href="<?php the_permalink(); ?>" class="d-block">
                                <?php echo get_the_title() ?>
                            </a>
                        </h3>
                        <p class="blog-text">
                            <?php echo $excerpt . '...'; ?>
                        </p>
                        <div class="d-flex blog-meta-tag justify-content-between">
                            <div class="">
                                <a href="<?php the_permalink(); ?>" class="readMore-link">Read More <i class="fa-solid fa-chevron-right"></i></a>
                            </div>
                            <div class="">
                                <span class="blog-date"><?php the_time('F d , Y'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        <?php else : ?>
            <p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
        <?php endif; ?>
        </div>
    </div>
</section>