<?php
foreach ($themeData['gradient_image_with_text'] as $image_data) :
?>
<section class="section-spacing network-tech-suit <?php echo $image_data['section_class'] ?>">
    <div class="container">
        <div class="<?php echo $image_data['background_class'] ?> inner-spacing">
            <div class="row justify-content-between align-items-center">
                <div class="<?php echo $image_data['col_image_size'] ?>">
                <?php
                    if ( ! empty( $image_data['section_image']['url'] ) ):
                ?>
                    <img src="<?php echo $image_data['section_image']['url']; ?>" alt="<?php echo $image_data['section_image']['alt']; ?>" class="img-fluid <?php echo $image_data['image_class'] ?>">
                <?php 
                    endif;
                ?>
                </div>
                <div class="<?php echo $image_data['col_text_size'] ?>">
                <div class="network-tech-suit-content">
                <?php
                    if ( ! empty( $image_data['heading'] ) ):
                ?>
                    <h2><?php echo $image_data['heading'] ?></h2>
                <?php 
                    endif;
                ?>
                    <?php
                    if ( ! empty( $image_data['description'] ) ):
                    ?>
                    <?php echo $image_data['description'] ?>
                    <?php 
                    endif;
                    ?>
                    <?php
                    if ( ! empty( $image_data['button_label'] ) ):
                    ?>
                    <div class="link-text">
                        <a href="<?php echo ! empty( $image_data['button_link']['url'] ) ? $image_data['button_link']['url'] : 'javascript:void(0)' ?>" target="<?php echo ! empty( $image_data['button_link']['target'] ) ? $image_data['button_link']['target'] : '_self' ?>" class="link-text"> <?php echo $image_data['button_label'] ?> <i class="fa-solid fa-chevron-right"></i></a>
                    </div>
                    <?php
                    endif;
                    ?>
                </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php 
endforeach;
?>