<?php
$current_tag = get_queried_object();
$resourcesData = get_fields('option');
if (isset($resourcesData['resources_listings']) && is_array($resourcesData['resources_listings'])) :
?>
    <section class="resource-menu-section">
        <div class="faq-tab-nav">
            <div class="container">
                <?php
                if (isset($resourcesData['resources_listings']['section_heading']) && !empty($resourcesData['resources_listings']['section_heading'])) :
                ?>
                    <h2><?php echo $resourcesData['resources_listings']['section_heading'] ?></h2>
                <?php
                endif;
                ?>
                <?php
                if (isset($resourcesData['resources_listings']['blog_categories']) && is_array($resourcesData['resources_listings']['blog_categories'])) :
                ?>
                    <ul class="list-inline faq-menu">
                        <?php
                        foreach ($resourcesData['resources_listings']['blog_categories'] as $CategoryRepeater) : ?>
                            <?php if (!empty($CategoryRepeater['category_title'])) :
                            ?>
                                <li class="list-inline-item">
                                    <a href="<?php echo !empty($CategoryRepeater['category_link']['url']) ? $CategoryRepeater['category_link']['url'] : 'javascript:void(0)' ?>" target="<?php echo !empty($CategoryRepeater['category_link']['target']) ? $CategoryRepeater['category_link']['target'] : '_self' ?>"><?php echo $CategoryRepeater['category_title']; ?></a>
                                </li>
                            <?php endif; ?>
                        <?php
                        endforeach;
                        ?>
                    </ul>
                <?php
                endif;
                ?>
            </div>
        </div>
    </section>
    <section class="section-spacing resource-list">
        <div class="container">
            <div class="blog-list-row">
                <div class="blog-list-col">
                    <form role="search" class="resource-search" method="get" id="searchform" action="<?php echo esc_url(home_url('/')); ?>">
                        <input class="resource-search-input" type="text" placeholder="I'm looking for..." value="" name="s" id="s">
                        <button class="resource-search-icon" type="submit" id="searchsubmit" value="Search">
                            <i class="fa-solid fa-magnifying-glass"></i>
                        </button>
                    </form>
                    <div class="blog-list-header">
                        <?php
                        if (isset($resourcesData['resources_listings']['blogs_heading']) && !empty($resourcesData['resources_listings']['blogs_heading'])) :
                        ?>
                            <h2><?php echo $resourcesData['resources_listings']['blogs_heading'] ?></h2>
                        <?php
                        endif;
                        ?>
                    </div>
                    <?php
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                    $the_query = array(
                        'post_type' => 'post',
                        'post_status' => 'publish',
                        'posts_per_page' => 4,
                        'paged' => $paged,
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'resource_type',
                                'field'    => 'name',
                                'terms'    => 'blog',
                            )
                        )
                    );
                    ?>
                    <?php
                    $wpb_all_query = new WP_Query($the_query);
                    ?>
                    <div class="row resource-blog-list-row">
                        <?php if ($wpb_all_query->have_posts()) : ?>
                            <!-- loop -->
                            <?php while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post(); ?>
                                <?php
                                $current_id = get_the_ID();
                                $category = get_the_category();
                                $cat_name = $category[0]->name;
                                $excerpt = get_the_excerpt($current_id);
                                $excerpt = substr($excerpt, 0, 130);
                                ?>
                                <div class="col-lg-6 resource-blog-list-col">
                                    <div class="card blog-card">
                                        <div class="card-header">
                                            <a href="<?php the_permalink(); ?>" class="d-block">
                                                <?php if (function_exists('add_theme_support')) {
                                                    the_post_thumbnail();
                                                } ?>
                                            </a>
                                            <span class="tag-categories "><?php echo $cat_name; ?></span>
                                        </div>
                                        <div class="card-body">
                                            <h3 class="blog-title">
                                                <a href="<?php the_permalink(); ?>" class="d-block">
                                                    <?php echo get_the_title() ?>
                                                </a>
                                            </h3>
                                            <p class="blog-text">
                                                <?php echo $excerpt . '...'; ?>
                                            </p>
                                            <div class="d-flex blog-meta-tag justify-content-between">
                                                <div class="">
                                                    <a href="<?php the_permalink(); ?>" class="readMore-link"><?php echo !empty($resourcesData['resources_listings']['read_more_text']) ? $resourcesData['resources_listings']['read_more_text'] : 'Read More' ?> <i class="fa-solid fa-chevron-right"></i></a>
                                                </div>
                                                <div class="">
                                                    <span class="blog-date"><?php the_time('F d , Y'); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile;
                            ?>
                            <?php wp_reset_postdata(); ?>
                        <?php else : ?>
                            <p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="pagination-resource">
                    <?php
                    /** Pagination query */                    
                    $total_pages = $wpb_all_query->max_num_pages;
                    if ($total_pages > 1){
                        $current_page = max(1, get_query_var('paged'));
                        echo paginate_links(array(
                            'base' => get_pagenum_link(1) . '%_%',
                            'format' => '/page/%#%',
                            'current' => $current_page,
                            'total' => $total_pages,
                            'prev_text'    => __('Prev'),
                            'next_text'    => __('Next'),
                        ));
                    } ?>
                    </div>
                </div>
                <aside class="blog-sidebar">
                    <div class="blog-sidebar-content">
                        <?php
                        if (isset($resourcesData['resources_listings']['sidebar_category_title']) && !empty($resourcesData['resources_listings']['sidebar_category_title'])) :
                        ?>
                            <h3><?php echo $resourcesData['resources_listings']['sidebar_category_title'] ?></h3>
                        <?php
                        endif;
                        ?>
                        <?php
                        // the query
                        $args = new WP_Query(array(
                            'post_type' => 'post',
                            'post_status' => 'publish',
                            'category_name' => 'Complete Guides',
                            'posts_per_page' => 3,
                        )); ?>
                        <?php if ($args->have_posts()) : ?>
                            <!-- loop -->
                            <ul class="list-unstyled">
                                <?php while ($args->have_posts()) : $args->the_post(); ?>
                                    <li>
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        <span><?php the_time('jS F'); ?></span>
                                    </li>
                                <?php endwhile; ?>
                                <div class="blog-sidebar-link">
                                    <?php
                                    $category = get_the_category();
                                    $first_category = $category[0];
                                    $catLink = get_category_link($first_category);
                                    ?>
                                    <a href="<?php echo get_category_link($first_category); ?>" class="">
                                        <?php echo !empty($resourcesData['resources_listings']['sidebar_posts_read_more_text']) ? $resourcesData['resources_listings']['sidebar_posts_read_more_text'] : 'Read More' ?> <i class="fa-solid fa-angle-right"></i>
                                    </a>
                                </div>
                            </ul>
                            <?php wp_reset_postdata(); ?>
                        <?php else : ?>
                            <p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
                        <?php endif; ?>
                    </div>
                </aside>


            </div>
        </div>
    </section>
<?php
endif;
?>