<?php
foreach ($themeData['tabs_slider'] as $tabsdata) :
?>
<!--Start High Performance Tech Capabilities -->
<section class="section-spacing bg-light <?php echo $tabsdata['section_class']; ?>">
    <div class="container">
        <div class="section-header">
            <?php
            if ( ! empty( $tabsdata['heading'] ) ):
            ?>
                <h2><?php echo $tabsdata['heading']; ?></h2>
            <?php
            endif;
            ?>
            <?php
            if ( ! empty( $tabsdata['description'] ) ):
            ?>
                <?php echo $tabsdata['description']; ?>
            <?php
            endif;
            ?>
        </div>
        <?php
        if (isset($tabsdata['tabs_data']) && is_array($tabsdata['tabs_data'])) :
        ?>
        <div class="tab-slider-section bg-white inner-spacing">
            <div id="tabHeading" class="owl-carousel owl-theme">
                <?php
                foreach ($tabsdata['tabs_data'] as $tabitem) :
                ?>
                <div class="item">
                    <?php
                    if ( ! empty( $tabitem['tab_title'] ) ):
                    ?>
                        <h5><?php echo $tabitem['tab_title']; ?></h5>
                    <?php
                    endif;
                    ?>
                </div>
                <?php 
                endforeach;
                ?>
            </div>
            <div id="tabContent" class="owl-carousel owl-theme">
                <?php
                foreach ($tabsdata['tabs_data'] as $tabitem) :
                ?>
                <div class="item">
                    <div class="row">
                        <div class="col-md-6">
                            <?php
                            if ( ! empty( $tabitem['content_heading'] ) ):
                            ?>
                                <h3><?php echo $tabitem['content_heading']; ?></h3>
                            <?php
                            endif;
                            ?>
                            <?php
                            if ( ! empty( $tabitem['content_description'] ) ):
                            ?>
                                <?php echo $tabitem['content_description']; ?>
                            <?php
                            endif;
                            ?>
                            <?php
                            if ( ! empty( $tabitem['button_link']['url'] ) ):
                            ?>
                            <div class="card-link">
                                <a href="<?php echo ! empty( $tabitem['button_link']['url'] ) ? $tabitem['button_link']['url'] : 'javascript:void(0)' ?>" target="<?php echo ! empty( $tabitem['button_link']['target'] ) ? $tabitem['button_link']['target'] : '_self' ?>" class="link-text"><?php echo $tabitem['button_label'] ?><i class="fa-solid fa-chevron-right"></i></a>
                            </div>
                            <?php
                            endif;
                            ?>
                        </div>
                        <div class="col-md-6">
                            <div class="tab-content-icon">
                                <?php
                                    if ( ! empty( $tabitem['content_image']['url'] ) ):
                                ?>
                                    <img src="<?php echo $tabitem['content_image']['url']; ?>" alt="<?php echo $tabitem['content_image']['alt']; ?>" class="img-fluid">
                                <?php 
                                    endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php 
                endforeach;
                ?>
            </div>
        </div>
        <?php
        endif;
        ?>
    </div>
</section>
<!--End High Performance Tech Capabilities -->
<?php 
endforeach;
?>