<?php
/**
 * Template Name: Search result Page
 */
get_header(); ?>
<section class="our-resources-blog search-page section-spacing">
	<div class="container">
		<?php
		$s          = get_search_query();
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$argsSearch = array(
			's'              => $s,
			'paged'          => $paged,
			'post_type'      => array('post','case-studies'.'ebooks'),
		);
		$the_query  = new WP_Query($argsSearch);
		$total      = $the_query->found_posts;
		_e("<h1 class='search-heading text-center'>" . $total . " Search Results Found For : ' " . esc_attr(get_query_var('s')) . " '</h1>");
		?>
		<div class="row resource-blog-list-row <?php echo $total ? '' : 'justify-content-center' ?>">
			<?php if ($the_query->have_posts()) :
				while ($the_query->have_posts()) : $the_query->the_post();
					$id        = get_the_id();			
					$thumbnail = get_the_post_thumbnail();
					$image_id    = get_post_thumbnail_id($id);
					$image_title = get_the_title($image_id);
					$category    = get_the_category($id);
					$excerpt     = get_the_excerpt($id);
					$date        = get_the_date($id);
			?>
					<div class="col-lg-4 col-md-6 resource-blog-list-col">
					<div class="card blog-card">
						<a href="<?php the_permalink(); ?>">
							<div class="card-header">
								<?php
								if (!empty($thumbnail) && isset($thumbnail)) :
									echo $thumbnail;
								else :
								?>
									<img class="no-preview" src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/05/no-preview-1.png" alt="No Preview">
								<?php
								endif;
								?>
							</div>
							<div class="card-body">
								<h4 class="blog-title"><?= esc_html(get_the_title()) ?></h4>
								<p class="blog-text"><?= esc_html($excerpt) ?></p>
							</div>
						</a>
					</div>
					</div>
				<?php
				endwhile;
			else :
				?>
				<div class="alert alert-info">
					<p>Sorry, but nothing matched your search criteria. Please try again with some different
						keywords.</p>
				</div>
			<?php
			endif;
			?>			
		</div>
        <!--pagination-->
			<div class="pagination-resource">
                    <?php
						$big = 999999999;
						echo paginate_links(array(
							'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
							'format'    => '?paged=%#%',
							'current'   => max(1, get_query_var('paged')),
							'total'     => $the_query->max_num_pages,
							'prev_text' => '<span>Prev</span>',
							'next_text' => '<span>Next</span>'
						));
						wp_reset_postdata();
						?>
					</div>
			<!--pagination ends-->
	</div>
</section>
<?php get_footer(); ?>