<?php

/**
 * The template for displaying single posts and pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 */
get_header();
$postid             = get_the_ID();
$themeData          = get_fields();
$page_url           = get_permalink($post->ID);
$title              = get_the_title(get_the_ID());
$author_id = get_the_author_meta( 'ID' );
?>
<?php
    if (have_posts()) : while(have_posts()) : the_post(); ?>
<section class="section-spacing">
    <div class="container">
        <div class="single-blog-header">
            <h1><?php the_title(); ?></h1>
        </div>
        <div class="single-blog-row">
            <div class="single-blog-content-col">
                <div class="single-blog-feature-img">
                    <?php if (function_exists('add_theme_support')) {
                        the_post_thumbnail();
                    } ?>
                </div>
                <div class="single-blog-meta-detail">
                    <p class="single-blog-meta-author">
                        <span class="autor-name"><?php echo get_the_author(); ?> </span>
                        <span class="published-date"><?php the_time('F d , Y'); ?></span>
                    </p>
                    <p class="single-blog-social">
                        <a id="fb-share-button" href='http://www.facebook.com/share.php?u=<?php echo urlencode($page_url); ?>&title=<?php echo urlencode($title); ?>' target="_blank">
                            <i class="fa-brands fa-facebook-f" aria-hidden="true"></i>
                        </a>
                        <a id="twitter-share-button" href='http://twitter.com/home?status=<?php echo urlencode($title); ?>+<?php echo urlencode($page_url); ?>' target='_blank'>
                            <i class="fa-brands fa-twitter" aria-hidden="true"></i>
                        </a>
                        <a id="linkdin-share-button" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php print(urlencode($page_url)); ?>&title=<?php echo urlencode($title); ?>&summary=<?php echo $description; ?>&source=<?php echo urlencode($page_url); ?>" target="_blank">
                            <i class="fa-brands fa-linkedin-in" aria-hidden="true"></i>
                        </a>
                    </p>
                </div>
                <div class="single-blog-content">
                    <?php the_content(); ?>
                </div>
                <?php
                $comments = get_comments(array('post_id' => $postid, 'status' => 'approve'));
                ?>
                <div class="single-blog-comment">
                    <h3 class="single-blog-comment-title">
                        <i class="fa fa-comments" aria-hidden="true"></i>
                        <?php echo count($comments); ?> Comments
                    </h3>
                    <?php if (!empty($comments)) {
                        foreach ($comments as $key => $value) { ?>
                            <div class="single-blog-comment-box">
                                <h5><?php echo @ucfirst($value->comment_author); ?></h5>
                                <div class="meta-box">
                                    <span><?php echo @date('d M, Y  h:i:s', strtotime($value->comment_date)); ?></span>
                                </div>
                                <p><?php echo @$value->comment_content; ?></p>
                            </div>
                    <?php }
                    } ?>
                </div>
                <div class="single-blog-comment-form">
                    <?php comment_form(); ?>
                </div>
            </div>
            <aside class="single-blog-sidebar-col">
                <div class="single-blog-sidebar-search">
                    <?php get_search_form(); ?>
                </div>
                <div class="single-sidebar-latest-blog">
                    <?php 
                    $resourcesOptions = get_fields( 'option' ); ?>
                <?php
                if ( isset($resourcesOptions['resources_listings']['latest_blog_text']) && !empty( $resourcesOptions['resources_listings']['latest_blog_text'] ) ):
                ?>
                    <h3><?php echo $resourcesOptions['resources_listings']['latest_blog_text'] ?></h3>
                <?php
                endif;
                ?>
                    <ul class="single-sidebar-blog-list">
                        <?php
                        global $post;
                        $args        = array(
                            'order'            => 'DESC',
                            'suppress_filters' => false,
                            'posts_per_page'   => 3,
                            'orderby'          => 'post_views',
                            'post__not_in' => array(get_the_ID())
                        );
                        $most_viewed = get_posts($args);
                        foreach ($most_viewed as $post) {
                            setup_postdata($post);
                        ?>
                            <li>
                                <div class="single-sidebar-blog-img">
                                    <?php if (function_exists('add_theme_support')) {
                                        the_post_thumbnail();
                                    } ?>
                                </div>
                                <h5 class="single-sidebar-blog-titile">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </h5>
                            </li>
                        <?php }
                        wp_reset_postdata();
                        ?>
                    </ul>
                </div>
        </div>
        </aside>
    </div>
    </div>
</section>
<?php endwhile; else : ?>
    <div id="post-<?php the_ID(); ?>" <?php post_class('no-posts'); ?>>
        <h3>No Posts found</h3>
    </div>
<?php endif; ?>
<?php get_footer(); ?>