<?php

/**
 * Template Name: Contact
 */
$contactData = get_fields();
$currentPage = get_queried_object();
get_header();
?>
<!--start contact form -->
<section class="section-spacing">
    <div class="container">
        <div class="row align-items-center justify-content-between">
            <div class="col-lg-6">
                <div class="ebook-content">
                <?php
                if ( isset($contactData['contact_data']['heading']) && !empty( $contactData['contact_data']['heading'] ) ):
                ?>
                    <h1><?php echo $contactData['contact_data']['heading']; ?></h1>
                <?php
                endif;
                ?>
                <?php
                if ( isset($contactData['contact_data']['description']) && !empty( $contactData['contact_data']['description'] ) ):
                ?>
                    <?php echo $contactData['contact_data']['description']; ?>
                <?php
                endif;
                ?>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="ebook-form">
                <?php
                if ( isset($contactData['contact_data']['contact_form_heading']) && !empty( $contactData['contact_data']['contact_form_heading'] ) ):
                ?>
                    <h2><?php echo $contactData['contact_data']['contact_form_heading']; ?></h2>
                <?php
                endif;
                ?>
                <?php
                 $shortcodedata = isset($contactData['contact_data']['contact_form_shortcode']) ? do_shortcode($contactData['contact_data']['contact_form_shortcode']) : ""; ?>
                <?php echo $shortcodedata; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!--end contact form -->
<?php
if (isset($contactData['timeline_data']) && is_array($contactData['timeline_data'])) :
?>
    <?php include(get_template_directory() . '/includes/timeline.php'); ?>
<?php
endif;
?>
<?php
get_footer();
?>
