<?php

/**
 *Template Name: Partner
 */
$themeData = get_fields();
get_header(); 

?>
<!--start hero banner -->
<?php if (isset($themeData['growing_bussines']) && is_array($themeData['growing_bussines'])) : ?>
<section id="<?php echo isset($themeData['growing_bussines']['section_id']) ? $themeData['growing_bussines']['section_id'] : ''; ?>" class="hero-inner-banner bg-img section-spacing" <?php if (!empty($themeData['growing_bussines']['background_image']['url'])) { ?> style="background-image: url(<?php echo $themeData['growing_bussines']['background_image']['url'] ?>); "<?php } ?>>
    <div class="container">
        <div class="d-flex align-items-center justify-content-between flex-wrap">
                <div class="inner-banner-content">
                    <h1><?php echo isset($themeData['growing_bussines']['heading']) ? $themeData['growing_bussines']['heading'] : ''; ?></h1>
                    <p><?php echo isset($themeData['growing_bussines']['short_info']) ? $themeData['growing_bussines']['short_info'] : ''; ?></p>
                </div>
            <div class="form-banner-design">                
                <?php if (!empty($themeData['growing_bussines']['form_heading'])) : ?>
                    <h4><?php echo $themeData['growing_bussines']['form_heading']; ?></h4>
                <?php endif; 
                 $shortcodedata = isset($themeData['growing_bussines']['contact_form_shortcode']) ? do_shortcode($themeData['growing_bussines']['contact_form_shortcode']) : "";
                ?>
                    <?php 
                    echo $shortcodedata; ?>
                </div>
        </div>
    </div>
</section>
<?php endif; ?>
<!--end hero banner -->
<?php if (isset($themeData['partner_program_heading']) && !empty($themeData['partner_program_heading'])) : ?>
<!--start join our partner program -->
<section class="section-spacing">
    <div class="container">
        <div class="section-header">
            <h2><?php echo isset($themeData['partner_program_heading']) ? $themeData['partner_program_heading'] : ''; ?></h2>
            <p><?php echo isset($themeData['partner_program_subheading']) ? $themeData['partner_program_subheading'] : ''; ?></p>
        </div>
        <div class="">
        <?php
        if (isset($themeData['image_and_sidetext']) && is_array($themeData['image_and_sidetext'])) :
            foreach ($themeData['image_and_sidetext'] as $textandicon) :
                $shortinfo = isset($textandicon['text_side_of_image']) ? $textandicon['text_side_of_image'] : '';
                $buttontext = isset($textandicon['button_text']) ? $textandicon['button_text'] : '';
                $rowClass = isset($textandicon['row_class']) ? $textandicon['row_class'] : '';
                $buttonlink = isset($textandicon['button_link']['url']) ? $textandicon['button_link']['url'] : 'javascript:void(0)';
                echo '
                <div class="row row-spacing '. $rowClass.' align-items-center justify-content-between">
                    <div class="col-md-6">
                        <div class="program-image">
                        <img src="'.$textandicon['image']['url'].'" alt="'.$textandicon['image']['alt'].'" class="img-fluid">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="program-content">
                        ' . $shortinfo . '
                          <div class="button-link">
                            <a href="'.$buttonlink.'" class="btn-sm-gradient">' . $buttontext . '</a>
                          </div>
                        </div>
                    </div>
                </div>';
            endforeach;
        endif;
        ?>
        </div>
    </div>
</section>
<?php endif; ?>
<!--end join our partner program -->
<!--start partner map -->
<?php
if (isset($themeData['map_model_content']) && is_array($themeData['map_model_content'])) :
?>
<section class="partner-image-map">
    <?php
    foreach ($themeData['map_model_content'] as $mapdata) :
    ?>
    <figure style="text-align: center; display: block;">
        <?php
        if (isset($mapdata['modal_buttons']) && is_array($mapdata['modal_buttons'])) :
        foreach ($mapdata['modal_buttons'] as $mapbuttons) : 
        ?>
            <?php
            if (isset($mapbuttons['button_class']) && isset($mapbuttons['button_target']) && !empty($mapbuttons['button_class']) && !empty($mapbuttons['button_target'])) :
            ?>
            <div class="<?php echo $mapbuttons['button_class']; ?> popUpBtn" data-modal="<?php echo $mapbuttons['button_target']; ?>"></div>
            <?php endif; ?>
        <?php endforeach; ?>
        <?php endif; ?>
        <?php if (isset($mapdata['map_main_image']['url']) && !empty($mapdata['map_main_image']['url'])) :
        ?>
            <lottie-player src="<?php echo $mapdata['map_main_image']['url']; ?>" background="transparent" speed="1" loop="" autoplay=""></lottie-player>
        <?php endif; ?>
    </figure>

    <!-- start  Modal -->
    <?php
    foreach ($mapdata['modal_content'] as $mapitem) : 
    ?>
    <div id="<?php echo $mapitem['modal_id']; ?>" class="modal map-detail-popup" style="display: none;">
        <!-- Modal content -->
        <div class="container">
            <span class="close"> <i class="fa-solid fa-chevron-left"></i><?php echo $mapdata['modal_close_text']; ?></span>
            <?php if (isset($mapitem['modal_map_image']['url']) && !empty($mapitem['modal_map_image']['url'])) :
            ?>
            <div class="map-image">
                <img src="<?php echo $mapitem['modal_map_image']['url']; ?>" alt="<?php echo $mapitem['modal_map_image']['alt']; ?>" class="img-fluid">
            </div>
            <?php endif; ?>
            <div class="map-content">
            <?php if (isset($mapitem['continent_title']) && !empty($mapitem['continent_title'])) :
            ?>
                <div class="map-content-title">
                    <h4><?php echo $mapitem['continent_title']; ?></h4>
                </div>
            <?php endif; ?>
            <?php
            if (isset($mapitem['company_info']) && is_array($mapitem['company_info'])) :
            ?>
                <div class="row align-items-center justify-content-center">
                <?php 
                foreach ($mapitem['company_info'] as $val) { 
                ?>
                    <div class="col-md-4">
                        <div class="state-info">
                            <?php if (!empty($val['brand_logo'])) { ?>
                            <div class="client-logo-image">
                                <img class="client-branch-logo" src="<?php echo $val['brand_logo']['url']; ?>" alt="<?php echo $val['brand_logo']['alt']; ?>">
                            </div>    
                            <?php } ?>
                            <div class="state-info-content">
                                <?php if (!empty($val['company_title'])) { ?>
                                    <h5><?php echo $val['company_title'] ?></h5>
                                <?php } ?>
                                <?php if (!empty($val['company_location'])) { ?>
                                    <p><?php echo $val['company_location'] ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <!-- end  Modal -->
    <?php endforeach; ?>
</section>
<?php endif; ?>
<!--end partner map -->

<!--Start Why Become a NetworkON Partner?-->
<section class="section-spacing">
    <div class="container">
        <div class="section-header">
            <h2><?php  echo isset($themeData['multigrid_module']['heading']) ? $themeData['multigrid_module']['heading'] : ''; ?></h2>
            <p><?php  echo isset($themeData['multigrid_module']['sub_heading']) ? $themeData['multigrid_module']['sub_heading'] : ''; ?></p>
        </div>
        <div class="row align-items-stretch justify-content-between">
        <?php
        if (isset($themeData['multigrid_module']['card_repeater']) && is_array($themeData['multigrid_module']['card_repeater'])) :
            foreach ($themeData['multigrid_module']['card_repeater'] as $cardRepeater) :
            ?>
            <div class="col-md-4">
                <div class="partner-col">
                  <?php if (isset($cardRepeater['card_image']['url']) && !empty($cardRepeater['card_image']['url'])) : ?>
                    <img src="<?php echo $cardRepeater['card_image']['url'] ?>" alt="<?php echo $cardRepeater['card_image']['url'] ?>">
                  <?php endif; ?>
                  <?php if (isset($cardRepeater['card_heading']) && !empty($cardRepeater['card_heading'])) : ?>
                    <h3><?php echo $cardRepeater['card_heading'] ?></h3>
                  <?php endif; ?>
                  <?php if (isset($cardRepeater['card_description']) && !empty($cardRepeater['card_description'])) : ?>
                    <?php echo $cardRepeater['card_description'] ?>
                  <?php endif; ?>
                </div>
            </div>
        <?php
            endforeach;
        endif; ?>
        </div>
    </div>
</section>
<!--End Why Become a NetworkON Partner?-->
<?php if (isset($themeData['customer_referral']['heading']) && !empty($themeData['customer_referral']['heading'])) : ?>
<section class="section-banner-spacing bg-img banner-cta-section" <?php if (!empty($themeData['customer_referral']['background_image']['url'])) { ?> style="background-image: url(<?php echo $themeData['customer_referral']['background_image']['url'] ?>); "<?php } ?>>
    <div class="container text-center">
        <h3 class="text-white"><?php echo isset($themeData['customer_referral']['heading']) ? $themeData['customer_referral']['heading'] : ''; ?></h3>
        <p class="text-white"><?php echo isset($themeData['customer_referral']['subheading']) ? $themeData['customer_referral']['subheading'] : ''; ?></p>
        <div class="">
        <?php
        $buttonlink = isset($themeData['customer_referral']['button_link']['url']) ? $themeData['customer_referral']['button_link']['url'] : 'javascript:void(0)';
        ?>
            <a href="<?php echo $buttonlink; ?>" class="btn-lg-gradient"><?php echo isset($themeData['customer_referral']['button_text']) ? $themeData['customer_referral']['button_text'] : ''; ?></a>
        </div>
    </div>
</section>
<?php endif; ?>
<?php if (isset($themeData['faq_group']) && is_array($themeData['faq_group'])) : 
    ?>
    <?php include( get_template_directory() . '/includes/faqs.php' ); ?>
<?php endif; ?>
<!-- Start of HubSpot Embed Code -->
<script type="text/javascript" id="hs-script-loader" async defer src="//js.hs-scripts.com/19573735.js"></script>
<!-- End of HubSpot Embed Code -->
<?php
get_footer();
?>