<?php
/**
 *Template Name: Pricing Page
 */
$themeData = get_fields();
$currentPage = get_queried_object();
get_header();
?>
<!--Pricing page-->

<?php if (isset($themeData['pricing_cards']) && is_array($themeData['pricing_cards'])) : ?>
<section class="pricing-setion section-spacing">
    <div class="container">
        <div class="row">
        <?php if (!empty($themeData['pricing_cards']['section_heading'])) : ?>
            <h1 class="text-center"><?php echo $themeData['pricing_cards']['section_heading']; ?></h1>
        <?php endif; ?>
            <div class="pricing-card-outer">
            <?php
            if (isset($themeData['pricing_cards']['card_data']) && is_array($themeData['pricing_cards']['card_data'])) :
                foreach ($themeData['pricing_cards']['card_data'] as $pricingdata) :
            ?>
                <div class="pricing-card">
                    <div class="card-header">
                    <?php if (!empty($pricingdata['heading'])) : ?>
                        <h2><?php echo $pricingdata['heading']; ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($pricingdata['sub_heading'])) : ?>
                        <h5><?php echo $pricingdata['sub_heading']; ?></h5>
                    <?php endif; ?>
                    </div>
                    <div class="card-body">
                    <ul>
                    <?php
                    if (isset($pricingdata['features_list']) && is_array($pricingdata['features_list'])) :
                        foreach ($pricingdata['features_list'] as $featuresData) :
                    ?>
                        <li> 
                        <?php if ($featuresData['availablity_check'] == 'yes') : 
                        ?>
                            <?php if (!empty($themeData['pricing_cards']['feature_yes_icon']['url'] )) : ?>
                            <img src="<?php echo $themeData['pricing_cards']['feature_yes_icon']['url'] ?>"alt="Feature yes icon" >
                            <?php endif; ?>
                        <?php else : ?>
                            <?php if (!empty($themeData['pricing_cards']['feature_no_icon']['url'] )) : ?>
                            <img src="<?php echo $themeData['pricing_cards']['feature_no_icon']['url'] ?>" alt="Feature no icon" >
                            <?php endif; ?>
                        <?php endif; ?>
                            <?php 
                            if (!empty($featuresData['feature_label'] )) : 
                                echo $featuresData['feature_label']; 
                            endif; ?>
                        </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    </ul>
                    </div>
                    <?php if (!empty($pricingdata['button_label'])) : ?>
                    <div class="card-button">                    
                        <a class="<?php echo $pricingdata['button_class']; ?>" <?php if (empty($pricingdata['button_url']['url'])) : ?> aria-disabled="true" disabled <?php else : ?> href="<?php echo $pricingdata['button_url']['url']; ?>" <?php endif; ?> target="<?php echo ! empty( $pricingdata['button_url']['target'] ) ? $pricingdata['button_url']['target'] : '_self' ?>"><?php echo $pricingdata['button_label']; ?></a>                    
                   </div>
                   <?php endif; ?>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>   
<!--start CTA banner -->
<?php if (isset($themeData['cta_data']) && is_array($themeData['cta_data'])) : ?>
    <?php include( get_template_directory() . '/includes/cta-banner.php' ); ?>
<?php endif; ?> 
<!--end CTA banner -->
<!----modal---->
<?php if (isset($themeData['modal_data']) && is_array($themeData['modal_data'])) : 
?>
  <div class="modal fade pricing-popup" id="<?php echo !empty( $themeData['modal_id'] ) ? $themeData['modal_id'] : '' ?>" tabindex="-1" aria-labelledby="pricing-modalLabel" aria-hidden="true">
    <?php include( get_template_directory() . '/includes/button-modal.php' ); ?>
  </div>
<?php endif; ?>
<!----end modal-->
<!-----faq---->
<?php if (isset($themeData['faq_group']) && is_array($themeData['faq_group'])) : 
    ?>
    <?php include( get_template_directory() . '/includes/faqs.php' ); ?>
<?php endif; ?>
<?php
get_footer();
?>