<?php

/**
 * Template Name: Home page
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<section class="home-banner">
  <div class="container">
    <div class="row">
      <div class="col-md-6">
        <div class="home-banner-content">
          <?php if (isset($field['banner_heading']) && !empty($field['banner_heading'])) : ?>
            <h1><?php echo $field['banner_heading'] ?></h1>
          <?php endif; ?>
          <?php echo $field['banner_subheading'] ?>
        </div>
      </div>
      <div class="col-md-6">
        <div class="home-banner-image owl-carousel">
          <?php foreach ($field['banner_images_silder'] as  $banner_images_silder) : ?>
            <div class="item">
              <?php if (isset($banner_images_silder['banner_image']['url']) && !empty($banner_images_silder['banner_image']['url'])) : ?>
                <img src="<?php echo $banner_images_silder['banner_image']['url'] ?>" alt="<?php echo $banner_images_silder['banner_image']['alt'] ?>">
              <?php endif ?>
            </div>
          <?php endforeach ?>
        </div>
      </div>
      <div class="input-box">
        <i class="fa fa-search"></i>
        <!-- <input type="text" placeholder="Job Tittle or Keyword" /> -->
        <?php get_search_form(); ?>
      </div>
    </div>
</section>


<section class="find-your-team">
  <div class="container">
    <div class="find-team-content">
      <?php if (isset($field['team_heading']) && !empty($field['team_heading'])) : ?>
        <h2><?php echo $field['team_heading'] ?></h2>
      <?php endif ?>
      <?php if (isset($field['team_subheading']) && !empty($field['team_subheading'])) : ?>
        <p><?php echo $field['team_subheading'] ?></p>
      <?php endif ?>
    </div>
  </div>
  <div class="animation-accordion">
    <div class="authoring-conversations">
      <div class="container">
        <div class="c-feature-ticker c-feature-ticker--dark js-fade-in js-feature-ticker " id="block_6232555f25c86">
          <div class="o-container">
            <div class="c-feature-ticker__wrap">
              <div class="c-feature-ticker__text-wrap">
                <div class="c-feature-ticker__list js-feature-ticker-list">
                  <?php foreach ($field['team_tabs'] as $key => $team_tabs) :

                  ?>
                    <?php if (isset($team_tabs['team_tab_image']['url']) && !empty($team_tabs['team_tab_image']['url'])) : ?>
                      <div class="c-feature-ticker__item js-fade-in-item c-feature-ticker__item-0 js-feature-ticker-item u-fade-out u-fade-in <?php if ($key == 0) {
                                                                                                                                                echo "c-feature-ticker__item--active";
                                                                                                                                              }   ?>" data-item-image-url="<?php echo $team_tabs['team_tab_image']['url'] ?>">
                        <h3 class="js-feature-ticker-item-trigger">
                          <?php if (isset($team_tabs['team_tab_heading']) && !empty($team_tabs['team_tab_heading'])) : ?>
                            <?php echo $team_tabs['team_tab_heading'] ?></h3>
                      <?php endif ?>
                      <p class="c-feature-ticker__item-headline js-feature-ticker-item-trigger">
                        <?php echo $team_tabs['team_tab_description'] ?></p>
                      <?php if (isset($team_tabs['team_link']['url']) && !empty($team_tabs['team_link']['url'])) : ?>
                        <a class="custom-link-animation" href="<?php echo $team_tabs['team_link']['url'] ?>" target="_self"> <?php echo $team_tabs['team_link']['title'] ?> <i class="fa fa-angle-right"></i></a>
                      <?php endif ?>
                      <div class="c-feature-ticker__item-content js-feature-ticker-item-content">
                      <?php if (isset($team_tabs['team_tab_image']['url']) && !empty($team_tabs['team_tab_image']['url'])) : ?>
                        <img decoding="async" class="c-feature-ticker__image c-feature-ticker__image--inline o-image" src="<?php echo $team_tabs['team_tab_image']['url'] ?>" alt="<?php echo $team_tabs['team_tab_image']['alt'] ?>)" width="969" height="547" loading="lazy">
                        <?php endif ?>

                      </div>
                      </div>
                    <?php endif ?>
                  <?php endforeach ?>
                </div>
              </div>
              <?php foreach ($field['team_tabs'] as $key => $team_tabs) :

              ?>
                <div class="c-feature-ticker__image-wrap js-fade-in-item u-fade-out u-fade-in" style="transition-delay: 0.3s;">

                  <img decoding="async" class="c-feature-ticker__image c-feature-ticker__image--left js-feature-ticker-image o-image o-image--hang-left" src="<?php echo $team_tabs['team_tab_image']['url'] ?>" alt="Actionable Revenue Analytics" width="969" height="547" loading="lazy">

                </div>
              <?php endforeach ?>
            </div>
            <script class="js-feature-ticker-duration" type="application/json">
              6000
            </script>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="begin-search">
  <div class="container">
    <div class="begin-search-content">
      <?php if (isset($field['counter_heading']) && !empty($field['counter_heading'])) : ?>
        <h2><?php echo $field['counter_heading'] ?></h2>
      <?php endif ?>
      <div class="row">
        <div class="col-md-4">
          <div class="numbered-list">
            <?php foreach ($field['left_counters'] as  $left_counter) : ?>
              <div class="list-item" data-index="<?php echo $left_counter['left_counter_number'] ?>">
                <div class="circle"><?php echo $left_counter['left_counter_number'] ?></div>
                <span class="list-text"><?php echo $left_counter['left_counter_text'] ?></span>
              </div>
            <?php endforeach ?>
          </div>
          <div class="begin-search-btn">
            <?php if (isset($field['counter_button']['url']) && !empty($field['counter_button']['url'])) : ?>
              <a class="button custom-button1" href="<?php echo $field['counter_button']['url'] ?>"><?php echo $field['counter_button']['title'] ?><span class="arrow1"><i class="fas fa-arrow-right"></i></span></a>
            <?php endif ?>
          </div>
        </div>
        <div class="col-md-8">
          <div class="begin-search-img">
            <?php if (isset($field['counter_image']['url']) && !empty($field['counter_image']['url'])) : ?>
              <img src="<?php echo $field['counter_image']['url'] ?>" alt="<?php echo $field['counter_image']['alt'] ?>">
            <?php endif ?>
            <div class="search-data">
              <ul class="search-data-list">
                <?php foreach ($field['right_counters'] as  $right_counter) : ?>
                  <li>
                    <?php if (isset($right_counter['counter_number']) && !empty($right_counter['counter_number'])) : ?>
                      <h4><?php echo $right_counter['counter_number'] ?>+</h4>
                    <?php endif ?>
                    <?php if (isset($right_counter['counter_text']) && !empty($right_counter['counter_text'])) : ?>
                      <p><?php echo $right_counter['counter_text'] ?></p>
                    <?php endif ?>
                  </li>
                <?php endforeach ?>
              </ul>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>




<?php get_template_part('/common/carousel', 'section', $themeData); ?>

<?php get_template_part('/common/why-join-us', 'section', $themeData); ?>
<section class="life-at-escalon">
  <div class="container">
    <div class="life-at-escalon-content">
      <h2><?php echo $themeData['gallery_heading'] ?></h2>
      <p><?php echo $themeData['gallery_subheading'] ?></p>
    </div>
    <div class="life-at-escalon-gallery">
      <?php echo do_shortcode('[modula id="255"]') ?>
    </div>

  </div>
</section>

<div class="follow-us">
  <div class="container">
    <div class="main-div">
      <a href="https://www.instagram.com/escalon.india/?igshid=NzZlODBkYWE4Ng%3D%3D" target="_blank">
        <p>Follow us on Instagram</p><i class="fa fa-instagram" aria-hidden="true"></i>
      </a>
    </div>
  </div>
</div>
<?php get_template_part('/common/recent-jobs', 'section', $themeData); ?>

<?php get_footer(); ?>