<?php

function load_stylesheets()
{
    wp_enqueue_style('bootstrap', get_template_directory_uri() . "/assets/css/bootstrap.css");
    wp_enqueue_style('owl-carousel', get_template_directory_uri() . "/assets/css/owl.carousel.min.css");
      wp_enqueue_style('theme', get_template_directory_uri() . "/assets/css/owl.theme.default.css");
    wp_enqueue_style('owl-perry', get_template_directory_uri() . "/assets/css/perry-weather.css");
  
    wp_enqueue_style('custom', get_template_directory_uri() . "/assets/css/custom-style.css", array(), time());
    wp_enqueue_style('style', get_template_directory_uri() . "/assets/css/style.css", array(), time());
}

add_action('wp_enqueue_scripts', 'load_stylesheets');
function addjs()
{
  wp_enqueue_script('jquery', get_template_directory_uri() . "/assets/js/jquery.min.js", array(), '3.6.0', true);
wp_enqueue_script('owl-carousel-jsss', get_template_directory_uri() . "/assets/js/owl.carousel.min.js", array(), '2.3.4', true);
wp_enqueue_script('mapbox-js', get_template_directory_uri() . "/assets/js/mapbox-gl.js", array(), time(), true);
wp_enqueue_script('perry-js', get_template_directory_uri() . "/assets/js/perry-weather.js", array(), time(), true);
// ... enqueue other scripts ...

    // Enqueue other scripts dependent on jQuery and Owl Carousel
    wp_enqueue_script('bootstrap-js', get_template_directory_uri() . '/assets/js/bootstrap.js', array(), null, true);
    wp_enqueue_script('custom-js', get_template_directory_uri() . "/assets/js/script.js", array(), time(), true);
    wp_enqueue_script('fav-js', get_template_directory_uri() . "/assets/js/fav.js", array(), '2.3.4', true);
    
}

add_action('wp_enqueue_scripts', 'addjs');
function register_menu()
{
  register_nav_menus(
    array(
      'primary-menu' => 'Primary Menu',
      'footer-menu' => 'Footer Menu'

    )
  );
}
add_action("init", "register_menu");


//add Theme setting link in wordpress end

if (function_exists('acf_add_options_page')) {
	acf_add_options_page(array(
	  'page_title'  => 'Theme General Settings',
	  'menu_title'  => 'Theme Settings',
	  'menu_slug'   => 'theme-general-settings',
	  'capability'  => 'edit_posts',
	  'redirect'    => false
	));
	acf_add_options_sub_page(array(
	  'page_title'  => 'Theme Header Settings',
	  'menu_title'  => 'Header',
	  'parent_slug' => 'theme-general-settings',
	));
	acf_add_options_sub_page(array(
	  'page_title'  => 'Theme Footer Settings',
	  'menu_title'  => 'Footer',
	  'parent_slug' => 'theme-general-settings',
	));
  }
  //add Theme setting link in wordpress end



// adding new features to wordpress theme
function fn_theme_supports()
{
  add_theme_support('title-tag');
  add_theme_support('post-thumbnails');
  add_theme_support('html5', array('search-form'));
  add_theme_support('custom-logo');
}
add_action('after_setup_theme', 'fn_theme_supports');

//register naviagation menu_slug
function fn_nav_menu()
{
  register_nav_menus(array(
    'primary-menu' => __('Primary Menu', 'text_domain'),
    'footer-menu' => __('Footer Menu', 'text_domain')
  ));
}
add_action('init', 'fn_nav_menu');

// Add 'nav-item' class to anchor and list for header start
add_filter('nav_menu_css_class', function ($classes, $item) {
    // Check if the current menu item has children (sub-menus)
    if (in_array('menu-item-has-children', $item->classes)) {
        $classes[] = 'nav-item dropdown';
    } else {
        $classes[] = 'nav-item';
    }
    // Check if the current menu item is the current page
    if (in_array('current-menu-item', $item->classes)) {
        $classes[] = 'current-nav-item';
    }
    return $classes;
}, 10, 2);
// Add 'dropdown-menu' class to sub-menu when the item has children
add_filter('nav_menu_submenu_css_class', function ($classes, $args, $depth) {
    $classes[] = 'dropdown-menu';
    return $classes;
}, 10, 3);
// Add attributes to nav menu link when the item has children
add_filter('nav_menu_link_attributes', function ($atts, $item, $args) {
    // Check if the current menu item has children (sub-menus)
    if (in_array('menu-item-has-children', $item->classes)) {
        $atts['class'] = 'nav-link dropdown-toggle';
        $atts['data-bs-toggle'] = 'dropdown';
        $atts['role'] = 'button';
        $atts['aria-expanded'] = 'false';
    } else {
        $atts['class'] = 'nav-link';
    }
    return $atts;
}, 10, 3);


//add class to anchor and list for header end


function cc_mime_types($mimes)
{
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');
function fix_svg()
{
  echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
}
add_action('admin_head', 'fix_svg');
// Allow SVG code end




//custom jobs
function custom_post_jobs()
{
  $labels = array(
    'name'               => _x('Jobs', 'post type general name'),
    'singular_name'      => _x('Jobs', 'post type singular name'),
    'all_items'          => __('All Jobs'),
    'menu_name'          => 'Jobs'
  );
  $args = array(
    'labels'        => $labels,
    'public'        => true,
    'supports'      => array('title', 'editor', 'thumbnail', 'custom-fields', 'excerpt'),
    'has_archive'   => true,
    "publicly_queryable" => true,
"query_var" => true,
'taxonomies' => array('post_tag'),
  );
  register_post_type('jobs', $args);
}
add_action('init', 'custom_post_jobs');
function themes_taxonomy() {
  register_taxonomy(
      'Key_skills',  // The name of the taxonomy. Name should be in slug form (must not contain capital letters or spaces).
      'jobs',             // post type name
      array(
          'hierarchical' => true,
          'label' => 'Key Skills', // display name
          'query_var' => true,
          'rewrite' => array(
              'slug' => 'key-skills'   // This controls the base slug that will display before each term
          )
      )
  );
}
add_action( 'init', 'themes_taxonomy');

// Function to register Location taxonomy
function location_taxonomy() {
  register_taxonomy(
      'location',            // The name of the taxonomy. Name should be in slug form.
      'jobs',                // Post type name
      array(
          'hierarchical' => true,
          'label' => 'Location', // Display name
          'query_var' => true,
          'rewrite' => array(
              'slug' => 'location' // Base slug
          )
      )
  );
}
add_action('init', 'location_taxonomy');

// Function to register Team taxonomy
function team_taxonomy() {
  register_taxonomy(
      'team',                // The name of the taxonomy. Name should be in slug form.
      'jobs',                // Post type name
      array(
          'hierarchical' => true,
          'label' => 'Team',    // Display name
          'query_var' => true,
          'rewrite' => array(
              'slug' => 'team'  // Base slug
          )
      )
  );
}
add_action('init', 'team_taxonomy');



//custom jobs

// add_action('wp_ajax_custom_action', 'custom_action_callback_wp');
// add_action( 'wp_ajax_nopriv_custom_action', 'custom_action_callback_wp' );
// function custom_action_callback_wp(){
//     print_r($_POST);die;
// }




add_action('wp_ajax_handle_request', 'handle_request');
add_action('wp_ajax_nopriv_handle_request', 'handle_request');

function handle_request()
{
    // Retrieve the selected term IDs from the AJAX request
    $data = isset($_POST['custom_data']) ? $_POST['custom_data'] : array();
    $search_term = isset($_REQUEST['search_term']) ? sanitize_text_field($_REQUEST['search_term']) : '';
    $paged = isset($_REQUEST['paged']) ? $_REQUEST['paged'] : 1;
    // Initialize the HTML content and an array to track unique post IDs
    $html_content = '';
    $unique_post_ids = array();
    // Construct the tax query array
    $tax_query = array();
    $count =1;
    if(!empty($data)) {
        $count =count($data[0]);
    }
   
    // Loop through each selected term
    for ($i = 0; $i <$count ; $i++) {        
        if(!empty($data) && isset($data[0][$i]) && isset($data[1][$i])){   
            $term_id = $data[0][$i];
            $taxonomy = $data[1][$i];
            // Include the selected term and its descendants in the tax query
            $term_descendants = get_term_children($term_id, $taxonomy);
            $terms_to_include = array_merge(array($term_id), $term_descendants);
           

            $tax_query[] = array(
                'taxonomy' => $taxonomy,
                'field'    => 'term_id',
                'terms'    => $term_id,
                'operator' => 'IN', // Include posts that match any of the terms
            );
        }
       
        $custom_search_query = array(
            'relation' => 'OR',
            array(
                'taxonomy' => 'team', // Replace with your actual taxonomy name
                'field'    => 'name',
                'terms'    => $search_term,
                'operator' => 'IN',
            ),
        );
        // Add the tax query to the main query arguments
        $args = array(
            'post_type'      => 'jobs',
            'posts_per_page' => 5,
            'orderby'        => 'date',
            'order'          => 'ASC',
            'paged' => $paged,
            // 'tax_query'      => $tax_query,
             'search_columns' => ['post_title'],
            'meta_query'     => $custom_search_query,
            
        );
        if(!empty($search_term)){
            $args['s'] = $search_term;

            
        }
        $args['paged'] = $paged;
        if(!empty($tax_query)){            
            $args['tax_query'] = array('relation' => 'OR') + $tax_query ;
        }
        // Execute the custom query
        $filtered_posts = new WP_Query($args);  
        // echo '<pre>';
        // print_r($filtered_posts) ;
        // echo '</pre>';
        // Process the filtered posts and append the HTML to the result
        if ($filtered_posts->have_posts()) {
            while ($filtered_posts->have_posts()) {
                $filtered_posts->the_post();

                // Check if the current post ID has already been processed
                $post_id = get_the_ID();
                if (!in_array($post_id, $unique_post_ids)) {
                    $themeData = get_fields('options');
                    $keySkills = get_field('key_skills');
                    $experience = get_field('experience');
                    $location = get_field('location');

                    ob_start();
                    ?>
                    <a href="<?php echo esc_url(get_permalink()); ?>">
                        <div class="unlock-future-card">
                            <h4><?php the_title(); ?></h4>
                            <div class="location-detail">
                                <ul>
                                    <li><img src="<?php echo $themeData['job_experience_icon']['url'] ?>" alt="<?php echo $themeData['job_experience_icon']['alt'] ?>"><?php echo $experience; ?></li>
                                    <?php
                                    // Check if $location is not null before looping through it
                                    if ($location !== null) :
                                        foreach ($location as $loc) :
                                    ?>
                                            <li><img src="<?php echo $themeData['job_location_icon']['url'] ?>" alt="<?php echo $themeData['job_location_icon']['alt'] ?>"><?php echo $loc->name; ?></li>
                                    <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </ul>
                            </div>
                            <div class="unlock-services">
                                <ul>
                                    <?php
                                    // Check if $keySkills is not null before looping through it
                                    if ($keySkills !== null) :
                                        foreach ($keySkills as $skills) :
                                    ?>
                                                <li><?php echo $skills->name; ?></li>
                                    <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </a>
                    <?php
                    $html_content .= ob_get_clean();

                    // Add the processed post ID to the unique_post_ids array
                    $unique_post_ids[] = $post_id;
                }
            }
            wp_reset_postdata();
        }
        }
    
                            $big = 999999999999;
    $html_content .= '<div class="custom-pagination">'.paginate_links(array(
                                'base' => str_replace($big, '%#%', get_pagenum_link($big)),
                                'format' => '?paged=%#%',
                                'current' =>$paged,
                                'total' => $filtered_posts->max_num_pages
                            )).'</div>';
    // Return the HTML content
    echo $html_content;
    // Always exit to avoid extra output
    wp_die();
}

function exclude_content_from_search($search, $wp_query) {
    if (is_search() && !is_admin()) {
        global $wpdb;

        // Get the search term
        $search_terms = $wp_query->query_vars['s'];

        // Escape any % characters
        $search_terms = esc_sql($search_terms);

        // Exclude post content from the search
        $search = " AND (
            {$wpdb->posts}.post_title LIKE '%{$search_terms}%'
            OR {$wpdb->posts}.post_excerpt LIKE '%{$search_terms}%'
        )";

        return $search;
    }

    return $search;
}

// Hook into the posts_search filter
add_filter('posts_search', 'exclude_content_from_search', 10, 2);


// add_action('save_post', 'replace_content_with_tags', 10, 2);

// function replace_content_with_tags($post_id, $post) {
//     // Check if this is a custom post type (replace 'your_custom_post_type' with your actual post type)
//     if ($post->post_type === 'jobs') {
//         // Get the current tags for the post
//         $current_tags = get_the_tags($post_id);

//         // Get the existing tags from the post content
//         $existing_tags = array();
//         preg_match_all('/<p class="post-tag" style="display: none;">([^<]+)<\/p>/', get_post_field('post_content', $post_id), $existing_tags);

//         // Flatten the existing tags array
//         $existing_tags = isset($existing_tags[1]) ? $existing_tags[1] : array();

//         // Compare the existing tags with the current tags
//         $tags_to_remove = array_diff($existing_tags, wp_list_pluck($current_tags, 'name'));

//         // Create a string of tag names separated by space
//         $tag_names = wp_list_pluck($current_tags, 'name');
//         $tag_string = get_post_field('post_content', $post_id);

//         // Check if the tag content already exists in the post content and remove if necessary
//         foreach ($tags_to_remove as $tag_to_remove) {
//             $tag_string = str_replace('<p class="post-tag" style="display: none;">' . $tag_to_remove . '</p>', '', $tag_string);
//         }

//         // Add new tags to the post content
//         foreach ($tag_names as $tag_name) {
//             $tag_to_add = '<p class="post-tag" style="display: none;">' . $tag_name . '</p>';
//             if (strpos($tag_string, $tag_to_add) === false) {
//                 $tag_string .= ' ' . $tag_to_add;
//             }
//         }

//         // Update the post content with the tag names using $wpdb
//         global $wpdb;
//         $wpdb->update(
//             $wpdb->posts,
//             array('post_content' => $tag_string),
//             array('ID' => $post_id),
//             array('%s'),
//             array('%d')
//         );
//     }
// }






    

