<?php get_header();
$themeData = get_fields('option');
$args = array('post_type' => 'jobs');
while (have_posts($args)) :
  the_post();
  $image_id = get_post_thumbnail_id($post->ID);
  $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);

  $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
  $default_image = site_url() . "/wp-content/uploads/2023/01/Escalon-Feature.png";
  $feature_image = !empty($thumbnail[0]) ?  $thumbnail[0] : $default_image;
  $keySkills = get_field('key_skills', $post->ID);
  $preKeySkills = get_field('preferred_key_skills', $post->ID);
  $experience = get_field('experience', $post->ID);
  $location = get_field('location', $post->ID);
  $postTitle = get_the_title();
  $job_banner = get_field('job_banner_image', 'option');
  $tab_data =  get_field('tabs', $post->ID);
?>


  <section class="banner-section-space">
    <div class="container">
      <div class="row">
        <div class="banner-outer-section">
          <div class="left-banner-content">

            <h1 class="main-heading"><?php echo $postTitle; ?></h1>
            <div class="job-details">
              <div class="experience-yaers"><span>
                  <svg xmlns="http://www.w3.org/2000/svg" width="31.399" height="27.254" viewBox="0 0 31.399 27.254">
                    <g id="briefcase_1_" data-name="briefcase (1)" transform="translate(0.5 0.5)">
                      <g id="Group_264970" data-name="Group 264970" transform="translate(0.691 14.509)">
                        <g id="Group_264969" data-name="Group 264969">
                          <path id="Path_395797" data-name="Path 395797" d="M39.963,279.273a.653.653,0,0,0-.691.691v8.982a.653.653,0,0,1-.691.691H13.71a.653.653,0,0,1-.691-.691v-8.982a.691.691,0,0,0-1.382,0v8.982a2.036,2.036,0,0,0,2.073,2.073H38.581a2.036,2.036,0,0,0,2.073-2.073v-8.982A.653.653,0,0,0,39.963,279.273Z" transform="translate(-11.637 -279.273)" fill="#fc8e26" stroke="#fc8e26" stroke-width="1" />
                        </g>
                      </g>
                      <g id="Group_264972" data-name="Group 264972" transform="translate(0 4.836)">
                        <g id="Group_264971" data-name="Group 264971">
                          <path id="Path_395798" data-name="Path 395798" d="M28.326,116.364H2.073A2.036,2.036,0,0,0,0,118.437v4.422a2.074,2.074,0,0,0,1.589,2l10.847,2.418v2.211a.653.653,0,0,0,.691.691h4.145a.653.653,0,0,0,.691-.691V127.28l10.847-2.418a2.074,2.074,0,0,0,1.589-2v-4.422A2.036,2.036,0,0,0,28.326,116.364ZM16.581,128.8H13.818v-2.764h2.764Zm12.436-5.942a.673.673,0,0,1-.553.691l-10.5,2.349v-.553a.653.653,0,0,0-.691-.691H13.127a.653.653,0,0,0-.691.691v.553l-10.5-2.349a.673.673,0,0,1-.553-.691v-4.422a.653.653,0,0,1,.691-.691H28.326a.653.653,0,0,1,.691.691Z" transform="translate(0 -116.364)" fill="#fc8e26" stroke="#fc8e26" stroke-width="1" />
                        </g>
                      </g>
                      <g id="Group_264974" data-name="Group 264974" transform="translate(9.672)">
                        <g id="Group_264973" data-name="Group 264973">
                          <path id="Path_395799" data-name="Path 395799" d="M171.89,34.909h-6.909a2.036,2.036,0,0,0-2.073,2.073v.691a.691.691,0,0,0,1.382,0v-.691a.653.653,0,0,1,.691-.691h6.909a.653.653,0,0,1,.691.691v.691a.691.691,0,0,0,1.382,0v-.691A2.036,2.036,0,0,0,171.89,34.909Z" transform="translate(-162.909 -34.909)" fill="#fc8e26" stroke="#fc8e26" stroke-width="1" />
                        </g>
                      </g>
                    </g>
                  </svg>

                </span>
                <h5><?php echo $experience; ?></h5>
              </div>
              <div class="location-area"><span>
                 
<svg xmlns="http://www.w3.org/2000/svg" width="20.179" height="26.96" viewBox="0 0 20.179 26.96">
  <g id="pin" transform="translate(0.5 0.5)">
    <g id="Group_264978" data-name="Group 264978" transform="translate(0 0)">
      <g id="Group_264977" data-name="Group 264977" transform="translate(0)">
        <path id="Path_395802" data-name="Path 395802" d="M57.67,0a9.6,9.6,0,0,0-9.59,9.59,11.065,11.065,0,0,0,.813,3.692A15.465,15.465,0,0,0,50,15.355l6.575,9.963a1.251,1.251,0,0,0,2.185,0l6.576-9.963a15.4,15.4,0,0,0,1.108-2.073,11.062,11.062,0,0,0,.813-3.692A9.6,9.6,0,0,0,57.67,0Zm7.737,12.844a14.172,14.172,0,0,1-1.01,1.89L57.82,24.7c-.13.2-.171.2-.3,0l-6.576-9.963a14.177,14.177,0,0,1-1.01-1.89,10.043,10.043,0,0,1-.725-3.254,8.462,8.462,0,1,1,16.923,0A10.051,10.051,0,0,1,65.406,12.844Z" transform="translate(-48.08)" fill="#fc8e26" stroke="#fc8e26" stroke-width="1"/>
        <path id="Path_395803" data-name="Path 395803" d="M117.157,64.008a5.077,5.077,0,1,0,5.077,5.077A5.083,5.083,0,0,0,117.157,64.008Zm0,9.026a3.949,3.949,0,1,1,3.949-3.949A3.953,3.953,0,0,1,117.157,73.034Z" transform="translate(-107.567 -59.495)" fill="#fc8e26" stroke="#fc8e26" stroke-width="1"/>
      </g>
    </g>
  </g>
</svg>


                  <?php foreach ($location as $loc) :
                  ?>

                </span>
                <h5><?php echo $loc->name; ?></h5>
              </div>
            <?php endforeach ?>
            </div>
            <a href="#apply" class="custom-btn-career">Apply Now <span class="custom-arrow"><i class="fas fa-arrow-right"></i></span></a>
          </div>
          <div class="banner-right-image">
            <div class="image-div">
              <img src="<?php echo $feature_image; ?>" alt="<?php echo $image_alt; ?>" />
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="circle-shape">
      <img src="<?php echo $themeData['banner_bg_image']['url'] ?>" alt="<?php echo $themeData['banner_bg_image']['alt'] ?>">
    </div>
  </section>
  <section class="section-space-job">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <div class="section-heading-div">
            <h2 class="section-main-heading">Job <span class="orange-color">Description</span></h2>
            <?php echo get_the_content() ?>
          </div>
        </div>
        <div class="col-12">
          <div class="tab-area-outer">
            <nav>
              <div class="nav nav-tabs" id="nav-tab" role="tablist">
                <?php if (isset($tab_data) && !empty($tab_data)) : ?>
                  <?php foreach ($tab_data as $key => $tab) : ?>
                    <button class="nav-link <?php if ($key == 0) {
                                              echo 'active';
                                            } ?>" id="nav-home-tab" data-bs-toggle="tab" data-bs-target="#nav-home-<?php echo $key ?>" type="button" role="tab" aria-controls="nav-home-<?php echo $key ?>" aria-selected="true"><?php echo $tab['job_tab_heading'] ?></button>
                  <?php endforeach ?>
                <?php endif ?>
              </div>
            </nav>
            <div class="tab-content" id="nav-tabContent">
              <?php if (isset($tab_data) && !empty($tab_data)) : ?>
                <?php foreach ($tab_data as $key => $tab) : ?>
                  <div class="tab-pane fade show <?php if ($key == 0) {
                                                    echo 'active';
                                                  } ?>" id="nav-home-<?php echo $key ?>" role="tabpanel" aria-labelledby="nav-home-tab">
                    <div class="points-outer">
                      <ul>
                        <?php echo $tab['job_tab_description'] ?>
                      </ul>
                    </div>
                  </div>
                <?php endforeach ?>
              <?php endif ?>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>
<a id="apply"></a>
  <?php get_template_part('/common/job-form', 'section', $themeData); ?>
<?php endwhile; ?>
<?php get_footer() ?>