<?php

/**
 * Template Name: About page
 *
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<!------------banner section start------------>
<section class="banner-section-space">
    <div class="container">
        <div class="row">
            <div class="banner-outer-section">
                <div class="left-banner-content">
                    <h1 class="main-heading job-listing">
                        <?php if (isset($field['banner_heading'])) : ?>
                            <?php echo $field['banner_heading']; ?>
                        <?php endif; ?>
                    </h1>
                    <?php if (isset($field['banner_description'])) : ?>
                        <?php echo $field['banner_description']; ?>
                    <?php endif; ?>
                </div>
                <div class="banner-right-image">
                    <div class="image-div">
                        <?php if (isset($field['banner_image']['url']) && !empty($field['banner_image']['url'])) : ?>
                            <img src="<?php echo $field['banner_image']['url']; ?>" alt="<?php echo $field['banner_image']['alt']; ?>" />
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if (isset($themeData['banner_bg_image']['url']) && !empty($themeData['banner_bg_image']['url'])) : ?>
        <div class="circle-shape">
            <img src="<?php echo $themeData['banner_bg_image']['url']; ?>" alt="<?php echo $themeData['banner_bg_image']['alt']; ?>">
        </div>
    <?php endif; ?>
</section>

<!------------banner section end------------>
<!-- meet our leader starts -->
<section class="meet-our-leaders">
    <div class="container">
        <div class="leader-heading">
            <h2><?php echo $field['leadership_heading'] ?></h2>
            <?php echo $field['leadership_subheading'] ?>
        </div>
        <div class="leader-content">
            <div class="row">
                <?php foreach ($field['leadership_cards'] as $key => $leadership) : ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="team-box">
                            <div class="leader-image">
                                <?php if (isset($leadership['leadership_image']['url']) && !empty($leadership['leadership_image']['url'])) : ?>
                                    <img src="<?php echo $leadership['leadership_image']['url'] ?>">
                                <?php endif; ?>
                            </div>
                            <div class="leader-details">
                                <div class="leader-name">
                                    <?php if (isset($leadership['leadership_name']) && !empty($leadership['leadership_name'])) : ?>
                                        <h5><?php echo $leadership['leadership_name'] ?></h5>
                                    <?php endif; ?>
                                    <?php if (isset($leadership['designation']) && !empty($leadership['designation'])) : ?>
                                        <p><?php echo $leadership['designation'] ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="leader-more">
                                    <?php if (isset($key)) : ?>
                                        <a href="#" data-bs-toggle="modal" data-bs-target="#exampleModal-<?php echo $key ?>">
                                            <i class="fa fa-arrow-right" aria-hidden="true"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    </div>
</section>
<!-- meet our leader ends -->


<!-- We take care Section Start -->
<?php get_template_part('/common/carousel', 'section', $themeData); ?>

<?php foreach ($field['leadership_cards'] as $key => $leadership) : ?>
    <div class="leader-modal">
        <div class="modal fade" id="exampleModal-<?php echo $key ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="leader-description">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                <i class="fa fa-times" aria-hidden="true"></i>
                            </button>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="modal-leader-img">
                                        <div class="leader-img">
                                            <?php if (isset($leadership['leadership_image']['url']) && !empty($leadership['leadership_image']['url'])) : ?>
                                                <img src="<?php echo $leadership['leadership_image']['url'] ?>">
                                            <?php endif; ?>
                                        </div>
                                        <div class="leader-info">
                                            <div class="leader-name">
                                                <?php if (isset($leadership['leadership_name']) && !empty($leadership['leadership_name'])) : ?>
                                                    <h5><?php echo $leadership['leadership_name'] ?></h5>
                                                <?php endif; ?>
                                                <?php if (isset($leadership['designation']) && !empty($leadership['designation'])) : ?>
                                                    <p><?php echo $leadership['designation'] ?></p>
                                                <?php endif; ?>
                                            </div>
                                            <div class="leader-linkedin">
                                                <?php if (isset($leadership['leadership_linkedin']['url']) && !empty($leadership['leadership_linkedin']['url'])) : ?>
                                                    <a href="<?php echo $leadership['leadership_linkedin']['url'] ?>" target="<?php echo $leadership['leadership_linkedin']['target'] ?>">
                                                        <i class="fa fa-linkedin" aria-hidden="true"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div class="modal-leader-content">
                                        <?php if (isset($leadership['leadership_bio']) && !empty($leadership['leadership_bio'])) {
                                            echo $leadership['leadership_bio'];
                                        } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach ?>


<?php get_footer() ?>