<?php

/**
 * Template Name: Contact page
 *
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<!------------banner section start------------>
<section class="banner-section-space">
    <div class="container">
        <div class="row">
            <div class="banner-outer-section">
                <div class="left-banner-content">
                    <h1 class="main-heading job-listing">
                        <?php if (isset($field['banner_heading'])) : ?>
                            <?php echo $field['banner_heading']; ?>
                        <?php endif; ?>
                    </h1>
                    <?php if (isset($field['banner_description'])) : ?>
                        <?php echo $field['banner_description']; ?>
                    <?php endif; ?>
                </div>
                <div class="banner-right-image">
                    <div class="image-div">
                        <?php if (isset($field['banner_image']['url']) && !empty($field['banner_image']['url'])) : ?>
                            <img src="<?php echo $field['banner_image']['url']; ?>" alt="<?php echo $field['banner_image']['alt']; ?>" />
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if (isset($themeData['banner_bg_image']['url']) && !empty($themeData['banner_bg_image']['url'])) : ?>
        <div class="circle-shape">
            <img src="<?php echo $themeData['banner_bg_image']['url']; ?>" alt="<?php echo $themeData['banner_bg_image']['alt']; ?>">
        </div>
    <?php endif; ?>
</section>
<!------------banner section end------------>
<!-- location starts -->
<section class="location">
    <div class="container">
        <div class="location-heading">
            <h2>Our <span>Locations</span></h2>
           <!-- <p>We are hiring for a Accountants & Senior Accountants for the Mohali location. Here is the JD of the role.</p>-->
        </div>
        <div class="escalon-map">
            <div id="map">
                <div class="map-container">
    <img src="https://career.escalon.growthpod.me/wordpress/wp-content/uploads/2024/01/Group-265547.svg">
        <div class="point mohali tippy" title="Escalon Tower, 7th Floor Plot No. ITC – 11, Sector 67 Mohali Punjab 160062"></div>
    <div class="point indore tippy" title="401, Manas Mayfair, Bhawrilal Mithaiwala Building, South tukoganj, MG Road, Indore – 453001"></div>
    <div class="point WorldHeadquarters tippy" title="World Headquarters, 2345 Yale Street, 1st Floor, Palo Alto, California, USA"></div>
    <div class="point Israel tippy" title="40 Einstein Street, Tel Aviv 6910203, Israel"></div>
    <div class="point LosAngeles tippy" title="1223 Wilshire Boulevard Santa Monica, CA 90403, Los Angeles"></div>
    <div class="point NewYork
 tippy" title="450 Park Ave South, Floor 12, NY NY 10016"></div>
    <div class="point Scandinavia tippy" title="Grundingen 6 0250 Oslo, Norway"></div>
    
  </div>
            </div>
        </div>
    </div>
</section>
<!-- location ends -->
<!-- contact form starts -->
<section class="contact-form">
    <div class="container">
        <div class="contact-heading">
            <h2><?php echo $themeData['contact_form_heading'] ?></h2>
            <?php echo $themeData['contact_form_subheading'] ?>
        </div>
        <div class="contact-form">
            <?php echo do_shortcode('[contact-form-7 id="b782206" title="Contact Us"]') ?>
        </div>
    </div>
</section>
<script src='https://unpkg.com/tippy.js@1.1.3/dist/tippy.min.js'></script>
<!--<script src='https://unpkg.com/mapbox-gl-leaflet'></script>-->
<!--
<script>
    mapboxgl.accessToken = 'pk.eyJ1IjoieWFzaGlrYTQyODciLCJhIjoiY2xxcG9jZjhpMHhodDJpc2J5ZGJuZG81eCJ9.n73ml0_xRetY8IDPjsKRSw';
    const map = new mapboxgl.Map({
        container: 'map',
        // Choose from Mapbox's core styles, or make your own style with Mapbox Studio
        style: 'mapbox://styles/mapbox/streets-v12',
        center: [78.9629, 20.5937],
        zoom: 5.15
    });

    map.on('load', () => {
        map.addSource('places', {
            'type': 'geojson',
            'data': {
                'type': 'FeatureCollection',
                'features': [{
                        'type': 'Feature',
                        'properties': {
                            'description': '<p>401, Manas Mayfair, Bhawrilal Mithaiwala Building, South Tukoganj, MG Road, Indore – 453001</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [22.724699, 75.866460] // Central India (near the center)
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 2</strong><p>Another location near the center of India.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [76.0856, 22.6719] // Another location near the center
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 3</strong><p>Yet another location near the center of India.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [78.4054, 23.2599] // Yet another location near the center
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 4</strong><p>Explore the beauty of central India from this location.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [75.9411, 21.2787] // Explore the beauty of central India
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 5</strong><p>Enjoy the tranquility of central India from this spot.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [76.5060, 22.9786] // Enjoy the tranquility of central India
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 6</strong><p>Central India awaits your exploration.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [78.2212, 22.9695] // Central India awaits your exploration
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 7</strong><p>Discover hidden gems in central India.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [77.7489, 23.2125] // Discover hidden gems in central India
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 8</strong><p>Experience the culture of central India.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [76.6548, 22.1302] // Experience the culture of central India
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 9</strong><p>Immerse yourself in the heart of India.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [78.6311, 23.6022] // Immerse yourself in the heart of India
                        }
                    },
                    {
                        'type': 'Feature',
                        'properties': {
                            'description': '<strong>Central India 10</strong><p>Feel the pulse of central India.</p>'
                        },
                        'geometry': {
                            'type': 'Point',
                            'coordinates': [77.2864, 23.8354] // Feel the pulse of central India
                        }
                    },
                    // Add more features as desired
                ]
            }
        });


        // Add a layer showing the places.
        map.addLayer({
            'id': 'places',
            'type': 'circle',
            'source': 'places',
            'paint': {
                'circle-color': '#4264fb',
                'circle-radius': 6,
                'circle-stroke-width': 2,
                'circle-stroke-color': '#ffffff'
            }
        });

        // Create a popup, but don't add it to the map yet.
        const popup = new mapboxgl.Popup({
            closeButton: false,
            closeOnClick: false
        });

        map.on('mouseenter', 'places', (e) => {
            // Change the cursor style as a UI indicator.
            map.getCanvas().style.cursor = 'pointer';

            // Copy coordinates array.
            const coordinates = e.features[0].geometry.coordinates.slice();
            const description = e.features[0].properties.description;

            // Ensure that if the map is zoomed out such that multiple
            // copies of the feature are visible, the popup appears
            // over the copy being pointed to.
            while (Math.abs(e.lngLat.lng - coordinates[0]) > 180) {
                coordinates[0] += e.lngLat.lng > coordinates[0] ? 360 : -360;
            }

            // Populate the popup and set its coordinates
            // based on the feature found.
            popup.setLngLat(coordinates).setHTML(description).addTo(map);
        });

        map.on('mouseleave', 'places', () => {
            map.getCanvas().style.cursor = '';
            popup.remove();
        });
    });
    
    jQuery(document).ready(function(){
    tippy('.tippy', {
      theme: 'light',
      size: 'big',
      arrow: true
    })
});
    
</script>
-->
<script>
   jQuery(document).ready(function(){
    tippy('.tippy', {
      theme: 'light',
      size: 'big',
      arrow: true
    })
});
</script>


<?php get_footer() ?>