<?php

/**
 * Template Name: job listing page
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<section class="banner-section-space">
    <div class="container">
        <div class="row">
            <div class="banner-outer-section">
                <div class="left-banner-content">
                    <?php if (isset($field['banner_heading']) && !empty($field['banner_heading'])) : ?>
                        <h1 class="main-heading job-listing"><?php echo $field['banner_heading'] ?></h1>
                    <?php endif; ?>
                    <?php echo $field['banner_description'] ?>
                </div>
                <div class="banner-right-image">
                    <div class="image-div">
                        <?php if (isset($field['banner_image']['url']) && !empty($field['banner_image']['url'])) : ?>
                            <img src="<?php echo $field['banner_image']['url'] ?>" alt="<?php echo $field['banner_image']['alt'] ?>" />
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="circle-shape">
        <img src="<?php echo $themeData['banner_bg_image']['url'] ?>" alt="<?php echo $themeData['banner_bg_image']['alt'] ?>">
    </div>
</section>
<section class="section-space-job">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="section-heading-div">
                    <?php if (isset($field['job_listing_heading']) && !empty($field['job_listing_heading'])) : ?>
                        <h2 class="section-main-heading"><?php echo $field['job_listing_heading'] ?></h2>
                    <?php endif ?>
                    <?php echo $field['job_listing_description'] ?>
                </div>
            </div>
            <div class="job-listing-outer">
                <div class="unlock-future-data ajax-post">


                    <?php
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                    $args = array(
                        'post_type' => 'jobs', 'posts_per_page' => 5, 'orderby' => 'date',
                        'order' => 'ASC', 'paged' => $paged
                    );
                    $posts = new WP_Query($args);
                    //                            print_r();die;
                    if ($posts->have_posts()) :
                        while ($posts->have_posts()) :
                            $posts->the_post();
                            $keySkills = get_field('key_skills');
                            $salary = get_field('salary');
                            $experience = get_field('experience');
                            $location = get_field('location', $post->ID);
                            $postLink = get_permalink();

                    ?>

                            <div class="unlock-future-data-cards" total-count="<?php echo $posts->found_posts; ?>">

                                <a href="<?php echo esc_url(get_permalink()); ?>">
                                    <div class="unlock-future-card">
                                        <h4><?php the_title(); ?></h4>
                                        <div class="location-detail">
                                            <ul>
                                                <li><img src="<?php echo $themeData['job_experience_icon']['url'] ?>" alt="<?php echo $themeData['job_experience_icon']['alt'] ?>"><?php echo $experience; ?></li>
                                                <?php
                                                // Check if $location is not null before looping through it
                                                if ($location !== null) :
                                                    foreach ($location as $loc) :
                                                ?>
                                                        <li><img src="<?php echo $themeData['job_location_icon']['url'] ?>" alt="<?php echo $themeData['job_location_icon']['alt'] ?>"><?php echo $loc->name; ?></li>
                                                <?php
                                                    endforeach;
                                                endif;
                                                ?>
                                            </ul>
                                        </div>
                                        <div class="unlock-services">
                                            <ul>
                                                <?php
                                                // Check if $keySkills is not null before looping through it
                                                if ($keySkills !== null) :
                                                    foreach ($keySkills as $skills) :
                                                ?>
                                                        <li><?php echo $skills->name; ?></li>
                                                <?php
                                                    endforeach;
                                                endif;
                                                ?>
                                            </ul>
                                        </div>
                                    </div>
                                </a>
                            </div>


                        <?php endwhile ?>

                        <div class="custom-pagination">
                            <?php
                            $big = 999999999999;
                            echo paginate_links(array(
                                'base' => str_replace($big, '%#%', get_pagenum_link($big)),
                                'format' => '?paged=%#%',
                                'current' => max(1, get_query_var('paged')),
                                'total' => $posts->max_num_pages
                            ));
                            wp_reset_postdata();
                            ?>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="job-filters">
                    <div class="job-search">
                        <div class="icon-search"><span><i class="fa-solid fa-magnifying-glass"></i></span></div>
                        <input type="search" class="form-control" id="job-search-input" placeholder="Job Title or Keyword">
                        <input type="hidden" value="<?php echo admin_url('admin-ajax.php'); ?>" id="ajax_url_input">
                        <div class="search-btn">
                            <a href="#" id="job-search-btn"><span><i class="fas fa-arrow-right" aria-hidden="true"></i></span></a>
                        </div>
                    </div>



                    <div class="filter-drop">
                        <div class="accordion" id="accordionExample">

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        Teams
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <?php
                                        $taxonomy = 'team'; // Replace 'your_taxonomy_name' with the actual taxonomy name
                                        $terms = get_terms(array(
                                            'taxonomy' => $taxonomy,
                                            'hide_empty' => false, // Set to false to display empty terms
                                        ));

                                        if ($terms && !is_wp_error($terms)) :
                                            foreach ($terms as $term) :
                                        ?>
                                                <div class="form-check">
                                                    <input class="form-check-input custom-taxonomy" type="checkbox" value="<?php echo esc_html($term->term_id); ?>" data-taxonomy="<?php echo esc_html($taxonomy); ?>" id="flexCheckChecked-<?php echo esc_html($term->term_id); ?>">
                                                    <label class="form-check-label" for="flexCheckChecked-<?php echo esc_html($term->term_id); ?>">
                                                        <?php echo esc_html($term->name); ?>
                                                    </label>
                                                </div>
                                        <?php endforeach;
                                        endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        Location
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <?php
                                       $taxonomy = 'location'; // Replace 'your_taxonomy_name' with the actual taxonomy name
                                       $terms = get_terms(array(
                                           'taxonomy' => $taxonomy,
                                           'hide_empty' => false, // Set to false to display empty terms
                                       ));


                                        if ($terms && !is_wp_error($terms)) :
                                            foreach ($terms as $term) :
                                        ?>
                                                <div class="form-check">
                                                    <input class="form-check-input custom-taxonomy" type="checkbox" value="<?php echo esc_html($term->term_id); ?>" data-taxonomy="<?php echo esc_html($taxonomy); ?>" id="flexCheckChecked-<?php echo esc_html($term->term_id); ?>">
                                                    <label class="form-check-label" for="flexCheckChecked-<?php echo esc_html($term->term_id); ?>">
                                                        <?php echo esc_html($term->name); ?>
                                                    </label>
                                                </div>
                                        <?php endforeach;
                                        endif;; ?>
                                    </div>


                                    <script>
                                        var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
                                        jQuery(document).ready(function($) {
                                            $('.custom-taxonomy').on('change', function(e) {
                                                var checkedCheckboxes = $('.custom-taxonomy:checked');
                                                // Check if any checkbox is checked
                                                if (checkedCheckboxes.length > 0) {
                                                    // Handle when at least one checkbox is checked
                                                    var selectedValueteam = $(checkedCheckboxes).map(function() {
                                                        return this.value;
                                                    }).get();
                                                    console.log(selectedValueteam + 'teamdatttt')
                                                    var selectedValuelocation = $(checkedCheckboxes).map(function() {
                                                        return $(this).data("taxonomy");
                                                    }).get();
                                                    var searchTerm = $('#job-search-input').val();

                                                    var formData = $(this).serializeArray();
                                                    var a_string = JSON.stringify(selectedValueteam);
                                                    formData.push({
                                                        name: 'yashi',
                                                        value: a_string
                                                    });
                                                    var b_string = JSON.stringify(selectedValuelocation);
                                                    formData.push({
                                                        name: 'yashi2',
                                                        value: b_string
                                                    });

                                                    // Make an AJAX call
                                                    $.ajax({
                                                        type: 'POST',
                                                        url: ajaxurl,
                                                        data: {
                                                            action: 'handle_request',
                                                            search_term: searchTerm,
                                                            custom_data: [selectedValueteam, selectedValuelocation]
                                                        },
                                                        success: function(response) {
                                                            // console.log('AJAX Response:', response);
                                                            // $('.unlock-future-card').hide();
                                                            // $('.ajax-post').html(response);
                                                            $('.unlock-future-card').hide();
                                                        console.log(response.length);
                                                        if (response.length == 37) {
                                                          
                                                            $('.custom-pagination').html('<p class="result-not-found">No jobs found for the selected criteria.</p>');
                                                        } else {
                                                      
                                                            //     // Append the new data to unlock-future-data-cards
                                                            $('.ajax-post').html(response);
                                                        }
                                                        },
                                                        error: function(errorThrown) {
                                                            // Handle AJAX error
                                                            console.log('AJAX Error:', errorThrown);
                                                        }
                                                    });
                                                } else {
                                                    // If no checkbox is checked, show all results
                                                    $('#job-search-input').val('');

                                                    // Make an AJAX call to show all results
                                                    $.ajax({
                                                        type: 'POST',
                                                        url: ajaxurl,
                                                        data: {
                                                            action: 'handle_request',

                                                            custom_data: [] // Pass an empty array since no checkboxes are checked
                                                        },
                                                        success: function(response) {
                                                            // console.log('AJAX Response:', response);
                                                            $('.unlock-future-card').show(); // Show all results
                                                            $('.ajax-post').html(response);
                                                        },
                                                        error: function(errorThrown) {
                                                            // Handle AJAX error
                                                            console.log('AJAX Error:', errorThrown);
                                                        }
                                                    });
                                                }
                                            });

                                            $('#job-search-btn').on('click', function(e) {
                                                e.preventDefault();
                                                var searchTerm = $('#job-search-input').val();

                                                var selectedValueteam = $('.custom-taxonomy:checked').map(function() {
                                                    return this.value;
                                                }).get();
                                                var selectedValuelocation = $('.custom-taxonomy:checked').map(function() {

                                                    return (this).getAttribute("data-taxonomy");
                                                }).get();
                                                var searchTerm = $('#job-search-input').val();

                                                //console.log(searchTerm);
                                                var formData = $(this).serializeArray();
                                                var a_string = JSON.stringify(selectedValueteam);
                                                formData.push({
                                                    name: 'yashi',
                                                    value: a_string
                                                });
                                                var b_string = JSON.stringify(selectedValuelocation);
                                                formData.push({
                                                    name: 'yashi2',
                                                    value: b_string
                                                });
                                                console.log(formData)
                                                // Make an AJAX call
                                                $.ajax({
                                                    type: 'POST',
                                                    url: ajaxurl,
                                                    data: {
                                                        action: 'handle_request',
                                                        search_term: searchTerm,
                                                        custom_data: [selectedValueteam,
                                                            selectedValuelocation
                                                        ]
                                                    },
                                                    success: function(response) {
                                                        // console.log('AJAX Response:', response);
                                                        $('.unlock-future-card').hide();
                                                        console.log(response.length);
                                                        if (response.length == 37) {
                                                          
                                                            $('.custom-pagination').html('<p class="result-not-found">No jobs found for the selected criteria</p>');
                                                        } else {
                                                      

                                                            //     // Append the new data to unlock-future-data-cards
                                                            $('.ajax-post').html(response);
                                                        }

                                                    },
                                                    error: function(errorThrown) {
                                                        // console.log('AJAX Error:', errorThrown);
                                                    }
                                                });
                                            });
                                            $(document).on('click', 'a.page-numbers', function(e) {
                                                e.preventDefault();

                                                var selectedValueteam = $('.custom-taxonomy:checked').map(function() {
                                                    return this.value;
                                                }).get();
                                                var selectedValuelocation = $('.custom-taxonomy:checked').map(function() {

                                                    return (this).getAttribute("data-taxonomy");
                                                }).get();
                                                var searchTerm = $('#job-search-input').val();
                                                var total = $('.unlock-future-data-cards').attr('total-count');
                                                var page = parseInt($(this).html());
                                                if ($(this).hasClass('next')) {
                                                    page = parseInt($('.current').html()) + 1;

                                                }
                                                if ($(this).hasClass('prev')) {
                                                    page = parseInt($('.current').html()) - 1;

                                                }
                                                var formData = $(this).serializeArray();
                                                var a_string = JSON.stringify(selectedValueteam);
                                                formData.push({
                                                    name: 'yashi',
                                                    value: a_string
                                                });
                                                var b_string = JSON.stringify(selectedValuelocation);
                                                formData.push({
                                                    name: 'yashi2',
                                                    value: b_string
                                                });
                                                //console.log(formData)
                                                // Make an AJAX call
                                                $.ajax({
                                                    type: 'POST',
                                                    url: ajaxurl,
                                                    data: {
                                                        action: 'handle_request',
                                                        search_term: searchTerm,
                                                        custom_data: [selectedValueteam,
                                                            selectedValuelocation
                                                        ],
                                                        paged: page
                                                        // term_ids: selectedValueteam,
                                                        // terms_ids_location:selectedValuelocation
                                                    },
                                                    success: function(response) {
                                                       // console.log('AJAX Response:', response);
                                                        //                                                            $('.custom-pagination').remove();
                                                        // Clear the previous content before appending new data
                                                        $('.unlock-future-card').hide();

                                                        // Append the new data to unlock-future-data-cards
                                                        $('.ajax-post').html(response);
                                                        //                                                            jQuery('.custom-pagination span.page-numbers').removeClass('current');
                                                        //                                                           calPage(page);
                                                    },
                                                    error: function(errorThrown) {
                                                        // console.log('AJAX Error:', errorThrown);
                                                    }
                                                });
                                            });
                                            $(document).on('keyup', '#job-search-input', function(e) {
                                                if (e.keyCode == 13) {
                                                    //                                                  e.preventDefault();
                                                    var searchTerm = $('#job-search-input').val();

                                                    var selectedValueteam = $('.custom-taxonomy:checked').map(function() {
                                                        return this.value;
                                                    }).get();
                                                    var selectedValuelocation = $('.custom-taxonomy:checked').map(function() {

                                                        return (this).getAttribute("data-taxonomy");
                                                    }).get();
                                                    var searchTerm = $('#job-search-input').val();
                                                    //console.log(selectedValueteam, selectedValuelocation)
                                                    var formData = $(this).serializeArray();
                                                    var a_string = JSON.stringify(selectedValueteam);
                                                    formData.push({
                                                        name: 'yashi',
                                                        value: a_string
                                                    });
                                                    var b_string = JSON.stringify(selectedValuelocation);
                                                    formData.push({
                                                        name: 'yashi2',
                                                        value: b_string
                                                    });
                                                    console.log(formData)
                                                    // Make an AJAX call
                                                    $.ajax({
                                                        type: 'POST',
                                                        url: ajaxurl,
                                                        data: {
                                                            action: 'handle_request',
                                                            search_term: searchTerm,
                                                            custom_data: [selectedValueteam,
                                                                selectedValuelocation
                                                            ]
                                                            // term_ids: selectedValueteam,
                                                            // terms_ids_location:selectedValuelocation
                                                        },
                                                        success: function(response) {
                                                            $('.unlock-future-card').hide();
                                                        //console.log(response.length);
                                                        if (response.length == 37) {
                                                          
                                                            $('.custom-pagination').html('<p class="result-not-found">No jobs found for the selected criteria.</p>');
                                                        } else {
                                                      
                                                            //     // Append the new data to unlock-future-data-cards
                                                            $('.ajax-post').html(response);
                                                        }

                                                        },
                                                        error: function(errorThrown) {
                                                            // console.log('AJAX Error:', errorThrown);
                                                        }
                                                    });
                                                }
                                            });
                                        });
                                    </script>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



<?php get_footer() ?>