<?php

/**
 * Template Name: life at escalon page
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>

<?php get_header(); ?>
<section class="banner-section-space custom-life-at-escalon">
    <div class="container">
        <div class="row">
            <div class="banner-outer-section">
                <div class="left-banner-content">
                    <?php if (isset($field['banner_heading']) && !empty($field['banner_heading'])) : ?>
                        <h2><?php echo $field['banner_heading']; ?></h2>
                    <?php endif; ?>

                    <?php if (isset($field['banner_subheading']) && !empty($field['banner_subheading'])) : ?>
                        <h1 class="main-heading"><?php echo $field['banner_subheading']; ?></h1>
                    <?php endif; ?>
                </div>

                <div class="banner-right-image">
                    <div class="image-div">
                        <?php if (isset($field['banner_image']['url']) && !empty($field['banner_image']['url'])) : ?>
                            <img src="<?php echo $field['banner_image']['url']; ?>" alt="<?php echo $field['banner_image']['alt']; ?>" />
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="circle-shape">
        <?php if (isset($themeData['banner_bg_image']['url']) && !empty($themeData['banner_bg_image']['url'])) : ?>
            <img src="<?php echo $themeData['banner_bg_image']['url']; ?>" alt="<?php echo $themeData['banner_bg_image']['alt']; ?>">
        <?php endif; ?>
    </div>
</section>


<section class="life-at-escalon escalon-life">
    <div class="container">
        <div class="life-at-escalon-content">
            <?php if (isset($themeData['gallery_heading']) && !empty($themeData['gallery_heading'])) : ?>
                <h2><?php echo $themeData['gallery_heading']; ?></h2>
            <?php endif; ?>

            <?php if (isset($themeData['gallery_subheading']) && !empty($themeData['gallery_subheading'])) : ?>
                <p><?php echo $themeData['gallery_subheading']; ?></p>
            <?php endif; ?>
        </div>

        <div class="life-at-escalon-gallery">
            <?php echo do_shortcode('[modula id="170"]'); ?>
        </div>
    </div>
</section>
<div class="follow-us">
    <div class="container">
        <div class="main-div">
            <a href="https://www.instagram.com/escalon.india/?igshid=NzZlODBkYWE4Ng%3D%3D" target="_blank">
                <p>Follow us on Instagram</p><i class="fa fa-instagram" aria-hidden="true"></i>
            </a>
        </div>
    </div>
</div>
<section class="life-at-escalon-testimonial">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="slider-outer">
                    <div class="slider-left-content">
                        <div class="quote-image">
                            <?php if (isset($themeData['testimonial_quotes_icon']['url']) && !empty($themeData['testimonial_quotes_icon']['url'])) : ?>
                                <img src="<?php echo $themeData['testimonial_quotes_icon']['url'] ?>" alt="<?php echo $themeData['testimonial_quotes_icon']['alt'] ?>">
                            <?php endif; ?>
                        </div>
                        <?php if (isset($themeData['testimonial_heading']) && !empty($themeData['testimonial_heading'])) : ?>
                            <h2><?php echo $themeData['testimonial_heading'] ?></h2>
                        <?php endif; ?>
                        <?php if (isset($themeData['testimonial_subheading']) && !empty($themeData['testimonial_subheading'])) : ?>
                            <?php echo $themeData['testimonial_subheading'] ?>
                        <?php endif; ?>
                    </div>
                    <div class="owl-carousel owl-theme" id="testimonial-slider">
                        <?php foreach ($themeData['testimonials'] as $testimonial) : ?>
                            <div class="item">
                                <div class="testimonial-slider">
                                    <div class="client-image">
                                        <?php
                                        if ($testimonial['type'] == 'image') {
                                        ?>
                                            <img src="<?php echo $testimonial['image']['url'] ?>" alt="<?php echo $testimonial['image']['alt'] ?>">

                                        <?php } elseif ($testimonial['type'] == 'iframe') { ?>
                                            <?php
                                            echo $testimonial['iframe'];
                                            ?>
                                        <?php } ?>
                                    </div>

                                    <div class="moments">
                                        <div class="qote-image">
                                            <?php if (isset($themeData['testimonial_image_quotes']['url']) && !empty($themeData['testimonial_image_quotes']['url'])) : ?>
                                                <img src="<?php echo $themeData['testimonial_image_quotes']['url'] ?>">
                                            <?php endif; ?>
                                        </div>
                                        <div class="testi-content">
                                            <?php if (isset($testimonial['testimonial_client_text']) && !empty($testimonial['testimonial_client_text'])) : ?>
                                                <p><?php echo $testimonial['testimonial_client_text'] ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php if (isset($testimonial['testimonial_client_bio']) && !empty($testimonial['testimonial_client_bio'])) : ?>
                                        <div class="client-description">

                                            <?php echo $testimonial['testimonial_client_bio'] ?>
                                       
                                         <h4 class="client-name">
                                            <?php if (isset($testimonial['testimonial_client_name']) && !empty($testimonial['testimonial_client_name'])) : ?>
                                                <?php echo $testimonial['testimonial_client_name'] ?>
                                            <?php endif; ?>
                                         </h4>
                                         <h5 class="designation">
                                            <?php if (isset($testimonial['testimonial_client_designation']) && !empty($testimonial['testimonial_client_designation'])) : ?>
                                                <?php echo $testimonial['testimonial_client_designation'] ?>
                                            <?php endif; ?>
                                         </h5>
                                        </div>
                                        <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="escalon-video">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="image-video">
                    <!-- <img src="assets/imgs/video-as.png"> -->
                    <?php if (isset($field['video']['url']) && !empty($field['video']['url'])) : ?>
                        <video autoplay muted loop playsinline preload="metadata" style="width: 100%; overflow:hidden; object-fit: cover">
                            <source src="<?php echo $field['video']['url'] ?>" type="video/mp4">
                        </video>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>


<?php get_footer(); ?>