<?php

/**
 * Template Name: Teams-tab page
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>

<?php get_template_part('/common/banner', 'section', $field); ?>

<!-- meet our leader starts -->
<!-- Add the necessary Bootstrap and jQuery script links here -->

<section class="meet-our-leaders">
    <div class="container">
        <div class="leader-heading">
            <h2>Meet <span>our leaders</span></h2>
        </div>

        <?php if (isset($field['teams_data']) && !empty($field['teams_data'])) : ?>
            <?php if (isset($field['teams_data']['tab_repeater']) && !empty($field['teams_data']['tab_repeater'])) : ?>
                <?php
                $tabNav = '';
                $tabContent = '';

                foreach ($field['teams_data']['tab_repeater'] as $teamsKey => $teamsDetails) :
                    $tabNav .= '<button class="nav-link' . (($teamsKey === 0) ? " active" : "") . '" id="nav-' . $teamsKey . '-tab" data-bs-toggle="tab"
                        data-bs-target="#nav-' . $teamsKey . '" type="button" role="tab" aria-controls="nav-' . $teamsKey . '"
                        aria-selected="true">' . $teamsDetails["tab_heading"] . '</button>';

                    if (isset($teamsDetails['leaders_details']) && !empty($teamsDetails['leaders_details'])) :
                        $tabContent .= '<div class="tab-pane fade ' . (($teamsKey === 0) ? " show active" : "") . '" id="nav-' . $teamsKey . '" role="tabpanel" aria-labelledby="nav-' . $teamsKey . '-tab">';
                        $tabContent .= '<div class="row">';

                        foreach ($teamsDetails['leaders_details'] as $leaderKey => $leaderDetails) :
                            $modalId = 'exampleModal-' . $teamsKey . '-' . $leaderKey;

                            $tabContent .= '<div class="col-lg-4 col-md-6">
                                <div class="team-box">
                                    <div class="leader-image">
                                        <img src="' . $leaderDetails["leader_image"]["url"] . '" alt="' . $leaderDetails["leader_image"]["alt"] . '">
                                    </div>
                                    <div class="leader-details">
                                        <div class="leader-name">
                                            <h5>' . $leaderDetails["leader_heading"] . '</h5>
                                            <p>' . $leaderDetails["leader_designation"] . '</p>
                                        </div>
                                        <div class="leader-more">
                                            <a href="#" data-bs-toggle="modal" data-desc="' . $leaderDetails["leader_description"] . '" data-bs-target="#' . $modalId . '">
                                                <i class="fa fa-arrow-right" aria-hidden="true"></i>
                                            </a>
                                        </div>
                                    </div>
                                    ' . generateModalHtml($modalId, $leaderDetails) . '
                                </div>
                            </div>';

                        // Generate Modal HTML

                        endforeach;

                        $tabContent .= '</div>';
                        $tabContent .= '</div>';
                    endif;
                endforeach;
                ?>
            <?php endif; ?>
        <?php endif; ?>

        <div class="leader-content">
            <div class="row">
                <nav>
                    <div class="nav nav-tabs" id="nav-tab" role="tablist">
                        <?php echo $tabNav; ?>
                    </div>
                </nav>
                <div class="tab-content" id="nav-tabContent">
                    <?php echo $tabContent; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
// Function to generate modal HTML
function generateModalHtml($modalId, $leaderDetails)
{
    $leaderImage = isset($leaderDetails["leader_image"]["url"]) ? $leaderDetails["leader_image"]["url"] : '';
    $leaderHeading = isset($leaderDetails["leader_heading"]) ? $leaderDetails["leader_heading"] : '';
    $leaderDesignation = isset($leaderDetails["leader_designation"]) ? $leaderDetails["leader_designation"] : '';
    $linkedinUrl = isset($leaderDetails["leadership_linkedin"]['url']) ? $leaderDetails["leadership_linkedin"]['url'] : '';
    $linkedinTarget = isset($leaderDetails["leadership_linkedin"]['target']) ? $leaderDetails["leadership_linkedin"]['target'] : '';
    $leaderDescription = isset($leaderDetails["leader_description"]) ? $leaderDetails["leader_description"] : '';

    // Check if LinkedIn link is available
    $linkedinSection = '';
    if ($linkedinUrl) {
        $linkedinSection = '<div class="leader-linkedin">
                                <a href="' . $linkedinUrl . '" target="' . $linkedinTarget . '">
                                    <i class="fa fa-linkedin" aria-hidden="true"></i>
                                </a>
                            </div>';
    }

    return '<div class="leader-modal">
                <div class="modal fade" id="' . $modalId . '" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-body">
                                <div class="leader-description">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                        <i class="fa fa-times" aria-hidden="true"></i>
                                    </button>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="modal-leader-img">
                                                <div class="leader-img">
                                                    <img src="' . $leaderImage . '">
                                                </div>
                                                <div class="leader-info">
                                                    <div class="leader-name">
                                                        <h5>' . $leaderHeading . ' </h5>
                                                        <p>' . $leaderDesignation . ' </p>
                                                    </div>
                                                    ' . $linkedinSection . '
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="modal-leader-content">
                                                ' . $leaderDescription . '
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>';
}

?>


<!-- meet our leader ends -->

<?php get_template_part('/common/recent-jobs', 'section', $themeData); ?>
<?php get_template_part('/common/carousel', 'section', $themeData); ?>
<?php get_template_part('/common/why-join-us', 'section', $themeData); ?>

<?php get_footer() ?>