<?php

/**
 * Template Name: teams page
 *
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<!------------banner section start------------>
<?php get_template_part('/common/banner', 'section', $field); ?>
<!------------banner section end------------>
<!-- meet our leader starts -->
<!-- meet our leader starts -->
<section class="meet-our-leaders">
    <div class="container">
        <div class="leader-heading">
        <?php if (isset($field['leadership_heading']) && !empty($field['leadership_heading'])) : ?>
            <h2><?php echo $field['leadership_heading'] ?></h2>
            <?php echo $field['leadership_subheading'] ?>
            <?php endif; ?>
        </div>
        <div class="leader-content">
            <div class="row">
                <?php foreach ($field['leadership_cards'] as $key => $leadership) : ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="team-box">
                            <div class="leader-image">
                                <?php if (isset($leadership['leadership_image']['url']) && !empty($leadership['leadership_image']['url'])) : ?>
                                    <img src="<?php echo $leadership['leadership_image']['url'] ?>">
                                <?php endif; ?>
                            </div>
                            <div class="leader-details">
                                <div class="leader-name">
                                    <?php if (isset($leadership['leadership_name']) && !empty($leadership['leadership_name'])) : ?>
                                        <h5><?php echo $leadership['leadership_name'] ?></h5>
                                    <?php endif; ?>
                                    <?php if (isset($leadership['designation']) && !empty($leadership['designation'])) : ?>
                                        <p><?php echo $leadership['designation'] ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="leader-more">
                                    <?php if (isset($key)) : ?>
                                        <a href="#" data-bs-toggle="modal" data-bs-target="#exampleModal-<?php echo $key ?>">
                                            <i class="fa fa-arrow-right" aria-hidden="true"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    </div>
</section>
<!-- meet our leader ends -->
<!-- meet our leader ends -->
<?php if (isset($field['feature_jobs']) && !empty($field['feature_jobs'])) : ?>
<section class="unlock-future">
  <div class="container">
    <div class="row">
      <div class="col-md-4">
        <div class="unlock-future-content">
        <?php if (isset($field['feature_job_heading']) && !empty($field['feature_job_heading'])) : ?>
          <h2><?php echo $field['feature_job_heading'] ?></h2>
          <?php endif; ?>
          <?php if (isset($field['more_job_links']['url']) && !empty($field['more_job_links']['url'])) : ?>
          <a href="<?php echo $field['more_job_links']['url'] ?>" class="custom-button1"><?php echo $field['more_job_links']['title'] ?><span class="arrow1"><i class="fas fa-arrow-right"></i></span></a>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-md-8">
        <div class="unlock-future-data">
          <div class="unlock-future-data-cards">
            <?php
            foreach ($field['feature_jobs'] as $cd) :
              $featurepost = $cd['jobs_post'];
              $id          =  $featurepost->ID;
              $keySkills = get_field('key_skills', $id);
              $experience = get_field('experience', $id);

              $featuredTitle = esc_html(get_the_title($id));
              $location = get_field('location', $id);
              $permalink = get_the_permalink($id);
            ?>

              <a href="<?php echo $permalink; ?>">
                <div class="unlock-future-card">
                  
                  <h4><?= $featuredTitle ?></h4>
                  <div class="location-detail">
                    <ul>
                      <li><img src="<?php echo $themeData['job_experience_icon']['url'] ?>" alt="<?php echo $themeData['job_experience_icon']['alt'] ?>"><?php echo $experience; ?></li>
                      <?php
                      // Check if $location is not null before looping through it
                      if ($location !== null) :
                        foreach ($location as $loc) :
                      ?>
                          <li><img src="<?php echo $themeData['job_location_icon']['url'] ?>" alt="<?php echo $themeData['job_location_icon']['alt'] ?>"><?php echo $loc->name; ?></li>
                      <?php
                        endforeach;
                      endif;
                      ?>
                    </ul>
                  </div>
                  <div class="unlock-services">
                    <ul>
                      <?php
                      // Check if $keySkills is not null before looping through it
                      if ($keySkills !== null) :
                        foreach ($keySkills as $skills) :
                      ?>
                          <li><?php echo $skills->name; ?></li>
                      <?php
                        endforeach;
                      endif;
                      ?>
                    </ul>
                  </div>
                </div>
              </a>


            <?php endforeach; ?>




          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php
              
                      endif;
                      ?>
<?php get_template_part('/common/carousel', 'section', $themeData); ?>
<?php get_template_part('/common/why-join-us', 'section', $themeData); ?>

<?php foreach ($field['leadership_cards'] as $key => $leadership) : ?>
    <div class="leader-modal">
        <div class="modal fade" id="exampleModal-<?php echo $key ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="leader-description">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                <i class="fa fa-times" aria-hidden="true"></i>
                            </button>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="modal-leader-img">
                                        <div class="leader-img">
                                            <?php if (isset($leadership['leadership_image']['url']) && !empty($leadership['leadership_image']['url'])) : ?>
                                                <img src="<?php echo $leadership['leadership_image']['url'] ?>">
                                            <?php endif; ?>
                                        </div>
                                        <div class="leader-info">
                                            <div class="leader-name">
                                                <?php if (isset($leadership['leadership_name']) && !empty($leadership['leadership_name'])) : ?>
                                                    <h5><?php echo $leadership['leadership_name'] ?></h5>
                                                <?php endif; ?>
                                                <?php if (isset($leadership['designation']) && !empty($leadership['designation'])) : ?>
                                                    <p><?php echo $leadership['designation'] ?></p>
                                                <?php endif; ?>
                                            </div>
                                            <div class="leader-linkedin">
                                                <?php if (isset($leadership['leadership_linkedin']['url']) && !empty($leadership['leadership_linkedin']['url'])) : ?>
                                                    <a href="<?php echo $leadership['leadership_linkedin']['url'] ?>" target="<?php echo $leadership['leadership_linkedin']['target'] ?>">
                                                        <i class="fa fa-linkedin" aria-hidden="true"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div class="modal-leader-content">
                                        <?php if (isset($leadership['leadership_bio']) && !empty($leadership['leadership_bio'])) {
                                            echo $leadership['leadership_bio'];
                                        } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach ?>
<?php get_footer() ?>