<?php
	/*
@package mod_wiziq
@copyright www.wiziq.com
@license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
*/
/*
This file is part of Wiziq - http://www.wiziq.com/
Moodle is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Moodle is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Moodle. If not, see <http://www.gnu.org/licenses/>.

*/
	/*
	 * Wiziq frontend courses file
	 */
	 
	class Wiziq_Frontend_Courses {
		
		
		/*
		 * Function to display course detail
		 */ 
		function wiziq_frontend_view_detail ( $course_id ) {
			$courses_url = get_permalink();
			$Wiziq_Util = new Wiziq_Util;
			
			//url structure
			$qvarsign = $Wiziq_Util->wiziq_frontend_url_structure();
			
			
			
			$wiziq_courses = new Wiziq_Courses;
			$res = $wiziq_courses->wiziq_get_single_courses ($course_id);
			$view_classes = $courses_url.$qvarsign.'caction=view_classes'.'&course_id='.$res->id;
			?>
                    

			<div class="front_wiziq userlogin " id="front_wiziq" >
				<div class="wiziq_left" >
				</div>
				<div class="wiziq_right" >
				<div class= "frontend_buttons courses_frontend_buttons" >	
					<a class="button button-primary buttonnew"  href="<?php echo site_url();?>/my-account/">Back to Dashboard</a>
				</div>

				
					<ul class = "wiziq_front_menu">
					    
						<li><h3><a href="<?php echo $courses_url; ?>" ><?php _e('Courses', 'wiziq'); ?></a></h3></li>
					</ul>
					<div class = "clearfix" ></div>
					<table class = "form-table" >
							<tr>
								<th><?php _e('Course Name', 'wiziq'); ?></th>
								<td>
								<strong>
									<?php echo $res->fullname;?>
								</strong>
								</td>
							</tr>
							<tr>
								<th><?php _e('Start date', 'wiziq'); ?></th>
								<td>
									<?php   
									if ( $res->startdate )
										echo date( WIZIQ_DATE_FORMAT, strtotime($res->startdate));
									else 
										_e( 'Start date not mentioned' , 'wiziq' );
									?>
								</td>
							</tr>
							<tr>
								<th><?php _e('End date', 'wiziq'); ?></th>
								<td>
								<?php 
									if ($res->enddate)
										echo date( WIZIQ_DATE_FORMAT, strtotime($res->enddate));
									else 
										_e('End date not mentioned');
								?>
								</td>
							</tr>
							<tr>
								<th><?php _e('Description', 'wiziq'); ?></th>
								<td>
								<?php 
									if ( $res->description )
										echo $res->description;
									else 
										_e( 'Description not added' , 'wiziq' );
								?>
								</td>
							</tr>
					</table>
					<div class= "frontend_buttons courses_frontend_buttons" >
						<a class= "button button-primary buttonnew" title="<?php _e('Back To Courses', 'wiziq'); ?>" href="<?php echo $courses_url; ?>" ><?php _e('Back To Courses','wiziq'); ?></a>
						<a class= "button button-primary buttonnew" title="<?php _e('View Classes', 'wiziq'); ?>" href="<?php echo $view_classes; ?>" ><?php _e('View Classes','wiziq'); ?></a>
					</div>
				</div>
			</div>
			<?php
		} 
		
		/*
		 * Function to display courses on front end to logged in users
		 * @since 1.0
		 */ 
		function wiziq_frontend_view_courses_logged () {
			global $wpdb;
			$user_permissions  = new Wiziq_User_Permissions;
			
			$Wiziq_Util = new Wiziq_Util;
			
			//url structure
			$qvarsign = $Wiziq_Util->wiziq_frontend_url_structure();
			
			$courses_url = get_permalink();
			$wiziq_frontend_courses = new Wiziq_Frontend_Courses;
			$courses_urls = $courses_url.$qvarsign.'action=courses';
			$add_curl = $courses_url.$qvarsign.'action=addcourse';
			$edit_curli = $courses_url.$qvarsign.'action=editcourse';
			$delete_curl = $courses_url.$qvarsign.'action=deletecourse';
			$content_url = $courses_url.$qvarsign.'ccaction=view_content';
			$wiziq_courses = new Wiziq_Courses;
			
			$wiziq_classes = $wpdb->prefix."wiziq_wclasses";
			?>

			<div class="front_wiziq userlogin " id="front_wiziq" >
                           
			<div class="wiziq_left" >
			</div>
			<div class="wiziq_right adnecl" >
				<?php 
				global $current_user;
				$usero = wp_get_current_user();
				//echo $usero->ID;
				?>
				<div class= "frontend_buttons courses_frontend_buttons" >	
					<a class="button button-primary buttonnew"  href="<?php echo site_url();?>/my-account/">Back to Dashboard</a>
				</div>
					<ul class = "wiziq_front_menu">
						<li>
							<h3>
								<a href="<?php echo $courses_url; ?>" ><?php _e('Courses', 'wiziq'); ?></a>
							</h3>
						
					</ul>
				<div class = "clearfix" ></div>
			<h4><div class="list_courses"><?php _e('COURSES LIST' , 'wiziq' );?></div>
				<?php
				$wiziq_enroluser_table = $wpdb->prefix.'wiziq_enroluser';
				  $cforpost = $wpdb->get_results('SELECT `upload_course` FROM '.$wiziq_enroluser_table.' WHERE user_id='.$usero->ID,ARRAY_A);
					$user_info = get_userdata($usero->ID);				
					$roeluse = implode(', ', $user_info->roles);				
				 if($cforpost[0]['upload_course'] == '1' || $roeluse == 'editor' || is_user_administrator()){ ?>
				|<div class="add_courses"><?php _e('ADD COURSES', 'wiziq' );?></div>
				<?php } ?>
			</h4>
                        
                       <?php if(isset($_GET['nopermission'])){  ?>
                        <div class="error" style="color:red">You have no permission to join this class</div> 
                       <?php } ?>
                        
			<?php
			/*
			 * Sorting logic
			 */ 
			if ( ! isset ( $_GET['sort-by'] ) ) {
				$sortby = "id";
			} else {
				$sortby = $_GET['sort-by'];
			}
			if ( !isset ($_GET['order-by']) ) {
				$orderby = "desc";
			}else {
				$orderby = $_GET['order-by'];
			}
			/*
			 * Pagination functionality 
			 */ 
                        
                     $user_id = get_current_user_id();
                global $wpdb;

                $tbname1 = $wpdb->prefix.'wiziq_enroluser';
                $sqry1 = "select * from $tbname1 where user_id=$user_id";
                $result1 = $wpdb->get_results($sqry1);

                foreach($result1 as $result1){
                   $courseid[]= $result1->course_id;
                }
                
               
          //      $courseidd=implode((array)$courseid,',');
					$courseidd=implode(",",$courseid);
                
                $tbname = $wpdb->prefix.'wiziq_courses';                      
                        
			$wiziq_courses = $wpdb->prefix."wiziq_courses";
                        if(current_user_can( 'administrator' )){
			$courses = $wpdb->get_results( "select * from $wiziq_courses" );
                        }
                        elseif(current_user_can( 'subscriber' )){
							
              $courses = $wpdb->get_results( "select * from $wiziq_courses where id in($courseidd)" ); 
                    
                        }
                        
                         elseif(current_user_can( 'editor' ) || current_user_can('author') || current_user_can('contributor')){
      $courses = $wpdb->get_results( "select * from $wiziq_courses where id in($courseidd) OR created_by=$user_id" );   
      
                        }                       
			$total_pages = !empty($courses)?count($courses):0 ;
			$limit = WIZIQ_PAGINATION_LIMIT;
			$adjacents = 3;
			$page = isset($_GET['pageno'])?$_GET['pageno']:'';
			if($page) 
				$start = ($page - 1) * $limit; 			//first item to display on this page
			else
				$start = 0;								//if no page var is given, set start to 0
			$targetpage = "";
			$homepage = get_permalink().$qvarsign;
			$targetpage .= get_permalink().$qvarsign;
			if ( isset ($_GET['sort-by']) && isset ($_GET['order-by']) ) {
				$targetpage .= 'sort-by='.$sortby.'&order-by='.$orderby.'&';
			}
			$pagination =  $Wiziq_Util->custom_pagination($page,$total_pages,$limit,$adjacents,$targetpage);
			
			
			$wiziq_courses = $wpdb->prefix."wiziq_courses";
			if ( $sortby == 'fullname' || $sortby ==  'id' ) {
                    $user_id = get_current_user_id();
                global $wpdb;

                $tbname1 = $wpdb->prefix.'wiziq_enroluser';
                $sqry1 = "select * from $tbname1 where user_id=$user_id";
                $result1 = $wpdb->get_results($sqry1);

                foreach($result1 as $result1){
                   $courseid[]= $result1->course_id;
                }

              //  $courseidd=implode((array)$courseid,',');
                $courseidd=implode(",",$courseid);
                
                $tbname = $wpdb->prefix.'wiziq_courses';
                if(current_user_can( 'administrator' )){
                 $wiziq_course_res = $wpdb->get_results( "select * from $wiziq_courses order by $sortby $orderby LIMIT $start ,$limit" );   
                }
                elseif(current_user_can( 'subscriber' )){
                 //$sqry = "select * from $tbname where id in($courseidd) order by id desc";
                 $wiziq_course_res = $wpdb->get_results( "select * from $wiziq_courses where id in($courseidd) order by $sortby $orderby LIMIT $start ,$limit" );
                 
                 
                }
                elseif(current_user_can( 'editor' ) || current_user_can('author') || current_user_can('contributor')){
                 //$sqry = "select * from $tbname where id in($courseidd) OR created_by=$user_id order by id desc";
 $wiziq_course_res = $wpdb->get_results( "select * from $wiziq_courses where id in($courseidd) OR created_by=$user_id order by $sortby $orderby LIMIT $start ,$limit" );   
 
                }
                $result = $wpdb->get_results($sqry);                           
                            
                            
                            
                            
				//$wiziq_course_res = $wpdb->get_results( "select * from $wiziq_courses order by $sortby $orderby LIMIT $start ,$limit" );
			} elseif ( $sortby == 'count' ) {
                             
				$wiziq_course_res = $wpdb->get_results("SELECT a.*,count(b.id) cls FROM $wiziq_courses a left join $wiziq_classes b on b.courseid=a.id group by a.id order by cls $orderby LIMIT $start ,$limit");
			} elseif ( $sortby == 'uname' ) {
                             
				$users = $wpdb->prefix."users";
				$usersmeta = $wpdb->prefix."usermeta";
				$name_query = "SELECT
								c.*,
								if ( m1.meta_value = '', u1.display_name, CONCAT(m1.meta_value,' ',m2.meta_value)) as name
								FROM $wiziq_courses c
								JOIN $users u1 ON (c.created_by = u1.id )
								JOIN $usersmeta m1 ON (m1.user_id = u1.id AND m1.meta_key = 'first_name')
								JOIN $usersmeta m2 ON (m2.user_id = u1.id AND m2.meta_key = 'last_name') order by name $orderby LIMIT $start ,$limit
							";
				$wiziq_course_res = $wpdb->get_results( $name_query);
			}
                        elseif ( $sortby == 'description' ) {
                             
				$wiziq_course_res = $wpdb->get_results("select * from $wiziq_courses order by $sortby $orderby LIMIT $start ,$limit");
			}
				/***** Sorting functionality *****/ 
			 if ( isset ( $_GET['sort-by'] ) && $_GET [ 'order-by']  ) :
			 
			 
					if ( "fullname" == $_GET['sort-by'] ) :
					
						if ( "asc" == $_GET['order-by']) {
							$nameclass = "sorting-up";
							$ordering = "desc";
							$nametitle = __( 'Click to sort by descending order' ,'wiziq');
						} else {
							$nameclass = "sorting-down";
							$ordering = "asc";
							$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
						}
						$countclass = "sorting-up";
						$countordering = "asc";
						$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
						$usernameclass = "sorting-down";
						$usernameordering = "asc";
						$usernametitle = __( 'Click to sort by ascending order' ,'wiziq');
                                                $descriptionclass = "sorting-down";
						$descriptionordering = "asc";
						$descriptiontitle = __( 'Click to sort by ascending order' ,'wiziq');
					elseif ( "count" == $_GET['sort-by'] )  :
						if ( "asc" == $_GET['order-by']) {
							$countclass = "sorting-up";
							$countordering = "desc";
							$counttitle = __( 'Click to sort by descending order' ,'wiziq');
						} else {
							$countclass = "sorting-down";
							$countordering = "asc";
							$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
						}
						$nameclass = "sorting-up";
						$ordering = "asc";
						$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
						$usernameclass = "sorting-down";
						$usernameordering = "asc";
						$usernametitle = __( 'Click to sort by ascending order' ,'wiziq');
                                                $descriptionclass = "sorting-down";
						$descriptionordering = "asc";
						$descriptiontitle = __( 'Click to sort by ascending order' ,'wiziq');
						
					elseif ( "uname" == $_GET['sort-by'] )  :
						if ( "asc" == $_GET['order-by']) {
								$usernameclass = "sorting-up";
								$usernameordering = "desc";
								$usernametitle = __( 'Click to sort by descending order' ,'wiziq');
							} else {
								$usernameclass = "sorting-down";
								$usernameordering = "asc";
								$usernametitle = __( 'Click to sort by ascending order' ,'wiziq');
							}
							$nameclass = "sorting-up";
							$ordering = "asc";
							$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
							$countclass = "sorting-up";
							$countordering = "asc";
							$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
                                                        $descriptionclass = "sorting-down";
							$descriptionordering = "asc";
							$descriptiontitle = __( 'Click to sort by ascending order' ,'wiziq');
                                        elseif ( "description" == $_GET['sort-by'] )  :
						if ( "asc" == $_GET['order-by']) {
								$descriptionclass = "sorting-up";
								$descriptionordering = "desc";
								$descriptiontitle = __( 'Click to sort by descending order' ,'wiziq');
							} else {
								$descriptionclass = "sorting-down";
								$descriptionordering = "asc";
								$descriptiontitle = __( 'Click to sort by ascending order' ,'wiziq');
							}
							$nameclass = "sorting-up";
							$ordering = "asc";
							$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
							$countclass = "sorting-up";
							$countordering = "asc";
							$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
                                                        $usernameclass = "sorting-down";
						$usernameordering = "asc";
						$usernametitle = __( 'Click to sort by ascending order' ,'wiziq');
					endif;
			else :
				$countordering = "asc";
				$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
				$nameclass = "sorting-up";
				$ordering = "asc";
				$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
				$usernameclass = "sorting-down";
				$usernameordering = "asc";
				$usernametitle = __( 'Click to sort by ascending order' ,'wiziq');
			endif;
			if( is_user_administrator() ) { ?>
				<table class="list_courses sortable" id="list_courses" >
						<tr>
							<th>
								<a href = "<?php echo $homepage.'sort-by=fullname&order-by='.$ordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Course Name','wiziq') ;?>
										<?php if (isset ( $_GET[ 'sort-by' ] ) && "fullname" == $_GET[ 'sort-by' ] ) : ?>
											<div class = "<?php echo $nameclass; ?>" ></div>
										<?php endif; ?>
									</span>
								</a>
							</th>
							<th>
                                                                <a href = "<?php echo $homepage.'sort-by=description&order-by='.$descriptionordering; ?>" title = "<?php echo $nametitle; ?>" >

								<span><?php _e('Description','wiziq');?></span>
                                                                <?php if (isset ( $_GET[ 'sort-by' ] ) && "description" == $_GET[ 'sort-by' ] ) : ?>
											<div class = "<?php echo $nameclass; ?>" ></div>
										<?php endif; ?>
                                                                
                                                                </a>
							</th>
							<th>
								<span><?php _e('Manage Course','wiziq');?></span>
							</th>
							<th>
								<a href = "<?php echo $homepage.'sort-by=uname&order-by='.$usernameordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Created By','wiziq') ;?></span>
									<?php if (isset ( $_GET[ 'sort-by' ] ) && "uname" == $_GET[ 'sort-by' ]): ?>
										<div class = "<?php echo $usernameclass; ?>" ></div>
									<?php endif; ?>
								</a>
							</th>
							<th>
								<a href = "<?php echo $homepage.'sort-by=count&order-by='.$countordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Number of Classes','wiziq') ;?></span>
									<?php if (isset ( $_GET[ 'sort-by' ] ) && "count" == $_GET[ 'sort-by' ]): ?>
										<div class = "<?php echo $countclass; ?>" ></div>
									<?php endif; ?>
								</a>
							</th>
						</tr>
					<?php
					$courses = get_front_courses();
					 $useiddd = get_current_user_id();

					
					if($courses){
						
						//Get courses and display
						
						foreach($wiziq_course_res as $course){
							$wiziq_class_permission = $user_permissions->wiziq_front_class_permission($course->id);
							$view_classes = $courses_url.$qvarsign.'caction=view_classes'.'&course_id='.$course->id;
							$course_detail = $courses_url.$qvarsign.'action=course_desc&course_id='.$course->id;
							$deletenonce = wp_create_nonce( 'delete-course-' . $course->id );
							$wiziq_classes = $wpdb->prefix."wiziq_wclasses";
							$classesqry = "select count(*) from $wiziq_classes where courseid = '$course->id'"; 
							$classesres = $wpdb->get_var($classesqry);
							$add_class_nonce = wp_create_nonce( 'add-class-' . $course->id );
							$add_curl = $courses_url.$qvarsign.'caction=add_class&course_id='.$course->id.'&wp_nonce='.$add_class_nonce;
							$edit_curl = wp_nonce_url( $edit_curli, 'edit-course-' . $course->id , 'wn');
							?>
								<input type = "hidden" value = "<?php echo $classesres; ?>" class = "hidden-classes" id= "hid-class-<?php echo $course->id;?>" />
							<?php
							echo '<tr>';
							echo '<td>';
							echo '<a href="'.$course_detail.'">';
							$coursename = $course->fullname;
							$courselen = strlen($coursename); 
							/* if ( $courselen > 10 )
								echo substr($coursename,0,10).'..';
							else 
								echo $course->fullname; */
                                                        echo $course->fullname;
							echo '</a>';
							echo '</td>';
							echo '<td>';
							//Display description upto 6 words and rest on hover
							echo '<div class = "al_down" >';
							$des = $course->description;
							$desc = $Wiziq_Util->shorten_string( $des , 6);
							echo $desc;
							echo '</div>';
							echo '</td>';
							echo '<td class="icons">';
							echo '<a  title="'.__('Edit this course', 'wiziq').'" href="'.$edit_curl.'&course_id='.$course->id.'" ><img alt = "'.__('Edit', 'wiziq').'" class = "classes-images" src="'.WIZIQ_PLUGINURL_PATH.'images/edit15.png" /></a>';
							if ( $wiziq_class_permission ) :
								echo '<a title="'.__('Add new class', 'wiziq').'" href="'.$add_curl.'" ><img alt = "'.__('Add new class', 'wiziq').'" src="'.WIZIQ_PLUGINURL_PATH.'images/add15.png" /></a>';
							else :
								echo '<a title="'.__('Add new class', 'wiziq').'" href="#" ><img alt = "'.__('Add new class', 'wiziq').'" src="'.WIZIQ_PLUGINURL_PATH.'images/add15.png" /></a>';
							endif;
							echo '<a id = "'.$course->id.'" title="'.__('Delete this course', 'wiziq').'" class = "classes-images submitdelete" href="'.$delete_curl.'&course_id='.$course->id.'&wn='.$deletenonce.'" ><img class = "classes-images" src="'.WIZIQ_PLUGINURL_PATH.'images/delete15.png" /></a>';
							echo '<input type="button"  class="addstudent pre seedtbut-'.$course->id.'" value="'.__("Add Student", "wiziq" ).'" onclick="addstudent_row_pre('.$course->id.','.$useiddd.')">';
							echo '<input type="button"  class="shoowstudent pre seedtbut-'.$course->id.'" value="'.__("Show Student", "wiziq" ).'" onclick="showstudent_row_pre('.$course->id.')">';
							echo '</td>';
							echo '<td>';
							//get user data and display name who created the class
							$user_info = get_userdata( $course->created_by ); 
							echo $user_info->display_name;
							echo '</td>';
							echo '<td>';
							if ( $classesres ) {
								echo '<a href="'.$view_classes.'">';
								echo $classesres;
								echo '</a>';
							}
							else {
								echo '---';
							}
							echo '</td>'; 
							?>
							<?php 
							echo '</tr>';
						 } // end foreach
					}
					else {
						echo '<tr><td colspan="5">'.__('No course available','wiziq').'</td></tr>';
					} // else no course available
					?>
                                        <tfoot>
					<tr>
					<th>
					<span><?php _e('Course Name','wiziq') ;?></span>
					</th>
					<th>
					<span><?php _e('Description','wiziq');?></span>
					</th>
					<th>
					<span><?php _e('Manage Course','wiziq');?></span>
					</th>
					<th>
					<span><?php _e('Created By','wiziq') ;?></span>
					</th>
					<th>
					<span><?php _e('Number of Classes','wiziq') ;?></span>
					</th>
					</tr>
                                        </tfoot>
				</table>
					<?php 
					//display pagination
					echo $pagination;
			} else {
			//user logged in but not administrator
			 ?>
			 <div class="overfulnew">
				<table class="list_courses sortable" id="list_courses" >
						<tr>
							<th>
								<a href = "javascript:;<?php //echo $homepage.'sort-by=fullname&order-by='.$ordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Course Name','wiziq') ;?></span>
									<?php if (isset ( $_GET[ 'sort-by' ] ) && "fullname" == $_GET[ 'sort-by' ] ) : ?>
										<div class = "<?php echo $nameclass; ?>" ></div>
									<?php endif; ?>
								</a>
								
							</th>
							<th>
								<span><?php _e('Description','wiziq');?></span>
							</th>
							<th>
								<a href = "javascript:;<?php //echo $homepage.'sort-by=uname&order-by='.$usernameordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Created By','wiziq') ;?></span>
									<?php if (isset ( $_GET[ 'sort-by' ] ) && "uname" == $_GET[ 'sort-by' ]): ?>
										<div class = "<?php echo $usernameclass; ?>" ></div>
									<?php endif; ?>
								</a>
								
							</th>
							<th>
								<a href = "javascript:;<?php //echo $homepage.'sort-by=count&order-by='.$countordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Number of Classes','wiziq') ;?></span>
									<?php if (isset ( $_GET[ 'sort-by' ] ) && "count" == $_GET[ 'sort-by' ]): ?>
										<div class = "<?php echo $countclass; ?>" ></div>
									<?php endif; ?>
								</a>
							</th>
						</tr>
					<?php
						$wiziq_courses = $wpdb->prefix."wiziq_courses";
						$wiziq_enroluser = $wpdb->prefix."wiziq_enroluser";
					$usero = wp_get_current_user();
				
					$chkusercou = $wpdb->get_results('SELECT id FROM '.$wiziq_courses.'', ARRAY_A);
										$allpreus = array();
                          foreach ($chkusercou as $key => $value) {
                            $preuch = $value;
                            $allpreus[] = $preuch;
                          }                       
               //     $chkcours = $wpdb->get_results('SELECT course_id FROM  '.$wiziq_enroluser.' WHERE user_id  ='.$usero->ID.'', ARRAY_A);
               
           $chkcours = $wpdb->get_results('SELECT course_id FROM  '.$wiziq_enroluser.' WHERE user_id  ='.$usero->ID.' AND upload_course = 1', ARRAY_A);
//echo 'SELECT course_id FROM  '.$wiziq_enroluser.' WHERE user_id  ='.$usero->ID.' AND upload_course = 1';

						$allcou = array();
                          foreach ($chkcours as $key => $value) {
                            $chkcourss = $value;
                            $allcou[] = $chkcourss;
                          }                           
                         $reco1 = array_intersect($allcou,$allpreus);                        
                      
                        
                       foreach ($reco1 as $recos) {						  
									?>
						   <style>
							.seedtbut-<?php echo $recos['course_id']; ?>{
								display:block !important;
							}
						   </style>
						<?php }						
					$courses = get_front_courses();
					$useiddd = get_current_user_id();
					if($courses){
						global $wpdb;
						$Wiziq_Util = new Wiziq_Util;						
						foreach($wiziq_course_res as $course){                         
                                                    
							$course_detail = $courses_url.$qvarsign.'action=course_desc&course_id='.$course->id;
							$view_classes = $courses_url.$qvarsign.'caction=view_classes'.'&course_id='.$course->id;
							$wiziq_classes = $wpdb->prefix."wiziq_wclasses";      
							$classesqry = "select count(*) from $wiziq_classes where courseid = '$course->id'"; 
							$classesres = $wpdb->get_var($classesqry);
							echo '<tr>';
							echo '<td>';
							echo '<a href="'.$course_detail.'">';
							$coursename = $course->fullname;
							$courselen = strlen($coursename); 
							/* if ( $courselen > 10 )
								echo substr($coursename,0,10).'..';
							else 
								echo $course->fullname; */
                            echo $course->fullname;
							echo '</a>';
							echo '<div class="table-top-row">';
							echo ' <input type="button" style="display:none;" class="edit_button pre seedtbut-'.$course->id.'" value="'.__("Edit", "wiziq" ).'" onclick="edit_row_pre('.$course->id.')">';
							echo '<input type="button" style="display:none;" class="delete_button pre seedtbut-'.$course->id.'" value="'.__("Delete", "wiziq" ).'" onclick="delete_row_pre('.$course->id.')">';		
							echo '</div>';		
							echo '<div class="table-top-rows">';			
							echo '<input type="button" style="display:none;" class="addstudent pre seedtbut-'.$course->id.'" value="'.__("Add Student", "wiziq" ).'" onclick="addstudent_row_pre('.$course->id.','.$useiddd.')">';
							echo '<input type="button" style="display:none;" class="shoowstudent pre seedtbut-'.$course->id.'" value="'.__("Show Student", "wiziq" ).'" onclick="showstudent_row_pre('.$course->id.')">';
								echo '</div>';	
							echo '</td>';
							echo '<td>';
							//Display description upto 6 words and rest on hover
							echo '<div class = "al_down">';
							$des = $course->description;
							$desc = $Wiziq_Util->shorten_string( $des , 6);
							echo $desc;
							echo '</div>';
							echo '</td>';
							echo '<td>';
							$user_info = get_userdata( $course->created_by ); 
							echo $user_info->display_name;
							echo '</td>';
							echo '<td>';
							if ( $classesres ) {
								echo '<a href="'.$view_classes.'">';
								echo $classesres;
								echo '</a>';
							}
							else {
								echo '---';
							}
							echo '</td>';  
							echo '</tr>';
                                                        
                                               // }   
						 } // end foreach
					} else {
						echo '<tr><td colspan="4">'.__('No course available','wiziq').'</td></tr>';
					} // else no course available
                                        echo '<tfoot>';
					echo '<tr>';
					echo '<th>';
					echo '<span>'.__('Course Name','wiziq').'</span>';
					echo '</th>';
					echo '<th>';
					echo '<span>'.__('Description','wiziq').'</span>';
					echo '</th>';
					echo '<th>';
					echo '<span>'.__('Created By','wiziq').'</span>';
					echo '</th>';
					echo '<th>';
					echo '<span>'.__('Number of Classes','wiziq').'</span>';
					echo '</th>';
					echo '</tr>';
                                         echo '</tfoot>';
					?>
				</table>
			</div>
			<?php echo $pagination;
			} ?>
				</div><!-- .close ./wiziq_right -->

			</div><!-- front_wiziq -->
			<div class = "wiziq_hide" >
				<span id = "course_delete" ><?php _e('Please delete inner classes first','wiziq');?></span>
				<span id = "wiziq_are_u_sure" ><?php _e('Are you sure, you want to delete','wiziq');?></span>
				<span id = "wiziq_select_course" ><?php _e('Please select courses to delete','wiziq');?></span>
			</div>
			
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
	
	<!-- For ditoo amdmin --> 
<?php if(current_user_can('administrator') ) { ?>
	
	<div class="wrap" style="display:none;">         

	 <h2><?php _e( 'Enroll Users for Course' , 'wiziq' ); ?></h2>
	 
	 
        <form method = "post" id= "enroll_users" class="newenroll_users" >
            <input type="hidden" value="<?php echo $_REQUEST['addstudent']; ?>" name="course_id"/>
            <?php
            global $wpdb;
            //get all admins
            $admins = get_users(array('role'=>"administrator"));
            foreach ($admins as $admin){ 
                $admin_ids[]=$admin->ID;
            }
            //all users excluding administator type
            $users = get_users(array('exclude' => $admin_ids));
            if(count($users)>0){
            $table_name = $wpdb->prefix . "wiziq_enroluser";
            $user_table = $wpdb->prefix . "users";
            $query = "SELECT t1.* , t2.user_login FROM $table_name AS t1, $user_table AS t2
                            WHERE t1.user_id = t2.ID AND t1.course_id =" . $_REQUEST['addstudent'];
            $enrolled_users = $wpdb->get_results($query);
            
         //   print_r($enrolled_users);
            ?>
            <table class= "wp-list-table widefat fixed pages" >
                <tbody>
                    <tr>
                        <td class="enroll-col"><?php _e('Enroll User','wiziq'); ?></td>
                        <td class="enroll-user-col">
                            <input value="" placeholder="Search..." id="s" type="text" /> 


                            <select name="enrolleduser[]" data-show-subtext="true" data-live-search="true" multiple size="10" class="wiziq-select selectpicker" id="wiziq-enroll-user">
                                <?php
                                $enrolled_ids = array();
                                if (count($enrolled_users) > 0) {
                                    foreach ($enrolled_users as $enrolled) {
										$user_info = get_userdata($enrolled->user_id);
										if(!empty($user_info->first_name)){
											$teacher_name = $user_info->first_name.' '.$user_info->last_name;
										} else	{
											$teacher_name = $user_info->display_name;
										}
										echo '<option data-subtext="' . $teacher_name . '" value="' . $enrolled->user_id . '" >' . $teacher_name . '</option>';
										$enrolled_ids[] = $enrolled->user_id;
                                    }
                                }
                                ?></select>
                            <input type="hidden" name="existing-users" value="<?php echo implode(",", $enrolled_ids); ?>"/>
                        </td>
                        <td class="action-col" style="text-align:center;">
                            <br/><br/><br/><br/><br/>
                            
                            <input type="button"  id="wiziq-add-user" value="<< <?php _e('Add','wiziq');?>" /><br/>
                            <input type="button" id="wiziq-remove-user" value="<?php _e('Remove','wiziq');?> >>" />
                            <br/><br/><br/>
                        </td>
                        <td class="enroll-all-col">
                            <input placeholder="Search..." id="allserach" type="text" />
                            <select name="alluser[]" multiple size="10" class="wiziq-select" id="wiziq-all-user"><?php
                        foreach ($users as $user) {
                            if (!in_array($user->ID, $enrolled_ids)) {
									$user_info = get_userdata($user->ID);
									if(!empty($user_info->first_name)){
										$teacher_name = $user_info->first_name.' '.$user_info->last_name;
									} else	{
										$teacher_name = $user_info->display_name;
									}
                                echo '<option value="' . $user->ID . '" >' . $teacher_name . '</option>';
							}
                        }
                        ?></select>
                        </td>
                        <?php 
							foreach ($users as $user) { 
								//removed on 24-nov-2014
								//$user_info = get_userdata($user->ID);
								//$user_rle = implode(', ', $user_info->roles);
								//if ( $user_rle == 'author' || $user_rle == 'editor') {
									//$role = "teacher";
								//} else {
									//$role = "student";
								//}
  /* start custom code to disable create class and upload content options for student or subscriber  */                                                                           
                                                                        
                        $user_info = get_userdata($user->ID);
			$user_rle = implode(', ', $user_info->roles);
			if ( $user_rle == 'editor' || $user_rle == 'author' || $user_rle == 'contributor') {
			$role = "teacher";
			} else {
			$role = "student";
			}   
                        
 /* end custom code to disable create class and upload content options for student or subscriber  */                                                                            
								echo '<input role = "'.$role.'" name= "user_permissions" type = "hidden" id= "user_role_'.$user->ID.'" value = "'.$role.'" />';
							}
							?>
                    </tr>
                </tbody>
            </table>
            <br/>          
            <h2><?php _e('User Permissions','wiziq'); ?></h2>
            <table id="wiziq-course-permission"class= "wp-list-table widefat fixed pages" >
                <thead>
                    <tr>
                        <th><?php _e( 'User Name' , 'wiziq' );?></th>
                        <th>
							<?php _e( 'Create Class' , 'wiziq' );?>
							<!--<input class = "all_check" type = "checkbox" id = "create_class_all" />-->
						</th>
                        <th>
							<?php _e( 'View Recording','wiziq');?>
							<!--<input class = "all_check" type = "checkbox" id = "view_recording_all" />-->
						</th>
						 <th>
							<?php _e( 'Download Recording','wiziq' );?>
							<!--<input class = "all_check" type = "checkbox" id = "download_recording_all" />-->
						</th>
                        <th>
							<?php _e( 'Create Course','wiziq' );?>
							<!--<input class = "all_check" type = "checkbox" id = "download_recording_all" />-->
						</th>
                        <th>
							<?php _e( 'Upload Content','wiziq' );?>
							<!--<input class = "all_check" type = "checkbox" id = "upload_content_all" />-->
						</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr colspan="5">
                        <td>
                        <?php
                        if(count($enrolled_users)==0){
                            _e('No users enrolled in this course','wiziq' );
                         }
                        ?>
                        </td>
                    </tr>
                </tfoot>
                <tbody>
                    <?php
                    if (count($enrolled_users) > 0) {
                        $tbody = array();
                        foreach ($enrolled_users as $enrolled) {
							
							$user_info = get_userdata($enrolled->user_id);
							$user_rle = implode(', ', $user_info->roles);
                                                       
							//removed on 24-nov-2014
							//if ( $user_rle == 'author' || $user_rle == 'editor') {
								//$user_return = true;
							//} else {
								//$user_return = false;
							//}
                        /* start custom code to disable create class and upload content options for student or subscriber  */               
                 					if ( $user_rle == 'editor'|| $user_rle == 'author' || $user_rle == 'contributor') {
								$user_return = true;
							} else {
								$user_return = false;
							} 
                                                      
                                                        
                      /* end custom code to disable create class and upload content options for student or subscriber */  
							if(!empty($user_info->first_name)){
								$teacher_name = $user_info->first_name.' '.$user_info->last_name;
							} else	{
								$teacher_name = $user_info->display_name;
							}
							$tbody[] = '<tr id=enroll_' . $enrolled->user_id . ' class="alternate iedit">';
							$tbody[] = '<td><input type="hidden" name="user_id[]" value="' . $enrolled->user_id . '" />' . $teacher_name . '</td>';
							$tbody[] = '<td><input type="hidden" value="0" name="create_class[' . $enrolled->user_id . ']" /><input value="1" type="checkbox" name="create_class[' . $enrolled->user_id . ']" class="create_class" id="create_class_' . $enrolled->user_id . '" ';
                            if ( $user_return && $enrolled->create_class == 1)
								$tbody[] = ' checked class="create_class"';
							else if ( !$user_return )
								$tbody[] = ' disabled class="create_class permission_disable"'; 
							$tbody[] = '/> </td><td><input type="hidden" value="0" name="view_recording[' . $enrolled->user_id . ']" /><input value="1" type="checkbox"  name="view_recording[' . $enrolled->user_id . ']" class="view_recording" ';
							if ($enrolled->view_recording == 1)
								$tbody[] = ' checked ';
							$tbody[] = '/> </td><td><input type="hidden" value="0" name="download_recording[' . $enrolled->user_id . ']" /><input value="1" type="checkbox" name="download_recording[' . $enrolled->user_id . ']" class="download_recording"';
							if ($enrolled->download_recording == 1)
								$tbody[] = ' checked ';
							$tbody[] = '/> </td><td><input type="hidden" value="0" name="upload_course[' . $enrolled->user_id . ']" /><input value="1" type="checkbox" name="upload_course[' . $enrolled->user_id . ']" class="upload_course" id="' . $enrolled->user_id . '" ';
							if ( $user_return && $enrolled->upload_course == 1)
								$tbody[] = ' checked class="upload_course"';	
								else if ( !$user_return )
								$tbody[] = ' disabled class="upload_course permission_disable"'; 
							$tbody[] = '/> </td><td><input type="hidden" value="0" name="upload_content[' . $enrolled->user_id . ']" /><input value="1" type="checkbox"  name="upload_content[' . $enrolled->user_id . ']"  class="upload_content" id="' . $enrolled->user_id . '" ';
							if ( $user_return && $enrolled->upload_content == 1)
								$tbody[] = ' checked class="upload_content"';
							else if ( !$user_return )
								$tbody[] = ' disabled class="upload_content permission_disable"'; 
							$tbody[] = '/> </td></tr>';
                        }
                        echo join("", $tbody);
                    }
                    ?>
                </tbody>
            </table>
            <br/>
            <input type="Submit" value="<?php _e( 'Save' , 'wiziq' ) ;?>" name="wiziq_enroll_users" id="wiziq_enroll_users" class="button button-primary">
             <a class="button button-primary" href="<?php echo $courses_url; ?>" ><?php _e( 'Cancel' , 'wiziq' ) ;?></a>
        </form>
        <?php
            }else{
                ?>
        <?php
            } ?>
    </div>
	<script>
	jQuery(".newenroll_users").validate({
             rules:
             {
                
             },
              messages: {    
			},
             submitHandler: function(form)
             {           
                jQuery.ajax({
                        type: "POST",
                       url: '<?php echo site_url(); ?>/wp-content/plugins/wiziq/adminrole.php',
                        data: jQuery(".newenroll_users").serialize(),
                        success: function(data){
                          jQuery('.loadercate').show();
                          setTimeout(
								function(){
									window.location='<?php echo $courses_url; ?>';}, 2000)
                     }
                });
             }
         });
	</script>
	
<?php } ?>
	<!-- For end amdmin --> 
	
	
<div class="curstext okokok" style="display:none">
						<div class="wrap">
							
		<h3><?php _e('ADD COURSES', 'wiziq'); ?></h3> 
		<form></form>
		<form method="post" id="add_course_form_section">
			 <?php  $user = wp_get_current_user(); 
					$userid = $user->ID;
				?>

			<table class="form-table">
				<tbody>
					<tr>
						<th><?php _e('Course name (required)', 'wiziq'); ?></th>
						<td>
							<input maxlength="70" type="text" class="regular-text" id="course_name_add" name="course_name_add">
						</td>
					</tr>
					<tr>
						<th><?php _e('Start date', 'wiziq'); ?></th>
						<td>
							<input type="text" name="stDate" id="stdatepickercourse">

						</td>
					</tr>
					<tr>
						<th><?php _e('End date', 'wiziq'); ?></th>
						<td>
							<input type="text" name="enDate" id="endatepickercourse">
							
						</td>
					</tr>
					<tr>
						<th><?php _e('Description', 'wiziq'); ?></th>
						<td>
							<textarea maxlength="1000" id="course_add" cols="40" rows="5" name="course_add"></textarea>
							<p class="wiziq_limit description"><?php _e('You can enter upto 1000 characters.', 'wiziq'); ?></p>
						</td>
					</tr>
					<input type="hidden" name="useid" value="<?php echo $userid; ?>">
					
				</tbody>
			</table>
			<input class="button button-primary pre wiziq-button" id="wiziq_add_course_course" type="Submit" name="wiziq_add_course_course" value="<?php _e('Save', 'wiziq'); ?>"> 
		</form>
		</div>
			</div>
			<?php 
			if($_GET['edituser']){ ?>
				<style>
					#front_wiziq{
						display:none;
						}
					.editcurstext{
						display:block !important;
						}	
				</style>
			<?php }
			?>
<div class="editcurstext" style="display:none">
						<div class="wrap">
		<h3><?php _e('Edit Course', 'wiziq' );?></h3>
		
		<form method="post" id="editwiziq_add_course_course">
			 <?php  $user = wp_get_current_user(); 
					$userid = $user->ID;
					  $cforpost = $wpdb->get_results('SELECT * FROM '.$wiziq_courses.' WHERE id ='.$_GET['edituser'].'', ARRAY_A);
				
				?>

			<table class="form-table">
				<tbody>
					<tr>
						<th><?php _e('Course name (required)', 'wiziq' );?></th>
						<td>
							<input maxlength="70" type="text" value="<?php echo $cforpost[0]['fullname'] ?>" class="regular-text" id="editcourse_name_add" name="editcourse_name_add">
						</td>
					</tr>
					<tr>
						<th><?php _e('Start date', 'wiziq' );?> </th>
						<td>
							<input type="text" name="editstDate" value="<?php echo $cforpost[0]['startdate'] ?>" id="editstdatepickercourse">

						</td>
					</tr>
					<tr>
						<th><?php _e('End date', 'wiziq' );?></th>
						<td>
							<input type="text" name="editenDate" value="<?php echo $cforpost[0]['enddate'] ?>" id="editendatepickercourse">
							
						</td>
					</tr>
					<tr>
						<th><?php _e('Description', 'wiziq' );?></th>
						<td>
							<textarea maxlength="1000" id="editcourse_add" cols="40" rows="5" name="editcourse_add"><?php echo $cforpost[0]['description'] ?></textarea>
							<p class="wiziq_limit description"><?php _e('You can enter upto 1000 characters.', 'wiziq' );?></p>
						</td>
					</tr>
					<input type="hidden" name="edituseid" value="<?php echo $userid; ?>">
						<input type="hidden" name="couid" value="<?php echo $cforpost[0]['id'] ?>">
					
				</tbody>
			</table>
			<input class="button pre button-primary wiziq-button" id="editwiziq_add_course_course" type="Submit" name="editwiziq_add_course_course" value="<?php _e('Update', 'wiziq' );?>"> 
			<a href="<?php echo $courses_url; ?>"><?php _e('Cancel', 'wiziq' );?></a>
		</form>
		</div>
			</div>

<?php 
			if($_GET['showstudent']){ ?>
				<style>
					#front_wiziq{
						display:none;
						}
					.showstudentall{
						display:block !important;
						}	
				</style>
			<?php }
			?>			
<div class="showstudentall" style="display:none">
	<?php 
	$usid =  get_current_user_id();


	$wiziq_enroluser = $wpdb->prefix."wiziq_enroluser";
	$shuser = $wpdb->get_results( 'select user_id from '.$wiziq_enroluser.' where course_id = "'.$_GET['showstudent'].'" And user_id != '.$usid.' ', ARRAY_A );
	?>
	<table>
  <tr>
    <th><?php _e('User Name', 'wiziq' );?></th>
    <th><?php _e('User Email', 'wiziq' );?></th>
     <th><?php _e('Remove', 'wiziq' );?></th>
  </tr>

	<?php
	foreach ($shuser as $shusers) {
			$user_info = get_userdata($shusers['user_id']);
			?>
			<tr>
				<td><?php echo $user_info->first_name;?> <?php echo $user_info->last_name;?></td>
				<td><?php echo $user_info->user_email;?></td>
				<td>
					<a id = "<?php echo $user_info->ID; ?>" class = "remst" onclick="delete_row_user('<?php echo $user_info->ID; ?>','<?php echo $_GET['showstudent']; ?>')"> <img src="<?php echo WIZIQ_PLUGINURL_PATH; ?>images/delete15.png" /></a>
				</td>
			</tr>		
	
	<?php }
	?>
	</table>
<a class= "button button-primary " title="<?php _e('Back To Courses', 'wiziq'); ?>" href="<?php echo $courses_url; ?>" ><?php _e('Back To Courses','wiziq'); ?></a>
</div>

<?php

			foreach($wiziq_course_res as $course){		
			
				
			if($_GET['addstudent']){ ?>
				<style>
					#front_wiziq{
						display:none;
						}
						.wrap{
						display:block !important;
					}
					
				</style>
			<?php }
			if($_GET['addstudent'] == $course->id && $_GET['addstudenthide'] != 1){
			?>
			<style>
				.addsutudent-<?php echo $course->id; ?>{
						display:block !important;
					}
					
			</style>
			<?php } ?>
			
		
			
<div class="addsutudent-<?php echo $course->id; ?>" id="addsutudentss" style="display:none">
   <div class="wrap">
		<h3><?php _e('Add Student', 'wiziq' );?></h3>
						<input type="checkbox" id="checkAll-<?php echo $course->id; ?>"><?php _e('Check All', 'wiziq' );?>

		<form method="post" id="addsutudent_add_course_course-<?php echo $course->id; ?>">
			 <?php  
			 $blogusers = get_users( [ 'role__in' => [ 'subscriber' ] ] );
				$udsid = array();
				foreach ( $blogusers as $user ) {
							$udsid[] = $user->ID;
				}
					$wiziq_users = $wpdb->prefix."wiziq_enroluser";
					$coursesus = $wpdb->get_results( 'select user_id from '.$wiziq_users.' where course_id = "'.$_GET['addstudent'].'"', ARRAY_A ); 	
					$udsidin = array();
						foreach ( $coursesus as $coursesus ) {
							$udsidin[] = $coursesus['user_id'];
						}

						$resultus=array_diff($udsid,$udsidin);
												
				?>

			<div class="allussub">
				
			<table class="scroll">
				 <thead>
				<tr>
					<th><?php _e('User Name', 'wiziq' );?></th>
					<th><?php _e('User Email', 'wiziq' );?></th>
					<th><?php _e('Select User', 'wiziq' );?></th>
				</tr>
				 </thead>
				  <tbody>
				<?php 	foreach ( $resultus as $usersubuser ) {					
					$user_info = get_userdata($usersubuser);
					 ?>
					<tr>
						
						<td><?php echo $user_info->first_name; ?> <?php echo $user_info->last_name; ?> </td>
						<td><?php echo $user_info->user_email; ?></td>
						<td>
							<input name="PO_PowerWindows[]" type="checkbox" class="PO_PowerWindows" value="<?php echo $user_info->ID; ?>" /> 
						</td>
				 </tr>
				 <?php } ?>
				 <input type="hidden" name="useidss" value="<?php echo $userid; ?>">
				 <input type="hidden" name="ccid" value="<?php echo $course->id; ?>">
				  </tbody>
				 </table>
			</div>
			<input class="button button-primary pre wiziq-button" id="addsutudent_add_course_course-<?php echo $course->id; ?>" type="Submit" name="addsutudent_add_course_course" value="<?php _e('Update', 'wiziq' );?>"> 
			<a href="<?php echo $courses_url; ?>"><?php _e('Cancel', 'wiziq' );?></a>
		</form>
	</div>
</div>
<script type="text/javascript">
	jQuery("#checkAll-<?php echo $course->id; ?>").click(function () {
     jQuery('input:checkbox').not(this).prop('checked', this.checked);
 });
	
	jQuery("#addsutudent_add_course_course-<?php echo $course->id; ?>").validate({
             rules:
             {
                PO_PowerWindows:
                {
                    required: true,
                }
             },
              messages: {
    
				PO_PowerWindows: 'Please Select at least One value',				
			},
             submitHandler: function(form)
             {           
                jQuery.ajax({
                        type: "POST",
                       url: '<?php echo site_url(); ?>/wp-content/plugins/wiziq/add_course_user.php',
                        data: jQuery("#addsutudent_add_course_course-<?php echo $course->id; ?>").serialize(),
                        success: function(data){
                          jQuery('.loadercate').show();
                               setTimeout(
								function(){
									window.location='<?php echo $courses_url; ?>';}, 2000)
                     }
                });
             }
         });
</script>

<?php } ?>
						
<div class="loadercate settings-for-posts-loader" id="loadingDivohy"  style="display: none;">
	<div class="loineer">
	<img src="<?php echo WIZIQ_PLUGINURL_PATH; ?>/images/demo_wait.gif">
	<p>Please wait...</p>
</div>
</div> 

	<script type="text/javascript">

 jQuery("#add_course_form_section").validate({
             rules:
             {
                course_name_add:
                {
                    required: true,
                },            
             course_add:
             {
                 required: true
                
             },
             stDate:
             {
                 required: true
                
             },
             enDate:
             {
                 required: true
                
             }
             },
              messages: {
    
				course_name_add: 'Please Insert Course Name',
				course_add: 'Please Insert Descirption',
				stDate: 'Please Insert Start date',
				enDate: 'Please Insert End date',
			},
             submitHandler: function(form)
             {           
                jQuery.ajax({
                        type: "POST",
                       url: '<?php echo site_url(); ?>/wp-content/plugins/wiziq/add_course_user.php',
                        data: jQuery("#add_course_form_section").serialize(),
                        success: function(data){
                           jQuery('.loadercate').show();
                               setTimeout(function() {
                                      document.location.reload()
                                }, 2000);
                     }
                });
             }
         });
jQuery(document).ready(function(){
     jQuery('#stdatepickercourse').datepicker({
		 minDate: 0,
        dateFormat: "yy-mm-dd"
     });
       jQuery('#endatepickercourse').datepicker({
		 minDate: 0,
        dateFormat: "yy-mm-dd"
     });
   });
   
   
function delete_row_pre(id)
{
	 if(confirm('Sure To Remove This Course and Classes ?'))
{
 jQuery.ajax
 ({
  type:'post',
  url:'<?php echo site_url(); ?>/wp-content/plugins/wiziq/add_course_user.php',
  data:{
   delete_row_pre:'delete_row_pre',
   row_id:id,
  },
  success:function(response) {
    var responsews = response.trim();
   if(responsews=="success")
   {
      jQuery('.loadercate').show();
       setTimeout(function() {
           document.location.reload()
         }, 2000)
   }
  }
 });
}
}
function delete_row_user(id,ccusid)
{
	 if(confirm('Sure To Remove This Student ?'))
{
 jQuery.ajax
 ({
  type:'post',
  url:'<?php echo site_url(); ?>/wp-content/plugins/wiziq/add_course_user.php',
  data:{
   delete_row_user:'delete_row_user',
   row_id:id,
    ccusid:ccusid,
  },
  success:function(response) {
    var responsews = response.trim();
   if(responsews=="success")
   {
      jQuery('.loadercate').show();
       setTimeout(function() {
           document.location.reload()
         }, 2000)
   }
  }
 });
}
}

function edit_row_pre(id)
{
        window.location.href='<?php echo $courses_url; ?>/?edituser='+id;
}
function addstudent_row_pre(id,usecid)
{
        window.location.href='<?php echo $courses_url; ?>/?addstudent='+id+'&addstudenthide='+usecid;
}
function showstudent_row_pre(id)
{
        window.location.href='<?php echo $courses_url; ?>/?showstudent='+id;
}



 jQuery("#editwiziq_add_course_course").validate({
             rules:
             {
                editcourse_name_add:
                {
                    required: true,
                },            
             editcourse_add:
             {
                 required: true
                
             },
             editstDate:
             {
                 required: true
                
             },
             editenDate:
             {
                 required: true
                
             }
             },
              messages: {
    
				editcourse_name_add: 'Please Insert Course Name',
				editcourse_add: 'Please Insert Descirption',
				editstDate: 'Please Insert Start date',
				editenDate: 'Please Insert End date',
			},
             submitHandler: function(form)
             {           
                jQuery.ajax({
                        type: "POST",
                       url: '<?php echo site_url(); ?>/wp-content/plugins/wiziq/add_course_user.php',
                        data: jQuery("#editwiziq_add_course_course").serialize(),
                        success: function(data){
                           jQuery('.loadercate').show();
                          // alert($courses_url);
                              setTimeout(
								 function(){
								 	window.location="<?php echo $courses_url; ?>";}, 2000)
                     }
                });
             }
         });
         
jQuery(document).ready(function(){
     jQuery('#editstdatepickercourse').datepicker({
		 minDate: 0,
        dateFormat: "yy-mm-dd"
     });
       jQuery('#editendatepickercourse').datepicker({
		 minDate: 0,
        dateFormat: "yy-mm-dd"
     });
   });
jQuery(document).ready(function(){
  jQuery(".add_courses").click(function(){
           jQuery(".tablenav-pages").hide();
  });
  jQuery(".list_courses").click(function(){
           jQuery(".tablenav-pages").show();
  });
     
    });

    </script>	
			<?php
		}//end of wiziq display courses function
		
		
		
		/*
		 * Function to add a course
		 * @since 1.0
		 */ 
		function  wiziq_frontend_add_courses_form () {
			?>
			<div class="front_addcourse" >
				<h3><?php _e('ADD COURSES', 'wiziq'); ?></h3>
				<div class="frontaddform" >
					<form name="add_course_form" id="add_course_form" action="<?php echo get_permalink(); ?>" method="post" >
						<div class = "wiziq_hide" id = "course_name_msg" ><?php _e('Please enter course name.', 'wiziq'); ?></div>
						<div class = "wiziq_hide" id = "course_start_date_msg" ><?php _e('Start date can not be empty.', 'wiziq'); ?></div>
						<div class = "wiziq_hide" id = "course_end_date_msg" ><?php _e('End date can not be empty.', 'wiziq'); ?></div>
						<div class = "wiziq_hide" id = "course_end_date_greater_msg" ><?php _e('End date should be one day greater than start date.', 'wiziq'); ?></div>
						<table>
							<tr>
								<th><?php _e('Course name (required)', 'wiziq'); ?></th>
								<td>
									<input maxlength= "70" name="course_name" id="course_name"  />
									<div class="wiziq_error" id="course_name_err"></div>
								</td>
							</tr>
							<tr>
								<th>
									<?php _e('Start date', 'wiziq'); ?>
								</th>
								<td>
									<input name="course_start_date" id="course_start_date"  />
									<a id = 'course_start_date_id' href= "javascript:void(0);" onclick = "display_settings('course_start_date_id','course_start_date');" class = "date_remove_button wiziq_hide" ><?php _e('Clear' , 'wiziq' ); ?></a>
									<div class="wiziq_error" id="course_start_date_err"></div>
								</td>
							</tr>
							<tr>
								<th><?php _e('End date', 'wiziq'); ?></th>
								<td>
									<input name="course_end_date" id="course_end_date"  />
									<a id = 'course_end_date_id' href= "javascript:void(0);" onclick = "display_settings('course_end_date_id','course_end_date');" class = "date_remove_button wiziq_hide" ><?php _e('Clear' , 'wiziq' ); ?></a>
									<div class="wiziq_error" id="course_end_date_err"></div>
								</td>
							</tr>
							<tr>
								<th><?php _e('Description', 'wiziq'); ?></th>
								<td>
									<textarea maxlength= "1000" name="course_descirption" id="course_descirption"  ></textarea>
									<div class= "wiziq_limit"><?php _e('You can enter upto 1000 characters.','wiziq');?></div>
								</td>
							</tr>
						</table>
						<input type="submit" name="wiziq_addfront_course" id="wiziq_add_course" value="<?php _e('Save', 'wiziq'); ?>" />
						<input type="submit" name="wiziq_editfront_course_cancel" id="wiziq_cancel_course" value= "<?php _e('Cancel', 'wiziq'); ?>" />
					</form>
				</div>
			</div>
	
			<?php
		}// end add course form function
		
		/*
		 * Wiziq edit class form
		 * @since 1.0
		 */ 
		function wiziq_frontend_edit_courses_form () {
			$nonce = $_REQUEST['wn'];
			$course_id = $_REQUEST['course_id'];
			//check for valid request
			if ( ! wp_verify_nonce( $nonce , 'edit-course-'.$course_id  ) ) {
					?>
					<script>
						window.location = "<?php echo $returnurl; ?>";
					</script>
					<?php
			}
			$wiziq_courses_class = new Wiziq_Courses();
			$course_res = $wiziq_courses_class->wiziq_get_single_courses ($course_id);
			?>
			<div class="front_addcourse" >
			<h3><?php _e('Edit Course', 'wiziq'); ?></h3>
			<div class="frontaddform" >
				<form name="edit_course_form" id="add_course_form" action="<?php echo get_permalink(); ?>" method="post" >
					<div class = "wiziq_hide" id = "course_name_msg" ><?php _e('Please enter course name.', 'wiziq'); ?></div>
					<div class = "wiziq_hide" id = "course_start_date_msg" ><?php _e('Start date can not be empty.', 'wiziq'); ?></div>
					<div class = "wiziq_hide" id = "course_end_date_msg" ><?php _e('End date can not be empty.', 'wiziq'); ?></div>
					<div class = "wiziq_hide" id = "course_end_date_greater_msg" ><?php _e('End date should be one day greater than start date.', 'wiziq'); ?></div>
					<table>
						<tr>
						<th><?php _e('Course name (required)', 'wiziq'); ?></th>
							<td>
								<input maxlength= "70" name="course_name" id="course_name" value = "<?php echo $course_res->fullname; ?>" />
								<div class="wiziq_error" id="course_name_err"></div>
							</td>
						</tr>
						<tr>
							<th><?php _e('Start date', 'wiziq'); ?></th>
							<td>
								<input name="course_start_date" id="course_start_date"  value = "<?php if($course_res->startdate) { echo date( 'm/d/Y',strtotime($course_res->startdate)); }  ?>" />
								<?php if ( $course_res->enddate) : ?>
									<a id = 'course_start_date_id' href= "javascript:void(0);" onclick = "display_settings('course_start_date_id','course_start_date');" class = "date_remove_button wiziq_show" ><?php _e('Clear' , 'wiziq' ); ?></a>
								<?php else : ?>
									<a id = 'course_start_date_id' href= "javascript:void(0);" onclick = "display_settings('course_start_date_id','course_start_date');" class = "date_remove_button wiziq_hide" ><?php _e('Clear' , 'wiziq' ); ?></a>
								<?php endif; ?>
								<div class="wiziq_error" id="course_start_date_err"></div>
							</td>
						</tr>
						<tr>
							<th><?php _e('End date', 'wiziq'); ?></th>
							<td>
								<input name="course_end_date" id="course_end_date"  value = "<?php if($course_res->enddate) { echo date( 'm/d/Y', strtotime($course_res->enddate)) ; } ?>" />
								<?php if ( $course_res->enddate) : ?>
									<a id = 'course_end_date_id' href= "javascript:void(0);" onclick = "display_settings('course_end_date_id','course_end_date');" class = "date_remove_button wiziq_show" ><?php _e('Clear' , 'wiziq' ); ?></a>
								<?php else : ?>
									<a id = 'course_end_date_id' href= "javascript:void(0);" onclick = "display_settings('course_end_date_id','course_end_date');" class = "date_remove_button wiziq_hide" ><?php _e('Clear' , 'wiziq' ); ?></a>
								<?php endif; ?>
								<div class="wiziq_error" id="course_end_date_err"></div>
							</td>
						</tr>
						<tr>
							<th><?php _e('Description', 'wiziq'); ?></th>
							<td>
								<textarea maxlength= "1000" name="course_descirption" id="course_descirption"  ><?php echo $course_res->description; ?></textarea>
								<div class= "wiziq_limit"><?php _e('You can enter upto 1000 characters.','wiziq');?></div>
							</td>
						</tr>
					</table>
					<input type = "hidden" name= "course_id" value = "<?php echo $_GET['course_id']; ?>"  />
					<input type="submit" name="wiziq_editfront_course" id="wiziq_add_course" value = "<?php _e('Update', 'wiziq'); ?>" />
					<input type="submit" name="wiziq_editfront_course_cancel" id="wiziq_cancel_course" value = "<?php _e('Cancel', 'wiziq'); ?>" />					
			</form>
		</div>
	</div>
	<?php
	}// end course edit form function
		
		/*
		 * Function to display courses on front end to not logged users
		 * @since 1.0
		 */ 
		function wiziq_frontend_view_courses_not_logged () 
		{
			global $wpdb;
			//url structure
			$wiziq_classes = $wpdb->prefix."wiziq_wclasses";
			$courses_url = get_permalink();
			$wiziq_frontend_courses = new Wiziq_Frontend_Courses;
			$wiziq_courses = new Wiziq_Courses;
			$Wiziq_Util = new Wiziq_Util;
			
			//url structure
			$qvarsign = $Wiziq_Util->wiziq_frontend_url_structure();
			
			$courses_urls = $courses_url.$qvarsign.'action=courses';
			$add_curl = $courses_url.$qvarsign.'action=addcourse';
			$edit_curl = $courses_url.$qvarsign.'action=editcourse';
			$delete_curl = $courses_url.$qvarsign.'action=deletecourse';
			/*
			 * Sorting logic
			 */ 
			if ( ! isset ( $_GET['sort-by'] ) ) {
				$sortby = "id";
			} else {
				$sortby = $_GET['sort-by'];
			}
			if ( !isset ($_GET['order-by']) ) {
				$orderby = "desc";
			}else {
				$orderby = $_GET['order-by'];
			}	
			
			/*
			 * Pagination functionality 
			 */ 
			$wiziq_courses = $wpdb->prefix."wiziq_courses";
			$courses = $wpdb->get_results( "select * from $wiziq_courses" ); 
			$total_pages = !empty($courses)?count($courses):0 ;
			$limit = WIZIQ_PAGINATION_LIMIT;
			$adjacents = 3;
			$page = isset($_GET['pageno'])?$_GET['pageno']:'';
			if($page) 
				$start = ($page - 1) * $limit; 			//first item to display on this page
			else
				$start = 0;								//if no page var is given, set start to 0
			$targetpage = "";
			$homepage = get_permalink().$qvarsign;
			$targetpage .= get_permalink().$qvarsign;
			if ( isset ($_GET['sort-by']) && isset ($_GET['order-by']) ) {
				$targetpage .= 'sort-by='.$sortby.'&order-by='.$orderby.'&';
			}
			$pagination =  $Wiziq_Util->custom_pagination($page,$total_pages,$limit,$adjacents,$targetpage);
			
			
			$wiziq_courses = $wpdb->prefix."wiziq_courses";
			if ( $sortby == 'fullname' || $sortby ==  'id' ) {
				$wiziq_course_res = $wpdb->get_results( "select * from $wiziq_courses order by $sortby $orderby LIMIT $start ,$limit" );
			} elseif ( $sortby == 'count' ) {
				$wiziq_course_res = $wpdb->get_results("SELECT a.*,count(b.id) cls FROM $wiziq_courses a left join $wiziq_classes b on b.courseid=a.id group by a.id order by cls $orderby LIMIT $start ,$limit");
			} elseif ( $sortby == 'uname' ) {
				$users = $wpdb->prefix."users";
				$usersmeta = $wpdb->prefix."usermeta";
				$name_query = "SELECT
								c.*,
								if ( m1.meta_value = '', u1.display_name, CONCAT(m1.meta_value,' ',m2.meta_value)) as name
								FROM $wiziq_courses c
								JOIN $users u1 ON (c.created_by = u1.id )
								JOIN $usersmeta m1 ON (m1.user_id = u1.id AND m1.meta_key = 'first_name')
								JOIN $usersmeta m2 ON (m2.user_id = u1.id AND m2.meta_key = 'last_name') order by name $orderby LIMIT $start ,$limit
							";
				//$wiziq_course_result = $wpdb->get_results("SELECT a.*,count(b.id) cls FROM $wiziq_courses a left join $wiziq_classes b on b.courseid=a.id group by a.id order by name $orderby LIMIT $start ,$limit");
				$wiziq_course_res = $wpdb->get_results( $name_query);
			}
				/***** Sorting functionality *****/ 
			 if ( isset ( $_GET['sort-by'] ) && $_GET [ 'order-by']  ) :
			 
			 
					if ( "fullname" == $_GET['sort-by'] ) :
					
						if ( "asc" == $_GET['order-by']) {
							$nameclass = "sorting-up";
							$ordering = "desc";
							$nametitle = __( 'Click to sort by descending order' ,'wiziq');
						} else {
							$nameclass = "sorting-down";
							$ordering = "asc";
							$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
						}
						$countclass = "sorting-up";
						$countordering = "asc";
						$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
						$usernameclass = "sorting-down";
						$usernameordering = "asc";
						$usernametitle = __( 'Click to sort by ascending order' ,'wiziq');
					elseif ( "count" == $_GET['sort-by'] )  :
						if ( "asc" == $_GET['order-by']) {
							$countclass = "sorting-up";
							$countordering = "desc";
							$counttitle = __( 'Click to sort by descending order' ,'wiziq');
						} else {
							$countclass = "sorting-down";
							$countordering = "asc";
							$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
						}
						$nameclass = "sorting-up";
						$ordering = "asc";
						$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
						$usernameclass = "sorting-down";
						$usernameordering = "asc";
						$usernametitle = __( 'Click to sort by ascending order' ,'wiziq');
						
					elseif ( "uname" == $_GET['sort-by'] )  :
						if ( "asc" == $_GET['order-by']) {
								$usernameclass = "sorting-up";
								$usernameordering = "desc";
								$usernametitle = __( 'Click to sort by descending order' ,'wiziq');
							} else {
								$usernameclass = "sorting-down";
								$usernameordering = "asc";
								$usernametitle = __( 'Click to sort by ascending order' ,'wiziq');
							}
							$nameclass = "sorting-up";
							$ordering = "asc";
							$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
							$countclass = "sorting-up";
							$countordering = "asc";
							$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
					endif;
			else :
				$countordering = "asc";
				$counttitle = __( 'Click to sort by ascending order' ,'wiziq');
				$nameclass = "sorting-up";
				$ordering = "asc";
				$nametitle = __( 'Click to sort by ascending order' ,'wiziq');
				$usernameclass = "sorting-down";
				$usernameordering = "asc";
				$usernametitle = __( 'Click to sort by ascending order' ,'wiziq'); 
			endif;
			?>
			<div class="front_wiziq notlogin" id="front_wiziq" >
			<div class="wiziq_left" >
			</div>
                      
        <?php	if(is_user_logged_in()) {  ?>                    
			<div class="wiziq_right" >
				<ul class = "wiziq_front_menu">
					<li>
						<h3>
							<a href="<?php echo $courses_url; ?>" ><?php _e('Courses', 'wiziq'); ?></a>
						</h3>
					</li>
				</ul>
				<div class="clearfix"></div>
				<h4><?php _e( 'Courses List' , 'wiziq' );?></h4>
				<table class="list_courses sortable" id="list_courses" >
						<tr>
							<th>
								<a href = "javascript:;<?php //echo $homepage.'sort-by=fullname&order-by='.$ordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Course Name','wiziq') ;?></span>
									<?php if (isset ( $_GET[ 'sort-by' ] ) && "fullname" == $_GET[ 'sort-by' ] ) : ?>
										<div class = "<?php echo $nameclass; ?>" ></div>
									<?php endif; ?>
								</a>
							</th>
							<th>
								<span><?php _e('Description','wiziq');?></span>
							</th>
							<th>
								<a href = "<?php echo $homepage.'sort-by=uname&order-by='.$usernameordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Created By','wiziq') ;?></span>
									<?php if (isset ( $_GET[ 'sort-by' ] ) && "uname" == $_GET[ 'sort-by' ]): ?>
										<div class = "<?php echo $usernameclass; ?>" ></div>
									<?php endif; ?>
								</a>
							</th>
							<th>
								<a href = "<?php echo $homepage.'sort-by=count&order-by='.$countordering; ?>" title = "<?php echo $nametitle; ?>" >
									<span><?php _e('Number of Classes','wiziq') ;?></span>
									<?php if (isset ( $_GET[ 'sort-by' ] ) && "count" == $_GET[ 'sort-by' ]): ?>
										<div class = "<?php echo $countclass; ?>" ></div>
									<?php endif; ?>
								</a>
							</th>
						</tr>
					<?php
					$courses = get_front_courses();
					if($courses){
						foreach($wiziq_course_res as $course){
							$course_detail = $courses_url.$qvarsign.'action=course_desc&course_id='.$course->id;
							$view_classes = $courses_url.$qvarsign.'caction=view_classes&course_id='.$course->id;
							$wiziq_classes = $wpdb->prefix."wiziq_wclasses";
							$classesqry = "select count(*) from $wiziq_classes where courseid = '$course->id'"; 
							$classesres = $wpdb->get_var($classesqry);
							echo '<tr>';
							echo '<td>';
							echo '<a href="'.$course_detail.'">';
							$coursename = $course->fullname;
							$courselen = strlen($coursename); 
							/* if ( $courselen > 10 )
								echo substr($coursename,0,10).'..';
							else 
								echo $course->fullname; */
                                                        echo $course->fullname;
							echo '</a>';
							echo '</td>';
							echo '<td>';
							//Display description upto 6 words and rest on hover
							echo '<div class = "al_down" >';
							$des = $course->description;
							$desc = $Wiziq_Util->shorten_string( $des , 6);
							echo $desc;
							echo '</td>';
							echo '<td>';
							$user_info = get_userdata( $course->created_by ); 
							echo $user_info->display_name;
							echo '</td>';
							echo '<td>';
							if ( $classesres ) {
								echo '<a href="'.$view_classes.'">';
								echo $classesres;
								echo '</a>';
							}
							else {
								echo '---';
							}
							echo '</td>'; 
							echo '</tr>';
						 } // end foreach
					} else {
						echo '<tr><td colspan="4">'.__('No course available','wiziq').'</td></tr>';
					} // else no course available
                                         echo '<tfoot>';
					echo '<tr>';
					echo '<th>';
					echo '<span>'.__('Course Name','wiziq').'</span>';
					echo '</th>';
					echo '<th>';
					echo '<span>'.__('Description','wiziq').'</span>';
					echo '</th>';
					echo '<th>';
					echo '<span>'.__('Created By','wiziq').'</span>';
					echo '</th>';
					echo '<th>';
					echo '<span>'.__('Number of Classes','wiziq').'</span>';
					echo '</th>';
					echo '</tr>';
					echo '</tfoot>';
                                        ?>
				</table>
				<!-- Display pagination -->
				<?php echo $pagination; ?>
				</div>
                            
                <?php }
                
                else{
                    ?>
                    
  				<div class="clearfix"></div>
				<h4><?php _e( 'Courses List' , 'wiziq' );?></h4>                  
                    
  <?php  _e('Please login to view courses ', 'wiziq');                
                    
                }
                ?>
                            
				<?php
		}//end view courses function
		
	} 
	
