<?php
/*
@package mod_wiziq
@copyright www.wiziq.com
@license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
*/
/*
This file is part of Wiziq - http://www.wiziq.com/
Moodle is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Moodle is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Moodle. If not, see <http://www.gnu.org/licenses/>.

*/
class wiziq_authBase
{
	private $secretAcessKey="";
	private $access_key="";
	public function __construct($secretAcessKey,$access_key)
	{
		$this->secretAcessKey=$secretAcessKey;
		$this->access_key=$access_key;
	}
function wiziq_generateTimeStamp()
{
	return time();
}

function wiziq_generateSignature($methodName,&$requestParameters) {
$signatureBase="";
$secretAcessKey = urlencode($this->secretAcessKey);
$requestParameters["access_key"] = $this->access_key;
$requestParameters["timestamp"] =$this->wiziq_generateTimeStamp();
$requestParameters["method"] = $methodName;

foreach ($requestParameters as $key => $value)
{
	if(strlen($signatureBase)>0)
	$signatureBase.="&";
	$signatureBase.="$key=$value";
}
//echo "<br>signatureBase=".$signatureBase;
return base64_encode($this->wiziq_hmacsha1($secretAcessKey, $signatureBase));
}

function wiziq_hmacsha1($key,$data) { 
    $blocksize=64;
    $hashfunc='sha1';
    if (strlen($key)>$blocksize)
        $key=pack('H*', $hashfunc($key));
    $key=str_pad($key,$blocksize,chr(0x00));
    $ipad=str_repeat(chr(0x36),$blocksize);
    $opad=str_repeat(chr(0x5c),$blocksize);
    $hmac = pack(
                'H*',$hashfunc(
                    ($key^$opad).pack(
                        'H*',$hashfunc(
                            ($key^$ipad).$data
                        )
                    )
                )
            );
    return $hmac;
}

}//end class AuthBase

class wiziq_httpRequest
{
		function wiziq_do_post_request($url, $data, $optional_headers = null)
		  {  
			$params = array('http' => array(
						  'method' => 'POST',
						  'content' => $data
					   ));
			if ($optional_headers !== null) 
			{
				$params['http']['header'] = $optional_headers;
			}
			if( ini_get('allow_url_fopen') ) {
			    	$ctx = stream_context_create($params);
			    	$fp = @fopen($url, 'rb', false, $ctx);
			    	if (!$fp) 
			{
				throw new Exception("Problem with $url, $php_errormsg");
			}
			$response = @stream_get_contents($fp);
			if ($response === false) 
			{
				throw new Exception("Problem reading data from $url, $php_errormsg");
			}
			
			} else {
			    
			$ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url );
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_VERBOSE, 1 );
            $response = curl_exec($ch);
            return $response;
            // close cURL resource, and free up system resources
            curl_close($ch);
		
		  
			if (!$response) 
			{
				throw new Exception("Problem with $url, $php_errormsg");
			}
			//$response = @stream_get_contents($fp);
			if ($response === false) 
			{
				throw new Exception("Problem reading data from $url, $php_errormsg");
			}
			}
			 
					 
			 return $response;
		  }
}//end class HttpRequest
