<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

if ( !function_exists( 'chld_thm_cfg_parent_css' ) ):
    function chld_thm_cfg_parent_css() {
        wp_enqueue_style( 'chld_thm_cfg_parent', trailingslashit( get_template_directory_uri() ) . 'style.css',array(), date("Y-m-d-h:i:s"), false);
    }
endif;
add_action( 'wp_enqueue_scripts', 'chld_thm_cfg_parent_css', 10 );

function twentysixteen_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Footer #3', 'twentysixteen' ),
		'id'            => 'sidebar-3',
		'description'   => __( 'Add widgets here to appear in your sidebar.', 'twentysixteen' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
    register_sidebar( array(
		'name'          => __( 'Footer #4', 'twentysixteen' ),
		'id'            => 'sidebar-4',
		'description'   => __( 'Add widgets here to appear in your sidebar.', 'twentysixteen' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	 register_sidebar( array(
		'name'          => __( 'Footer #5', 'twentysixteen' ),
		'id'            => 'sidebar-5',
		'description'   => __( 'Add widgets here to appear in your sidebar.', 'twentysixteen' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

  register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'twentysixteen' ),
		'id'            => 'sidebar-blog',
		'description'   => __( 'Add widgets here to appear in your sidebar.', 'twentysixteen' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'twentysixteen_widgets_init' );

// END ENQUEUE PARENT ACTION
function twentysixteen_scripts() {
	
	// enqueue style
  //  wp_enqueue_style('bootstrap-css', get_stylesheet_directory_uri() .'/css/bootstrap.css');
	wp_enqueue_style('bootstrap-min-css', get_stylesheet_directory_uri() .'/css/bootstrap.min.css', array(), date("Y-m-d-h:i:s"), false);
    wp_enqueue_style('slick-style', get_stylesheet_directory_uri() .'/css/slick.css');
    wp_enqueue_style('slick-theme', get_stylesheet_directory_uri() .'/css/slick-theme.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() .'/css/custom-style.css');
    wp_enqueue_style('aos-style', get_stylesheet_directory_uri() .'/css/aos.css');
	
	// enqueue script
 //   wp_enqueue_script('bootstrap-js', get_stylesheet_directory_uri() .'/js/bootstrap.js');
 wp_enqueue_script('custom-aos', get_stylesheet_directory_uri() .'/js/aos.js',array( 'jquery' ),false,true);

	wp_enqueue_script('bootstrap-min-js', get_stylesheet_directory_uri() .'/js/bootstrap.min.js', array(), date("Y-m-d-h:i:s"), true);
    wp_enqueue_script('slick-themes', get_stylesheet_directory_uri() .'/js/slick.js',array( 'jquery' ),false,true);
    wp_enqueue_script('custom-themes', get_stylesheet_directory_uri() .'/js/custom.js',array( 'jquery' ),false,true);
    wp_enqueue_script('datalayer', get_stylesheet_directory_uri() .'/js/datalayer.js',array( 'jquery' ),false,true);    
}
add_action('wp_enqueue_scripts', 'twentysixteen_scripts');

function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml'; 
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types'); 

if (function_exists('acf_add_options_page')) {
  acf_add_options_page();
}

function my_post_type_textimonial() {
register_post_type( 'testimonial',
array(
  'label' => __('Testimonial'),
  'singular_label' => __('testimonial', 'we'),
  '_builtin' => false,
  'public' => true,
  'show_ui' => true,
  'show_in_nav_menus' => true,
  'hierarchical' => true,
  'capability_type' => 'page',
  'rewrite' => array(
  'slug' => 'testimonial',
  'with_front' => FALSE,
  ),
    'supports' => array(
    'title',
    'editor',
    'thumbnail',
    'custom-fields'
    )
  )
);

register_taxonomy('testimonial_categories', 'testimonial', array('hierarchical' => true, 'label' => 'Testimonial Categories', 'singular_name' => 'testimonial-category', 'rewrite' => array( 'slug' => 'testimonial' ), "query_var" => true));
}

add_action('init', 'my_post_type_textimonial');


function my_post_type_packages() {
register_post_type( 'packages',
array(
  'label' => __('Packages'),
  'singular_label' => __('', 'we'),
  '_builtin' => false,
  'public' => true,
  'show_ui' => true,
  'show_in_nav_menus' => true,
  'hierarchical' => true,
  'capability_type' => 'page',
  'rewrite' => array(
  'slug' => 'packages',
  'with_front' => FALSE,
  ),
    'supports' => array(
    'title',
    'editor',
    'thumbnail',
    'custom-fields'
    )
  )
);

register_taxonomy('packages_categories', 'packages', array('hierarchical' => true, 'label' => 'Packages Categories', 'singular_name' => 'packages-category','show_admin_column'   => true,'rewrite' => array( 'slug' => 'packages' ), "query_var" => true));
}

add_action('init', 'my_post_type_packages');



/*-------------------- Load More Post --------------------*/


/*
 * Set post views count using post meta
 */




function count_post_visits() {
  if( is_single() ) {
     global $post;
     $views = get_post_meta( $post->ID, 'my_post_viewed', true );
     if( $views == '' ) {
        update_post_meta( $post->ID, 'my_post_viewed', '1' );   
     } else {
        $views_no = intval( $views );
        update_post_meta( $post->ID, 'my_post_viewed', ++$views_no );
     }
  }
}
add_action( 'wp_head', 'count_post_visits' );


$slug = $instance['id']; // not sure on this?
$post = get_page_by_path($slug,OBJECT,'cat_image');

if (!$post) {
    // create fresh post from widget instance data
    $args = array('post_type' => 'cat_image'); // ...and all the rest
    $post = wp_insert_post($args);
}

// $thumbnail_id = get_post_meta( $post->ID, '_thumbnail_id', true );  
// $postthumbnailhtml = _wp_post_thumbnail_html( $thumbnail_id, $post->ID );

function shapeSpace_display_search_form() {
	$search_form = '<form method="get" id="search-form-alt" action="'. esc_url(home_url('/')) .'">
		<input type="text" name="s" id="s" placeholder="Search..">
	</form>';
	return $search_form;
}
add_shortcode('display_search_form', 'shapeSpace_display_search_form');
if (class_exists('WooCommerce')) {
  function woocommerce_support()
  {
    add_theme_support('woocommerce');
  }
  add_action('after_setup_theme', 'woocommerce_support');
}
// custom add to cart button
function woo_custom_product_add_to_cart_text()
{
  return __('Buy Now', 'woocommerce');
}
add_filter('add_to_cart_text', 'woo_custom_product_add_to_cart_text');
add_filter('woocommerce_product_add_to_cart_text', 'woo_custom_product_add_to_cart_text');
// custom description of products
function excerpt_in_product_archives()
{
  the_excerpt();
}
add_action('woocommerce_after_shop_loop_item_title', 'excerpt_in_product_archives', 40);
//Hiding the Short Description on the Product Page
function remove_short_desc_product()
{
  remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
  add_action('woocommerce_single_product_summary', 'the_content', 20);
}
add_action('init', 'remove_short_desc_product');

//This will remove the short description from the top of the product page and replace it with the long description. 
function remove_product_long_desc($tabs)
{
  unset($tabs['description']);
  return $tabs;
}
add_filter('woocommerce_product_tabs', 'remove_product_long_desc', 98);
//remove default sorting dropdown 
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
//remove showing x result
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
//Woocommerce: change user role after completing order
function wpa_120656_convert_paying_customer($order_id)
{
  $order = new WC_Order($order_id);
  if ($order->user_id > 0) {
    update_user_meta($order->user_id, 'paying_customer', 1);
    $user = new WP_User($order->user_id);
    // Remove role
    $user->remove_role('customer');
    // Add role
    $user->add_role('subscriber');
  }
}
add_action('woocommerce_order_status_completed', 'wpa_120656_convert_paying_customer');
// make checkbox instead of quantity input in all products under the grouped product and enable only singl product in cart
function custom_remove_all_quantity_fields($return, $product)
{
  return true;
}
add_filter('woocommerce_is_sold_individually', 'custom_remove_all_quantity_fields', 10, 2);

// Remove image from product pages
 remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20);


 // This fn Automatically set the WooCommerce order status as Completed based on payment method
 add_action('woocommerce_order_status_changed', 'auto_complete_by_payment_method');
 function auto_complete_by_payment_method($order_id)
 {
   
   if ( ! $order_id ) {
         return;
   }
   global $product;
   $order = wc_get_order( $order_id );
   
   if ($order->data['status'] == 'processing') {
         $payment_method=$order->get_payment_method();
         if ($payment_method!="cod")
         {
             $order->update_status( 'completed' );
         }
       
   }
   
 }

 //  it will remove the product links from your cart page
 add_filter('woocommerce_cart_item_permalink','__return_false');



// removes the previous product and adds the new one with the new product configuration.
 add_filter ( 'woocommerce_before_cart' , 'allow_single_quantity_in_cart' );
    function allow_single_quantity_in_cart() {
            global $woocommerce;

            $cart_contents  =  $woocommerce->cart->get_cart();
            $keys           =  array_keys ( $cart_contents );

            foreach ( $keys as $key ) {
                    $woocommerce->cart->set_quantity ( $key, 1, true );
            }
    }

//remove downloads from menu in my-account page
    function custom_my_account_menu_items( $items ) {
      unset($items['downloads']);
      return $items;
  }
  add_filter( 'woocommerce_account_menu_items', 'custom_my_account_menu_items' );

// Remove related products output
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );



    //First hook that adds the menu item to my-account WooCommerce menu 

function example_forum_link( $menu_links ){
 
	// we will hook "womanide-forum" later
	$new = array( 'course-wiziq' => 'My Courses' );
 
	// or in case you need 2 links
	// $new = array( 'link1' => 'Link 1', 'link2' => 'Link 2' );
 
	// array_slice() is good when you want to add an element between the other ones
	$menu_links = array_slice( $menu_links, 0, 1, true ) 
	+ $new 
	+ array_slice( $menu_links, 1, NULL, true );
 
 
	return $menu_links;
 
 
}
add_filter ( 'woocommerce_account_menu_items', 'example_forum_link' );


// Second Filter to Redirect the WooCommerce endpoint to custom URL
function forum_example_hook_endpoint( $url, $endpoint, $value, $permalink ){
 
	if( $endpoint === 'course-wiziq' ) {
	   
		// This is where you add the custom URL, it could be external like, in this case, we need to go to my profile on the bbpress froum
		// I will use this function (bp_core_get_username( bp_loggedin_user_id() );) to get my profile user id and add it to the URL as shown below 
		
		// $url =  do_shortcode('[site_url]'.'[WizIQ]');
    $url = 
    $url = do_shortcode('[WizIQ]');
 
	}
	return $url;
 
}


/* Place a cart icon with number of items and total cost in the menu bar.*/
add_filter('wp_nav_menu_items','sk_wcmenucart', 10, 2);
function sk_wcmenucart($menu, $args) {

	// Check if WooCommerce is active and add a new item to a menu assigned to Primary Navigation Menu location
	if ( !in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) || 'primary' !== $args->theme_location )
		return $menu;

	ob_start();
		global $woocommerce;
		$viewing_cart = __('View your shopping cart', 'your-theme-slug');
		$start_shopping = __('Start shopping', 'your-theme-slug');
		$cart_url = $woocommerce->cart->get_cart_url();
		$shop_page_url = get_permalink( woocommerce_get_page_id( 'shop' ) );
		$cart_contents_count = $woocommerce->cart->cart_contents_count;
	$cart_contents = sprintf(_n('%d ', '%d ', $cart_contents_count, 'your-theme-slug'), $cart_contents_count); 
  
		$cart_total = $woocommerce->cart->get_cart_total();
		// Uncomment the line below to hide nav menu cart item when there are no items in the cart
		// if ( $cart_contents_count > 0 ) {
			if ($cart_contents_count == 0) {
				$menu_item = '<li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-989 right"><a class="wcmenucart-contents" href="'. $cart_url.'" title="'. $start_shopping .'">';
			} else {
				$menu_item = '<li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-990 right"><a class="wcmenucart-contents" href="'. $cart_url .'" title="'. $viewing_cart .'">';
			}
      $menu_item .= '<img src="/wp-content/uploads/2021/08/Icon-shopping-basket.svg">';
			// $menu_item .= $cart_contents.' - '. $cart_total;
      $menu_item .= '<span>' . $cart_contents .'</span>' ;
			$menu_item .= '</a></li>';
    
		// Uncomment the line below to hide nav menu cart item when there are no items in the cart
		// }
		echo $menu_item;
	$social = ob_get_clean();
	return $menu . $social;

}



//add category name in cart page

add_filter( 'woocommerce_cart_item_name', 'bbloomer_cart_item_category', 9999, 3 );
 
function bbloomer_cart_item_category( $name, $cart_item, $cart_item_key ) {
 
   $product = $cart_item['data'];
   if ( $product->is_type( 'variation' ) ) {
      $product = wc_get_product( $product->get_parent_id() );
   }
 
   $cat_ids = $product->get_category_ids();
 
   if ( $cat_ids ) $name .= '<br>' . wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . ' ', '</span>' );
 
   return $name;
 
}


// name chnage ..my account when user login and login by default name in navbar menu

add_filter( 'wp_nav_menu_items', 'wti_loginout_menu_link', 10, 2 );
function wti_loginout_menu_link( $items, $args ) {
   if ($args->theme_location == 'primary') {
      if (is_user_logged_in()) {
        $items .= '<li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-991 right"><a href="'. site_url() .'/my-account/">'. __("My Account") .'</a></li>';
      } else {
         $items .= '<li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-992 right"><a href="'. site_url() .'/my-account/">'. __("Log In") .'</a></li>';
      }
   }
   return $items;
}




// Display order items product categories (Orders on front end and emails)
add_action( 'woocommerce_order_item_meta_end', 'display_custom_data_in_emails', 10, 4 );
function display_custom_data_in_emails( $item_id, $item, $order, $bool ) {
    // Get the product categories for this item
    $terms = wp_get_post_terms( $item->get_product_id(), 'product_cat', array( 'fields' => 'names' ) );

    // Output a coma separated string of product category names
    echo "<br><small>" . implode(', ', $terms) . "</small>";
}

// Display order items product categories in admin order edit pages
add_action( 'woocommerce_after_order_itemmeta', 'custom_admin_order_itemmeta', 15, 3 );
function custom_admin_order_itemmeta( $item_id, $item, $product ){
    //if( ! is_admin() ) return; // only backend

    // Target order "line items" only to avoid errors
    if( $item->is_type( 'line_item' ) ){
        // Get the product categories for this item
        $terms = wp_get_post_terms( $item->get_product_id(), 'product_cat', array( 'fields' => 'names' ) );

        // Output a coma separated string of product category names
        echo "<br><small>" . implode(', ', $terms) . "</small>";
    }
}


function vasco_five_most_recent_years ($values, $options, $args) {

  if ( in_array('year', $options) ){

       $year = [];
       $i = 0;

       for( $i = 0; $i < 5; $i++){ // Get 4 most recent years after current year

            $year[] = (int) date("Y") + $i;
        }

        return $year ;
  }

 return $values;
}

add_filter('wpcf7_form_tag_data_option', 'vasco_five_most_recent_years', 10, 3);


// //add column in my account order page and get product woocommemrce
if( !(current_user_can( 'administrator' ) || current_user_can('editor')|| current_user_can('author') || current_user_can('contributor')) ){
add_filter( 'woocommerce_account_orders_columns', 'add_account_orders_column', 10, 1 );
function add_account_orders_column( $columns ){
    $reordered_columns = array();
    // Inserting columns to a specific location
    foreach( $columns as $key => $column){
        $reordered_columns[$key] = $column;
        if( $key ==  'order-total' ){
            // Inserting after "Status" column
              $reordered_columns['custom-column'] = __( 'Hours', 'woocommerce' );
              
    }
  
}
return $reordered_columns;
 
}
   add_action( 'woocommerce_my_account_my_orders_column_custom-column', 'add_account_orders_column_rows' );
function add_account_orders_column_rows( $order) {
        $ordered_items = $order->get_items();
        $i=0;
foreach ( $ordered_items as $item ) {
    $product = $order->get_product_from_item( $item );
    if($i>0 ){   
       print_r( (','. $product->get_attributes()['hours']['options'][0])) ;     
    }else {
      print_r( ( $product->get_attributes()['hours']['options'][0])) ;  
    }
    $i++;
    }

}
}



//  //First hook that adds the menu item to my-account WooCommerce menu 

 function example_forum_linkk( $menu_links ){
	$new = array( 'classes-calendar' => 'Classes Calender' );
	$menu_links = array_slice( $menu_links, 0, 1, true ) 
	+ $new 
	+ array_slice( $menu_links, 1, NULL, true );
 
 
	return $menu_links;
 
 
}
add_filter ( 'woocommerce_account_menu_items', 'example_forum_linkk' );


// Second Filter to Redirect the WooCommerce endpoint to custom URL
function forum_example_hook_endpointt( $url, $endpoint, $value, $permalink ){
	if( $endpoint === 'classes-calendar' ) {
    $url = do_shortcode('[site_url]');
	}
	return $url; 
}
add_filter ( 'woocommerce_account_menu_itemss', 'forum_example_hook_endpointt' );