<?php
/**
 * Header file for the Twenty Twenty WordPress default theme.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since Twenty Twenty 1.0
 */

?>
<!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
	<!-- Google Tag Manager -->
	<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
	new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
	j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
	'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
	})(window,document,'script','dataLayer','GTM-TW93DFM');</script>
	<!-- End Google Tag Manager -->
</head>

<body <?php body_class(); ?>>
	<!-- Google Tag Manager (noscript) -->
	<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TW93DFM"
	height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<!-- End Google Tag Manager (noscript) -->
	<?php
		wp_body_open();
		?>
	<header id="site-header" class="header-footer-group" role="banner">
		<div class="top-bar">
			<div class="container-topbar">
				<div class="row">
					<div class="col-sm-8">
						<?php if (!empty(get_field('top_bar_number','option'))) { ?>
						<div class="contact-number-topbar topbar-info">
							<div class="info-icon">
								<?php $number_icon = get_field('number_icon','option');
											if( !empty( $number_icon ) ){ ?>
								<img src="<?php echo esc_url($number_icon['url']); ?>"
									alt="<?php echo esc_attr($number_icon['alt']); ?>" />
								<?php } ?><a
								href="tel:<?php echo get_field('top_bar_number','option');?>">
								<?php echo get_field('top_bar_number','option');?></a>
							</div>
						</div>
						<?php } ?>
						<?php if (!empty(get_field('top_bar_email','option'))) { ?>
						<div class="emailid-topbar topbar-info">
							<div class="info-icon">
								
								<?php $email_icon = get_field('email_icon','option');
											if( !empty( $email_icon ) ){ ?>
								<img src="<?php echo esc_url($email_icon['url']); ?>"
									alt="<?php echo esc_attr($email_icon['alt']); ?>" />
								<?php } ?><a
								href="mailto:<?php echo get_field('top_bar_email','option');?>"><?php echo get_field('top_bar_email','option');?></a>
							</div>
						</div>
						<?php } ?>
					</div>
					<div class="col-sm-4">
						<div class="social">
							<?php if( have_rows('social_icons', 'option') ): ?>
							<ul>
								<?php while( have_rows('social_icons', 'option') ): the_row(); ?>
								<li> <?php $social_icon = get_sub_field('social_icon','option');

											$social_link = get_sub_field('social_link', 'option');
											if( $social_link ): 
												$social_link_url = $social_link['url'];
												$social_link_title = $social_link['title'];
												$social_link_target = $social_link['target'] ? $social_link['target'] : '_self';
												?>
									<a href="<?php echo esc_url( $social_link_url ); ?>"
										target="<?php echo esc_attr( $social_link_target ); ?>"><?php if( !empty( $social_icon ) ){ ?>
										<img src="<?php echo esc_url($social_icon['url']); ?>"
											alt="<?php echo esc_attr($social_icon['alt']); ?>" />
										<?php } ?></a>
									<?php endif; ?>
								</li>
								<?php endwhile; ?>
							</ul>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="header-inner section-inner">

			<div class="header-titles-wrapper">

				<?php

					// Check whether the header search is activated in the customizer.
					$enable_header_search = get_theme_mod( 'enable_header_search', true );

					if ( true === $enable_header_search ) {

						?>

				<button class="toggle search-toggle mobile-search-toggle" data-toggle-target=".search-modal"
					data-toggle-body-class="showing-search-modal" data-set-focus=".search-modal .search-field"
					aria-expanded="false">
					<span class="toggle-inner">
						<span class="toggle-icon">
							<?php twentytwenty_the_theme_svg( 'search' ); ?>
						</span>
						<span class="toggle-text"><?php _ex( 'Search', 'toggle text', 'twentytwenty' ); ?></span>
					</span>
				</button><!-- .search-toggle -->

				<?php } ?>

				<div class="header-titles">

					<?php
							// Site title or logo.
							twentytwenty_site_logo();

							// Site description.
							twentytwenty_site_description();
						?>

				</div><!-- .header-titles -->

				<button class="toggle nav-toggle mobile-nav-toggle" data-toggle-target=".menu-modal"
					data-toggle-body-class="showing-menu-modal" aria-expanded="false"
					data-set-focus=".close-nav-toggle">
					<span class="toggle-inner">
						<span class="toggle-icon">
							<?php twentytwenty_the_theme_svg( 'ellipsis' ); ?>
						</span>
						<span class="toggle-text"><?php _e( 'Menu', 'twentytwenty' ); ?></span>
						
					</span>
				</button><!-- .nav-toggle -->

			</div><!-- .header-titles-wrapper -->

			<div class="header-navigation-wrapper">

				<?php
					if ( has_nav_menu( 'primary' ) || ! has_nav_menu( 'expanded' ) ) {
						?>

				<nav class="primary-menu-wrapper"
					aria-label="<?php echo esc_attr_x( 'Horizontal', 'menu', 'twentytwenty' ); ?>" role="navigation">

					<ul class="primary-menu reset-list-style">

						<?php
								if ( has_nav_menu( 'primary' ) ) {

									wp_nav_menu(
										array(
											'container'  => '',
											'items_wrap' => '%3$s',
											'theme_location' => 'primary',
										)
									);

								} elseif ( ! has_nav_menu( 'expanded' ) ) {

									wp_list_pages(
										array(
											'match_menu_classes' => true,
											'show_sub_menu_icons' => true,
											'title_li' => false,
											'walker'   => new TwentyTwenty_Walker_Page(),
										)
									);

								}
								?>

					</ul>

				</nav><!-- .primary-menu-wrapper -->

				<?php
					}

					if ( true === $enable_header_search || has_nav_menu( 'expanded' ) ) {
						?>

				<div class="header-toggles hide-no-js">

					<?php
						if ( has_nav_menu( 'expanded' ) ) {
							?>

					<div class="toggle-wrapper nav-toggle-wrapper has-expanded-menu">

						<button class="toggle nav-toggle desktop-nav-toggle" data-toggle-target=".menu-modal"
							data-toggle-body-class="showing-menu-modal" aria-expanded="false"
							data-set-focus=".close-nav-toggle">
							<span class="toggle-inner">
								<span class="toggle-text"><?php _e( 'Menu', 'twentytwenty' ); ?></span>
								<span class="toggle-icon">
									<?php twentytwenty_the_theme_svg( 'ellipsis' ); ?>
								</span>
							</span>
						</button><!-- .nav-toggle -->

					</div><!-- .nav-toggle-wrapper -->

					<?php
						}

						if ( true === $enable_header_search ) {
							?>

					<div class="toggle-wrapper search-toggle-wrapper">

						<button class="toggle search-toggle desktop-search-toggle" data-toggle-target=".search-modal"
							data-toggle-body-class="showing-search-modal" data-set-focus=".search-modal .search-field"
							aria-expanded="false">
							<span class="toggle-inner">
								<?php twentytwenty_the_theme_svg( 'search' ); ?>
								<span
									class="toggle-text"><?php _ex( 'Search', 'toggle text', 'twentytwenty' ); ?></span>
							</span>
						</button><!-- .search-toggle -->

					</div>

					<?php
						}
						?>

				</div><!-- .header-toggles -->
				<?php
					}
					?>

			</div><!-- .header-navigation-wrapper -->

		</div><!-- .header-inner -->

		<?php
			// Output the search modal (if it is activated in the customizer).
			if ( true === $enable_header_search ) {
				get_template_part( 'template-parts/modal-search' );
			}
			?>

	</header><!-- #site-header -->
	<div class="content-box">
		<?php
		// Output the menu modal.
		get_template_part( 'template-parts/modal-menu' );