<?php
/**
 * The template for displaying single posts and pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since Twenty Twenty 1.0
 */

get_header();

?>
<section class="page-banner">
	<div class="banner-middle">
		<div class="row">
			<div class="col-sm-12">
				<?php $banner_image = get_field('single_blog_page_banner_image', 'option');
              	if( !empty( $banner_image ) ){ ?>
				<img src="<?php echo esc_url($banner_image['url']); ?>"
					alt="<?php echo esc_attr($banner_image['alt']); ?>" />
				<?php } ?>
				<?php if (!empty(get_field('single_blog_page_banner_title', 'option'))) { ?>
				<h1 class="page-title">
					<?php echo get_field('single_blog_page_banner_title', 'option');?></h1>
				<?php } ?>
			</div>
		</div>
	</div>
</section>
<section class="blog-content">
	<div class="container">
		<div class="row">
			<div class="col-sm-9">
				<div class="single-box">
					<?php
				$brd_color = get_field('border_color',$featured_post->ID);?>
					<hr class="<?php echo $brd_color; ?>"><?php 
				if ( ! post_password_required() && ! is_attachment() ) {
					the_post_thumbnail();
				} ?>
				</div>
				<h2 class="post-title"><?php the_title(); ?></h2>
				<h5><?php the_category(); ?><div class="post-date">-
						<?php echo get_the_time("F d, Y", $featured_post->ID); ?></div>
				</h5>
				<div class="blog-desc">
					<?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'twentytwelve' ) ); ?>
				</div><!-- .entry-content -->
			</div>
			<div class="col-sm-3">
				<label>Search</label>
				<div class="search-box">
					<form role="search" method="get" id="searchform" class="searchform"
						action="<?php echo esc_url( home_url( '/' ) ); ?>">
						<div>
							<input type="text" placeholder="Search" value="<?php echo get_search_query(); ?>" name="term"
								id="term" />
							<div class="submit-btn"><input type="submit" id="searchsubmit"
									value="<?php echo esc_attr_x( 'Search', 'submit button' ); ?>" /></div>
						</div>
					</form>
				</div>
				
				<ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
					<li class="nav-item">
						<a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#recent-post" role="tab"
							aria-controls="pills-home" aria-selected="true">Recent</a>
					</li>
					<li class="nav-item">
						<a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#popular-post" role="tab"
							aria-controls="pills-profile" aria-selected="false">Popular Posts</a>
					</li>
				</ul>
				<div class="tab-content" id="pills-tabContent">
					<div class="tab-pane fade show active" id="recent-post" role="tabpanel"
						aria-labelledby="pills-home-tab">
						<?php                              
						$wp_query = new WP_Query();
						$wp_query->query(array("post_type"=>"post","posts_per_page" =>3,'orderby' => 'date','order' => 'DESC')); ?>
						<?php while(have_posts()) : the_post() ;?>
						<!--slider first start-->
						<div class="row">
							<div class="col-sm-5">
								<?php if (has_post_thumbnail( $post->ID ) ){ ?>
								<?php $image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
								<img src='<?php echo $image_url[0]; ?>' alt="<?php the_title(); ?>"/>
								<?php } ?>
							</div>
							<div class="col-sm-7">
								<h3><?php the_title(); ?></h3>
								<span><?php echo get_the_time("F d, Y", $featured_post->ID); ?></span>
								<a href="<?php the_permalink(); ?>">+Read More</a>
							</div>
						</div>
						<?php 
						endwhile;
						wp_reset_query(); ?>
					</div>
					<div class="tab-pane fade" id="popular-post" role="tabpanel" aria-labelledby="pills-profile-tab">
						<?php 
							$popular_posts_args = array(
							'posts_per_page' => 3,
							'meta_key' => 'my_post_viewed',
							'orderby' => 'meta_value_num',
							'order'=> 'DESC'
							);
							$popular_posts_loop = new WP_Query( $popular_posts_args );
							while( $popular_posts_loop->have_posts() ):
							$popular_posts_loop->the_post(); ?>
						<div class="row">
							<div class="col-sm-5">
								<?php if (has_post_thumbnail( $post->ID ) ){ ?>
								<?php $image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
								<img src='<?php echo $image_url[0]; ?>' alt="popular-<?php the_title(); ?>"/>
								<?php } ?>
							</div>
							<div class="col-sm-7">
								<h3><?php the_title(); ?></h3>
								<span><?php echo get_the_time("F d, Y", $featured_post->ID); ?></span>
								<a href="<?php the_permalink(); ?>">+Read More</a>
							</div>
						</div>
						<?php endwhile;
							wp_reset_query(); 
							?>
					</div>
				</div>
				<div class="all-cat">
					<h2>Categories</h2>
					<?php 
						global $cat;
						$categoriasFilhas = get_categories('parent=' . $cat); ?>
					<ul><?php 
						foreach($categoriasFilhas as $category) {
						echo '<li><a href="' . get_category_link( $category->term_id ) . '" >' . $category->name.'</a></li>';
						}
						$the_query = get_posts( array( 
							'category_name' => $category->name,
						) );
						?>
					</ul>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="subscribe">
	<div class="container">
		<?php if (!empty(get_field('newsletter_title', 'option'))) { ?>
		<h2 class="newsletter-title">
		<?php echo get_field('newsletter_title', 'option');?></h1>
		<?php } ?>
		<script charset="utf-8" type="text/javascript" src="//js.hsforms.net/forms/shell.js"></script>
		<script>
			hbspt.forms.create({
				region: "na1",
				portalId: "20218807",
				formId: "930f9742-6edb-4c61-9d0a-b5f9f09c3615"
			});
		</script>
	</div>
</section>
<?php get_footer(); ?>