<?php 

/* Template Name: About */

get_header();
$get_page_ID = get_the_ID();
 $field_color=get_sub_field('percentage_color');
 get_template_part( 'template-parts/page-banner', 'page' ); 
 ?>
<section class="founder-section" data-aos="fade-down-right">
  <div class="container">
    <?php if( have_rows('founder_details') ){ ?>
    <div class="row">
      <?php while( have_rows('founder_details') ): the_row(); ?>
      <div class="col-md-6" data-aos="flip-up">
        <div class="founder-box">
          <?php if (!empty(get_sub_field('founder_name',$get_page_ID))) { ?>
          <h3><?php echo get_sub_field('founder_name',$get_page_ID);?></h1>
            <?php } 
            if (!empty(get_sub_field('founder_position',$get_page_ID))) { ?>
            <h5><?php echo get_sub_field('founder_position',$get_page_ID);?></h5>
            <?php }
            if (!empty(get_sub_field('founder_subtitle',$get_page_ID))) { ?>
            <h6><?php echo get_sub_field('founder_subtitle',$get_page_ID);?></h6>
            <?php }
            if (!empty(get_sub_field('founder_description',$get_page_ID))) { ?>
            <p><?php echo get_sub_field('founder_description',$get_page_ID);?></p>
            <?php } ?>
        </div>
      </div>
      <?php endwhile; ?>
    </div>
    <?php } ?>
  </div>
</section>
<section class="steps-details" data-aos="fade-down-left">
  <div class="personalize-box prep-personalize-box">
    <div class="about-coastline">
      <div class="steps-bg green">
        <div class="container">
          <div class="row">
            <div class="col-md-6">
              <h1 class="About" data-aos="slide-right"><?php  echo get_field('about_coastline_heading'); ?></h1>
              <p class="prep-para" data-aos="slide-left"><?php echo get_field('about_Coastline_paragraphs'); ?></p>
            </div>
            <div class="col-md-6">
              <div class="personalize-learning prep-img">
                <?php 
                  $image = get_field('about_Coastline_images');
                  if( !empty( $image ) ){ ?>
                    <img src="<?php echo esc_url($image['url']); ?>" alt="<?php  echo get_field('about_coastline_heading'); ?>" data-aos="slide-right"/>
                  <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="student-areas" data-aos="fade-down-left">
  <div class="why-choose-us">
    <div class="container">
      <div class="col-md-12">
        <div class="student-section-blk">
          <h2 class="student-area-heading" data-aos="slide-right"><?php  echo get_field('why_choose_us'); ?></h2>
          <p class="student-area-description" data-aos="slide-left"></p>
        </div>
        <div class="row">
          <?php
            if( have_rows('why_choose_us_section') ) {
              while(have_rows('why_choose_us_section'))
              {
               the_row();
               ?>
              <div class="col-md-1" data-aos="slide-right">
                <div class="image">
                  <img src="<?php echo get_sub_field('why_choose_image');?>" class="img-fluid" alt="<?php the_sub_field('why_choose_text'); ?>">
                </div>
              </div>
              <div class="col-md-3" data-aos="slide-left">
                <ul class="critical_areas">
                  <li style="border-color:<?php the_sub_field('border-color'); ?>" ;>
                    <?php the_sub_field('why_choose_text'); ?></li>
                </ul>
              </div>
          <?php } } ?>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="steps-details" data-aos="fade-down-left">
  <div class="personalize-box prep-personalize-box">
    <div class="steps-bgs green">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <h1 class="About" data-aos="slide-right"><?php echo get_field('our_focus'); ?></h1>
            <p class="prep-para"  data-aos="slide-left"><?php echo get_field('our_focus_para'); ?></p>
          </div>
        </div>
      </div>
      <div class="container xcv">
        <div class="row">
          <div class="col-md-7 mt-3">
            <div class="personalize-learning focus-img">
              <?php 
                $image = get_field('our_focus_image');
                  if( !empty( $image ) ){ ?>
                    <img src="<?php echo esc_url($image['url']); ?>" data-aos="slide-right" />
              <?php } ?>
            </div>
          </div>
          <div class="col-md-5 mt-3" data-aos="slide-left">
            <div class="subject-progressbar">
              <ul class="subject-progressbar-list" data-aos="slide-right">
                <?php
                  if( have_rows('subject_progressbar') ) {
                    while(have_rows('subject_progressbar'))
                    {
                    the_row();
                    ?>
                      <div class="first">
                        <p style="color:<?php echo get_sub_field('percentage_color'); ?>; ">
                          <?php echo get_sub_field('subject');?> </p>
                        <li>
                          <div class="progress" style="height: 20px;">

                            <div class="progress-bar "
                              style="width:<?php echo get_sub_field('width'); ?>;background-color:<?php echo get_sub_field('percentage_color'); ?>;">
                            </div>
                        </li>
                      </div>
              <?php } } ?>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="subscribe" data-aos="fade-down-left">
  <div class="container">
    <?php if (!empty(get_field('newsletter_title', 'option'))) { ?>
    <h2 class="newsletter-title" data-aos="slide-left">
      <?php echo get_field('newsletter_title', 'option');?></h1>
      <?php } ?>
      <script charset="utf-8" type="text/javascript" src="//js.hsforms.net/forms/shell.js"></script>
      <script>
        hbspt.forms.create({
          region: "na1",
          portalId: "20218807",
          formId: "930f9742-6edb-4c61-9d0a-b5f9f09c3615"
        });
      </script>
  </div>
</section>
<?php  get_footer (); ?>