<?php
/**
 * Template Name: Academic Page Template
 */

get_header();
$get_page_ID = get_the_ID();
?>
<?php get_template_part( 'template-parts/page-banner', 'page' ); 
?>
<section class="Academic-packages-section" >
  <div class="container">
    <div class="row">
      <div class="col-sm-12">
        <div class="packages-block">
          <div class="packages-detail">
            <h2 class="mt-5" data-aos="fade-bottom">Academic & AP Exam Packages</h2>
            <ul class="packages-type row">
              <?php 
                  $args = array(  
                      'post_type' => 'packages', 
                      'posts_per_page' => -1, 
                      'order'     => 'ASC',
                      'tax_query' => array(
                          array(
                              'taxonomy' => 'packages_categories',
                              'field'    => 'slug', // search by slug name, you may change to use ID
                              'terms'    => 'ap-exam-packages', // value of the slug for taxonomy, in term using ID, you should using integer type casting (int) $value
                          ),
                      )
                  );
                  $new_query = new WP_Query($args);
                  if($new_query->have_posts()) : while ($new_query->have_posts()) : $new_query->the_post(); ?>
                    <li class="col list-btn" >
                      <div class="list-spacing">
                        <?php $field_color = get_field('border_color'); ?>
                        <hr class="<?php echo $field_color; ?>" />
                        <?php 
                          $buttun_text = get_field( "buttun_text" );
                          $package_description = get_field( "package_description" );
                          $price_package = get_field( "price_package" );
                          $price_sub_text = get_field( "price_sub_text" );
                          $hourly_text = get_field( "hourly_text" );
                          
                          if( !empty($buttun_text) ) { ?>
                                  <div class="package-link"><?php echo $buttun_text; ?></div>
                                  <?php } 
                          if( !empty($package_description) ) { ?>
                                  <p><?php echo $package_description;?></p>
                                  <?php }  
                          if (!empty($price_package)) { ?>
                                  <h1 class="mt-5"><?php echo $price_package;?><sup><?php echo $price_sub_text;?> </sup> </h1>
                                  <?php } 
                          if (!empty($hourly_text)) { ?>
                                  <h3 class="mt-5"><?php echo $hourly_text;?></h3>
                                  <?php } 
                          ?>
                      </div>
                      <?php 
                        $learn_more_button = get_field('learn_more_button');
                        if( $learn_more_button ): 
                            $more_button_url = $learn_more_button['url'];
                            $more_button_title = $learn_more_button['title'];
                            $more_button_target = $learn_more_button['target'] ? $learn_more_button['target'] : '_self';
                            ?>
                      <a class="<?php echo $field_color; ?> animated-button" href="<?php echo esc_url( $more_button_url ); ?>"
                        target="<?php echo esc_attr( $more_button_target ); ?>"><span><?php echo esc_html( $more_button_title ); ?></span></a>
                      <?php endif; ?>
                    </li>
               <?php endwhile; wp_reset_postdata(); endif;?>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="section-courses">
  <div class="container">
    <?php if (!empty(get_field('academic_subject_heading',$get_page_ID))) { ?>
    <div class="row">
      <div class="col-sm-12">
        <h2 class="academic-subject-heading" data-aos="fade-bottom">
          <?php echo get_field('academic_subject_heading',$get_page_ID);?></h2>
      </div>
    </div>
    <?php } ?>
  </div>
  <div class="subject-section-row">
    <?php if( have_rows('academic_subjects') ) { ?>
    <?php while( have_rows('academic_subjects') ): the_row();
          $subject_color = get_sub_field('subject_color'); ?>
    <div class="subject-section <?php echo $subject_color; ?>">
      <div class="container">
        <div class="row">
          <div class="col-md-6 img-space" data-aos="slide-right">
            <?php if (!empty(get_sub_field('subject_name',$get_page_ID))) { ?>
            <h3 class="subject-name" data-aos="slide-right">
              <?php echo get_sub_field('subject_name',$get_page_ID);?></h3>
            <?php } ?>
            <?php $subject_image = get_sub_field('subject_image');
                    if( !empty( $subject_image ) ){ ?>
            <img src="<?php echo esc_url($subject_image['url']); ?>"
              alt="<?php echo esc_attr($subject_image['alt']); ?>"  data-aos="slide-right" />
            <?php } ?>
          </div>
          <div class="col-md-6" data-aos="fade-right" >
            <div class="level-courses">
              <div class="level-courses-blk ">
                <?php if (!empty(get_sub_field('subject_level',$get_page_ID))) { ?>
                <h3 class="subject-level"  ><?php echo get_sub_field('subject_level',$get_page_ID);?></h3>
                <?php } ?>
                <?php if (!empty(get_sub_field('subject_level_description',$get_page_ID))) { ?>
                <p class="subject-level-description">
                  <?php echo get_sub_field('subject_level_description',$get_page_ID);?></p>
                <?php } ?>
              </div>
              <div class="level-courses-desc">
                <?php if (!empty(get_sub_field('subject_level_second',$get_page_ID))) { ?>
                <h3 class="subject-level"><?php echo get_sub_field('subject_level_second',$get_page_ID);?></h3>
                <?php } ?>
                <?php if (!empty(get_sub_field('subject_level_desc',$get_page_ID))) { ?>
                <p class="subject-level-desc" ><?php echo get_sub_field('subject_level_desc',$get_page_ID);?></p>
                <?php } ?>
              </div>
              <?php if( have_rows('subject_level_description_second') ) { ?>
              <div class="row">
                <?php while( have_rows('subject_level_description_second') ): the_row(); ?>
                <div class="col-sm-6" >
                  <?php $course_image = get_sub_field('course_image');
                            if( !empty( $course_image ) ){ ?>
                  <img src="<?php echo esc_url($course_image['url']); ?>"
                    alt="<?php echo esc_attr($course_image['alt']); ?>" />
                  <?php }  
                            $course_color = get_sub_field('course_color'); ?>
                  <div class="course-detail-box <?php echo $course_color; ?>"  >
                    <?php if (!empty(get_sub_field('course_title',$get_page_ID))) { ?>
                      <div class="box-spac"><h3 class="course-title"><?php echo get_sub_field('course_title',$get_page_ID);?></h3></div>
                    <?php } ?>
                    <?php if (!empty(get_sub_field('couse_description',$get_page_ID))) { ?>
                    <?php echo get_sub_field('couse_description',$get_page_ID);?>
                    <?php } ?>
                  </div>
                </div>
                <?php endwhile; ?>
              </div>
              <?php }?>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php endwhile; ?>
    <?php }?>
  </div>
</section>
<section class="get-started-section">
  <div class="container">
    <div class="get-started">
      <div class="row">
          <div class="col-md-8 col-sm-10">
          <?php echo do_shortcode('[contact-form-7 id="1088" title="Contact form 1"]'); ?>
          </div>
      </div>
    </div>
  </div>
</section>
</section>
<?php $coastline_method_image = get_field('coastline_method_background_image',$get_page_ID); ?>
<section class="coastline-method" style="background-image:url('<?php echo $coastline_method_image['url'];?>')" >
  <div class="container">
    <div class="row middle">
      <div class="col-sm-9">
        <?php if (!empty(get_field('coastline_method_heading',$get_page_ID))) { ?>
        <h3><?php echo get_field('coastline_method_heading',$get_page_ID);?></h3>
        <?php } ?>
        <?php if (!empty(get_field('coastline_method_description',$get_page_ID))) { ?>
        <p><?php echo get_field('coastline_method_description',$get_page_ID);?></p>
        <?php } ?>
      </div>
      <div class="col-sm-3">
        <?php $coastline_method_link = get_field('coastline_method_link');
                if( $coastline_method_link ){ 
                    $coastline_link_url = $coastline_method_link['url'];
                    $coastline_link_title = $coastline_method_link['title'];
                    $coastline_link_target = $coastline_method_link['target'] ? $link['target'] : '_self';
                    ?>
        <a class="coastline-btn animated-button" href="<?php echo esc_url( $coastline_link_url ); ?>"
          target="<?php echo esc_attr( $coastline_link_target ); ?>"><span><?php echo esc_html( $coastline_link_title ); ?> </span></a>
        <?php } ?>
      </div>
    </div>
  </div>
</section>

<?php
get_footer();