<?php
/**
 * Template Name: ACT Page Template
 */

get_header();
$get_page_ID = get_the_ID();
?>
<?php get_template_part( 'template-parts/page-banner', 'page' ); 
?>
<section class="test-prep-packages">
  <div class="container">
    <div class="row">
      <div class="col-sm-12">
        <div class="packages-block">
          <div class="packages-detail">
            <h2 class="mt-5"  data-aos="fade-bottom">Test Prep Packages</h2>
            <ul class="packages-type col3 row">
              <?php 
                  $args = array(  
                      'post_type' => 'packages', 
                      'posts_per_page' => -1, 
                      'order'     => 'ASC',
                      'tax_query' => array(
                          array(
                              'taxonomy' => 'packages_categories',
                              'field'    => 'slug', // search by slug name, you may change to use ID
                              'terms'    => 'test-prep-packages', // value of the slug for taxonomy, in term using ID, you should using integer type casting (int) $value
                          ),
                      )
                  );
                  $new_query = new WP_Query($args);
              if($new_query->have_posts()) : while ($new_query->have_posts()) : $new_query->the_post(); ?>
              <li class="col-md-3 list-btn">
              <div class="list-spacing">
                <?php $field_color = get_field('border_color'); ?>
                <hr class="<?php echo $field_color; ?>" />
                <?php 
                  $buttun_text = get_field( "buttun_text" );
                  $package_description = get_field( "package_description" );
                  $price_package = get_field( "price_package" );
                  $price_sub_text = get_field( "price_sub_text" );
                  $hourly_text = get_field( "hourly_text" );
                  
                  if( !empty($buttun_text) ) { ?>
                          <div class="package-link"><?php echo $buttun_text; ?></div>
                          <?php } 
                  if( !empty($package_description) ) { ?>
                          <p><?php echo $package_description;?></p>
                          <?php }  
                  if (!empty($price_package)) { ?>
                          <h1 class="mt-5"><?php echo $price_package;?><sup><?php echo $price_sub_text;?> </sup> </h1>
                          <?php } 
                  if (!empty($hourly_text)) { ?>
                          <h3 class="mt-5"><?php echo $hourly_text;?></h3>
                          <?php } 
                  ?>
              </div>
              <?php 
                $learn_more_button = get_field('learn_more_button');
                if( $learn_more_button ): 
                    $more_button_url = $learn_more_button['url'];
                    $more_button_title = $learn_more_button['title'];
                    $more_button_target = $learn_more_button['target'] ? $learn_more_button['target'] : '_self';
                    ?>
              <a class="<?php echo $field_color; ?> animated-button" href="<?php echo esc_url( $more_button_url ); ?>"
                target="<?php echo esc_attr( $more_button_target ); ?>"><span><?php echo esc_html( $more_button_title ); ?></span></a>
              <?php endif; ?>
            </li>
              <?php endwhile; wp_reset_postdata(); endif;?>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="act-dates table-date">
      <div class="row">
        <div class="col-sm-12">
          <?php if( have_rows('act_dates_table') ): ?>
              <?php while( have_rows('act_dates_table') ): the_row(); ?>
               <div class="national-dates">
              <?php if (!empty(get_sub_field('act_table_heading',$get_page_ID))) { ?>
                  <h2  data-aos="fade-bottom"><?php echo get_sub_field('act_table_heading',$get_page_ID);?></h2>
              <?php } ?>
              <div class="container">
                <div class="table-responsive">
                  <table class="table" >
                    <?php if (!empty(get_sub_field('act_table_row_heading',$get_page_ID))) { ?>
                        <?php echo get_sub_field('act_table_row_heading',$get_page_ID);?> 
                    <?php } ?>
                    <?php if( have_rows('act_table_data') ) { ?>   
                        <?php while( have_rows('act_table_data') ): the_row();  ?>
                              <tr>
                                <td><?php the_sub_field('first_column'); ?></td>
                                <td><?php the_sub_field('second_column'); ?></td>
                                <td><?php the_sub_field('third_column'); ?></td>
                                <td><?php the_sub_field('fourth_column'); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php } ?>
                  </table>
                  
                  </div>
                    <?php if (!empty(get_sub_field('act_table_row_description',$get_page_ID))) { ?>
                        <p class="act-table-description" data-aos="slide-left"><?php echo get_sub_field('act_table_row_description',$get_page_ID);?></p> 
                    <?php } ?>
                    <?php 
                      $act_table_link = get_sub_field('act_table_link');
                      if( $act_table_link ): 
                          $act_table_link_url = $act_table_link['url'];
                          $act_table_link_title = $act_table_link['title'];
                          $act_table_link_target = $act_table_link['target'] ? $act_table_link['target'] : '_self';
                          ?>
                          <p class="act-table-link" data-aos="slide-right"><a href="<?php echo esc_url( $act_table_link_url ); ?>" target="<?php echo esc_attr( $act_table_link_target ); ?>"><?php echo esc_html( $act_table_link_title ); ?></a></p>
                      <?php endif; ?>
                      <?php 
                      $act_register_button = get_sub_field('act_register_button');
                      if( $act_register_button ): 
                          $act_register_link_url = $act_register_button['url'];
                          $act_register_link_title = $act_register_button['title'];
                          $act_register_link_target = $act_register_button['target'] ? $act_register_button['target'] : '_self';
                          ?>
                         <p class="act-register-button" data-aos="fade-bottom" ><a href="<?php echo esc_url( $act_register_link_url ); ?> " target="<?php echo esc_attr( $act_register_link_target ); ?>" class="animated-button"><span><?php echo esc_html( $act_register_link_title ); ?></span></a></p> 
                      <?php endif; ?>
                </div>
                  </div>           
                <?php endwhile; ?>

          <?php endif; ?>
        </div> 
      </div>
</section>
<section class="get-started-section">
  <div class="container">
    <div class="get-started">
      <div class="row">
          <div class="col-md-8 col-sm-10">
          <?php echo do_shortcode('[contact-form-7 id="1088" title="Contact form 1"]'); ?>
          </div>
      </div>
    </div>
  </div>
</section>
<?php if (!empty(get_field('coastline_method_heading',$get_page_ID))) { ?>
<?php $coastline_method_image = get_field('coastline_method_background_image',$get_page_ID); ?>
<section  class="coastline-method" style="background-image:url('<?php echo $coastline_method_image['url'];?>')">
  <div class="container">
      <div class="row middle">
          <div class="col-sm-9">
            
              <h3><?php echo get_field('coastline_method_heading',$get_page_ID);?></h3>

            <?php if (!empty(get_field('coastline_method_description',$get_page_ID))) { ?>
              <p><?php echo get_field('coastline_method_description',$get_page_ID);?></p>
            <?php } ?>
          </div>
          <div class="col-sm-3">
              <?php $coastline_method_link = get_field('coastline_method_link');
                if( $coastline_method_link ){ 
                    $coastline_link_url = $coastline_method_link['url'];
                    $coastline_link_title = $coastline_method_link['title'];
                    $coastline_link_target = $coastline_method_link['target'] ? $link['target'] : '_self';
                    ?>
                    <a class="coastline-btn animated-button" href="<?php echo esc_url( $coastline_link_url ); ?>" target="<?php echo esc_attr( $coastline_link_target ); ?>"><span><?php echo esc_html( $coastline_link_title ); ?></span></a>
              <?php } ?>
          </div>
      </div>
  </div>    
</section>
            <?php } ?>
<?php
get_footer();