<?php
/**
 * Template Name: Coastline Method Page Template
 */

get_header();
$get_page_ID = get_the_ID();
get_template_part( 'template-parts/page-banner', 'page' ); 
?>
<section>
  <div class="prep-arrow">
    <div class="row">
      <div class="container-fluid">
        <?php if( have_rows('consultation_steps') ){ ?>
        <ul class="critical_area-prep">
          <?php 
          $count = 0;
          while( have_rows('consultation_steps') ): the_row(); 
          $field_color = get_sub_field('border_color'); ?>
          <li style="border-left: 8px solid #<?php echo $field_color; ?>; "><?php the_sub_field('consultaion_list'); ?>
          </li>
          <li class="prep-arrow"><svg xmlns="http://www.w3.org/2000/svg" width="62.298" height="43.804"
              viewBox="0 0 62.298 43.804">
              <defs>
                <style>
                  .a<?php echo $count; ?> {
                    fill: #<?php echo $field_color;
                    ?>;
                  }
                </style>
              </defs>
              <path class="a<?php echo $count; ?>"
                d="M41.95,5.333a2.209,2.209,0,1,0-3.14,3.108L54.73,24.36H2.2A2.187,2.187,0,0,0,0,26.56a2.211,2.211,0,0,0,2.2,2.23H54.73L38.811,44.68a2.254,2.254,0,0,0,0,3.14,2.2,2.2,0,0,0,3.14,0L61.639,28.131a2.162,2.162,0,0,0,0-3.108Z"
                transform="translate(0 -4.674)" />
            </svg></li>
          <?php $count++;  endwhile; ?>
        </ul>
        <?php } ?>
      </div>
    </div>
  </div>
  </div>
</section>
<section class="steps-details">
  <div class="personalize-box prep-personalize-box">
    <?php if( have_rows('steps_details') ): ?>
    <?php while( have_rows('steps_details') ): the_row(); 
        $steps_color = get_sub_field('steps_color');
        ?><div class="steps-bg <?php echo $steps_color; ?>">
      <div class="container">
        <div class="row">
          <div class="col-sm-6">
            <div class="personalize-learning prep-img">
              <?php $steps_image = get_sub_field('steps_image');
              if( !empty( $steps_image ) ){ ?>
              <img src="<?php echo esc_url($steps_image['url']); ?>"
                alt="<?php echo get_sub_field('steps_title',$get_page_ID);?>" data-aos="slide-right" />
              <?php } ?>
            </div>
          </div>
          <div class="col-sm-6">
            <?php if (!empty(get_sub_field('steps_title',$get_page_ID))) { ?>
            <h1 class="banner-title prep-h1" ><?php echo get_sub_field('steps_title',$get_page_ID);?><span
                class="sub-title">
                <?php echo get_sub_field('steps_sub_title',$get_page_ID);?></span></h1>
            <?php }  
                if (!empty(get_sub_field('steps_description',$get_page_ID))) { ?>
            <p class="prep-para" ><?php echo get_sub_field('steps_description',$get_page_ID);?></p>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
    <?php endwhile; ?>
  </div>
  <?php endif; ?>
  </div>
</section>
<section class="prep-arr" >
  <div class="container">
    <div class="row">
      <div class="col-sm-6">
        <?php echo get_field('academic_program',$get_page_ID);?>
      </div>
      <div class="col-sm-6">
        <?php echo get_field('test_prep',$get_page_ID);?>
      </div>
    </div>
</section>
<section class="get-started-section">
  <div class="container">
    <div class="get-started">
      <div class="row">
        <div class="col-md-8 col-sm-10">
          <?php echo do_shortcode('[contact-form-7 id="1088" title="Contact form 1"]'); ?>
        </div>
      </div>
    </div>
  </div>
</section>
<?php if (!empty(get_field('coastline_method_heading',$get_page_ID))) { ?>
<?php $coastline_method_image = get_field('coastline_method_background_image',$get_page_ID); ?>
<section class="coastline-method" style="background-image:url('<?php echo $coastline_method_image['url'];?>')">
  <div class="container">
    <div class="row middle">
      <div class="col-sm-9">
        <h3><?php echo get_field('coastline_method_heading',$get_page_ID);?></h3>
        <?php if (!empty(get_field('coastline_method_description',$get_page_ID))) { ?>
        <p><?php echo get_field('coastline_method_description',$get_page_ID);?></p>
        <?php } ?>
      </div>
      <div class="col-sm-3" >
        <?php $coastline_method_link = get_field('coastline_method_link');
        if( $coastline_method_link ){ 
            $coastline_link_url = $coastline_method_link['url'];
            $coastline_link_title = $coastline_method_link['title'];
            $coastline_link_target = $coastline_method_link['target'] ? $link['target'] : '_self';
            ?>
        <a class="coastline-btn animated-button" href="<?php echo esc_url( $coastline_link_url ); ?>"
          target="<?php echo esc_attr( $coastline_link_target ); ?>"><span><?php echo esc_html( $coastline_link_title ); ?></span></a>
        <?php } ?>
      </div>
    </div>
  </div>
</section>
<?php }  
get_footer();