<?php
/**
 * Template Name: Contact Page Template
 */

get_header();
$get_page_ID = get_the_ID();
?>
<?php get_template_part( 'template-parts/page-banner', 'page' ); 
?>
<section class="contact-form" >
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div class="cont-heading">
          <?php if (!empty(get_field('contact_form_title',$get_page_ID))) { ?>
          <h2 data-aos="fade-bottom"><?php echo get_field('contact_form_title',$get_page_ID);?></h2>
          <?php } ?>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-6">
        <script charset="utf-8" type="text/javascript" src="//js.hsforms.net/forms/shell.js"></script>
        <script>
          hbspt.forms.create({
            region: "na1",
            portalId: "20218807",
            formId: "8e99a1c5-e487-40dc-82f8-fbf42b0db553"
          });
        </script>
      </div>
      <div class="col-sm-6" >
        <?php $contact_image = get_field('contact_image');
          if( !empty( $contact_image ) ){ ?>
        <img src="<?php echo esc_url($contact_image['url']); ?>" alt="<?php echo get_field('contact_form_title',$get_page_ID);?>" data-aos="slide-left"/>
        <?php } ?>
        <div class="info-box">
          <?php if( have_rows('contact_info') ): ?>
          <ul class="info-detail" data-aos="slide-left">
            <?php while( have_rows('contact_info') ): the_row(); ?>
            <li data-aos="slide-left"><label><?php the_sub_field('info_title'); ?></label>
              <a href="mailto:<?php the_sub_field('add_email'); ?>"><?php the_sub_field('add_email'); ?></a>
            </li>
            <?php endwhile; ?>
          </ul>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</section>
<?php if (!empty(get_field('coastline_method_heading',$get_page_ID))) { ?>
<?php $coastline_method_image = get_field('coastline_method_background_image',$get_page_ID); ?>
<section class="coastline-method" style="background-image:url('<?php echo $coastline_method_image['url'];?>')">
  <div class="container">
    <div class="row middle">
      <div class="col-sm-9">
        <h3><?php echo get_field('coastline_method_heading',$get_page_ID);?></h3>
        <?php if (!empty(get_field('coastline_method_description',$get_page_ID))) { ?>
        <p><?php echo get_field('coastline_method_description',$get_page_ID);?></p>
        <?php } ?>
      </div>
      <div class="col-sm-3">
        <?php $coastline_method_link = get_field('coastline_method_link');
                if( $coastline_method_link ){ 
                    $coastline_link_url = $coastline_method_link['url'];
                    $coastline_link_title = $coastline_method_link['title'];
                    $coastline_link_target = $coastline_method_link['target'] ? $link['target'] : '_self';
                    ?>
        <a class="coastline-btn animated-button" href="<?php echo esc_url( $coastline_link_url ); ?>"
          target="<?php echo esc_attr( $coastline_link_target ); ?>"><span><?php echo esc_html( $coastline_link_title ); ?></span></a>
        <?php } ?>
      </div>
    </div>
  </div>
</section>
<?php } ?>
<?php
get_footer();