<?php
/**
 * Template Name: FAQ Page Template
 */

get_header();
$get_page_ID = get_the_ID();
?>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
<script>
    jQuery(document).ready(function(){
        // Add minus icon for collapse element which is open by default
        jQuery(".collapse.show").each(function(){
        	jQuery(this).prev(".card-header").find(".fa").addClass("fa-minus").removeClass("fa-plus");
        });
        // Toggle plus minus icon on show hide of collapse element
        jQuery(".collapse").on('show.bs.collapse', function(){
        	jQuery(this).prev(".card-header").find(".fa").removeClass("fa-plus").addClass("fa-minus");
        }).on('hide.bs.collapse', function(){
        	jQuery(this).prev(".card-header").find(".fa").removeClass("fa-minus").addClass("fa-plus");
        });
    });
</script>
<?php get_template_part( 'template-parts/page-banner', 'page' ); 
?>
<section class="accordion-section" data-aos="fade-down">
  <div class="container">
  <?php if (!empty(get_field('accordion_title',$get_page_ID))) { ?>
    <div class="accord-head">
      <h2 ><?php echo get_field('accordion_title',$get_page_ID);?> </h2>     
    </div>
  <?php } ?>
  <?php if( have_rows('accordion_tab') ) { ?>
      <div class="accordion" id="accordionExample">
        <?php 
        $row_countt = 1;
        while( have_rows('accordion_tab') ): the_row(); ?>
          <div class="card">
            <div class="card-header" id="headingOne<?php echo $row_countt; ?>">
              <h2 class="mb-0" >
                <button type="button" class="btn btn-link" data-toggle="collapse" data-target="#collapseOne<?php echo $row_countt; ?>">
                  <div class="blk">
                    <?php if (!empty(get_sub_field('accordion_sub_heading',$get_page_ID))) { ?>
                    <label class="accordion_sub_heading"><?php echo get_sub_field('accordion_sub_heading',$get_page_ID);?></label> <?php } ?>
                    <?php if (!empty(get_sub_field('accordion_heading',$get_page_ID))) { ?>
                    <span class="accordion_heading"><?php echo get_sub_field('accordion_heading',$get_page_ID);?></span> <?php } ?>
                    <?php if (!empty(get_sub_field('accordion_description',$get_page_ID))) { ?>
                    <p class="accordion_description"><?php echo get_sub_field('accordion_description',$get_page_ID);?></p> <?php } ?>
                  </div>
                  <div class="blk-icon"><i class="fa fa-plus"></i></div></button>		
              <?php $timing_title = get_sub_field('timing_title',$get_page_ID); ?>				
              </h2>
            </div>
            <div id="collapseOne<?php echo $row_countt; ?>" class="collapse" aria-labelledby="headingOne<?php echo $row_countt; ?>" data-parent="#accordionExample">
              <div class="card-body" >
              <?php if( have_rows('accordion_list') ): ?>
                <ul class="accordion_list">
                  <?php while( have_rows('accordion_list') ): the_row(); ?>
                    <li>
                      <div class="row"> 
                        <div class="col-md-7 col-7">
                          <?php if (!empty(get_sub_field('section_number',$get_page_ID))) {  ?>
                                <span class="list_common"> <?php echo get_sub_field('section_number',$get_page_ID);?> </span> 
                          <?php  } ?>
                               <span class="list_title"><?php echo get_sub_field('list_title',$get_page_ID); ?> </span>
                        </div>
                        <div class="col-md-5 col-5 align-right"> 
                          <label><?php echo $timing_title;?></label>
                          <span class="list_common"><?php echo get_sub_field('list_timing',$get_page_ID); ?></span>
                        </div>
                      </div>   
                    </li>
                      <div class="vl"></div>
                  <?php endwhile; ?>
                </ul>
              <?php endif; ?>
              <?php if (!empty(get_sub_field('according_desc',$get_page_ID))) { ?>
                <div class="red-desc"><?php echo get_sub_field('according_desc',$get_page_ID);?></div> 
                <?php } ?>
                <?php if (!empty(get_sub_field('according_content',$get_page_ID))) { ?>
                <div class="according_content"><?php echo get_sub_field('according_content',$get_page_ID);?></div> 
                <?php } ?>
              </div>
            </div>
          </div>
        <?php $row_countt++; endwhile; ?>
      </div>
  <?php }?>
  </div>
</section>
<?php if (!empty(get_field('coastline_method_heading',$get_page_ID))) { 
$coastline_method_image = get_field('coastline_method_background_image',$get_page_ID); ?>
<section  class="coastline-method" style="background-image:url('<?php echo $coastline_method_image['url'];?>')">
  <div class="container">
      <div class="row middle">
          <div class="col-sm-9" >
            <h3><?php echo get_field('coastline_method_heading',$get_page_ID);?></h3>
            <?php if (!empty(get_field('coastline_method_description',$get_page_ID))) { ?>
              <p><?php echo get_field('coastline_method_description',$get_page_ID);?></p>
            <?php } ?>
          </div>
          <div class="col-sm-3" >
              <?php $coastline_method_link = get_field('coastline_method_link');
                if( $coastline_method_link ){ 
                    $coastline_link_url = $coastline_method_link['url'];
                    $coastline_link_title = $coastline_method_link['title'];
                    $coastline_link_target = $coastline_method_link['target'] ? $link['target'] : '_self';
                    ?>
                    <a class="coastline-btn animated-button" href="<?php echo esc_url( $coastline_link_url ); ?>" target="<?php echo esc_attr( $coastline_link_target ); ?>"><span><?php echo esc_html( $coastline_link_title ); ?></span></a>
              <?php } ?>
          </div>
      </div>
  </div>    
</section>
<?php } ?>
<Script>
jQuery( document ).ready(function() {
  jQuery( ".card:first-child .collapse" ).addClass( "show" );
});
</Script>
<?php
get_footer();