<?php
/**
 * Template Name: Home Page Template
 */

get_header();
$get_page_ID = get_the_ID();
?>
<section class="banner" data-aos="zoom-in" >
  <?php if( have_rows('banner_slider') ) { ?>
  <div class="regular slider">
    <?php while( have_rows('banner_slider') ): the_row(); ?>
    <div class="banner-box">
      <?php   $image = get_sub_field('banner_image');
            if( !empty( $image ) ){ ?>
      <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
      <?php } ?>
      <div class="desc-banner">
        <div class="col-sm-6"></div>
        <div class="col-sm-6" data-aos="slide-left">
          <?php if (!empty(get_sub_field('sub_title',$get_page_ID))) { ?>
          <span class="sub-title">
            <?php echo get_sub_field('sub_title',$get_page_ID);?></span>
          <?php } ?>
          <?php if (!empty(get_sub_field('title',$get_page_ID))) { ?>
          <h2 class="banner-title">
            <?php echo get_sub_field('title',$get_page_ID);?></h2>
          <?php } ?>
          <?php if (!empty(get_sub_field('description',$get_page_ID))) { ?>
          <p class="banner-desc">
            <?php echo get_sub_field('description',$get_page_ID);?></p>
          <?php } 
           $link = get_sub_field('button_link');
              if( $link ){ 
                  $link_url = $link['url'];
                  $link_title = $link['title'];
                  $link_target = $link['target'] ? $link['target'] : '_self';
                  ?>
        <a class="banner-link animated-button"href="<?php echo esc_url( $link_url ); ?>"
            target="<?php echo esc_attr( $link_target ); ?>"><span><?php echo esc_html( $link_title ); ?></span></a>
          <?php } ?>
        </div>
      </div>
    </div>
    <?php endwhile; ?>
  </div>
  <?php } ?>
</section>
<section class="academic-section" >
  <div class="container">
    <div class="academic-box">
      <?php if( have_rows('banner_academics') ) { ?>
      <div class="row">
        <?php while( have_rows('banner_academics') ): the_row(); ?>
        
        <div class="col-sm-3 col-6" >
          <div class="academic-detail">
            <?php   $academic_image = get_sub_field('banner_academics_image');
                  if( !empty( $academic_image ) ){ ?>
            <img src="<?php echo esc_url($academic_image['url']); ?>"
              alt="<?php echo get_sub_field('banner_academics_title',$get_page_ID);?>" />
            <?php } ?>
            <?php if (!empty(get_sub_field('banner_academics_title',$get_page_ID))) { ?>
              <?php 
              $banner_academics_link = get_sub_field('banner_academics_link');
              if( $banner_academics_link ): 
                  $link_url = $banner_academics_link['url'];
                  $link_title = $banner_academics_link['title'];
                  $link_target = $banner_academics_link['target'] ? $banner_academics_link['target'] : '_self';
                  ?>
                  <a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>">
                      <h5 class="banner-title"> <?php echo get_sub_field('banner_academics_title',$get_page_ID);?></h5></a>
                      <?php endif; ?>
            <?php } ?>
          </div>
        </div>
        <?php endwhile; ?>
      </div>
      <?php } ?>
     </div>
  </div>
  <div class="container program-work-sections" data-aos="fade-bottom">
    <div class="row">
      <div class="col-sm-12">
        <?php if (!empty(get_field('program_work_title',$get_page_ID))) { ?>
        <h2 class="program-work-title">
          <?php echo get_field('program_work_title',$get_page_ID);?></h2>
        <?php } ?>
      </div>
    </div>
    <?php if( have_rows('program_work_sections') ) { ?>
    <div class="personalize-box">
      <?php while( have_rows('program_work_sections') ): the_row(); ?>
      <div class="row">
        <div class="col-sm-6" data-aos="fade-left">
          <div class="personalize-learning">
            <?php   $program_work_image = get_sub_field('program_work_image');
                    if( !empty( $program_work_image ) ){ ?>
            <img src="<?php echo esc_url($program_work_image['url']); ?>"
              alt="<?php echo get_sub_field('program_work_title',$get_page_ID);?>" />
            <?php } ?>
          </div>
        </div>
        <div class="col-sm-6" >
          <?php if (!empty(get_sub_field('program_work_title',$get_page_ID))) { ?>
          <h3 class="banner-title">
            <?php echo get_sub_field('program_work_title',$get_page_ID);?></h3>
          <?php } ?>
          <?php if (!empty(get_sub_field('program_work_description',$get_page_ID))) { ?>
          <p><?php echo get_sub_field('program_work_description',$get_page_ID);?></p>
          <?php } ?>
        </div>
      </div>
      <?php endwhile; ?>
    </div>
    <?php } ?>
  </div>
</section>
<section class="packages-advertise">
  <div class="container">
    <div class="row">
      <div class="col-sm-12">
          <div class="advertise-slides">
            <?php if( have_rows('packages_advertise') ){ ?>
            <div class="packages-advertise-slider sliders">
            <?php while( have_rows('packages_advertise') ): the_row(); ?>
              <div class="packages-advertise-block">
                    <?php if (!empty(get_sub_field('packages_advertise_title',$get_page_ID))) { ?>
                    <h3><?php echo get_sub_field('packages_advertise_title',$get_page_ID);?></h3>
                    <?php } ?>
                    <?php if (!empty(get_sub_field('packages_advertise_price',$get_page_ID))) { ?>
                    <span class="sub-title">
                      <?php echo get_sub_field('packages_advertise_price',$get_page_ID); 
                      $packages_link = get_sub_field('packages_advertise_link');
                        if( $packages_link ){ 
                            $packages_link_url = $packages_link['url'];
                            $packages_link_title = $packages_link['title'];
                            $packages_link_target = $packages_link['target'] ? $packages_link['target'] : '_self';
                            ?>
                            <a class="package-adv-link animated-button" href="<?php echo esc_url( $packages_link_url ); ?>"
                              target="<?php echo esc_attr( $packages_link_target ); ?>"><span><?php echo esc_html( $packages_link_title ); ?></span></a>
                            <?php } ?>
                      </span>
                    <?php } ?>
              </div>
            <?php endwhile; ?>
            </div>
          <?php }  ?>
          </div>
    </div>
  </div>
</section> 
<section class="packages-section" >
  <div class="container">
    <div class="row">
      <div class="col-sm-12">
        <?php if( have_rows('packages') ) { ?>
        <div class="packages-block">
          <?php while( have_rows('packages') ): the_row(); ?>
          <div class="packages-detail">
            <?php if (!empty(get_sub_field('packages_title',$get_page_ID))) { ?>
            <h2 data-aos="fade-bottom"><?php echo get_sub_field('packages_title',$get_page_ID);?></h2>
            <?php } 
             $count = count(get_sub_field('packages_type')); 
              if( have_rows('packages_type') ) { ?>
            <ul class="packages-type row">
              <?php while( have_rows('packages_type') ): the_row();
              $field_color = get_sub_field('border_color'); ?>
              <li class="col" >
              <hr class="<?php echo $field_color; ?>"/>
               <?php $package_link = get_sub_field('package_link');
                    if( $package_link ){ 
                        $package_link_url = $package_link['url'];
                        $package_link_url_title = $package_link['title'];
                        $package_link_url_target = $package_link['target'] ? $package_link['target'] : '_self';
                ?>
                <a class="package-link animated-button" href="<?php echo esc_url( $package_link_url ); ?>"
                  target="<?php echo esc_attr( $package_link_url_target ); ?>"><span><?php echo esc_html( $package_link_url_title ); ?></span></a>
                <?php } ?>
                <?php if (!empty(get_sub_field('package_description',$get_page_ID))) { ?>
                <p><?php echo get_sub_field('package_description',$get_page_ID);?></p>
                <?php } ?>
              </li>
              <?php endwhile; ?>
            </ul>
            <?php } ?>
          </div>
          <?php endwhile; ?>
        </div>
        <?php } ?>
      </div>
    </div>
  </div>
</section>

<section class="blog-section">
<div class="container">
    <div class="row">
      <div class="col-sm-12">
        <div class="blog-title">
            <?php if (!empty(get_field('blog_title',$get_page_ID))) { ?>
                  <h2><?php echo get_field('blog_title',$get_page_ID);?></h2>
            <?php } ?>
        </div>
        <div class="blog-list">
        <?php
        $featured_posts = get_field('blog_list');
      
        if( $featured_posts ): ?>
            <div class="row">
            <?php foreach( $featured_posts as $featured_post ): 
                $permalink = get_permalink( $featured_post->ID );
                $post_date = get_the_date( 'F j, Y', $featured_post->ID ); 
                $brd_color = get_field('border_color',$featured_post->ID); 
                ?>
                <div class="col-md-4">
                  <div class="blog-box">
                  <hr class="<?php echo $brd_color; ?>">
                  <div class="blog-category <?php echo $brd_color; ?>"><span><?php $category = get_the_category($featured_post->ID);
                    echo $category[0]->cat_name;?></span>
                      </div>
                    <?php // echo get_the_post_thumbnail($featured_post->ID, 'large'); ?>
                    <?php if (has_post_thumbnail( $featured_post->ID ) ){ ?>
                    <?php $image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $featured_post->ID ), 'single-post-thumbnail' ); ?>
                        <img src='<?php echo $image_url[0]; ?>' alt="<?php echo wp_trim_words( get_the_title($featured_post->ID),5, '...' ); ?>" />
                    <?php } ?>
                      <div class="blog-info">
                        <h3><?php echo wp_trim_words( get_the_title($featured_post->ID),5, '...' ); ?></h3>
                        <p><?php echo wp_trim_words( get_the_excerpt($featured_post->ID),10, '...' ); ?></p>
                      </div>
                      <div class="blog-date"><span><?php echo $post_date; ?></span>
                        <a href="<?php echo esc_url( $permalink ); ?>">+Read More</a>
                      </div>
                    </div>
                </div>
            <?php endforeach; ?>
            </div>
        <?php endif; ?>
        </div>
        <div class="blog-view-all">
          <?php $view_all_link = get_field('view_all_link');
              if( $view_all_link ){ 
                  $view_all_link_url = $view_all_link['url'];
                  $view_all_link_title = $view_all_link['title'];
                  $view_all_link_target = $view_all_link['target'] ? $view_all_link['target'] : '_self';
                  ?>
          <a class="blog-link" href="<?php echo esc_url( $view_all_link_url ); ?>"
            target="<?php echo esc_attr( $view_all_link_target ); ?>"><?php echo esc_html( $view_all_link_title ); ?> <img src="/wp-content/uploads/2021/06/right-arrow-7.svg"/></a>
          <?php } ?>
        </div>
      </div>
    </div>
</div>      
</section>
<section class="get-started-section" id="get-started-section">
  <div class="container">
    <div class="get-started">
      <div class="row">
          <div class="col-md-8 col-sm-10">
          <?php echo do_shortcode('[contact-form-7 id="1088" title="Contact form 1"]'); ?>
          </div>
      </div>
    </div>
  </div>
</section>
<section class="testimonial-section" >
 <div class="testimonial">
  <div class="container">
      <div class="row middle">
            <div class="col-sm-8 col-md-9">
              <div class="testimonial-info"> <?php if (!empty(get_field('testimonial_heading',$get_page_ID))) { ?>
                <h2><?php echo get_field('testimonial_heading',$get_page_ID);?></h2>
                <?php } 
              if (!empty(get_field('testimonial_sub_heading',$get_page_ID))) { ?>
                <h3><?php echo get_field('testimonial_sub_heading',$get_page_ID);?></h3>
                <?php } ?>
              </div>
            </div>
            <div class="col-sm-4 col-md-3">
                <?php 
                $testimonial_button_link = get_field('testimonial_button_link');
                if( $testimonial_button_link ): 
                    $testimonial_link_url = $testimonial_button_link['url'];
                    $testimonial_link_title = $testimonial_button_link['title'];
                    $testimonial_link_target = $testimonial_button_link['target'] ? $testimonial_button_link['target'] : '_self';
                    ?>
                    <a class="testimonial-link animated-button" href="<?php echo esc_url( $testimonial_link_url ); ?>" target="<?php echo esc_attr( $testimonial_link_target ); ?>"><span><?php echo esc_html( $testimonial_link_title ); ?></span></a>
                <?php endif; ?>
            </div>
      </div>
    </div>
  </div> 
  <div class="testimonial-carousel">
    <div class="container">
      <div class="row">
        <div class="col-sm-12">
          <div class="testimonial-slider slider">
            <?php $loop = new WP_Query( array( 'post_type' => 'testimonial', 'posts_per_page' => 10 ) ); ?>
              <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                <div class="block"><p><?php echo wp_trim_words( get_the_excerpt(),100, '...' ); ?></p>
              <h3><?php the_title(); ?></h3>
              </div>
              <?php endwhile; ?>
          </div>
        </div>
      </div>   
    </div>
  </div>                      
</section>
<?php
get_footer();
?>
