<?php
/**
 * Template Name: SAT/PSAT Page Template
 */

get_header();
$get_page_ID = get_the_ID();
get_template_part( 'template-parts/page-banner', 'page' ); ?>
<section class="test-prep-packages" >
  <div class="container">
    <div class="row">
      <div class="col-sm-12">
        <div class="packages-block">
          <div class="packages-detail">
            <h2 class="mt-5" data-aos="fade-bottom">Test Prep Packages</h2>
            <ul class="packages-type col3 row">
              <?php 
                  $args = array(  
                      'post_type' => 'packages', 
                      'posts_per_page' => -1, 
                      'order'     => 'ASC',
                      'tax_query' => array(
                          array(
                              'taxonomy' => 'packages_categories',
                              'field'    => 'slug', // search by slug name, you may change to use ID
                              'terms'    => 'test-prep-packages', // value of the slug for taxonomy, in term using ID, you should using integer type casting (int) $value
                          ),
                      )
                  );
                  $new_query = new WP_Query($args);
              if($new_query->have_posts()) { while ($new_query->have_posts()) : $new_query->the_post(); ?>
              <li class="col-sm-3 list-btn" >
                <div class="list-spacing">
                  <?php $field_color = get_field('border_color'); ?>
                  <hr class="<?php echo $field_color; ?>" />
                  <?php 
                  $buttun_text = get_field( "buttun_text" );
                  $package_description = get_field( "package_description" );
                  $price_package = get_field( "price_package" );
                  $price_sub_text = get_field( "price_sub_text" );
                  $hourly_text = get_field( "hourly_text" );
                  
                  if( !empty($buttun_text) ) { ?>
                  <div class="package-link"><?php echo $buttun_text; ?></div>
                  <?php } 
                  if( !empty($package_description) ) { ?>
                    <p><?php echo $package_description;?></p>
                  <?php }  
                  if (!empty($price_package)) { ?>
                    <h1 class="mt-5"><?php echo $price_package;?><sup><?php echo $price_sub_text;?> </sup> </h1>
                  <?php } 
                  if (!empty($hourly_text)) { ?>
                    <h3 class="mt-5"><?php echo $hourly_text;?></h3>
                  <?php } 
                  ?>
                </div>
                <?php 
                $learn_more_button = get_field('learn_more_button');
                if( $learn_more_button ){
                    $more_button_url = $learn_more_button['url'];
                    $more_button_title = $learn_more_button['title'];
                    $more_button_target = $learn_more_button['target'] ? $learn_more_button['target'] : '_self';
                    ?>
                <a class="<?php echo $field_color; ?> animated-button" href="<?php echo esc_url( $more_button_url ); ?>"
                  target="<?php echo esc_attr( $more_button_target ); ?>"><span><?php echo esc_html( $more_button_title ); ?>
                  </span></a>
                <?php } ?>
              </li>
              <?php endwhile; wp_reset_postdata(); } ?>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="sat-dates table-date" >
  <?php if (!empty(get_field('sat_dates_heading',$get_page_ID))) { ?>
  <h2 data-aos="fade-bottom"><?php echo get_field('sat_dates_heading',$get_page_ID);?></h2>
  <?php } ?>
  <div class="container">
    <div class="row">
      <div class="col-sm-12" >
        <?php
        if (!empty(get_field('sat_dates_description',$get_page_ID))) { ?>
          <p data-aos="fade-bottom" class="sat_dates_description"><?php echo get_field('sat_dates_description',$get_page_ID);?></p>
        <?php } 
        if( have_rows('sat_dates_table_row') ) { ?>
        <div class="table-responsive">
            <table class="table" >
              <?php 
              if (!empty(get_field('sat_dates_table',$get_page_ID))) { ?>
              <?php echo get_field('sat_dates_table',$get_page_ID);?>
              <?php } ?>
              <?php while( have_rows('sat_dates_table_row') ): the_row();  ?>
              <tr>
                <td><?php the_sub_field('first_column'); ?></td>
                <td><?php the_sub_field('second_column'); ?></td>
                <td><?php the_sub_field('third_column'); ?></td>
                <td><?php the_sub_field('fourth_column'); ?></td>
                <td><?php the_sub_field('fifth_column'); ?></td>
              </tr>
              <?php endwhile; ?>
            </table>
          </div>
          <?php } ?>
        <div class="register-btn">
          <?php 
          $sat_dates_link = get_field('sat_dates_link');
          if( $sat_dates_link ){
              $sat_dates_link_url = $sat_dates_link['url'];
              $sat_dates_link_title = $sat_dates_link['title'];
              $sat_dates_link_target = $sat_dates_link['target'] ? $sat_dates_link['target'] : '_self';
              ?>
          <a class="sat_dates_link_target animated-button " href="<?php echo esc_url( $sat_dates_link_url ); ?>"
            target="<?php echo esc_attr( $sat_dates_link_target ); ?>"><span><?php echo esc_html( $sat_dates_link_title ); ?></span></a>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="get-started-section">
  <div class="container">
    <div class="get-started">
      <div class="row">
          <div class="col-md-8 col-sm-10">
          <?php echo do_shortcode('[contact-form-7 id="1088" title="Contact form 1"]'); ?>
          </div>
      </div>
    </div>
  </div>
</section>
<?php $coastline_method_image = get_field('coastline_method_background_image',$get_page_ID); ?>
<section class="coastline-method" style="background-image:url('<?php echo $coastline_method_image['url'];?>')">
  <div class="container">
    <div class="row middle">
      <div class="col-sm-9">
        <?php if (!empty(get_field('coastline_method_heading',$get_page_ID))) { ?>
        <h3><?php echo get_field('coastline_method_heading',$get_page_ID);?></h3>
        <?php } ?>
        <?php if (!empty(get_field('coastline_method_description',$get_page_ID))) { ?>
        <p><?php echo get_field('coastline_method_description',$get_page_ID);?></p>
        <?php } ?>
      </div>
      <div class="col-sm-3" >
        <?php $coastline_method_link = get_field('coastline_method_link');
                if( $coastline_method_link ){ 
                    $coastline_link_url = $coastline_method_link['url'];
                    $coastline_link_title = $coastline_method_link['title'];
                    $coastline_link_target = $coastline_method_link['target'] ? $link['target'] : '_self';
                    ?>
        <a class="coastline-btn animated-button" href="<?php echo esc_url( $coastline_link_url ); ?>"
          target="<?php echo esc_attr( $coastline_link_target ); ?>"><span><?php echo esc_html( $coastline_link_title ); ?>
          </span></a>
        <?php } ?>
      </div>
    </div>
  </div>
</section>
<?php
get_footer();