<?php
/**
 * Template Name: SSAT Page Template
 */

get_header();
$get_page_ID = get_the_ID();
?>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
<script>
    jQuery(document).ready(function(){
        // Add minus icon for collapse element which is open by default
        jQuery(".collapse.show").each(function(){
        	jQuery(this).prev(".card-header").find(".fa").addClass("fa-minus").removeClass("fa-plus");
        });
        
        // Toggle plus minus icon on show hide of collapse element
        jQuery(".collapse").on('show.bs.collapse', function(){
        	jQuery(this).prev(".card-header").find(".fa").removeClass("fa-plus").addClass("fa-minus");
        }).on('hide.bs.collapse', function(){
        	jQuery(this).prev(".card-header").find(".fa").removeClass("fa-minus").addClass("fa-plus");
        });
    });
</script>
<?php get_template_part( 'template-parts/page-banner', 'page' ); 
?>
<section class="test-prep-packages">
  <div class="container">
    <div class="row">
      <div class="col-sm-12">
        <div class="packages-block">
          <div class="packages-detail">
            <h2 class="mt-5" data-aos="fade-bottom">Test Prep Packages</h2>
            <ul class="packages-type col3 row">
              <?php 
                  $args = array(  
                      'post_type' => 'packages', 
                      'posts_per_page' => -1, 
                      'order'     => 'ASC',
                      'tax_query' => array(
                          array(
                              'taxonomy' => 'packages_categories',
                              'field'    => 'slug', // search by slug name, you may change to use ID
                              'terms'    => 'test-prep-packages', // value of the slug for taxonomy, in term using ID, you should using integer type casting (int) $value
                          ),
                      )
                  );
                  $new_query = new WP_Query($args);
              if($new_query->have_posts()) : while ($new_query->have_posts()) : $new_query->the_post(); ?>
              <li class="col-md-3 list-btn" >
              <div class="list-spacing">
                <?php $field_color = get_field('border_color'); ?>
                <hr class="<?php echo $field_color; ?>" />
                <?php 
                  $buttun_text = get_field( "buttun_text" );
                  $package_description = get_field( "package_description" );
                  $price_package = get_field( "price_package" );
                  $price_sub_text = get_field( "price_sub_text" );
                  $hourly_text = get_field( "hourly_text" );
                  
                  if( !empty($buttun_text) ) { ?>
                          <div class="package-link" ><?php echo $buttun_text; ?></div>
                          <?php } 
                  if( !empty($package_description) ) { ?>
                          <p><?php echo $package_description;?></p>
                          <?php }  
                  if (!empty($price_package)) { ?>
                          <h1 class="mt-5" ><?php echo $price_package;?><sup><?php echo $price_sub_text;?> </sup> </h1>
                          <?php } 
                  if (!empty($hourly_text)) { ?>
                          <h3 class="mt-5" ><?php echo $hourly_text;?></h3>
                          <?php } 
                  ?>
              </div>
              <?php 
                $learn_more_button = get_field('learn_more_button');
                if( $learn_more_button ): 
                    $more_button_url = $learn_more_button['url'];
                    $more_button_title = $learn_more_button['title'];
                    $more_button_target = $learn_more_button['target'] ? $learn_more_button['target'] : '_self';
                    ?>
              <a class="<?php echo $field_color; ?> animated-button" href="<?php echo esc_url( $more_button_url ); ?>"
                target="<?php echo esc_attr( $more_button_target ); ?>"><span><?php echo esc_html( $more_button_title ); ?></span></a>
              <?php endif; ?>
            </li>
              <?php endwhile; wp_reset_postdata(); endif;?>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="accordion-section">
  <div class="container">
  <?php if( have_rows('accordion_tab') ) { ?>
      <div class="accordion" id="accordionExample">
        <?php 
        $row_countt = 1;
        while( have_rows('accordion_tab') ): the_row(); ?>
          <div class="card">
            <div class="card-header" id="headingOne<?php echo $row_countt; ?>">
              <h2 class="mb-0">
                <button type="button" class="btn btn-link" data-toggle="collapse" data-target="#collapseOne<?php echo $row_countt; ?>">
                  <div class="blk">
                    <?php if (!empty(get_sub_field('accordion_sub_heading',$get_page_ID))) { ?>
                    <label class="accordion_sub_heading"><?php echo get_sub_field('accordion_sub_heading',$get_page_ID);?></label> <?php } ?>
                    <?php if (!empty(get_sub_field('accordion_heading',$get_page_ID))) { ?>
                    <span class="accordion_heading" ><?php echo get_sub_field('accordion_heading',$get_page_ID);?></span> <?php } ?>
                    <?php if (!empty(get_sub_field('accordion_description',$get_page_ID))) { ?>
                    <p class="accordion_description"><?php echo get_sub_field('accordion_description',$get_page_ID);?></p> <?php } ?>
                  </div>
                  <div class="blk-icon"><i class="fa fa-plus" ></i></div></button>		
              <?php $timing_title = get_sub_field('timing_title',$get_page_ID); ?>				
              </h2>
            </div>
            <div id="collapseOne<?php echo $row_countt; ?>" class="collapse" aria-labelledby="headingOne<?php echo $row_countt; ?>" data-parent="#accordionExample">
              <div class="card-body" data-aos="fade-bottom">
              <?php if( have_rows('accordion_list') ): ?>
                <ul class="accordion_list">
                  <?php while( have_rows('accordion_list') ): the_row(); ?>
                    <li>
                      <div class="row"> 
                        <div class="col-md-7 col-7" >
                          <?php if (!empty(get_sub_field('section_number',$get_page_ID))) {  ?>
                                <span class="list_common" > <?php echo get_sub_field('section_number',$get_page_ID);?> </span> 
                          <?php  } ?>
                               <span class="list_title"><?php echo get_sub_field('list_title',$get_page_ID); ?> </span>
                        </div>
                        <div class="col-md-5 col-5 align-right"> 
                          <label><?php echo $timing_title;?></label>
                          <span class="list_common"><?php echo get_sub_field('list_timing',$get_page_ID); ?></span>
                        </div>
                      </div>   
                    
                    </li>
                      <div class="vl"></div>
                  <?php endwhile; ?>
                </ul>
              <?php endif; ?>
              <?php if (!empty(get_sub_field('according_desc',$get_page_ID))) { ?>
                <div class="red-desc"><?php echo get_sub_field('according_desc',$get_page_ID);?></div> 
                <?php } ?>
                <?php if (!empty(get_sub_field('according_content',$get_page_ID))) { ?>
                <div class="according_content"><?php echo get_sub_field('according_content',$get_page_ID);?></div> 
                <?php } ?>
              </div>
            </div>
          </div>
        <?php $row_countt++; endwhile; ?>
      </div>
  <?php }?>
  </div>
</section>
<section class="get-started-section" id="get-started-section">
  <div class="container">
    <div class="get-started">
      <div class="row">
          <div class="col-md-8 col-sm-10">
          <?php echo do_shortcode('[contact-form-7 id="1088" title="Contact form 1"]'); ?>
          </div>
      </div>
    </div>
  </div>
</section>
<?php if (!empty(get_field('coastline_method_heading',$get_page_ID))) { ?>
<?php $coastline_method_image = get_field('coastline_method_background_image',$get_page_ID); ?>
<section  class="coastline-method" style="background-image:url('<?php echo $coastline_method_image['url'];?>')">
  <div class="container">
      <div class="row middle">
          <div class="col-sm-9">
            <h3><?php echo get_field('coastline_method_heading',$get_page_ID);?></h3>
            <?php if (!empty(get_field('coastline_method_description',$get_page_ID))) { ?>
              <p><?php echo get_field('coastline_method_description',$get_page_ID);?></p>
            <?php } ?>
          </div>
          <div class="col-sm-3">
              <?php $coastline_method_link = get_field('coastline_method_link');
                if( $coastline_method_link ){ 
                    $coastline_link_url = $coastline_method_link['url'];
                    $coastline_link_title = $coastline_method_link['title'];
                    $coastline_link_target = $coastline_method_link['target'] ? $link['target'] : '_self';
                    ?>
                    <a class="coastline-btn animated-button" href="<?php echo esc_url( $coastline_link_url ); ?>" target="<?php echo esc_attr( $coastline_link_target ); ?>"><span><?php echo esc_html( $coastline_link_title ); ?></span></a>
              <?php } ?>
          </div>
      </div>
  </div>    
</section>
<?php } ?>
<Script>
jQuery( document ).ready(function() {
jQuery( ".card:first-child .collapse" ).addClass( "show" );
});
</Script>
<?php
get_footer();