<?php
/**
 * Template Name: Test Prep Page Template
 */

get_header();
$get_page_ID = get_the_ID();
?>

<div class="page-price-academics">
  <section class="page-banner">
    <div class="banner-middle">
      <div class="row">
        <div class="col-sm-12">
          <?php $banner_image = get_field('banner_image');
        if( !empty( $banner_image ) ){ ?>
          <img src="<?php echo esc_url($banner_image['url']); ?>" alt="<?php echo esc_attr($banner_image['alt']); ?>"
            class="desktop-view" />
          <?php } ?>
          <?php $banner_image__mobile = get_field('banner_image__mobile');
        if( !empty( $banner_image__mobile ) ){ ?>
          <img src="<?php echo esc_url($banner_image__mobile['url']); ?>"
            alt="<?php echo esc_attr($banner_image__mobile['alt']); ?>" class="mobile-view" />
          <?php } ?>
          <?php if (!empty(get_field('banner_title',$get_page_ID))) { ?>
          <h1 class="page-title">
            <?php echo get_field('banner_title',$get_page_ID);?></h1>
          <?php } ?>
        </div>
      </div>
    </div>
    <?php if (!empty(get_field('banner_description',$get_page_ID))) { ?>
      <div class="banner-description">
        <?php $banner_icon = get_field('banner_icon');
        if( !empty( $banner_icon ) ){ ?>
          <img src="<?php echo esc_url($banner_icon['url']); ?>" alt="<?php echo esc_attr($banner_icon['alt']); ?>" />
        <?php } ?>
        <div class="banner-link"><?php 
            $banner_link_field = get_field('banner_link_field');
            if( $banner_link_field ){ 
            $banner_link_url = $banner_link_field['url'];
            $banner_link_title = $banner_link_field['title'];
            $banner_link_target = $banner_link_field['target'] ? $banner_link_field['target'] : '_self';
            ?>
          <a href="<?php echo esc_url( $banner_link_url ); ?>"
            target="<?php echo esc_attr( $banner_link_target ); ?>"><img
              src="/wp-content/uploads/2021/06/testimonial-left-arrow.svg" /><?php echo esc_html( $banner_link_title ); ?></a>
        <?php } ?></div>
        <div class="container">
          <p class="page-banner-desc">
            <?php echo get_field('banner_description',$get_page_ID);?></p>
        </div>
      </div>
    <?php } ?>
  </section>
  <!-- showing error message for item add in cart -->
  <?php    do_action( 'woocommerce_before_shop_loop' ); ?>
  <section class="Academic-packages-section" id="test-prep-packages" >
    <div class="container">
      <div class="row">
        <div class="col-sm-12">
          <div class="packages-block">
            <div class="packages-detail">
              <h2 class="mt-5" data-aos="fade-bottom">Test Prep Packages</h2>
              <ul class="packages-type row regular slider">
                <?php 
                  $args = array(  
                      'post_type' => 'product', 
                      'posts_per_page' => -1, 
                      'order'     => 'ASC',
                      'tax_query' => array(
                          array(
                              'taxonomy' => 'product_cat',
                              'field'    => 'slug', // search by slug name, you may change to use ID
                              'terms'    => 'test-prep-packages	', // value of the slug for taxonomy, in term using ID, you should using integer type casting (int) $value
                          ),
                      )
                  );
                  $new_query = new WP_Query($args);
                if($new_query->have_posts()) { while ($new_query->have_posts()) : $new_query->the_post(); ?>
                <li class="col list-btn">
                  <div class="list-spacing">
                    <?php $field_color = get_field('border_color'); ?>
                    <hr class="<?php echo $field_color; ?>" />
                    <?php 
                    $buttun_text = get_field( "buttun_text" );
                    $package_description = get_field( "package_description" );
                    $price_package = get_field( "price_package" );
                    $price_sub_text = get_field( "price_sub_text" );
                    $hourly_text = get_field( "hourly_text" );
                    if( !empty($buttun_text) ) { ?>
                      <div class="package-link "><?php echo $buttun_text; ?></div>
                    <?php }  ?>
                      <h1 class="mt-5"> <?php echo $price_package; 
                  $price = get_post_meta( get_the_ID(), '_regular_price', true);
                  //echo $price;?><sup><?php echo $price_sub_text;?> </sup> </h1>
                    <?php 
                    if (!empty($hourly_text)) { ?>
                      <h3 class="mt-5"><?php echo $hourly_text;?></h3>
                    <?php }   
                    if( !empty($package_description) ) { ?>
                     <p><?php echo $package_description;?></p>
                    <?php }  ?>
                    <div class="listing <?php echo $field_color; ?>">
                      <?php the_excerpt();      
                      ?>
                    </div>
                  </div>
                  <?php 
                  $learn_more_button = get_field('buy_now');
                  if( $learn_more_button ){ 
                  $more_button_url = $learn_more_button['url'];
                  $more_button_title = $learn_more_button['title'];
                  $more_button_target = $learn_more_button['target'] ? $learn_more_button['target'] : '_self';
                  ?>
                  <a class="<?php echo $field_color; ?> animated-button"
                    href="<?php echo esc_url( $more_button_url ); ?>"
                    target="<?php echo esc_attr( $more_button_target ); ?>"><span><?php echo esc_html( $more_button_title ); ?></span></a>
                  <?php } ?>
                  <?php
                  //custom add to cart button woocommmerce
                global $product;
                $pid = $product->get_id();
                ?>
                <a href="<?php echo do_shortcode( '[add_to_cart_url id=' . $pid . ']' ) ?>" class="<?php echo $field_color; ?> animated-button">BUY NOW</a>             
                </li>
          
                
                <?php endwhile; wp_reset_postdata(); } ?>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="get-started-section" >
  <div class="container">
    <div class="get-started">
      <div class="row">
          <div class="col-md-8 col-sm-10">
          <?php echo do_shortcode('[contact-form-7 id="1088" title="Contact form 1"]'); ?>
          </div>
      </div>
    </div>
  </div>
</section>
  <?php $coastline_method_image = get_field('coastline_method_background_image',$get_page_ID); ?>
  <section class="coastline-method" style="background-image:url('<?php echo $coastline_method_image['url'];?>')">
    <div class="container">
      <div class="row middle">
        <div class="col-sm-9">
          <?php if (!empty(get_field('coastline_method_heading',$get_page_ID))) { ?>
          <h3><?php echo get_field('coastline_method_heading',$get_page_ID);?></h3>
          <?php } ?>
          <?php if (!empty(get_field('coastline_method_description',$get_page_ID))) { ?>
          <p><?php echo get_field('coastline_method_description',$get_page_ID);?></p>
          <?php } ?>
        </div>
        <div class="col-sm-3">
          <?php $coastline_method_link = get_field('coastline_method_link');
          if( $coastline_method_link ){ 
              $coastline_link_url = $coastline_method_link['url'];
              $coastline_link_title = $coastline_method_link['title'];
              $coastline_link_target = $coastline_method_link['target'] ? $link['target'] : '_self';
              ?>
          <a class="coastline-btn animated-button" href="<?php echo esc_url( $coastline_link_url ); ?>"
            target="<?php echo esc_attr( $coastline_link_target ); ?>"><span><?php echo esc_html( $coastline_link_title ); ?></span></a>
          <?php } ?>
        </div>
      </div>
    </div>
  </section>
</div>

<script type="text/javascript">
  jQuery(document).on('ready', function () {
    function slickify(){
    jQuery("#test-prep-packages .regular").slick({
      dots: false,
      infinite: true,
      autoplay: true,
      autoplaySpeed: 10000,
      slidesToShow: 4,
      slidesToScroll: 1,
      arrows: true,
      responsive: [{
          breakpoint: 1024,
          settings: {
            slidesToShow: 3,
            slidesToScroll: 1,
            infinite: true,
            dots: false,
          },
        },
        {
          breakpoint: 991,
          settings: {
            slidesToShow: 2,
            slidesToScroll: 1,
            infinite: true,
            arrows: false,
            dots: true,
          },
        },
        {
          breakpoint: 576,
          settings: "unslick"
        },
      ],
    });
  }
    slickify();
$(window).resize(function(){
    var $windowWidth = $(window).width();
    if ($windowWidth > 576) {
     	slickify();   
    }
});
  });
</script>
<?php
get_footer();