<?php
/*
 * WiziQ installation file
 */ 
 /*
@package mod_wiziq
@copyright www.wiziq.com
@license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
*/
/*
This file is part of Wiziq - http://www.wiziq.com/
Moodle is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Moodle is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Moodle. If not, see <http://www.gnu.org/licenses/>.

*/
/*
 * Create API options
 */ 
function wiziq_install_options() {
	add_option( 'api_url', 'http://classapi.wiziqxt.com/apimanager.ashx');
	add_option( 'recurring_api_url', 'http://classapi.wiziqxt.com/apimanager.ashx');
	add_option( 'content_url', 'http://contentapi.wiziqxt.com/RestService/RestService.ashx');
	add_option( 'access_key', '' , 'mnhgfjf' , 'yes');
	add_option( 'secret_key', '');
	add_option( 'returnURL', '');
	add_option( 'content_language', 'http://classapi.wiziqxt.com/vc-language.xml');
	add_option( 'timezone_api_url', 'http://classapi.wiziqxt.com/tz.xml');
        add_option( 'email_notification', 'NO');
        
      
        
}

/*
 * Create necessary tables while creating the plugin
 */ 
function wiziq_table_create() {
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	global $wpdb;
	$wiziq_courses = $wpdb->prefix."wiziq_courses";
	$wiziq_wclasses = $wpdb->prefix."wiziq_wclasses";
	$wiziq_enroluser = $wpdb->prefix."wiziq_enroluser";
	$wiziq_contents = $wpdb->prefix."wiziq_contents";
	$wiziq_download = $wpdb->prefix."wiziq_download";
	
	$courses_creations = "CREATE TABLE $wiziq_courses (
		id int AUTO_INCREMENT PRIMARY KEY,
		created_by int NOT NULL,
		fullname varchar(255) NOT NULL,
		startdate date NULL DEFAULT NULL ,
		enddate date NULL DEFAULT NULL,
		description text NOT NULL,
		userid int NULL
	);";
	$classes_creations = "CREATE TABLE $wiziq_wclasses (
		id int AUTO_INCREMENT PRIMARY KEY,
		created_by int NOT NULL,
		class_name varchar(100) NOT NULL,
		class_time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		duration varchar(100) NOT NULL,
		courseid int NOT NULL,
		classtimezone varchar(100) NOT NULL,
		language varchar(100) NOT NULL,
		recordclass varchar(10) NOT NULL,
		attendee_limit int NOT NULL,
		response_class_id int NOT NULL,
		response_recording_url text NOT NULL,
		response_presenter_url text NOT NULL,
		status varchar(200) NOT NULL,
		master_id int(20) NOT NULL,
		attendence_report varchar(100) NOT NULL,
		get_detail tinyint NOT NULL,
		download_recording text NOT NULL,
		is_recurring varchar(10) NOT NULL
	);";
	$enroluser_creations = "CREATE TABLE $wiziq_enroluser (
		user_id int NOT NULL,
		course_id int NOT NULL,
		create_class tinyint NOT NULL,
		edit_class tinyint NOT NULL,
		delete_class tinyint NOT NULL,
		view_recording tinyint NOT NULL,
		download_recording tinyint NOT NULL,
		upload_content tinyint NOT NULL,
		upload_course tinyint NOT NULL
	);";
	$content_creations = "CREATE TABLE $wiziq_contents (
		id int AUTO_INCREMENT PRIMARY KEY,
		status varchar(10) NOT NULL,
		created_by int NOT NULL,
		isfolder tinyint NOT NULL,
		name varchar(255) NOT NULL,
		parent int NOT NULL,
		content_id int NOT NULL,
		uploadingfile varchar(255) NOT NULL,
		folderpath varchar(100) NOT NULL
	);";
	
	$content_download = "CREATE TABLE $wiziq_download (
		id int AUTO_INCREMENT PRIMARY KEY,	
		att varchar(255) NOT NULL,
		ed varchar(255) NOT NULL,
		ex varchar(255) NOT NULL,
		aat varchar(255) NOT NULL,
		response_class_id varchar(255) NOT NULL,
		courdid varchar(255) NOT NULL
		
	);";
	if($wpdb->get_var("SHOW TABLES LIKE '$wiziq_courses'") != $wiziq_courses) {
		$wpdb->query($courses_creations);
	}
	if($wpdb->get_var("SHOW TABLES LIKE '$wiziq_wclasses'") != $wiziq_wclasses) {
		$wpdb->query($classes_creations);
	}
	if($wpdb->get_var("SHOW TABLES LIKE '$wiziq_enroluser'") != $wiziq_enroluser) {
		$wpdb->query($enroluser_creations);
	}
	if($wpdb->get_var("SHOW TABLES LIKE '$wiziq_contents'") != $wiziq_contents) {
		$wpdb->query($content_creations);
	}
	if($wpdb->get_var("SHOW TABLES LIKE '$wiziq_download'") != $wiziq_download) {
		$wpdb->query($content_download);
	}
	$content_qry = "insert into $wiziq_contents (created_by, isfolder, name, parent, content_id)
	values ( '0','1','My Content' ,'0', '0') ";
	$wpdb->query($content_qry) ;
}
