<?php

if ( ! function_exists( 'edgtf_core_map_masonry_gallery_meta' ) ) {
	function edgtf_core_map_masonry_gallery_meta() {
		
		$masonry_gallery_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => array( 'masonry-gallery' ),
				'title' => esc_html__( 'Masonry Gallery General', 'edgtf-core' ),
				'name'  => 'masonry_gallery_meta'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_masonry_gallery_item_title_tag',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Title Tag', 'edgtf-core' ),
				'parent'        => $masonry_gallery_meta_box,
				'options'       => gastrobar_edge_get_title_tag(true)
			)
		);

        gastrobar_edge_create_meta_box_field(
            array(
                'name'          => 'edgtf_masonry_gallery_predefined_style',
                'type'          => 'select',
                'default_value' => 'no',
                'label'         => esc_html__( 'Choose Predefined Style', 'edgtf-core' ),
                'parent'        => $masonry_gallery_meta_box,
                'options'       => gastrobar_edge_get_yes_no_select_array()
            )
        );

		gastrobar_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_masonry_gallery_item_text',
				'type'   => 'text',
				'label'  => esc_html__( 'Text', 'edgtf-core' ),
				'parent' => $masonry_gallery_meta_box
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_masonry_gallery_item_image',
				'type'   => 'image',
				'label'  => esc_html__( 'Custom Item Icon', 'edgtf-core' ),
				'parent' => $masonry_gallery_meta_box
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_masonry_gallery_item_link',
				'type'   => 'text',
				'label'  => esc_html__( 'Link', 'edgtf-core' ),
				'parent' => $masonry_gallery_meta_box
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_masonry_gallery_item_link_target',
				'type'          => 'select',
				'default_value' => '_self',
				'label'         => esc_html__( 'Link Target', 'edgtf-core' ),
				'parent'        => $masonry_gallery_meta_box,
				'options'       => gastrobar_edge_get_link_target_array()
			)
		);
		
		gastrobar_edge_add_admin_section_title( array(
			'name'   => 'edgtf_section_style_title',
			'parent' => $masonry_gallery_meta_box,
			'title'  => esc_html__( 'Masonry Gallery Item Style', 'edgtf-core' )
		) );
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_masonry_gallery_item_size',
				'type'          => 'select',
				'default_value' => 'square-small',
				'label'         => esc_html__( 'Size', 'edgtf-core' ),
				'parent'        => $masonry_gallery_meta_box,
				'options'       => array(
					'square-small'        => esc_html__( 'Square Small', 'edgtf-core' ),
					'square-big'          => esc_html__( 'Square Big', 'edgtf-core' ),
					'rectangle-portrait'  => esc_html__( 'Rectangle Portrait', 'edgtf-core' ),
					'rectangle-landscape' => esc_html__( 'Rectangle Landscape', 'edgtf-core' )
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_masonry_gallery_item_type',
				'type'          => 'select',
				'default_value' => 'standard',
				'label'         => esc_html__( 'Type', 'edgtf-core' ),
				'parent'        => $masonry_gallery_meta_box,
				'options'       => array(
					'standard'                   => esc_html__( 'Standard', 'edgtf-core' ),
					'with-button'                => esc_html__( 'With Button', 'edgtf-core' ),
					'simple'                     => esc_html__( 'Simple', 'edgtf-core' ),
                    'simple-without-hover'       => esc_html__( 'Simple Without Hover', 'edgtf-core' )
				),
				'args'           => array(
					'dependence' => true,
					'hide'       => array(
						'with-button'           => '#edgtf_masonry_gallery_item_simple_type_container',
						'simple'                => '#edgtf_masonry_gallery_item_button_type_container',
						'standard'              => '#edgtf_masonry_gallery_item_button_type_container, #edgtf_masonry_gallery_item_simple_type_container',
                        'simple-without-hover'  => '#edgtf_masonry_gallery_item_button_type_container, #edgtf_masonry_gallery_item_simple_type_container',
					),
					'show'            => array(
						'with-button' => '#edgtf_masonry_gallery_item_button_type_container',
						'simple'      => '#edgtf_masonry_gallery_item_simple_type_container',
						'standard'    => ''
					)
				)
			)
		);
		
		$masonry_gallery_item_button_type_container = gastrobar_edge_add_admin_container_no_style(
			array(
				'name'            => 'masonry_gallery_item_button_type_container',
				'parent'          => $masonry_gallery_meta_box,
				'hidden_property' => 'edgtf_masonry_gallery_item_type',
				'hidden_values'   => array( 'standard', 'simple' )
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_masonry_gallery_button_label',
				'type'   => 'text',
				'label'  => esc_html__( 'Button Label', 'edgtf-core' ),
				'parent' => $masonry_gallery_item_button_type_container
			)
		);
		
		$masonry_gallery_item_simple_type_container = gastrobar_edge_add_admin_container_no_style(
			array(
				'name'            => 'masonry_gallery_item_simple_type_container',
				'parent'          => $masonry_gallery_meta_box,
				'hidden_property' => 'edgtf_masonry_gallery_item_type',
				'hidden_values'   => array( 'standard', 'with-button' )
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_masonry_gallery_simple_content_background_skin',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Content Background Skin', 'edgtf-core' ),
				'parent'        => $masonry_gallery_item_simple_type_container,
				'options'       => array(
					'default'           => esc_html__( 'Default', 'edgtf-core' ),
					'custom-skin-1'     => esc_html__( 'Custom Style 1', 'edgtf-core' ),
					'custom-skin-2'     => esc_html__( 'Custom Style 2', 'edgtf-core' ),
					'transparent'       => esc_html__( 'Transparent', 'edgtf-core' )
				)
			)
		);

	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'edgtf_core_map_masonry_gallery_meta', 45 );
}