<?php

namespace EdgeCore\CPT\Shortcodes\OpeningHours;

use EdgeCore\Lib;

class OpeningHours implements Lib\ShortcodeInterface
{
    private $base;

    public function __construct() {
        $this->base = 'edgtf_opening_hours';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if (function_exists('vc_map')) {
            vc_map(
                array(
                    'name'                      => esc_html__('Edge Opening Hours', 'edgtf-core'),
                    'base'                      => $this->getBase(),
                    'category'                  => esc_html__('by EDGE', 'edgtf-core'),
                    'icon'                      => 'icon-wpb-custom-font extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
                    'params'                    => array(
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'day',
                            'heading'     => esc_html__('Day of the Week', 'edgtf-core'),
                            'description' => esc_html__('eg: Monday ', 'edgtf-core'),
                        ),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'day_color',
                            'heading'    => esc_html__('Day Label Color', 'edgtf-core'),
                            'save_always' => true,
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'hours',
                            'heading'     => esc_html__('Hours', 'edgtf-core'),
                            'description' => esc_html__('eg: 9:00 - 22:00 ', 'edgtf-core'),
                        ),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'hours_color',
                            'heading'    => esc_html__('Hours Label Color', 'edgtf-core'),
                            'save_always' => true,
                        ),
	                    array(
		                    'type'       => 'colorpicker',
		                    'param_name' => 'dots_color',
		                    'heading'    => esc_html__('Dots Color', 'edgtf-core'),
		                    'save_always' => true,
	                    ),
                    )
                )
            );
        }
    }

    public function render($atts, $content = null) {
        $args = array(
            'day'             => '',
            'hours'           => '',
            'hours_color'     => '',
            'day_color'       => '',
	        'dots_color'      => ''
        );

        $params = shortcode_atts($args, $atts);

        $params['hours_styles']   = $this->getHoursStyles( $params );
        $params['day_styles']     = $this->getDayStyles( $params );
	    $params['dots_styles']    = $this->getDotsSyles( $params );

        $html = edgtf_core_get_shortcode_module_template_part('templates/opening-hours', 'opening-hours', '', $params);

        return $html;
    }

    private function getHoursStyles( $params ) {
        $styles = array();

        if($params['hours_color'] !== '') {
            $styles['color'] = 'color: ' . $params['hours_color'];
        }

        return $styles;
    }

    private function getDayStyles( $params ) {
        $styles = array();

        if($params['day_color'] !== '') {
            $styles['color'] = 'color: ' . $params['day_color'];
        }

        return $styles;
    }

	private function getDotsSyles( $params ) {
		$styles = array();

		if($params['dots_color'] !== '') {
			$styles['color'] = 'border-color: ' . $params['dots_color'];
		}

		return $styles;
	}

}