<?php
namespace EdgeCore\CPT\Shortcodes\PricingList;

use EdgeCore\Lib;

class PricingList implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'edgtf_pricing_list';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		vc_map(
			array(
				'name'                    => esc_html__( 'Edge Pricing list', 'edgtf-core' ),
				'base'                    => $this->base,
				'as_parent'               => array( 'only' => 'edgtf_pricing_list_item' ),
				'content_element'         => true,
				'category'                => esc_html__( 'by EDGE', 'edgtf-core' ),
				'icon'                    => 'icon-wpb-pricing-list extended-custom-icon',
				'show_settings_on_create' => true,
				'js_view'                 => 'VcColumnView',
				'params'                  => array(
					array(
						'type'        => 'textfield',
						'param_name'  => 'title',
						'heading'     => esc_html__('Title', 'edgtf-core'),
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'custom_title',
						'heading'     => esc_html__('Use Our Predefined Style For Title', 'edgtf-core'),
						'value'       => array_flip(gastrobar_edge_get_yes_no_select_array(false, true))
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'title_align',
						'heading'     => esc_html__('Title Alignment', 'edgtf-core'),
						'value'       => array(
							esc_html__( 'Left', 'edgtf-core' )   => 'edgtf-pli-title-left',
							esc_html__( 'Center', 'edgtf-core' ) => 'edgtf-pli-title-center'
						),
						'save_always' => true
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'item_space',
						'heading'     => esc_html__('Space between items', 'edgtf-core'),
						'value'       => array(
							esc_html__( 'Small', 'edgtf-core' )  => 'edgtf-pli-small-space',
							esc_html__( 'Normal', 'edgtf-core' ) => 'edgtf-pli-normal-space',
							esc_html__( 'Large', 'edgtf-core' )  => 'edgtf-pli-large-space'
						),
						'save_always' => true
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'skin',
						'heading'     => esc_html__('Pricing Items Skin', 'edgtf-core'),
						'value'       => array(
							esc_html__( 'Default (dark)', 'edgtf-core' ) => '',
							esc_html__( 'Light', 'edgtf-core' )          => 'edgtf-pli-light'
						),
						'save_always' => true
					),
				)
			)
		);
	}

	public function render($atts, $content = null) {
		$args = array(
			'title'             => '',
			'custom_title'      => 'yes',
			'title_align'       => 'left',
			'item_space'        => 'edgtf-pli-small-space',
			'skin'              => ''
		);

		$params = shortcode_atts($args, $atts);

		$params['holder_class']        = $this->getHolderClass($params);
		$params['title_holder_styles'] = $this->getTitleHolderStyles($params);
		$params['content']             = $content;
		
		$html = edgtf_core_get_shortcode_module_template_part('templates/pricing-list', 'pricing-list', '', $params);

		return $html;
	}

	private function getHolderClass($params) {
		$class = array();

		$class[] = $params['item_space'];

		if(!empty($params['skin'])) {
			$class[] = $params['skin'];
		}

		return implode( ' ', $class );
	}

	private function getTitleHolderStyles($params) {
		$styles = array();

		if(!empty($params['title_align'])) {
			$styles[] = 'text-align: '. $params['title_align'];
		}

		return implode( ';', $styles );
	}
}