<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <?php
    /**
     * gastrobar_edge_action_header_meta hook
     *
     * @see gastrobar_edge_header_meta() - hooked with 10
     * @see gastrobar_edge_user_scalable_meta - hooked with 10
     * @see edgtf_core_set_open_graph_meta - hooked with 10
     */
    do_action('gastrobar_edge_action_header_meta');

    wp_head(); ?>
</head>
<body <?php body_class(); ?> itemscope itemtype="//schema.org/WebPage">
<?php
/**
 * gastrobar_edge_action_after_body_tag hook
 *
 * @see gastrobar_edge_get_side_area() - hooked with 10
 * @see gastrobar_edge_smooth_page_transitions() - hooked with 10
 */
do_action('gastrobar_edge_action_after_body_tag'); ?>

<div class="edgtf-wrapper edgtf-404-page">
    <div class="edgtf-wrapper-inner">
        <?php
        /**
         * gastrobar_edge_action_after_wrapper_inner hook
         *
         * @see gastrobar_edge_get_header() - hooked with 10
         * @see gastrobar_edge_get_mobile_header() - hooked with 20
         * @see gastrobar_edge_back_to_top_button() - hooked with 30
         * @see gastrobar_edge_get_header_minimal_full_screen_menu() - hooked with 40
         * @see gastrobar_edge_get_header_bottom_navigation() - hooked with 40
         */
        do_action('gastrobar_edge_action_after_wrapper_inner');

        do_action('gastrobar_edge_action_before_main_content'); ?>

        <div class="edgtf-content" <?php gastrobar_edge_content_elem_style_attr(); ?>>
            <div class="edgtf-content-inner">
                <div class="edgtf-page-not-found">
                    <?php
                    $edgtf_title_image_404 = gastrobar_edge_options()->getOptionValue('404_page_title_image');
                    $edgtf_title_404 = gastrobar_edge_options()->getOptionValue('404_title');
                    $edgtf_subtitle_404 = gastrobar_edge_options()->getOptionValue('404_subtitle');
                    $edgtf_text_404 = gastrobar_edge_options()->getOptionValue('404_text');
                    $edgtf_button_label = gastrobar_edge_options()->getOptionValue('404_back_to_home');
                    $edgtf_button_style = gastrobar_edge_options()->getOptionValue('404_button_style');
                    ?>

                    <div class="edgtf-404-holder">
                        <span class="edgtf-404">
                            <?php esc_html_e('404', 'gastrobar'); ?>
                        </span>
                    </div>

                    <?php if (!empty($edgtf_title_404)) { ?>
                        <h1 class="edgtf-404-title">
                            <?php echo esc_html($edgtf_title_404); ?>
                        </h1>
                    <?php } ?>

                    <h2 class="edgtf-404-subtitle">
                        <?php if (!empty($edgtf_subtitle_404)) {
                            echo esc_html($edgtf_subtitle_404);
                        } else {
                            esc_html_e('Page not found', 'gastrobar');
                        } ?>
                    </h2>

                    <p class="edgtf-404-text">
                        <?php if (!empty($edgtf_text_404)) {
                            echo esc_html($edgtf_text_404);
                        } else {
                            esc_html_e('The page you are looking for does not exist. It may have been moved, or removed altogether. Perhaps you can return back to the site\'s homepage and see if you can find what you are looking for. ', 'gastrobar');
                        } ?>
                    </p>

                    <?php
                    $edgtf_params = array();
                    $edgtf_params['text'] = !empty($edgtf_button_label) ? $edgtf_button_label : esc_html__('Homepage', 'gastrobar');
                    $edgtf_params['link'] = esc_url(home_url('/'));
                    $edgtf_params['target'] = '_self';
                    $edgtf_params['size'] = 'medium';
                    $edgtf_params['hover_animation'] = 'yes';

                    if ($edgtf_button_style == 'light-style') {
                        $edgtf_params['custom_class'] = 'edgtf-btn-light-style';
                    } else {
                        $edgtf_params['custom_class'] = '';
                    }

                    if(gastrobar_edge_core_plugin_installed()) {
                        echo gastrobar_edge_execute_shortcode('edgtf_button', $edgtf_params);
                    } else { ?>
                        <a itemprop="url" href="<?php echo esc_url( $edgtf_params['link'] ) ?>" target="_self" class="edgtf-btn edgtf-btn-medium edgtf-btn-solid <?php echo esc_attr($edgtf_params['custom_class'])?>">
                            <span class="edgtf-btn-text"><?php echo esc_attr($edgtf_params['text']) ?></span>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php wp_footer(); ?>
</body>
</html>