<?php

if(!function_exists('gastrobar_edge_design_styles')) {
    /**
     * Generates general custom styles
     */
    function gastrobar_edge_design_styles() {
	    $font_family = gastrobar_edge_options()->getOptionValue( 'google_fonts' );
	    if ( ! empty( $font_family ) && gastrobar_edge_is_font_option_valid( $font_family ) ) {
		    $font_family_selector = array(
			    'body'
		    );
		    echo gastrobar_edge_dynamic_css( $font_family_selector, array( 'font-family' => gastrobar_edge_get_font_option_val( $font_family ) ) );
	    }

		$first_main_color = gastrobar_edge_options()->getOptionValue('first_color');
        if(!empty($first_main_color)) {
            $color_selector = array(
	            'a:hover',
	            'h1 a:hover',
	            'h2 a:hover',
	            'h3 a:hover',
	            'h4 a:hover',
	            'h5 a:hover',
	            'h6 a:hover',
	            'p a:hover',
	            '.edgtf-custom-font-heading',
	            'blockquote:before',
	            '.edgtf-comment-holder .edgtf-comment-text .comment-edit-link',
	            '.edgtf-comment-holder .edgtf-comment-text .comment-reply-link',
	            '.edgtf-comment-holder .edgtf-comment-text .replay',
	            '.edgtf-comment-holder .edgtf-comment-text #cancel-comment-reply-link',
	            '.edgtf-owl-slider .owl-nav .owl-next',
	            '.edgtf-owl-slider .owl-nav .owl-prev',
	            '.widget.edgtf-author-info-widget .edgtf-aiw-image-wrap .edgtf-aiw-name-wrap .edgtf-aiw-name a',
	            '.widget.widget_rss .edgtf-widget-title .rsswidget:hover',
	            '.widget.widget_search button:hover',
	            '.widget.widget_tag_cloud a:hover',
	            '.edgtf-sidebar .widget.widget_archive ul li a:hover',
	            '.edgtf-sidebar .widget.widget_categories ul li a:hover',
	            '.edgtf-sidebar .widget.widget_meta ul li a:hover',
	            '.edgtf-sidebar .widget.widget_nav_menu ul li a:hover',
	            '.edgtf-sidebar .widget.widget_pages ul li a:hover',
	            '.edgtf-sidebar .widget.widget_recent_comments ul li a:hover',
	            '.edgtf-sidebar .widget.widget_recent_entries ul li a:hover',
	            '.edgtf-page-footer .widget a:hover',
	            '.edgtf-side-menu .widget a:hover',
	            '.edgtf-page-footer .widget.widget_rss .edgtf-footer-widget-title .rsswidget:hover',
	            '.edgtf-side-menu .widget.widget_rss .edgtf-footer-widget-title .rsswidget:hover',
	            '.edgtf-page-footer .widget.widget_search button:hover',
	            '.edgtf-side-menu .widget.widget_search button:hover',
	            '.edgtf-page-footer .widget.widget_tag_cloud a:hover',
	            '.edgtf-side-menu .widget.widget_tag_cloud a:hover',
	            '.edgtf-side-menu .widget a:hover',
	            '.edgtf-page-footer .edgtf-blog-list-holder.edgtf-bl-minimal .edgtf-post-title a:hover',
	            '.edgtf-page-footer .edgtf-blog-list-holder.edgtf-bl-minimal .edgtf-post-info-date a:hover',
	            '.edgtf-page-footer .edgtf-footer-top-holder a:hover',
	            '.edgtf-page-footer .edgtf-footer-bottom-holder a:hover',
	            '.edgtf-top-bar a:hover',
	            '.edgtf-top-bar .widget.widget_search button:hover',
	            'aside.edgtf-sidebar .widget.edgtf-blog-list-widget .edgtf-blog-list-holder.edgtf-bl-simple .edgtf-bli-content .edgtf-post-info-date a:hover',
	            'aside.edgtf-sidebar .widget.edgtf-social-icons-widget .edgtf-social-icon-widget-holder:hover',
	            '.widget.widget_edgtf_twitter_widget .edgtf-twitter-widget.edgtf-twitter-standard li .edgtf-twitter-icon',
	            '.widget.widget_edgtf_twitter_widget .edgtf-twitter-widget.edgtf-twitter-slider li .edgtf-tweet-text a',
	            '.widget.widget_edgtf_twitter_widget .edgtf-twitter-widget.edgtf-twitter-slider li .edgtf-tweet-text span',
	            '.widget.widget_edgtf_twitter_widget .edgtf-twitter-widget.edgtf-twitter-standard li .edgtf-tweet-text a:hover',
	            '.widget.widget_edgtf_twitter_widget .edgtf-twitter-widget.edgtf-twitter-slider li .edgtf-twitter-icon i',
	            '.select2-container--default .select2-selection--single .select2-selection__arrow:before',
	            '.select2-container--default .select2-results__option--highlighted[aria-selected]',
	            '.select2-container--default .select2-results__option[aria-selected=true]',
	            '.select2-container--default .select2-results__option[aria-disabled=true]',
	            '.edgtf-blog-holder article.sticky .edgtf-post-title a',
	            '.edgtf-blog-holder article .edgtf-post-info-bottom .edgtf-post-info-bottom-left .edgtf-post-info-date a',
	            '.edgtf-blog-holder article .edgtf-post-info-bottom .edgtf-post-info-bottom-left>div a:hover',
	            '.edgtf-blog-holder article .edgtf-post-info-bottom .edgtf-post-info-bottom-right>div a:hover',
	            '.edgtf-blog-holder article .edgtf-post-info-bottom .edgtf-post-info-bottom-right .edgtf-blog-like a',
	            '.edgtf-blog-holder article .edgtf-post-info-bottom .edgtf-post-info-bottom-right .edgtf-post-info-comments-holder a',
	            '.edgtf-blog-holder.edgtf-blog-masonry article .edgtf-post-info-date a:hover',
	            '.edgtf-author-description .edgtf-author-description-text-holder .edgtf-author-name a:hover',
	            '.edgtf-author-description .edgtf-author-description-text-holder .edgtf-author-social-icons a:hover',
	            '.edgtf-bl-standard-pagination ul li.edgtf-bl-pag-active a',
	            '.edgtf-blog-pagination ul li a.edgtf-pag-active',
	            '.edgtf-blog-pagination ul li a:hover',
	            '.edgtf-blog-single-navigation .edgtf-blog-single-next-holder .edgtf-blog-nav-title:hover',
	            '.edgtf-blog-single-navigation .edgtf-blog-single-prev-holder .edgtf-blog-nav-title:hover',
	            '.edgtf-blog-holder.edgtf-blog-single article .edgtf-post-text .edgtf-social-share-holder.edgtf-list li a:hover',
	            '.edgtf-blog-list-holder .edgtf-bli-info .edgtf-bli-info-left .edgtf-post-info-date a',
	            '.edgtf-blog-list-holder .edgtf-bli-info .edgtf-bli-info-left>div a:hover',
	            '.edgtf-blog-list-holder .edgtf-bli-info .edgtf-bli-info-right>div a:hover',
	            '.edgtf-blog-list-holder .edgtf-bli-info .edgtf-bli-info-right .edgtf-blog-like a',
	            '.edgtf-blog-list-holder .edgtf-bli-info .edgtf-bli-info-right .edgtf-post-info-comments-holder a',
	            '.edgtf-blog-list-holder.edgtf-bl-minimal .edgtf-post-info-date a',
	            '.edgtf-blog-list-holder.edgtf-bl-simple .edgtf-bli-content .edgtf-post-info-date a',
	            '.edgtf-main-menu ul li a:hover',
	            '.edgtf-main-menu>ul>li.edgtf-active-item>a',
	            '.edgtf-light-header .edgtf-page-header>div:not(.edgtf-sticky-header):not(.fixed) .edgtf-main-menu>ul>li.edgtf-active-item>a',
	            '.edgtf-light-header .edgtf-page-header>div:not(.edgtf-sticky-header):not(.fixed) .edgtf-main-menu>ul>li>a:hover',
	            '.edgtf-drop-down .second .inner ul li.current-menu-ancestor>a',
	            '.edgtf-drop-down .second .inner ul li.current-menu-item>a',
	            '.edgtf-drop-down .wide .second .inner>ul>li.current-menu-item>a',
	            'nav.edgtf-fullscreen-menu ul li ul li.current-menu-ancestor>a',
	            'nav.edgtf-fullscreen-menu ul li ul li.current-menu-item>a',
	            'nav.edgtf-fullscreen-menu>ul>li.edgtf-active-item>a',
	            '.edgtf-fullscreen-menu-light a:hover',
	            '.edgtf-fullscreen-bottom-widget-area-holder .edgtf-fullscreen-bottom-widget-area-holder-inner a:hover',
	            '.edgtf-header-vertical .edgtf-vertical-menu ul li a:hover',
	            '.edgtf-header-vertical .edgtf-vertical-menu ul li.current-menu-ancestor>a',
	            '.edgtf-header-vertical .edgtf-vertical-menu ul li.current-menu-item>a',
	            '.edgtf-header-vertical .edgtf-vertical-menu ul li.current_page_item>a',
	            '.edgtf-header-vertical .edgtf-vertical-menu ul li.edgtf-active-item>a',
	            '.edgtf-light-header.edgtf-header-vertical .edgtf-vertical-area-widget-holder a:hover',
	            '.edgtf-dark-header.edgtf-header-vertical .edgtf-vertical-area-widget-holder a:hover',
	            '.edgtf-mobile-header .edgtf-mobile-menu-opener.edgtf-mobile-menu-opened a',
	            '.edgtf-mobile-header .edgtf-mobile-nav .edgtf-grid>ul>li.edgtf-active-item>a',
	            '.edgtf-mobile-header .edgtf-mobile-nav .edgtf-grid>ul>li.edgtf-active-item>h6',
	            '.edgtf-mobile-header .edgtf-mobile-nav ul li a:hover',
	            '.edgtf-mobile-header .edgtf-mobile-nav ul li h6:hover',
	            '.edgtf-mobile-header .edgtf-mobile-nav ul ul li.current-menu-ancestor>a',
	            '.edgtf-mobile-header .edgtf-mobile-nav ul ul li.current-menu-ancestor>h6',
	            '.edgtf-mobile-header .edgtf-mobile-nav ul ul li.current-menu-item>a',
	            '.edgtf-mobile-header .edgtf-mobile-nav ul ul li.current-menu-item>h6',
	            '.edgtf-light-header .edgtf-top-bar a:hover',
	            '.edgtf-dark-header .edgtf-top-bar a:hover',
	            '.edgtf-search-page-holder article.sticky .edgtf-post-title a',
	            '.edgtf-search-cover .edgtf-search-close a:hover',
	            '.edgtf-side-menu-button-opener.opened',
	            '.edgtf-side-menu-button-opener:hover',
	            '.edgtf-side-menu .edgtf-icon-widget-holder:hover',
	            '.edgtf-pl-filter-holder ul li.edgtf-pl-current span',
	            '.edgtf-pl-filter-holder ul li:hover span',
	            '.edgtf-pl-standard-pagination ul li.edgtf-pl-pag-active a',
	            '.edgtf-portfolio-slider-holder .edgtf-portfolio-list-holder.edgtf-nav-light-skin .owl-nav .owl-next:hover',
	            '.edgtf-portfolio-slider-holder .edgtf-portfolio-list-holder.edgtf-nav-light-skin .owl-nav .owl-prev:hover',
	            '.edgtf-portfolio-list-holder.edgtf-pl-gallery-overlay article .edgtf-pli-text .edgtf-pli-category-holder a:hover',
	            '.edgtf-banner-holder .edgtf-banner-link-text .edgtf-banner-link-hover span',
	            '.edgtf-image-with-text-holder .edgtf-iwt-title a:hover',
	            '.edgtf-pricing-item-holder .edgtf-pi-title a:hover',
	            '.edgtf-pricing-list .edgtf-pricing-list-item .edgtf-pli-content .edgtf-pli-title-holder .edgtf-pli-price-holder .edgtf-pli-price',
	            '.edgtf-social-share-holder.edgtf-dropdown .edgtf-social-share-dropdown-opener:hover',
	            '.edgtf-tabs.edgtf-tabs-standard .edgtf-tabs-nav li.ui-state-active a',
	            '.edgtf-tabs.edgtf-tabs-standard .edgtf-tabs-nav li.ui-state-hover a',
	            '.edgtf-tabs.edgtf-tabs-vertical .edgtf-tabs-nav li.ui-state-active a',
	            '.edgtf-tabs.edgtf-tabs-vertical .edgtf-tabs-nav li.ui-state-hover a',
	            '.edgtf-team-holder.edgtf-team-info-below-image .edgtf-team-social-wrapper .edgtf-team-social-holder .edgtf-team-icon .edgtf-icon-element',
	            '.edgtf-team-holder.edgtf-team-info-on-image .edgtf-team-social-holder:not(.edgtf-team-social-icon-skin-light):not(.edgtf-team-social-icon-skin-dark) .edgtf-team-icon .edgtf-icon-element:hover',
	            '.edgtf-team-holder .edgtf-team-social-holder.edgtf-team-social-icon-skin-light .edgtf-team-icon .edgtf-icon-element:hover',
	            '.edgtf-team-holder .edgtf-team-social-holder.edgtf-team-social-icon-skin-dark .edgtf-team-icon .edgtf-icon-element:hover',
	            '.edgtf-twitter-list-holder .edgtf-twitter-icon',
	            '.edgtf-twitter-list-holder .edgtf-tweet-text a:hover',
	            '.edgtf-twitter-list-holder .edgtf-twitter-profile a:hover'
            );

            $woo_color_selector = array();
            if(gastrobar_edge_is_woocommerce_installed()) {
                $woo_color_selector = array(
	                '.edgtf-pl-holder .edgtf-pli .edgtf-pli-rating',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-rating',
	                '.edgtf-pls-holder .edgtf-pls-text .edgtf-pls-rating',
	                '.edgtf-product-info .edgtf-pi-rating',
	                '.edgtf-woo-single-page .woocommerce-tabs #reviews .comment-respond .stars a.active:after',
	                '.edgtf-woo-single-page .woocommerce-tabs #reviews .comment-respond .stars a:before',
	                '.woocommerce .star-rating',
	                'div.woocommerce>.single-product .woocommerce-tabs #reviews .comment-respond .stars a.active:after',
	                'div.woocommerce>.single-product .woocommerce-tabs #reviews .comment-respond .stars a:before',
	                '.woocommerce-pagination .page-numbers li a.current',
	                '.woocommerce-pagination .page-numbers li a:hover',
	                '.woocommerce-pagination .page-numbers li span.current',
	                '.woocommerce-pagination .page-numbers li span:hover',
	                'ul.products>.product .price',
	                'div.woocommerce>.single-product .woocommerce-tabs #reviews ol.commentlist .comment_container .meta .woocommerce-review__published-date',
	                '.edgtf-woo-single-page .edgtf-single-product-summary .price',
	                '.edgtf-woo-single-page .edgtf-single-product-summary .woocommerce-product-rating .woocommerce-review-link',
	                '.edgtf-woo-single-page .edgtf-single-product-summary .product_meta>span a:hover',
	                '.edgtf-woo-single-page .edgtf-single-product-summary .edgtf-woo-social-share-holder .edgtf-social-share-holder a',
	                '.edgtf-woo-single-page .edgtf-single-product-summary p.stock.in-stock',
	                '.edgtf-woo-single-page .edgtf-single-product-summary p.stock.out-of-stock',
	                '.edgtf-woo-single-page .woocommerce-tabs #reviews ol.commentlist .comment_container .meta .woocommerce-review__published-date',
	                '.edgtf-light-header .edgtf-page-header>div:not(.edgtf-sticky-header):not(.fixed) .edgtf-shopping-cart-holder .edgtf-header-cart:hover',
	                '.widget.woocommerce.widget_layered_nav ul li.chosen a',
	                '.widget.woocommerce.widget_product_categories ul li a:hover',
	                '.widget.woocommerce.widget_products ul li .amount',
	                '.widget.woocommerce.widget_recently_viewed_products ul li .amount',
	                '.widget.woocommerce.widget_top_rated_products ul li .amount',
	                '.widget.woocommerce.widget_product_search .woocommerce-product-search button:hover',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-price',
	                '.edgtf-plc-holder.edgtf-plc-nav-light-skin .owl-nav .owl-next:hover',
	                '.edgtf-plc-holder.edgtf-plc-nav-light-skin .owl-nav .owl-prev:hover',
	                '.edgtf-pls-holder .edgtf-pls-text .edgtf-pls-price',
	                '.edgtf-pl-holder .edgtf-pli .edgtf-pli-price',
                );
            }

            $color_selector = array_merge($color_selector, $woo_color_selector);

	        $color_important_selector = array(
		        '.edgtf-portfolio-list-holder.edgtf-pl-hover-overlay-background article .edgtf-pli-text .edgtf-pli-category-holder a:hover'
	        );

            $background_color_selector = array(
                '.edgtf-st-loader .pulse',
                '.edgtf-st-loader .double_pulse .double-bounce1',
                '.edgtf-st-loader .double_pulse .double-bounce2',
                '.edgtf-st-loader .cube',
                '.edgtf-st-loader .rotating_cubes .cube1',
                '.edgtf-st-loader .rotating_cubes .cube2',
                '.edgtf-st-loader .stripes > div',
                '.edgtf-st-loader .wave > div',
                '.edgtf-st-loader .two_rotating_circles .dot1',
                '.edgtf-st-loader .two_rotating_circles .dot2',
                '.edgtf-st-loader .five_rotating_circles .container1 > div',
                '.edgtf-st-loader .five_rotating_circles .container2 > div',
                '.edgtf-st-loader .five_rotating_circles .container3 > div',
                '.edgtf-st-loader .atom .ball-1:before',
                '.edgtf-st-loader .atom .ball-2:before',
                '.edgtf-st-loader .atom .ball-3:before',
                '.edgtf-st-loader .atom .ball-4:before',
                '.edgtf-st-loader .clock .ball:before',
                '.edgtf-st-loader .mitosis .ball',
                '.edgtf-st-loader .lines .line1',
                '.edgtf-st-loader .lines .line2',
                '.edgtf-st-loader .lines .line3',
                '.edgtf-st-loader .lines .line4',
                '.edgtf-st-loader .fussion .ball',
                '.edgtf-st-loader .fussion .ball-1',
                '.edgtf-st-loader .fussion .ball-2',
                '.edgtf-st-loader .fussion .ball-3',
                '.edgtf-st-loader .fussion .ball-4',
                '.edgtf-st-loader .wave_circles .ball',
                '.edgtf-st-loader .pulse_circles .ball',
                '#submit_comment:hover',
                '.post-password-form input[type=\'submit\']:hover',
                'input.wpcf7-form-control.wpcf7-submit',
                '#edgtf-back-to-top > span',
	            '.edgtf-btn.edgtf-btn-solid',
	            '.edgtf-icon-shortcode.circle',
                '.edgtf-icon-shortcode.square',
	            '.widget #wp-calendar td#today',
	            '.edgtf-progress-bar .edgtf-pb-content-holder .edgtf-pb-content'
            );

	        $background_color_important_selector = array(
		        '.edgtf-btn.edgtf-btn-outline:not(.edgtf-btn-custom-hover-bg):hover',
	        );

	        $woo_background_color_selector = array();
            if(gastrobar_edge_is_woocommerce_installed()) {
                $woo_background_color_selector = array(
	                '.woocommerce-page .edgtf-content .wc-forward:not(.added_to_cart):not(.checkout-button)',
	                '.woocommerce-page .edgtf-content a.added_to_cart',
	                '.woocommerce-page .edgtf-content a.button',
	                '.woocommerce-page .edgtf-content button[type=submit]:not(.edgtf-woo-search-widget-button)',
	                '.woocommerce-page .edgtf-content input[type=submit]',
	                'div.woocommerce .wc-forward:not(.added_to_cart):not(.checkout-button)',
	                'div.woocommerce a.added_to_cart',
	                'div.woocommerce a.button',
	                'div.woocommerce button[type=submit]:not(.edgtf-woo-search-widget-button)',
	                'div.woocommerce input[type=submit]',
	                '.edgtf-woo-single-page .edgtf-single-product-content .edgtf-single-new-product',
	                '.woocommerce .edgtf-new-product',
	                '.woocommerce .edgtf-onsale',
	                '.woocommerce .edgtf-out-of-stock',
	                '.edgtf-shopping-cart-dropdown .edgtf-cart-bottom .edgtf-cart-checkout',
	                '.edgtf-shopping-cart-dropdown .edgtf-cart-bottom .edgtf-view-cart',
	                '.edgtf-shopping-cart-dropdown .edgtf-cart-bottom .edgtf-cart-checkout:hover',
	                '.widget.woocommerce.widget_price_filter .price_slider_wrapper .ui-widget-content .ui-slider-handle',
	                '.widget.woocommerce.widget_price_filter .price_slider_wrapper .ui-widget-content .ui-slider-range',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-image-outer .edgtf-plc-image .edgtf-plc-onsale',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-image-outer .edgtf-plc-image .edgtf-plc-out-of-stock',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-add-to-cart.edgtf-default-skin .added_to_cart',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-add-to-cart.edgtf-default-skin .button',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-add-to-cart.edgtf-light-skin .added_to_cart:hover',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-add-to-cart.edgtf-light-skin .button:hover',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-add-to-cart.edgtf-dark-skin .added_to_cart:hover',
	                '.edgtf-plc-holder .edgtf-plc-item .edgtf-plc-add-to-cart.edgtf-dark-skin .button:hover',
	                '.edgtf-plc-holder.edgtf-plc-pag-light-skin .owl-dots .owl-dot span',
	                '.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-image .edgtf-pli-onsale',
	                '.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-image .edgtf-pli-out-of-stock',
	                '.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-default-skin .added_to_cart',
	                '.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-default-skin .button',
	                '.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-light-skin .added_to_cart:hover',
	                '.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-light-skin .button:hover',
	                '.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-dark-skin .added_to_cart:hover',
	                '.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-dark-skin .button:hover',
                );
            }

            $background_color_selector = array_merge($background_color_selector, $woo_background_color_selector);

            $border_color_selector = array(
	            '.edgtf-st-loader .pulse_circles .ball',
	            '.edgtf-owl-slider .owl-dots .owl-dot.active span',
	            '.edgtf-owl-slider .owl-dots .owl-dot:hover span',
	            '#edgtf-back-to-top>span',
	            '.edgtf-rf-holder .edgtf-rf-col-holder .edgtf-rf-field-holder input[type=text]',
	            '.edgtf-rf-holder .edgtf-rf-col-holder .edgtf-rf-field-holder select',
	            '.edgtf-rf-holder.edgtf-rf-light .edgtf-rf-col-holder .edgtf-rf-field-holder input[type=text]:focus',
	            '.edgtf-rf-holder.edgtf-rf-light .edgtf-rf-col-holder .edgtf-rf-field-holder select:focus',
	            '.edgtf-testimonials-holder .edgtf-testimonials .edgtf-testimonial-image img',
	            '.edgtf-tabs.edgtf-tabs-standard .edgtf-tabs-nav li.ui-state-active:after',
	            '.edgtf-tabs.edgtf-tabs-standard .edgtf-tabs-nav li.ui-state-hover:after',
	            '.edgtf-tabs.edgtf-tabs-vertical .edgtf-tabs-nav li.ui-state-active:after',
	            '.edgtf-tabs.edgtf-tabs-vertical .edgtf-tabs-nav li.ui-state-hover:after',
	            '.edgtf-team-holder.edgtf-team-info-below-image .edgtf-team-image-frame',
            );

	        $woo_border_color_selector = array();
	        if(gastrobar_edge_is_woocommerce_installed()) {
		        $woo_border_color_selector = array(
			        '.woocommerce-page .edgtf-content .edgtf-quantity-buttons .edgtf-quantity-input:focus',
			        'div.woocommerce .edgtf-quantity-buttons .edgtf-quantity-input:focus',
			        'div.woocommerce>.single-product .woocommerce-tabs #reviews .comment-respond .comment-form-comment>textarea:focus',
		        );
	        }
	        $border_color_selector = array_merge($border_color_selector, $woo_border_color_selector);

	        $border_color_important_selector = array(
		        '.edgtf-btn.edgtf-btn-outline:not(.edgtf-btn-custom-hover-bg):hover',
	        );

            echo gastrobar_edge_dynamic_css($color_selector, array('color' => $first_main_color));
	        echo gastrobar_edge_dynamic_css($color_important_selector, array('color' => $first_main_color.'!important'));
	        echo gastrobar_edge_dynamic_css($background_color_selector, array('background-color' => $first_main_color));
	        echo gastrobar_edge_dynamic_css($background_color_important_selector, array('background-color' => $first_main_color.'!important'));
	        echo gastrobar_edge_dynamic_css($border_color_selector, array('border-color' => $first_main_color));
	        echo gastrobar_edge_dynamic_css($border_color_important_selector, array('border-color' => $first_main_color.'!important'));
        }
	
	    $page_background_color = gastrobar_edge_options()->getOptionValue( 'page_background_color' );
	    if ( ! empty( $page_background_color ) ) {
		    $background_color_selector = array(
			    'body',
			    '.edgtf-content',
			    '.edgtf-container'
		    );
		    echo gastrobar_edge_dynamic_css( $background_color_selector, array( 'background-color' => $page_background_color ) );
	    }
	
	    $selection_color = gastrobar_edge_options()->getOptionValue( 'selection_color' );
	    if ( ! empty( $selection_color ) ) {
		    echo gastrobar_edge_dynamic_css( '::selection', array( 'background' => $selection_color ) );
		    echo gastrobar_edge_dynamic_css( '::-moz-selection', array( 'background' => $selection_color ) );
	    }
	
	    $preload_background_styles = array();
	
	    if ( gastrobar_edge_options()->getOptionValue( 'preload_pattern_image' ) !== "" ) {
		    $preload_background_styles['background-image'] = 'url(' . gastrobar_edge_options()->getOptionValue( 'preload_pattern_image' ) . ') !important';
	    }
	
	    echo gastrobar_edge_dynamic_css( '.edgtf-preload-background', $preload_background_styles );
    }

    add_action('gastrobar_edge_action_style_dynamic', 'gastrobar_edge_design_styles');
}

if ( ! function_exists( 'gastrobar_edge_content_styles' ) ) {
	function gastrobar_edge_content_styles() {
		$content_style = array();
		
		$padding_top = gastrobar_edge_options()->getOptionValue( 'content_top_padding' );
		if ( $padding_top !== '' ) {
			$content_style['padding-top'] = gastrobar_edge_filter_px( $padding_top ) . 'px';
		}
		
		$content_selector = array(
			'.edgtf-content .edgtf-content-inner > .edgtf-full-width > .edgtf-full-width-inner',
		);
		
		echo gastrobar_edge_dynamic_css( $content_selector, $content_style );
		
		$content_style_in_grid = array();
		
		$padding_top_in_grid = gastrobar_edge_options()->getOptionValue( 'content_top_padding_in_grid' );
		if ( $padding_top_in_grid !== '' ) {
			$content_style_in_grid['padding-top'] = gastrobar_edge_filter_px( $padding_top_in_grid ) . 'px';
		}
		
		$content_selector_in_grid = array(
			'.edgtf-content .edgtf-content-inner > .edgtf-container > .edgtf-container-inner',
		);
		
		echo gastrobar_edge_dynamic_css( $content_selector_in_grid, $content_style_in_grid );
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_content_styles' );
}

if ( ! function_exists( 'gastrobar_edge_h1_styles' ) ) {
	function gastrobar_edge_h1_styles() {
		$margin_top    = gastrobar_edge_options()->getOptionValue( 'h1_margin_top' );
		$margin_bottom = gastrobar_edge_options()->getOptionValue( 'h1_margin_bottom' );
		
		$item_styles = gastrobar_edge_get_typography_styles( 'h1' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = gastrobar_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = gastrobar_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h1'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo gastrobar_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_h1_styles' );
}

if ( ! function_exists( 'gastrobar_edge_h2_styles' ) ) {
	function gastrobar_edge_h2_styles() {
		$margin_top    = gastrobar_edge_options()->getOptionValue( 'h2_margin_top' );
		$margin_bottom = gastrobar_edge_options()->getOptionValue( 'h2_margin_bottom' );
		
		$item_styles = gastrobar_edge_get_typography_styles( 'h2' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = gastrobar_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = gastrobar_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h2'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo gastrobar_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_h2_styles' );
}

if ( ! function_exists( 'gastrobar_edge_h3_styles' ) ) {
	function gastrobar_edge_h3_styles() {
		$margin_top    = gastrobar_edge_options()->getOptionValue( 'h3_margin_top' );
		$margin_bottom = gastrobar_edge_options()->getOptionValue( 'h3_margin_bottom' );
		
		$item_styles = gastrobar_edge_get_typography_styles( 'h3' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = gastrobar_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = gastrobar_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h3'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo gastrobar_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_h3_styles' );
}

if ( ! function_exists( 'gastrobar_edge_h4_styles' ) ) {
	function gastrobar_edge_h4_styles() {
		$margin_top    = gastrobar_edge_options()->getOptionValue( 'h4_margin_top' );
		$margin_bottom = gastrobar_edge_options()->getOptionValue( 'h4_margin_bottom' );
		
		$item_styles = gastrobar_edge_get_typography_styles( 'h4' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = gastrobar_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = gastrobar_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h4'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo gastrobar_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_h4_styles' );
}

if ( ! function_exists( 'gastrobar_edge_h5_styles' ) ) {
	function gastrobar_edge_h5_styles() {
		$margin_top    = gastrobar_edge_options()->getOptionValue( 'h5_margin_top' );
		$margin_bottom = gastrobar_edge_options()->getOptionValue( 'h5_margin_bottom' );
		
		$item_styles = gastrobar_edge_get_typography_styles( 'h5' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = gastrobar_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = gastrobar_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h5'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo gastrobar_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_h5_styles' );
}

if ( ! function_exists( 'gastrobar_edge_h6_styles' ) ) {
	function gastrobar_edge_h6_styles() {
		$margin_top    = gastrobar_edge_options()->getOptionValue( 'h6_margin_top' );
		$margin_bottom = gastrobar_edge_options()->getOptionValue( 'h6_margin_bottom' );
		
		$item_styles = gastrobar_edge_get_typography_styles( 'h6' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = gastrobar_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = gastrobar_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h6'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo gastrobar_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_h6_styles' );
}

if ( ! function_exists( 'gastrobar_edge_text_styles' ) ) {
	function gastrobar_edge_text_styles() {
		$item_styles = gastrobar_edge_get_typography_styles( 'text' );
		
		$item_selector = array(
			'p'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo gastrobar_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_text_styles' );
}

if ( ! function_exists( 'gastrobar_edge_link_styles' ) ) {
	function gastrobar_edge_link_styles() {
		$link_styles      = array();
		$link_color       = gastrobar_edge_options()->getOptionValue( 'link_color' );
		$link_font_style  = gastrobar_edge_options()->getOptionValue( 'link_fontstyle' );
		$link_font_weight = gastrobar_edge_options()->getOptionValue( 'link_fontweight' );
		$link_decoration  = gastrobar_edge_options()->getOptionValue( 'link_fontdecoration' );
		
		if ( ! empty( $link_color ) ) {
			$link_styles['color'] = $link_color;
		}
		if ( ! empty( $link_font_style ) ) {
			$link_styles['font-style'] = $link_font_style;
		}
		if ( ! empty( $link_font_weight ) ) {
			$link_styles['font-weight'] = $link_font_weight;
		}
		if ( ! empty( $link_decoration ) ) {
			$link_styles['text-decoration'] = $link_decoration;
		}
		
		$link_selector = array(
			'a',
			'p a'
		);
		
		if ( ! empty( $link_styles ) ) {
			echo gastrobar_edge_dynamic_css( $link_selector, $link_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_link_styles' );
}

if ( ! function_exists( 'gastrobar_edge_link_hover_styles' ) ) {
	function gastrobar_edge_link_hover_styles() {
		$link_hover_styles     = array();
		$link_hover_color      = gastrobar_edge_options()->getOptionValue( 'link_hovercolor' );
		$link_hover_decoration = gastrobar_edge_options()->getOptionValue( 'link_hover_fontdecoration' );
		
		if ( ! empty( $link_hover_color ) ) {
			$link_hover_styles['color'] = $link_hover_color;
		}
		if ( ! empty( $link_hover_decoration ) ) {
			$link_hover_styles['text-decoration'] = $link_hover_decoration;
		}
		
		$link_hover_selector = array(
			'a:hover',
			'p a:hover'
		);
		
		if ( ! empty( $link_hover_styles ) ) {
			echo gastrobar_edge_dynamic_css( $link_hover_selector, $link_hover_styles );
		}
		
		$link_heading_hover_styles = array();
		
		if ( ! empty( $link_hover_color ) ) {
			$link_heading_hover_styles['color'] = $link_hover_color;
		}
		
		$link_heading_hover_selector = array(
			'h1 a:hover',
			'h2 a:hover',
			'h3 a:hover',
			'h4 a:hover',
			'h5 a:hover',
			'h6 a:hover'
		);
		
		if ( ! empty( $link_heading_hover_styles ) ) {
			echo gastrobar_edge_dynamic_css( $link_heading_hover_selector, $link_heading_hover_styles );
		}
	}
	
	add_action( 'gastrobar_edge_action_style_dynamic', 'gastrobar_edge_link_hover_styles' );
}

if ( ! function_exists( 'gastrobar_edge_smooth_page_transition_styles' ) ) {
	function gastrobar_edge_smooth_page_transition_styles( $style ) {
		$id            = gastrobar_edge_get_page_id();
		$loader_style  = array();
		$current_style = '';
		
		$background_color = gastrobar_edge_get_meta_field_intersect( 'smooth_pt_bgnd_color', $id );
		if ( ! empty( $background_color ) ) {
			$loader_style['background-color'] = $background_color;
		}
		
		$loader_selector = array(
			'.edgtf-smooth-transition-loader'
		);
		
		if ( ! empty( $loader_style ) ) {
			$current_style .= gastrobar_edge_dynamic_css( $loader_selector, $loader_style );
		}
		
		$spinner_style = array();
		$spinner_color = gastrobar_edge_get_meta_field_intersect( 'smooth_pt_spinner_color', $id );
		if ( ! empty( $spinner_color ) ) {
			$spinner_style['background-color'] = $spinner_color;
		}
		
		$spinner_selectors = array(
			'.edgtf-st-loader .edgtf-rotate-circles > div',
			'.edgtf-st-loader .pulse',
			'.edgtf-st-loader .double_pulse .double-bounce1',
			'.edgtf-st-loader .double_pulse .double-bounce2',
			'.edgtf-st-loader .cube',
			'.edgtf-st-loader .rotating_cubes .cube1',
			'.edgtf-st-loader .rotating_cubes .cube2',
			'.edgtf-st-loader .stripes > div',
			'.edgtf-st-loader .wave > div',
			'.edgtf-st-loader .two_rotating_circles .dot1',
			'.edgtf-st-loader .two_rotating_circles .dot2',
			'.edgtf-st-loader .five_rotating_circles .container1 > div',
			'.edgtf-st-loader .five_rotating_circles .container2 > div',
			'.edgtf-st-loader .five_rotating_circles .container3 > div',
			'.edgtf-st-loader .atom .ball-1:before',
			'.edgtf-st-loader .atom .ball-2:before',
			'.edgtf-st-loader .atom .ball-3:before',
			'.edgtf-st-loader .atom .ball-4:before',
			'.edgtf-st-loader .clock .ball:before',
			'.edgtf-st-loader .mitosis .ball',
			'.edgtf-st-loader .lines .line1',
			'.edgtf-st-loader .lines .line2',
			'.edgtf-st-loader .lines .line3',
			'.edgtf-st-loader .lines .line4',
			'.edgtf-st-loader .fussion .ball',
			'.edgtf-st-loader .fussion .ball-1',
			'.edgtf-st-loader .fussion .ball-2',
			'.edgtf-st-loader .fussion .ball-3',
			'.edgtf-st-loader .fussion .ball-4',
			'.edgtf-st-loader .wave_circles .ball',
			'.edgtf-st-loader .pulse_circles .ball'
		);
		
		if ( ! empty( $spinner_style ) ) {
			$current_style .= gastrobar_edge_dynamic_css( $spinner_selectors, $spinner_style );
		}
		
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'gastrobar_edge_filter_add_page_custom_style', 'gastrobar_edge_smooth_page_transition_styles' );
}