<?php

if ( ! function_exists( 'gastrobar_edge_map_general_meta' ) ) {
	function gastrobar_edge_map_general_meta() {
		
		$general_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => apply_filters( 'gastrobar_edge_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'gastrobar' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'gastrobar' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'gastrobar' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'gastrobar' ),
				'parent'        => $general_meta_box
			)
		);
		
		$edgtf_content_padding_group = gastrobar_edge_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Style', 'gastrobar' ),
				'description' => esc_html__( 'Define styles for Content area', 'gastrobar' ),
				'parent'      => $general_meta_box
			)
		);
		
			$edgtf_content_padding_row = gastrobar_edge_add_admin_row(
				array(
					'name'   => 'edgtf_content_padding_row',
					'next'   => true,
					'parent' => $edgtf_content_padding_group
				)
			);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'   => 'edgtf_page_content_top_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Top Padding', 'gastrobar' ),
						'parent' => $edgtf_content_padding_row,
						'args'   => array(
							'suffix' => 'px'
						)
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'    => 'edgtf_page_content_top_padding_mobile',
						'type'    => 'selectsimple',
						'label'   => esc_html__( 'Set this top padding for mobile header', 'gastrobar' ),
						'parent'  => $edgtf_content_padding_row,
						'options' => gastrobar_edge_get_yes_no_select_array( false )
					)
				);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_page_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Page Background Color', 'gastrobar' ),
				'description' => esc_html__( 'Choose background color for page content', 'gastrobar' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Content Layout - end **********************/
		
		/***************** Boxed Layout - begin **********************/
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'    => 'edgtf_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'gastrobar' ),
				'parent'  => $general_meta_box,
				'options' => gastrobar_edge_get_yes_no_select_array(),
				'args'    => array(
					'dependence' => true,
					'hide'       => array(
						''    => '#edgtf_boxed_container_meta',
						'no'  => '#edgtf_boxed_container_meta',
						'yes' => ''
					),
					'show'       => array(
						''    => '',
						'no'  => '',
						'yes' => '#edgtf_boxed_container_meta'
					)
				)
			)
		);
		
			$boxed_container_meta = gastrobar_edge_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'hidden_property' => 'edgtf_boxed_meta',
					'hidden_values'   => array(
						'',
						'no'
					)
				)
			);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'gastrobar' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'gastrobar' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'gastrobar' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'gastrobar' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'gastrobar' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'gastrobar' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => 'fixed',
						'label'         => esc_html__( 'Background Image Attachment', 'gastrobar' ),
						'description'   => esc_html__( 'Choose background image attachment', 'gastrobar' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'gastrobar' ),
							'fixed'  => esc_html__( 'Fixed', 'gastrobar' ),
							'scroll' => esc_html__( 'Scroll', 'gastrobar' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/

		/***************** Overlapping Content - begin **********************/

		do_action( 'gastrobar_edge_filter_overlapping_meta_boxes_map', $general_meta_box );

		/***************** Overlapping Content - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'gastrobar' ),
				'parent'        => $general_meta_box,
				'options'       => gastrobar_edge_get_yes_no_select_array(),
				'args'    => array(
					'dependence'    => true,
					'hide'          => array(
						''    => '#edgtf_edgtf_paspartu_container_meta',
						'no'  => '#edgtf_edgtf_paspartu_container_meta',
						'yes' => ''
					),
					'show'          => array(
						''    => '',
						'no'  => '',
						'yes' => '#edgtf_edgtf_paspartu_container_meta'
					)
				)
			)
		);
		
			$paspartu_container_meta = gastrobar_edge_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'edgtf_paspartu_container_meta',
					'hidden_property' => 'edgtf_paspartu_meta',
					'hidden_values'   => array(
						'',
						'no'
					)
				)
			);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'gastrobar' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'gastrobar' ),
						'parent'      => $paspartu_container_meta
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'gastrobar' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'gastrobar' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'gastrobar' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'gastrobar' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'edgtf_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'gastrobar' ),
						'options'       => gastrobar_edge_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Content Width Layout - begin **********************/
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'gastrobar' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'gastrobar' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'gastrobar' ),
					'edgtf-grid-1400' => esc_html__( '1400px', 'gastrobar' ),
					'edgtf-grid-1300' => esc_html__( '1300px', 'gastrobar' ),
					'edgtf-grid-1200' => esc_html__( '1200px', 'gastrobar' ),
					'edgtf-grid-1100' => esc_html__( '1100px', 'gastrobar' ),
					'edgtf-grid-1000' => esc_html__( '1000px', 'gastrobar' ),
					'edgtf-grid-800'  => esc_html__( '800px', 'gastrobar' )
				)
			)
		);
		
		/***************** Content Width Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'gastrobar' ),
				'parent'        => $general_meta_box,
				'options'       => gastrobar_edge_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''    => '#edgtf_page_transitions_container_meta',
						'no'  => '#edgtf_page_transitions_container_meta',
						'yes' => ''
					),
					'show'       => array(
						''    => '',
						'no'  => '',
						'yes' => '#edgtf_page_transitions_container_meta'
					)
				)
			)
		);
		
			$page_transitions_container_meta = gastrobar_edge_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'page_transitions_container_meta',
					'hidden_property' => 'edgtf_smooth_page_transitions_meta',
					'hidden_values'   => array(
						'',
						'no'
					)
				)
			);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'gastrobar' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'gastrobar' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => gastrobar_edge_get_yes_no_select_array(),
						'args'        => array(
							'dependence' => true,
							'hide'       => array(
								''    => '#edgtf_page_transition_preloader_container_meta',
								'no'  => '#edgtf_page_transition_preloader_container_meta',
								'yes' => ''
							),
							'show'       => array(
								''    => '',
								'no'  => '',
								'yes' => '#edgtf_page_transition_preloader_container_meta'
							)
						)
					)
				);
				
				$page_transition_preloader_container_meta = gastrobar_edge_add_admin_container(
					array(
						'parent'          => $page_transitions_container_meta,
						'name'            => 'page_transition_preloader_container_meta',
						'hidden_property' => 'edgtf_page_transition_preloader_meta',
						'hidden_values'   => array(
							'',
							'no'
						)
					)
				);
				
					gastrobar_edge_create_meta_box_field(
						array(
							'name'   => 'edgtf_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'gastrobar' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = gastrobar_edge_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'gastrobar' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'gastrobar' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = gastrobar_edge_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					gastrobar_edge_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'edgtf_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'gastrobar' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'gastrobar' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'gastrobar' ),
								'pulse'                 => esc_html__( 'Pulse', 'gastrobar' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'gastrobar' ),
								'cube'                  => esc_html__( 'Cube', 'gastrobar' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'gastrobar' ),
								'stripes'               => esc_html__( 'Stripes', 'gastrobar' ),
								'wave'                  => esc_html__( 'Wave', 'gastrobar' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'gastrobar' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'gastrobar' ),
								'atom'                  => esc_html__( 'Atom', 'gastrobar' ),
								'clock'                 => esc_html__( 'Clock', 'gastrobar' ),
								'mitosis'               => esc_html__( 'Mitosis', 'gastrobar' ),
								'lines'                 => esc_html__( 'Lines', 'gastrobar' ),
								'fussion'               => esc_html__( 'Fussion', 'gastrobar' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'gastrobar' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'gastrobar' ),
                                'gastro_spin'           => esc_html__( 'GastroBar Spin', 'gastrobar' )
							)
						)
					);
					
					gastrobar_edge_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'edgtf_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'gastrobar' ),
							'parent' => $row_pt_spinner_animation_meta
						)
					);
					
					gastrobar_edge_create_meta_box_field(
						array(
							'name'        => 'edgtf_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'gastrobar' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'gastrobar' ),
							'options'     => gastrobar_edge_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'gastrobar' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'gastrobar' ),
				'parent'      => $general_meta_box,
				'options'     => gastrobar_edge_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/
	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_general_meta', 10 );
}