<?php

if ( ! function_exists( 'gastrobar_edge_general_options_map' ) ) {
    /**
     * General options page
     */
    function gastrobar_edge_general_options_map() {

        gastrobar_edge_add_admin_page(
            array(
                'slug'  => '',
                'title' => esc_html__( 'General', 'gastrobar' ),
                'icon'  => 'fa fa-institution'
            )
        );

        $panel_design_style = gastrobar_edge_add_admin_panel(
            array(
                'page'  => '',
                'name'  => 'panel_design_style',
                'title' => esc_html__( 'Design Style', 'gastrobar' )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'enable_google_fonts',
                'type'          => 'yesno',
                'default_value' => 'yes',
                'label'         => esc_html__( 'Enable Google Fonts', 'gastrobar' ),
                'parent'        => $panel_design_style,
                'args'          => array(
                    "dependence" => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_google_fonts_container"
                )
            )
        );

        $google_fonts_container = gastrobar_edge_add_admin_container(
            array(
                'parent'          => $panel_design_style,
                'name'            => 'google_fonts_container',
                'hidden_property'   => 'enable_google_fonts',
                'hidden_value'      => 'no'
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'google_fonts',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__( 'Google Font Family', 'gastrobar' ),
                'description'   => esc_html__( 'Choose a default Google font for your site', 'gastrobar' ),
                'parent'        => $google_fonts_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'additional_google_fonts',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Additional Google Fonts', 'gastrobar' ),
                'parent'        => $google_fonts_container,
                'args'          => array(
                    "dependence"             => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_additional_google_fonts_container"
                )
            )
        );

        $additional_google_fonts_container = gastrobar_edge_add_admin_container(
            array(
                'parent'          => $google_fonts_container,
                'name'            => 'additional_google_fonts_container',
                'hidden_property' => 'additional_google_fonts',
                'hidden_value'    => 'no'
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font1',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__( 'Font Family', 'gastrobar' ),
                'description'   => esc_html__( 'Choose additional Google font for your site', 'gastrobar' ),
                'parent'        => $additional_google_fonts_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font2',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__( 'Font Family', 'gastrobar' ),
                'description'   => esc_html__( 'Choose additional Google font for your site', 'gastrobar' ),
                'parent'        => $additional_google_fonts_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font3',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__( 'Font Family', 'gastrobar' ),
                'description'   => esc_html__( 'Choose additional Google font for your site', 'gastrobar' ),
                'parent'        => $additional_google_fonts_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font4',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__( 'Font Family', 'gastrobar' ),
                'description'   => esc_html__( 'Choose additional Google font for your site', 'gastrobar' ),
                'parent'        => $additional_google_fonts_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'additional_google_font5',
                'type'          => 'font',
                'default_value' => '-1',
                'label'         => esc_html__( 'Font Family', 'gastrobar' ),
                'description'   => esc_html__( 'Choose additional Google font for your site', 'gastrobar' ),
                'parent'        => $additional_google_fonts_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'google_font_weight',
                'type'          => 'checkboxgroup',
                'default_value' => '',
                'label'         => esc_html__( 'Google Fonts Style & Weight', 'gastrobar' ),
                'description'   => esc_html__( 'Choose a default Google font weights for your site. Impact on page load time', 'gastrobar' ),
                'parent'        => $google_fonts_container,
                'options'       => array(
                    '100'  => esc_html__( '100 Thin', 'gastrobar' ),
                    '100i' => esc_html__( '100 Thin Italic', 'gastrobar' ),
                    '200'  => esc_html__( '200 Extra-Light', 'gastrobar' ),
                    '200i' => esc_html__( '200 Extra-Light Italic', 'gastrobar' ),
                    '300'  => esc_html__( '300 Light', 'gastrobar' ),
                    '300i' => esc_html__( '300 Light Italic', 'gastrobar' ),
                    '400'  => esc_html__( '400 Regular', 'gastrobar' ),
                    '400i' => esc_html__( '400 Regular Italic', 'gastrobar' ),
                    '500'  => esc_html__( '500 Medium', 'gastrobar' ),
                    '500i' => esc_html__( '500 Medium Italic', 'gastrobar' ),
                    '600'  => esc_html__( '600 Semi-Bold', 'gastrobar' ),
                    '600i' => esc_html__( '600 Semi-Bold Italic', 'gastrobar' ),
                    '700'  => esc_html__( '700 Bold', 'gastrobar' ),
                    '700i' => esc_html__( '700 Bold Italic', 'gastrobar' ),
                    '800'  => esc_html__( '800 Extra-Bold', 'gastrobar' ),
                    '800i' => esc_html__( '800 Extra-Bold Italic', 'gastrobar' ),
                    '900'  => esc_html__( '900 Ultra-Bold', 'gastrobar' ),
                    '900i' => esc_html__( '900 Ultra-Bold Italic', 'gastrobar' )
                )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'google_font_subset',
                'type'          => 'checkboxgroup',
                'default_value' => '',
                'label'         => esc_html__( 'Google Fonts Subset', 'gastrobar' ),
                'description'   => esc_html__( 'Choose a default Google font subsets for your site', 'gastrobar' ),
                'parent'        => $google_fonts_container,
                'options'       => array(
                    'latin'        => esc_html__( 'Latin', 'gastrobar' ),
                    'latin-ext'    => esc_html__( 'Latin Extended', 'gastrobar' ),
                    'cyrillic'     => esc_html__( 'Cyrillic', 'gastrobar' ),
                    'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'gastrobar' ),
                    'greek'        => esc_html__( 'Greek', 'gastrobar' ),
                    'greek-ext'    => esc_html__( 'Greek Extended', 'gastrobar' ),
                    'vietnamese'   => esc_html__( 'Vietnamese', 'gastrobar' )
                )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'first_color',
                'type'        => 'color',
                'label'       => esc_html__( 'First Main Color', 'gastrobar' ),
                'description' => esc_html__( 'Choose the most dominant theme color. Default color is #00bbb3', 'gastrobar' ),
                'parent'      => $panel_design_style
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'page_background_color',
                'type'        => 'color',
                'label'       => esc_html__( 'Page Background Color', 'gastrobar' ),
                'description' => esc_html__( 'Choose the background color for page content. Default color is #ffffff', 'gastrobar' ),
                'parent'      => $panel_design_style
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'selection_color',
                'type'        => 'color',
                'label'       => esc_html__( 'Text Selection Color', 'gastrobar' ),
                'description' => esc_html__( 'Choose the color users see when selecting text', 'gastrobar' ),
                'parent'      => $panel_design_style
            )
        );

        /***************** Passepartout Layout - begin **********************/

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'boxed',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Boxed Layout', 'gastrobar' ),
                'parent'        => $panel_design_style,
                'args'          => array(
                    "dependence"             => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_boxed_container"
                )
            )
        );

        $boxed_container = gastrobar_edge_add_admin_container(
            array(
                'parent'          => $panel_design_style,
                'name'            => 'boxed_container',
                'hidden_property' => 'boxed',
                'hidden_value'    => 'no'
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'page_background_color_in_box',
                'type'        => 'color',
                'label'       => esc_html__( 'Page Background Color', 'gastrobar' ),
                'description' => esc_html__( 'Choose the page background color outside box', 'gastrobar' ),
                'parent'      => $boxed_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'boxed_background_image',
                'type'        => 'image',
                'label'       => esc_html__( 'Background Image', 'gastrobar' ),
                'description' => esc_html__( 'Choose an image to be displayed in background', 'gastrobar' ),
                'parent'      => $boxed_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'boxed_pattern_background_image',
                'type'        => 'image',
                'label'       => esc_html__( 'Background Pattern', 'gastrobar' ),
                'description' => esc_html__( 'Choose an image to be used as background pattern', 'gastrobar' ),
                'parent'      => $boxed_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'boxed_background_image_attachment',
                'type'          => 'select',
                'default_value' => '',
                'label'         => esc_html__( 'Background Image Attachment', 'gastrobar' ),
                'description'   => esc_html__( 'Choose background image attachment', 'gastrobar' ),
                'parent'        => $boxed_container,
                'options'       => array(
                    ''       => esc_html__( 'Default', 'gastrobar' ),
                    'fixed'  => esc_html__( 'Fixed', 'gastrobar' ),
                    'scroll' => esc_html__( 'Scroll', 'gastrobar' )
                )
            )
        );

        /***************** Boxed Layout - end **********************/

        /***************** Passepartout Layout - begin **********************/

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'paspartu',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Passepartout', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'gastrobar' ),
                'parent'        => $panel_design_style,
                'args'          => array(
                    "dependence"             => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_paspartu_container"
                )
            )
        );

        $paspartu_container = gastrobar_edge_add_admin_container(
            array(
                'parent'          => $panel_design_style,
                'name'            => 'paspartu_container',
                'hidden_property' => 'paspartu',
                'hidden_value'    => 'no'
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'paspartu_color',
                'type'        => 'color',
                'label'       => esc_html__( 'Passepartout Color', 'gastrobar' ),
                'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'gastrobar' ),
                'parent'      => $paspartu_container
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'paspartu_width',
                'type'        => 'text',
                'label'       => esc_html__( 'Passepartout Size', 'gastrobar' ),
                'description' => esc_html__( 'Enter size amount for passepartout', 'gastrobar' ),
                'parent'      => $paspartu_container,
                'args'        => array(
                    'col_width' => 2,
                    'suffix'    => 'px or %'
                )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'paspartu_responsive_width',
                'type'        => 'text',
                'label'       => esc_html__( 'Responsive Passepartout Size', 'gastrobar' ),
                'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'gastrobar' ),
                'parent'      => $paspartu_container,
                'args'        => array(
                    'col_width' => 2,
                    'suffix'    => 'px or %'
                )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'parent'        => $paspartu_container,
                'type'          => 'yesno',
                'default_value' => 'no',
                'name'          => 'disable_top_paspartu',
                'label'         => esc_html__( 'Disable Top Passepartout', 'gastrobar' )
            )
        );

        /***************** Passepartout Layout - end **********************/

        /***************** Content Layout - begin **********************/

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'initial_content_width',
                'type'          => 'select',
                'default_value' => 'edgtf-grid-1300',
                'label'         => esc_html__( 'Initial Width of Content', 'gastrobar' ),
                'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'gastrobar' ),
                'parent'        => $panel_design_style,
                'options'       => array(
                    'edgtf-grid-1100' => esc_html__( '1100px - default', 'gastrobar' ),
                    'edgtf-grid-1400' => esc_html__( '1400px', 'gastrobar' ),
                    'edgtf-grid-1300' => esc_html__( '1300px', 'gastrobar' ),
                    'edgtf-grid-1200' => esc_html__( '1200px', 'gastrobar' ),
                    'edgtf-grid-1000' => esc_html__( '1000px', 'gastrobar' ),
                    'edgtf-grid-800'  => esc_html__( '800px', 'gastrobar' )
                )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'preload_pattern_image',
                'type'          => 'image',
                'label'         => esc_html__( 'Preload Pattern Image', 'gastrobar' ),
                'description'   => esc_html__( 'Choose preload pattern image to be displayed until images are loaded', 'gastrobar' ),
                'parent'        => $panel_design_style
            )
        );

        /***************** Content Layout - end **********************/

        $panel_settings = gastrobar_edge_add_admin_panel(
            array(
                'page'  => '',
                'name'  => 'panel_settings',
                'title' => esc_html__( 'Settings', 'gastrobar' )
            )
        );

        /***************** Smooth Scroll Layout - begin **********************/

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'page_smooth_scroll',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Smooth Scroll', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will perform a smooth scrolling effect on every page (except on Mac and touch devices)', 'gastrobar' ),
                'parent'        => $panel_settings
            )
        );

        /***************** Smooth Scroll Layout - end **********************/

        /***************** Smooth Page Transitions Layout - begin **********************/

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'smooth_page_transitions',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Smooth Page Transitions', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'gastrobar' ),
                'parent'        => $panel_settings,
                'args'          => array(
                    "dependence"             => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_page_transitions_container"
                )
            )
        );

        $page_transitions_container = gastrobar_edge_add_admin_container(
            array(
                'parent'          => $panel_settings,
                'name'            => 'page_transitions_container',
                'hidden_property' => 'smooth_page_transitions',
                'hidden_value'    => 'no'
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'page_transition_preloader',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Enable Preloading Animation', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'gastrobar' ),
                'parent'        => $page_transitions_container,
                'args'          => array(
                    "dependence"             => true,
                    "dependence_hide_on_yes" => "",
                    "dependence_show_on_yes" => "#edgtf_page_transition_preloader_container"
                )
            )
        );

        $page_transition_preloader_container = gastrobar_edge_add_admin_container(
            array(
                'parent'          => $page_transitions_container,
                'name'            => 'page_transition_preloader_container',
                'hidden_property' => 'page_transition_preloader',
                'hidden_value'    => 'no'
            )
        );


        gastrobar_edge_add_admin_field(
            array(
                'name'   => 'smooth_pt_bgnd_color',
                'type'   => 'color',
                'label'  => esc_html__( 'Page Loader Background Color', 'gastrobar' ),
                'parent' => $page_transition_preloader_container
            )
        );

        $group_pt_spinner_animation = gastrobar_edge_add_admin_group(
            array(
                'name'        => 'group_pt_spinner_animation',
                'title'       => esc_html__( 'Loader Style', 'gastrobar' ),
                'description' => esc_html__( 'Define styles for loader spinner animation', 'gastrobar' ),
                'parent'      => $page_transition_preloader_container
            )
        );

        $row_pt_spinner_animation = gastrobar_edge_add_admin_row(
            array(
                'name'   => 'row_pt_spinner_animation',
                'parent' => $group_pt_spinner_animation
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'type'          => 'selectsimple',
                'name'          => 'smooth_pt_spinner_type',
                'default_value' => '',
                'label'         => esc_html__( 'Spinner Type', 'gastrobar' ),
                'parent'        => $row_pt_spinner_animation,
                'options'       => array(
                    'rotate_circles'        => esc_html__( 'Rotate Circles', 'gastrobar' ),
                    'pulse'                 => esc_html__( 'Pulse', 'gastrobar' ),
                    'double_pulse'          => esc_html__( 'Double Pulse', 'gastrobar' ),
                    'cube'                  => esc_html__( 'Cube', 'gastrobar' ),
                    'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'gastrobar' ),
                    'stripes'               => esc_html__( 'Stripes', 'gastrobar' ),
                    'wave'                  => esc_html__( 'Wave', 'gastrobar' ),
                    'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'gastrobar' ),
                    'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'gastrobar' ),
                    'atom'                  => esc_html__( 'Atom', 'gastrobar' ),
                    'clock'                 => esc_html__( 'Clock', 'gastrobar' ),
                    'mitosis'               => esc_html__( 'Mitosis', 'gastrobar' ),
                    'lines'                 => esc_html__( 'Lines', 'gastrobar' ),
                    'fussion'               => esc_html__( 'Fussion', 'gastrobar' ),
                    'wave_circles'          => esc_html__( 'Wave Circles', 'gastrobar' ),
                    'pulse_circles'         => esc_html__( 'Pulse Circles', 'gastrobar' ),
                    'gastro_spin'           => esc_html__( 'GastroBar Spin', 'gastrobar' )
                )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'type'          => 'colorsimple',
                'name'          => 'smooth_pt_spinner_color',
                'default_value' => '',
                'label'         => esc_html__( 'Spinner Color', 'gastrobar' ),
                'parent'        => $row_pt_spinner_animation
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'page_transition_fadeout',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Enable Fade Out Animation', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'gastrobar' ),
                'parent'        => $page_transitions_container
            )
        );

        /***************** Smooth Page Transitions Layout - end **********************/

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'show_back_button',
                'type'          => 'yesno',
                'default_value' => 'yes',
                'label'         => esc_html__( 'Show "Back To Top Button"', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will display a Back to Top button on every page', 'gastrobar' ),
                'parent'        => $panel_settings
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'          => 'responsiveness',
                'type'          => 'yesno',
                'default_value' => 'yes',
                'label'         => esc_html__( 'Responsiveness', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will make all pages responsive', 'gastrobar' ),
                'parent'        => $panel_settings
            )
        );

        $panel_custom_code = gastrobar_edge_add_admin_panel(
            array(
                'page'  => '',
                'name'  => 'panel_custom_code',
                'title' => esc_html__( 'Custom Code', 'gastrobar' )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'custom_js',
                'type'        => 'textarea',
                'label'       => esc_html__( 'Custom JS', 'gastrobar' ),
                'description' => esc_html__( 'Enter your custom Javascript here', 'gastrobar' ),
                'parent'      => $panel_custom_code
            )
        );

        $panel_google_api = gastrobar_edge_add_admin_panel(
            array(
                'page'  => '',
                'name'  => 'panel_google_api',
                'title' => esc_html__( 'Google API', 'gastrobar' )
            )
        );

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'google_maps_api_key',
                'type'        => 'text',
                'label'       => esc_html__( 'Google Maps Api Key', 'gastrobar' ),
                'description' => esc_html__( 'Insert your Google Maps API key here. For instructions on how to create a Google Maps API key, please refer to our to our documentation.', 'gastrobar' ),
                'parent'      => $panel_google_api
            )
        );
    }

    add_action( 'gastrobar_edge_action_options_map', 'gastrobar_edge_general_options_map', 1 );
}

if ( ! function_exists( 'gastrobar_edge_page_general_style' ) ) {
    /**
     * Function that prints page general inline styles
     */
    function gastrobar_edge_page_general_style( $style ) {
        $current_style = '';
        $page_id       = gastrobar_edge_get_page_id();
        $class_prefix  = gastrobar_edge_get_unique_page_class( $page_id );

        $boxed_background_style = array();

        $boxed_page_background_color = gastrobar_edge_get_meta_field_intersect( 'page_background_color_in_box', $page_id );
        if ( ! empty( $boxed_page_background_color ) ) {
            $boxed_background_style['background-color'] = $boxed_page_background_color;
        }

        $boxed_page_background_image = gastrobar_edge_get_meta_field_intersect( 'boxed_background_image', $page_id );
        if ( ! empty( $boxed_page_background_image ) ) {
            $boxed_background_style['background-image']    = 'url(' . esc_url( $boxed_page_background_image ) . ')';
            $boxed_background_style['background-position'] = 'center 0px';
            $boxed_background_style['background-repeat']   = 'no-repeat';
        }

        $boxed_page_background_pattern_image = gastrobar_edge_get_meta_field_intersect( 'boxed_pattern_background_image', $page_id );
        if ( ! empty( $boxed_page_background_pattern_image ) ) {
            $boxed_background_style['background-image']    = 'url(' . esc_url( $boxed_page_background_pattern_image ) . ')';
            $boxed_background_style['background-position'] = '0px 0px';
            $boxed_background_style['background-repeat']   = 'repeat';
        }

        $boxed_page_background_attachment = gastrobar_edge_get_meta_field_intersect( 'boxed_background_image_attachment', $page_id );
        if ( ! empty( $boxed_page_background_attachment ) ) {
            $boxed_background_style['background-attachment'] = $boxed_page_background_attachment;
        }

        $boxed_background_selector = $class_prefix . '.edgtf-boxed .edgtf-wrapper';

        if ( ! empty( $boxed_background_style ) ) {
            $current_style .= gastrobar_edge_dynamic_css( $boxed_background_selector, $boxed_background_style );
        }

        $paspartu_style     = array();
        $paspartu_res_style = array();
        $paspartu_res_start = '@media only screen and (max-width: 1024px) {';
        $paspartu_res_end   = '}';

        $paspartu_color = gastrobar_edge_get_meta_field_intersect( 'paspartu_color', $page_id );
        if ( ! empty( $paspartu_color ) ) {
            $paspartu_style['background-color'] = $paspartu_color;
        }

        $paspartu_width = gastrobar_edge_get_meta_field_intersect( 'paspartu_width', $page_id );
        if ( $paspartu_width !== '' ) {
            if ( gastrobar_edge_string_ends_with( $paspartu_width, '%' ) || gastrobar_edge_string_ends_with( $paspartu_width, 'px' ) ) {
                $paspartu_style['padding'] = $paspartu_width;
            } else {
                $paspartu_style['padding'] = $paspartu_width . 'px';
            }
        }

        $paspartu_selector = $class_prefix . '.edgtf-paspartu-enabled .edgtf-wrapper';

        if ( ! empty( $paspartu_style ) ) {
            $current_style .= gastrobar_edge_dynamic_css( $paspartu_selector, $paspartu_style );
        }

        $paspartu_responsive_width = gastrobar_edge_get_meta_field_intersect( 'paspartu_responsive_width', $page_id );
        if ( $paspartu_responsive_width !== '' ) {
            if ( gastrobar_edge_string_ends_with( $paspartu_responsive_width, '%' ) || gastrobar_edge_string_ends_with( $paspartu_responsive_width, 'px' ) ) {
                $paspartu_res_style['padding'] = $paspartu_responsive_width;
            } else {
                $paspartu_res_style['padding'] = $paspartu_responsive_width . 'px';
            }
        }

        if ( ! empty( $paspartu_res_style ) ) {
            $current_style .= $paspartu_res_start . gastrobar_edge_dynamic_css( $paspartu_selector, $paspartu_res_style ) . $paspartu_res_end;
        }

        $current_style = $current_style . $style;

        return $current_style;
    }

    add_filter( 'gastrobar_edge_filter_add_page_custom_style', 'gastrobar_edge_page_general_style' );
}