<?php

if ( ! function_exists( 'gastrobar_edge_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function gastrobar_edge_reset_options_map() {
		
		gastrobar_edge_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'gastrobar' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = gastrobar_edge_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'gastrobar' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'gastrobar' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_options_map', 'gastrobar_edge_reset_options_map', 100 );
}