<?php

foreach ( glob( EDGE_FRAMEWORK_MODULES_ROOT_DIR . '/blog/admin/meta-boxes/*/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'gastrobar_edge_map_blog_meta' ) ) {
	function gastrobar_edge_map_blog_meta() {
		$edgt_blog_categories = array();
		$categories           = get_categories();
		foreach ( $categories as $category ) {
			$edgt_blog_categories[ $category->slug ] = $category->name;
		}
		
		$blog_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => array( 'page' ),
				'title' => esc_html__( 'Blog', 'gastrobar' ),
				'name'  => 'blog_meta'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_blog_category_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Blog Category', 'gastrobar' ),
				'description' => esc_html__( 'Choose category of posts to display (leave empty to display all categories)', 'gastrobar' ),
				'parent'      => $blog_meta_box,
				'options'     => $edgt_blog_categories
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_show_posts_per_page_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Posts', 'gastrobar' ),
				'description' => esc_html__( 'Enter the number of posts to display', 'gastrobar' ),
				'parent'      => $blog_meta_box,
				'options'     => $edgt_blog_categories,
				'args'        => array( "col_width" => 3 )
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_blog_masonry_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Layout', 'gastrobar' ),
				'description' => esc_html__( 'Set masonry layout. Default is in grid.', 'gastrobar' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''           => esc_html__( 'Default', 'gastrobar' ),
					'in-grid'    => esc_html__( 'In Grid', 'gastrobar' ),
					'full-width' => esc_html__( 'Full Width', 'gastrobar' )
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_blog_masonry_number_of_columns_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Number of Columns', 'gastrobar' ),
				'description' => esc_html__( 'Set number of columns for your masonry blog lists', 'gastrobar' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''      => esc_html__( 'Default', 'gastrobar' ),
					'two'   => esc_html__( '2 Columns', 'gastrobar' ),
					'three' => esc_html__( '3 Columns', 'gastrobar' ),
					'four'  => esc_html__( '4 Columns', 'gastrobar' ),
					'five'  => esc_html__( '5 Columns', 'gastrobar' )
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_blog_masonry_space_between_items_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Space Between Items', 'gastrobar' ),
				'description' => esc_html__( 'Set space size between posts for your masonry blog lists', 'gastrobar' ),
				'options'     => gastrobar_edge_get_space_between_items_array( true ),
				'parent'      => $blog_meta_box
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_blog_list_featured_image_proportion_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Featured Image Proportion', 'gastrobar' ),
				'description'   => esc_html__( 'Choose type of proportions you want to use for featured images on masonry blog lists', 'gastrobar' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''         => esc_html__( 'Default', 'gastrobar' ),
					'fixed'    => esc_html__( 'Fixed', 'gastrobar' ),
					'original' => esc_html__( 'Original', 'gastrobar' )
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_blog_pagination_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Pagination Type', 'gastrobar' ),
				'description'   => esc_html__( 'Choose a pagination layout for Blog Lists', 'gastrobar' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''                => esc_html__( 'Default', 'gastrobar' ),
					'standard'        => esc_html__( 'Standard', 'gastrobar' ),
					'load-more'       => esc_html__( 'Load More', 'gastrobar' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'gastrobar' ),
					'no-pagination'   => esc_html__( 'No Pagination', 'gastrobar' )
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'type'          => 'text',
				'name'          => 'edgtf_number_of_chars_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Number of Words in Excerpt', 'gastrobar' ),
				'description'   => esc_html__( 'Enter a number of words in excerpt (article summary). Default value is 40', 'gastrobar' ),
				'parent'        => $blog_meta_box,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_blog_meta', 30 );
}