<?php

if ( ! function_exists( 'gastrobar_edge_map_post_audio_meta' ) ) {
	function gastrobar_edge_map_post_audio_meta() {
		$audio_post_format_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'gastrobar' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'gastrobar' ),
				'description'   => esc_html__( 'Choose audio type', 'gastrobar' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'gastrobar' ),
					'self'            => esc_html__( 'Self Hosted', 'gastrobar' )
				),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						'social_networks' => '#edgtf_edgtf_audio_self_hosted_container',
						'self'            => '#edgtf_edgtf_audio_embedded_container'
					),
					'show'       => array(
						'social_networks' => '#edgtf_edgtf_audio_embedded_container',
						'self'            => '#edgtf_edgtf_audio_self_hosted_container'
					)
				)
			)
		);
		
		$edgtf_audio_embedded_container = gastrobar_edge_add_admin_container(
			array(
				'parent'          => $audio_post_format_meta_box,
				'name'            => 'edgtf_audio_embedded_container',
				'hidden_property' => 'edgtf_audio_type_meta',
				'hidden_value'    => 'self'
			)
		);
		
		$edgtf_audio_self_hosted_container = gastrobar_edge_add_admin_container(
			array(
				'parent'          => $audio_post_format_meta_box,
				'name'            => 'edgtf_audio_self_hosted_container',
				'hidden_property' => 'edgtf_audio_type_meta',
				'hidden_value'    => 'social_networks'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'gastrobar' ),
				'description' => esc_html__( 'Enter audio URL', 'gastrobar' ),
				'parent'      => $edgtf_audio_embedded_container,
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'gastrobar' ),
				'description' => esc_html__( 'Enter audio link', 'gastrobar' ),
				'parent'      => $edgtf_audio_self_hosted_container,
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_post_audio_meta', 23 );
}